Mercury on macOS
================

This file documents the port of Mercury to macOS.
(i.e. the `*-apple-darwin*` configuration).

Mercury does not support versions of macOS prior to 10.9.
Mercury supports both Intel and Apple Silicon Macs, although the latter has not
been extensively tested.

Contents
--------

* Mercury on macOS
* Note for users of Xcode 11
* Deployment Target Settings
* Deep profiling on macOS

Mercury on macOS
----------------

Mercury should build and install "out-of-the-box" on Intel and Apple Silicon
Macs using macOS 10.9 onwards.

The `asm_fast*` and `reg*` grades are only available on 64-bit Intel systems
and only when using GCC version 4.3 or later as the C compiler.

If `clang` is being used as the C compiler, then the only low-level C grades
available are the `none*` grades. The high-level C, Java, and C# grades
all work. The C# grades require the Mono .NET implementation.
(See [README.CSharp.md](README.CSharp.md) for further details.)

If the `asm_fast.gc` grade is not available, and unless otherwise directed,
then the `hlc.gc` grade will be used as the default grade for compiling
applications.

On machines running versions of macOS up to, and including, 10.14, you can
choose to install a 32-bit version of Mercury instead of the default 64-bit
version. This is done by invoking Mercury's `configure` script either with the
option

```
    --with-cc="clang -m32"
```

or

```
    --with-cc="gcc -m32"
```

depending on your preferred C compiler. In either case, every invocation
of the selected C compiler on Mercury-generated C files will specify
the `-m32` option. The reason for the restriction to version 10.14 is that
macOS does not support 32-bit executables from version 10.15 onwards.

If, after installing Mercury, you encounter errors about missing `.mih` files,
and you have [fink](https://www.finkproject.org/) installed, try removing the
fink components from your `PATH` (these usually start with `/sw`) and
reinstalling.

Note for users of Xcode 11
--------------------------

Versions of Xcode 11 prior to 11.4 ship with a broken version of `clang`
that *cannot* be used to compile Mercury. The `configure` script will print
a warning if it detects that you are using the broken version.

A discussion of this issue can be found at
[this](https://forums.developer.apple.com/thread/121887) thread in the Apple
Developer forum.
This
[post](https://github.com/Mercury-Language/mercury/issues/88#issuecomment-624329679)
describes a way that has been found to fix the problem.

Deployment Target Settings
--------------------------

By default, the Mercury compiler is configured so that the macOS deployment
target for code generated by the Mercury compiler is set to the value of the
`MACOSX_DEPLOYMENT_TARGET` environment variable (if set), or else to the macOS
version of the host system.

You can specify a different deployment target at configuration time using
the `configure` script's `--with-macosx-deployment-target` option.

(See the "SDK Compatibility Guide" in the Apple developer documentation
for further information about the deployment target setting.)

Deep profiling on macOS
-----------------------

The Mercury deep profiler requires a local web server. To use the deep
profiler:

- Select and install a web server, and
- Install and enable the `mdprof_cgi` script according to the rules of that
  web server.
