%---------------------------------------------------------------------------%
% vim: ts=4 sw=4 et ft=mercury
%---------------------------------------------------------------------------%
%
% This module tests class methods with unconstrained type variables.
%
% The code generated by the compiler of 13/1/2001 for this test case
% segfaults. The problem is that the argument types of
% 'Introduced_pred_for_extra_var_method__class__list__list__arity_1______extra_var_method__p_4'
% after polymorphism are (TypeInfo_for_U, TypeclassInfo_for_class, ...),
% but do_call_class_method is passing in
% (TypeclassInfo_for_class, TypeInfo_for_U, ...).

:- module typeclass_order_bug_2.

:- interface.

:- import_module io.

:- pred main(io::di, io::uo) is det.

:- implementation.

:- import_module int.
:- import_module list.

:- typeclass class(T) where [
    pred p(U::in, T::in, io::di, io::uo) is det
].

:- instance class(list(T)) <= class(T) where [
    pred(p/4) is p_list
].

:- instance class(int) where [
    pred(p/4) is p_int
].

main(!IO) :-
    p("string", [1, 2, 3], !IO).

:- pred p_list(U::in, list(T)::in, io::di, io::uo) is det <= class(T).

p_list(U, List, !IO) :-
    list.foldl(p(U), List, !IO),
    io.write_line(U, !IO).

:- pred p_int(U::in, int::in, io::di, io::uo) is det.

p_int(U, Int, !IO) :-
    io.write_int(Int + 1, !IO),
    io.nl(!IO),
    io.write_line(U, !IO).
