// vim: ts=4 sw=4 expandtab ft=c

// Copyright (C) 2022 The Mercury team.
// This file is distributed under the terms specified in COPYING.LIB.

// Generated by generate_windows_error_name

#include <stdlib.h>

#include "mercury_windows_error_name.h"

#ifdef MR_WIN32

const char *
MR_win32_error_name(DWORD errcode)
{
    switch (errcode) {
    case ERROR_SUCCESS: return "SUCCESS";
    case ERROR_INVALID_FUNCTION: return "INVALID_FUNCTION";
    case ERROR_FILE_NOT_FOUND: return "FILE_NOT_FOUND";
    case ERROR_PATH_NOT_FOUND: return "PATH_NOT_FOUND";
    case ERROR_TOO_MANY_OPEN_FILES: return "TOO_MANY_OPEN_FILES";
    case ERROR_ACCESS_DENIED: return "ACCESS_DENIED";
    case ERROR_INVALID_HANDLE: return "INVALID_HANDLE";
    case ERROR_ARENA_TRASHED: return "ARENA_TRASHED";
    case ERROR_NOT_ENOUGH_MEMORY: return "NOT_ENOUGH_MEMORY";
    case ERROR_INVALID_BLOCK: return "INVALID_BLOCK";
    case ERROR_BAD_ENVIRONMENT: return "BAD_ENVIRONMENT";
    case ERROR_BAD_FORMAT: return "BAD_FORMAT";
    case ERROR_INVALID_ACCESS: return "INVALID_ACCESS";
    case ERROR_INVALID_DATA: return "INVALID_DATA";
    case ERROR_OUTOFMEMORY: return "OUTOFMEMORY";
    case ERROR_INVALID_DRIVE: return "INVALID_DRIVE";
    case ERROR_CURRENT_DIRECTORY: return "CURRENT_DIRECTORY";
    case ERROR_NOT_SAME_DEVICE: return "NOT_SAME_DEVICE";
    case ERROR_NO_MORE_FILES: return "NO_MORE_FILES";
    case ERROR_WRITE_PROTECT: return "WRITE_PROTECT";
    case ERROR_BAD_UNIT: return "BAD_UNIT";
    case ERROR_NOT_READY: return "NOT_READY";
    case ERROR_BAD_COMMAND: return "BAD_COMMAND";
    case ERROR_CRC: return "CRC";
    case ERROR_BAD_LENGTH: return "BAD_LENGTH";
    case ERROR_SEEK: return "SEEK";
    case ERROR_NOT_DOS_DISK: return "NOT_DOS_DISK";
    case ERROR_SECTOR_NOT_FOUND: return "SECTOR_NOT_FOUND";
    case ERROR_OUT_OF_PAPER: return "OUT_OF_PAPER";
    case ERROR_WRITE_FAULT: return "WRITE_FAULT";
    case ERROR_READ_FAULT: return "READ_FAULT";
    case ERROR_GEN_FAILURE: return "GEN_FAILURE";
    case ERROR_SHARING_VIOLATION: return "SHARING_VIOLATION";
    case ERROR_LOCK_VIOLATION: return "LOCK_VIOLATION";
    case ERROR_WRONG_DISK: return "WRONG_DISK";
    case ERROR_SHARING_BUFFER_EXCEEDED: return "SHARING_BUFFER_EXCEEDED";
    case ERROR_HANDLE_EOF: return "HANDLE_EOF";
    case ERROR_HANDLE_DISK_FULL: return "HANDLE_DISK_FULL";
    case ERROR_NOT_SUPPORTED: return "NOT_SUPPORTED";
    case ERROR_REM_NOT_LIST: return "REM_NOT_LIST";
    case ERROR_DUP_NAME: return "DUP_NAME";
    case ERROR_BAD_NETPATH: return "BAD_NETPATH";
    case ERROR_NETWORK_BUSY: return "NETWORK_BUSY";
    case ERROR_DEV_NOT_EXIST: return "DEV_NOT_EXIST";
    case ERROR_TOO_MANY_CMDS: return "TOO_MANY_CMDS";
    case ERROR_ADAP_HDW_ERR: return "ADAP_HDW_ERR";
    case ERROR_BAD_NET_RESP: return "BAD_NET_RESP";
    case ERROR_UNEXP_NET_ERR: return "UNEXP_NET_ERR";
    case ERROR_BAD_REM_ADAP: return "BAD_REM_ADAP";
    case ERROR_PRINTQ_FULL: return "PRINTQ_FULL";
    case ERROR_NO_SPOOL_SPACE: return "NO_SPOOL_SPACE";
    case ERROR_PRINT_CANCELLED: return "PRINT_CANCELLED";
    case ERROR_NETNAME_DELETED: return "NETNAME_DELETED";
    case ERROR_NETWORK_ACCESS_DENIED: return "NETWORK_ACCESS_DENIED";
    case ERROR_BAD_DEV_TYPE: return "BAD_DEV_TYPE";
    case ERROR_BAD_NET_NAME: return "BAD_NET_NAME";
    case ERROR_TOO_MANY_NAMES: return "TOO_MANY_NAMES";
    case ERROR_TOO_MANY_SESS: return "TOO_MANY_SESS";
    case ERROR_SHARING_PAUSED: return "SHARING_PAUSED";
    case ERROR_REQ_NOT_ACCEP: return "REQ_NOT_ACCEP";
    case ERROR_REDIR_PAUSED: return "REDIR_PAUSED";
    case ERROR_FILE_EXISTS: return "FILE_EXISTS";
    case ERROR_CANNOT_MAKE: return "CANNOT_MAKE";
    case ERROR_FAIL_I24: return "FAIL_I24";
    case ERROR_OUT_OF_STRUCTURES: return "OUT_OF_STRUCTURES";
    case ERROR_ALREADY_ASSIGNED: return "ALREADY_ASSIGNED";
    case ERROR_INVALID_PASSWORD: return "INVALID_PASSWORD";
    case ERROR_INVALID_PARAMETER: return "INVALID_PARAMETER";
    case ERROR_NET_WRITE_FAULT: return "NET_WRITE_FAULT";
    case ERROR_NO_PROC_SLOTS: return "NO_PROC_SLOTS";
    case ERROR_TOO_MANY_SEMAPHORES: return "TOO_MANY_SEMAPHORES";
    case ERROR_EXCL_SEM_ALREADY_OWNED: return "EXCL_SEM_ALREADY_OWNED";
    case ERROR_SEM_IS_SET: return "SEM_IS_SET";
    case ERROR_TOO_MANY_SEM_REQUESTS: return "TOO_MANY_SEM_REQUESTS";
    case ERROR_INVALID_AT_INTERRUPT_TIME: return "INVALID_AT_INTERRUPT_TIME";
    case ERROR_SEM_OWNER_DIED: return "SEM_OWNER_DIED";
    case ERROR_SEM_USER_LIMIT: return "SEM_USER_LIMIT";
    case ERROR_DISK_CHANGE: return "DISK_CHANGE";
    case ERROR_DRIVE_LOCKED: return "DRIVE_LOCKED";
    case ERROR_BROKEN_PIPE: return "BROKEN_PIPE";
    case ERROR_OPEN_FAILED: return "OPEN_FAILED";
    case ERROR_BUFFER_OVERFLOW: return "BUFFER_OVERFLOW";
    case ERROR_DISK_FULL: return "DISK_FULL";
    case ERROR_NO_MORE_SEARCH_HANDLES: return "NO_MORE_SEARCH_HANDLES";
    case ERROR_INVALID_TARGET_HANDLE: return "INVALID_TARGET_HANDLE";
    case ERROR_INVALID_CATEGORY: return "INVALID_CATEGORY";
    case ERROR_INVALID_VERIFY_SWITCH: return "INVALID_VERIFY_SWITCH";
    case ERROR_BAD_DRIVER_LEVEL: return "BAD_DRIVER_LEVEL";
    case ERROR_CALL_NOT_IMPLEMENTED: return "CALL_NOT_IMPLEMENTED";
    case ERROR_SEM_TIMEOUT: return "SEM_TIMEOUT";
    case ERROR_INSUFFICIENT_BUFFER: return "INSUFFICIENT_BUFFER";
    case ERROR_INVALID_NAME: return "INVALID_NAME";
    case ERROR_INVALID_LEVEL: return "INVALID_LEVEL";
    case ERROR_NO_VOLUME_LABEL: return "NO_VOLUME_LABEL";
    case ERROR_MOD_NOT_FOUND: return "MOD_NOT_FOUND";
    case ERROR_PROC_NOT_FOUND: return "PROC_NOT_FOUND";
    case ERROR_WAIT_NO_CHILDREN: return "WAIT_NO_CHILDREN";
    case ERROR_CHILD_NOT_COMPLETE: return "CHILD_NOT_COMPLETE";
    case ERROR_DIRECT_ACCESS_HANDLE: return "DIRECT_ACCESS_HANDLE";
    case ERROR_NEGATIVE_SEEK: return "NEGATIVE_SEEK";
    case ERROR_SEEK_ON_DEVICE: return "SEEK_ON_DEVICE";
    case ERROR_IS_JOIN_TARGET: return "IS_JOIN_TARGET";
    case ERROR_IS_JOINED: return "IS_JOINED";
    case ERROR_IS_SUBSTED: return "IS_SUBSTED";
    case ERROR_NOT_JOINED: return "NOT_JOINED";
    case ERROR_NOT_SUBSTED: return "NOT_SUBSTED";
    case ERROR_JOIN_TO_JOIN: return "JOIN_TO_JOIN";
    case ERROR_SUBST_TO_SUBST: return "SUBST_TO_SUBST";
    case ERROR_JOIN_TO_SUBST: return "JOIN_TO_SUBST";
    case ERROR_SUBST_TO_JOIN: return "SUBST_TO_JOIN";
    case ERROR_BUSY_DRIVE: return "BUSY_DRIVE";
    case ERROR_SAME_DRIVE: return "SAME_DRIVE";
    case ERROR_DIR_NOT_ROOT: return "DIR_NOT_ROOT";
    case ERROR_DIR_NOT_EMPTY: return "DIR_NOT_EMPTY";
    case ERROR_IS_SUBST_PATH: return "IS_SUBST_PATH";
    case ERROR_IS_JOIN_PATH: return "IS_JOIN_PATH";
    case ERROR_PATH_BUSY: return "PATH_BUSY";
    case ERROR_IS_SUBST_TARGET: return "IS_SUBST_TARGET";
    case ERROR_SYSTEM_TRACE: return "SYSTEM_TRACE";
    case ERROR_INVALID_EVENT_COUNT: return "INVALID_EVENT_COUNT";
    case ERROR_TOO_MANY_MUXWAITERS: return "TOO_MANY_MUXWAITERS";
    case ERROR_INVALID_LIST_FORMAT: return "INVALID_LIST_FORMAT";
    case ERROR_LABEL_TOO_LONG: return "LABEL_TOO_LONG";
    case ERROR_TOO_MANY_TCBS: return "TOO_MANY_TCBS";
    case ERROR_SIGNAL_REFUSED: return "SIGNAL_REFUSED";
    case ERROR_DISCARDED: return "DISCARDED";
    case ERROR_NOT_LOCKED: return "NOT_LOCKED";
    case ERROR_BAD_THREADID_ADDR: return "BAD_THREADID_ADDR";
    case ERROR_BAD_ARGUMENTS: return "BAD_ARGUMENTS";
    case ERROR_BAD_PATHNAME: return "BAD_PATHNAME";
    case ERROR_SIGNAL_PENDING: return "SIGNAL_PENDING";
    case ERROR_MAX_THRDS_REACHED: return "MAX_THRDS_REACHED";
    case ERROR_LOCK_FAILED: return "LOCK_FAILED";
    case ERROR_BUSY: return "BUSY";
    case ERROR_CANCEL_VIOLATION: return "CANCEL_VIOLATION";
    case ERROR_ATOMIC_LOCKS_NOT_SUPPORTED: return "ATOMIC_LOCKS_NOT_SUPPORTED";
    case ERROR_INVALID_SEGMENT_NUMBER: return "INVALID_SEGMENT_NUMBER";
    case ERROR_INVALID_ORDINAL: return "INVALID_ORDINAL";
    case ERROR_ALREADY_EXISTS: return "ALREADY_EXISTS";
    case ERROR_INVALID_FLAG_NUMBER: return "INVALID_FLAG_NUMBER";
    case ERROR_SEM_NOT_FOUND: return "SEM_NOT_FOUND";
    case ERROR_INVALID_STARTING_CODESEG: return "INVALID_STARTING_CODESEG";
    case ERROR_INVALID_STACKSEG: return "INVALID_STACKSEG";
    case ERROR_INVALID_MODULETYPE: return "INVALID_MODULETYPE";
    case ERROR_INVALID_EXE_SIGNATURE: return "INVALID_EXE_SIGNATURE";
    case ERROR_EXE_MARKED_INVALID: return "EXE_MARKED_INVALID";
    case ERROR_BAD_EXE_FORMAT: return "BAD_EXE_FORMAT";
    case ERROR_ITERATED_DATA_EXCEEDS_64k: return "ITERATED_DATA_EXCEEDS_64k";
    case ERROR_INVALID_MINALLOCSIZE: return "INVALID_MINALLOCSIZE";
    case ERROR_DYNLINK_FROM_INVALID_RING: return "DYNLINK_FROM_INVALID_RING";
    case ERROR_IOPL_NOT_ENABLED: return "IOPL_NOT_ENABLED";
    case ERROR_INVALID_SEGDPL: return "INVALID_SEGDPL";
    case ERROR_AUTODATASEG_EXCEEDS_64k: return "AUTODATASEG_EXCEEDS_64k";
    case ERROR_RING2SEG_MUST_BE_MOVABLE: return "RING2SEG_MUST_BE_MOVABLE";
    case ERROR_RELOC_CHAIN_XEEDS_SEGLIM: return "RELOC_CHAIN_XEEDS_SEGLIM";
    case ERROR_INFLOOP_IN_RELOC_CHAIN: return "INFLOOP_IN_RELOC_CHAIN";
    case ERROR_ENVVAR_NOT_FOUND: return "ENVVAR_NOT_FOUND";
    case ERROR_NO_SIGNAL_SENT: return "NO_SIGNAL_SENT";
    case ERROR_FILENAME_EXCED_RANGE: return "FILENAME_EXCED_RANGE";
    case ERROR_RING2_STACK_IN_USE: return "RING2_STACK_IN_USE";
    case ERROR_META_EXPANSION_TOO_LONG: return "META_EXPANSION_TOO_LONG";
    case ERROR_INVALID_SIGNAL_NUMBER: return "INVALID_SIGNAL_NUMBER";
    case ERROR_THREAD_1_INACTIVE: return "THREAD_1_INACTIVE";
    case ERROR_LOCKED: return "LOCKED";
    case ERROR_TOO_MANY_MODULES: return "TOO_MANY_MODULES";
    case ERROR_NESTING_NOT_ALLOWED: return "NESTING_NOT_ALLOWED";
    case ERROR_EXE_MACHINE_TYPE_MISMATCH: return "EXE_MACHINE_TYPE_MISMATCH";
    case ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY: return "EXE_CANNOT_MODIFY_SIGNED_BINARY";
    case ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY: return "EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY";
    case ERROR_FILE_CHECKED_OUT: return "FILE_CHECKED_OUT";
    case ERROR_CHECKOUT_REQUIRED: return "CHECKOUT_REQUIRED";
    case ERROR_BAD_FILE_TYPE: return "BAD_FILE_TYPE";
    case ERROR_FILE_TOO_LARGE: return "FILE_TOO_LARGE";
    case ERROR_FORMS_AUTH_REQUIRED: return "FORMS_AUTH_REQUIRED";
    case ERROR_PIPE_LOCAL: return "PIPE_LOCAL";
    case ERROR_BAD_PIPE: return "BAD_PIPE";
    case ERROR_PIPE_BUSY: return "PIPE_BUSY";
    case ERROR_NO_DATA: return "NO_DATA";
    case ERROR_PIPE_NOT_CONNECTED: return "PIPE_NOT_CONNECTED";
    case ERROR_MORE_DATA: return "MORE_DATA";
    case ERROR_VC_DISCONNECTED: return "VC_DISCONNECTED";
    case ERROR_INVALID_EA_NAME: return "INVALID_EA_NAME";
    case ERROR_EA_LIST_INCONSISTENT: return "EA_LIST_INCONSISTENT";
    case ERROR_NO_MORE_ITEMS: return "NO_MORE_ITEMS";
    case ERROR_CANNOT_COPY: return "CANNOT_COPY";
    case ERROR_DIRECTORY: return "DIRECTORY";
    case ERROR_EAS_DIDNT_FIT: return "EAS_DIDNT_FIT";
    case ERROR_EA_FILE_CORRUPT: return "EA_FILE_CORRUPT";
    case ERROR_EA_TABLE_FULL: return "EA_TABLE_FULL";
    case ERROR_INVALID_EA_HANDLE: return "INVALID_EA_HANDLE";
    case ERROR_EAS_NOT_SUPPORTED: return "EAS_NOT_SUPPORTED";
    case ERROR_NOT_OWNER: return "NOT_OWNER";
    case ERROR_TOO_MANY_POSTS: return "TOO_MANY_POSTS";
    case ERROR_PARTIAL_COPY: return "PARTIAL_COPY";
    case ERROR_OPLOCK_NOT_GRANTED: return "OPLOCK_NOT_GRANTED";
    case ERROR_INVALID_OPLOCK_PROTOCOL: return "INVALID_OPLOCK_PROTOCOL";
    case ERROR_DISK_TOO_FRAGMENTED: return "DISK_TOO_FRAGMENTED";
    case ERROR_DELETE_PENDING: return "DELETE_PENDING";
    case ERROR_MR_MID_NOT_FOUND: return "MR_MID_NOT_FOUND";
    case ERROR_SCOPE_NOT_FOUND: return "SCOPE_NOT_FOUND";
    case ERROR_INVALID_ADDRESS: return "INVALID_ADDRESS";
    case ERROR_ARITHMETIC_OVERFLOW: return "ARITHMETIC_OVERFLOW";
    case ERROR_PIPE_CONNECTED: return "PIPE_CONNECTED";
    case ERROR_PIPE_LISTENING: return "PIPE_LISTENING";
    case ERROR_WAKE_SYSTEM: return "WAKE_SYSTEM";
    case ERROR_WAIT_1: return "WAIT_1";
    case ERROR_WAIT_2: return "WAIT_2";
    case ERROR_WAIT_3: return "WAIT_3";
    case ERROR_WAIT_63: return "WAIT_63";
    case ERROR_ABANDONED_WAIT_0: return "ABANDONED_WAIT_0";
    case ERROR_ABANDONED_WAIT_63: return "ABANDONED_WAIT_63";
    case ERROR_USER_APC: return "USER_APC";
    case ERROR_KERNEL_APC: return "KERNEL_APC";
    case ERROR_ALERTED: return "ALERTED";
    case ERROR_EA_ACCESS_DENIED: return "EA_ACCESS_DENIED";
    case ERROR_OPERATION_ABORTED: return "OPERATION_ABORTED";
    case ERROR_IO_INCOMPLETE: return "IO_INCOMPLETE";
    case ERROR_IO_PENDING: return "IO_PENDING";
    case ERROR_NOACCESS: return "NOACCESS";
    case ERROR_SWAPERROR: return "SWAPERROR";
    case ERROR_STACK_OVERFLOW: return "STACK_OVERFLOW";
    case ERROR_INVALID_MESSAGE: return "INVALID_MESSAGE";
    case ERROR_CAN_NOT_COMPLETE: return "CAN_NOT_COMPLETE";
    case ERROR_INVALID_FLAGS: return "INVALID_FLAGS";
    case ERROR_UNRECOGNIZED_VOLUME: return "UNRECOGNIZED_VOLUME";
    case ERROR_FILE_INVALID: return "FILE_INVALID";
    case ERROR_FULLSCREEN_MODE: return "FULLSCREEN_MODE";
    case ERROR_NO_TOKEN: return "NO_TOKEN";
    case ERROR_BADDB: return "BADDB";
    case ERROR_BADKEY: return "BADKEY";
    case ERROR_CANTOPEN: return "CANTOPEN";
    case ERROR_CANTREAD: return "CANTREAD";
    case ERROR_CANTWRITE: return "CANTWRITE";
    case ERROR_REGISTRY_RECOVERED: return "REGISTRY_RECOVERED";
    case ERROR_REGISTRY_CORRUPT: return "REGISTRY_CORRUPT";
    case ERROR_REGISTRY_IO_FAILED: return "REGISTRY_IO_FAILED";
    case ERROR_NOT_REGISTRY_FILE: return "NOT_REGISTRY_FILE";
    case ERROR_KEY_DELETED: return "KEY_DELETED";
    case ERROR_NO_LOG_SPACE: return "NO_LOG_SPACE";
    case ERROR_KEY_HAS_CHILDREN: return "KEY_HAS_CHILDREN";
    case ERROR_CHILD_MUST_BE_VOLATILE: return "CHILD_MUST_BE_VOLATILE";
    case ERROR_NOTIFY_ENUM_DIR: return "NOTIFY_ENUM_DIR";
    case ERROR_DEPENDENT_SERVICES_RUNNING: return "DEPENDENT_SERVICES_RUNNING";
    case ERROR_INVALID_SERVICE_CONTROL: return "INVALID_SERVICE_CONTROL";
    case ERROR_SERVICE_REQUEST_TIMEOUT: return "SERVICE_REQUEST_TIMEOUT";
    case ERROR_SERVICE_NO_THREAD: return "SERVICE_NO_THREAD";
    case ERROR_SERVICE_DATABASE_LOCKED: return "SERVICE_DATABASE_LOCKED";
    case ERROR_SERVICE_ALREADY_RUNNING: return "SERVICE_ALREADY_RUNNING";
    case ERROR_INVALID_SERVICE_ACCOUNT: return "INVALID_SERVICE_ACCOUNT";
    case ERROR_SERVICE_DISABLED: return "SERVICE_DISABLED";
    case ERROR_CIRCULAR_DEPENDENCY: return "CIRCULAR_DEPENDENCY";
    case ERROR_SERVICE_DOES_NOT_EXIST: return "SERVICE_DOES_NOT_EXIST";
    case ERROR_SERVICE_CANNOT_ACCEPT_CTRL: return "SERVICE_CANNOT_ACCEPT_CTRL";
    case ERROR_SERVICE_NOT_ACTIVE: return "SERVICE_NOT_ACTIVE";
    case ERROR_FAILED_SERVICE_CONTROLLER_CONNECT: return "FAILED_SERVICE_CONTROLLER_CONNECT";
    case ERROR_EXCEPTION_IN_SERVICE: return "EXCEPTION_IN_SERVICE";
    case ERROR_DATABASE_DOES_NOT_EXIST: return "DATABASE_DOES_NOT_EXIST";
    case ERROR_SERVICE_SPECIFIC_ERROR: return "SERVICE_SPECIFIC_ERROR";
    case ERROR_PROCESS_ABORTED: return "PROCESS_ABORTED";
    case ERROR_SERVICE_DEPENDENCY_FAIL: return "SERVICE_DEPENDENCY_FAIL";
    case ERROR_SERVICE_LOGON_FAILED: return "SERVICE_LOGON_FAILED";
    case ERROR_SERVICE_START_HANG: return "SERVICE_START_HANG";
    case ERROR_INVALID_SERVICE_LOCK: return "INVALID_SERVICE_LOCK";
    case ERROR_SERVICE_MARKED_FOR_DELETE: return "SERVICE_MARKED_FOR_DELETE";
    case ERROR_SERVICE_EXISTS: return "SERVICE_EXISTS";
    case ERROR_ALREADY_RUNNING_LKG: return "ALREADY_RUNNING_LKG";
    case ERROR_SERVICE_DEPENDENCY_DELETED: return "SERVICE_DEPENDENCY_DELETED";
    case ERROR_BOOT_ALREADY_ACCEPTED: return "BOOT_ALREADY_ACCEPTED";
    case ERROR_SERVICE_NEVER_STARTED: return "SERVICE_NEVER_STARTED";
    case ERROR_DUPLICATE_SERVICE_NAME: return "DUPLICATE_SERVICE_NAME";
    case ERROR_DIFFERENT_SERVICE_ACCOUNT: return "DIFFERENT_SERVICE_ACCOUNT";
    case ERROR_CANNOT_DETECT_DRIVER_FAILURE: return "CANNOT_DETECT_DRIVER_FAILURE";
    case ERROR_CANNOT_DETECT_PROCESS_ABORT: return "CANNOT_DETECT_PROCESS_ABORT";
    case ERROR_NO_RECOVERY_PROGRAM: return "NO_RECOVERY_PROGRAM";
    case ERROR_SERVICE_NOT_IN_EXE: return "SERVICE_NOT_IN_EXE";
    case ERROR_NOT_SAFEBOOT_SERVICE: return "NOT_SAFEBOOT_SERVICE";
    case ERROR_END_OF_MEDIA: return "END_OF_MEDIA";
    case ERROR_FILEMARK_DETECTED: return "FILEMARK_DETECTED";
    case ERROR_BEGINNING_OF_MEDIA: return "BEGINNING_OF_MEDIA";
    case ERROR_SETMARK_DETECTED: return "SETMARK_DETECTED";
    case ERROR_NO_DATA_DETECTED: return "NO_DATA_DETECTED";
    case ERROR_PARTITION_FAILURE: return "PARTITION_FAILURE";
    case ERROR_INVALID_BLOCK_LENGTH: return "INVALID_BLOCK_LENGTH";
    case ERROR_DEVICE_NOT_PARTITIONED: return "DEVICE_NOT_PARTITIONED";
    case ERROR_UNABLE_TO_LOCK_MEDIA: return "UNABLE_TO_LOCK_MEDIA";
    case ERROR_UNABLE_TO_UNLOAD_MEDIA: return "UNABLE_TO_UNLOAD_MEDIA";
    case ERROR_MEDIA_CHANGED: return "MEDIA_CHANGED";
    case ERROR_BUS_RESET: return "BUS_RESET";
    case ERROR_NO_MEDIA_IN_DRIVE: return "NO_MEDIA_IN_DRIVE";
    case ERROR_NO_UNICODE_TRANSLATION: return "NO_UNICODE_TRANSLATION";
    case ERROR_DLL_INIT_FAILED: return "DLL_INIT_FAILED";
    case ERROR_SHUTDOWN_IN_PROGRESS: return "SHUTDOWN_IN_PROGRESS";
    case ERROR_NO_SHUTDOWN_IN_PROGRESS: return "NO_SHUTDOWN_IN_PROGRESS";
    case ERROR_IO_DEVICE: return "IO_DEVICE";
    case ERROR_SERIAL_NO_DEVICE: return "SERIAL_NO_DEVICE";
    case ERROR_IRQ_BUSY: return "IRQ_BUSY";
    case ERROR_MORE_WRITES: return "MORE_WRITES";
    case ERROR_COUNTER_TIMEOUT: return "COUNTER_TIMEOUT";
    case ERROR_FLOPPY_ID_MARK_NOT_FOUND: return "FLOPPY_ID_MARK_NOT_FOUND";
    case ERROR_FLOPPY_WRONG_CYLINDER: return "FLOPPY_WRONG_CYLINDER";
    case ERROR_FLOPPY_UNKNOWN_ERROR: return "FLOPPY_UNKNOWN_ERROR";
    case ERROR_FLOPPY_BAD_REGISTERS: return "FLOPPY_BAD_REGISTERS";
    case ERROR_DISK_RECALIBRATE_FAILED: return "DISK_RECALIBRATE_FAILED";
    case ERROR_DISK_OPERATION_FAILED: return "DISK_OPERATION_FAILED";
    case ERROR_DISK_RESET_FAILED: return "DISK_RESET_FAILED";
    case ERROR_EOM_OVERFLOW: return "EOM_OVERFLOW";
    case ERROR_NOT_ENOUGH_SERVER_MEMORY: return "NOT_ENOUGH_SERVER_MEMORY";
    case ERROR_POSSIBLE_DEADLOCK: return "POSSIBLE_DEADLOCK";
    case ERROR_MAPPED_ALIGNMENT: return "MAPPED_ALIGNMENT";
    case ERROR_SET_POWER_STATE_VETOED: return "SET_POWER_STATE_VETOED";
    case ERROR_SET_POWER_STATE_FAILED: return "SET_POWER_STATE_FAILED";
    case ERROR_TOO_MANY_LINKS: return "TOO_MANY_LINKS";
    case ERROR_OLD_WIN_VERSION: return "OLD_WIN_VERSION";
    case ERROR_APP_WRONG_OS: return "APP_WRONG_OS";
    case ERROR_SINGLE_INSTANCE_APP: return "SINGLE_INSTANCE_APP";
    case ERROR_RMODE_APP: return "RMODE_APP";
    case ERROR_INVALID_DLL: return "INVALID_DLL";
    case ERROR_NO_ASSOCIATION: return "NO_ASSOCIATION";
    case ERROR_DDE_FAIL: return "DDE_FAIL";
    case ERROR_DLL_NOT_FOUND: return "DLL_NOT_FOUND";
    case ERROR_NO_MORE_USER_HANDLES: return "NO_MORE_USER_HANDLES";
    case ERROR_MESSAGE_SYNC_ONLY: return "MESSAGE_SYNC_ONLY";
    case ERROR_SOURCE_ELEMENT_EMPTY: return "SOURCE_ELEMENT_EMPTY";
    case ERROR_DESTINATION_ELEMENT_FULL: return "DESTINATION_ELEMENT_FULL";
    case ERROR_ILLEGAL_ELEMENT_ADDRESS: return "ILLEGAL_ELEMENT_ADDRESS";
    case ERROR_MAGAZINE_NOT_PRESENT: return "MAGAZINE_NOT_PRESENT";
    case ERROR_DEVICE_REINITIALIZATION_NEEDED: return "DEVICE_REINITIALIZATION_NEEDED";
    case ERROR_DEVICE_REQUIRES_CLEANING: return "DEVICE_REQUIRES_CLEANING";
    case ERROR_DEVICE_DOOR_OPEN: return "DEVICE_DOOR_OPEN";
    case ERROR_DEVICE_NOT_CONNECTED: return "DEVICE_NOT_CONNECTED";
    case ERROR_NOT_FOUND: return "NOT_FOUND";
    case ERROR_NO_MATCH: return "NO_MATCH";
    case ERROR_SET_NOT_FOUND: return "SET_NOT_FOUND";
    case ERROR_POINT_NOT_FOUND: return "POINT_NOT_FOUND";
    case ERROR_NO_TRACKING_SERVICE: return "NO_TRACKING_SERVICE";
    case ERROR_NO_VOLUME_ID: return "NO_VOLUME_ID";
    case ERROR_UNABLE_TO_REMOVE_REPLACED: return "UNABLE_TO_REMOVE_REPLACED";
    case ERROR_UNABLE_TO_MOVE_REPLACEMENT: return "UNABLE_TO_MOVE_REPLACEMENT";
    case ERROR_UNABLE_TO_MOVE_REPLACEMENT_2: return "UNABLE_TO_MOVE_REPLACEMENT_2";
    case ERROR_JOURNAL_DELETE_IN_PROGRESS: return "JOURNAL_DELETE_IN_PROGRESS";
    case ERROR_JOURNAL_NOT_ACTIVE: return "JOURNAL_NOT_ACTIVE";
    case ERROR_POTENTIAL_FILE_FOUND: return "POTENTIAL_FILE_FOUND";
    case ERROR_JOURNAL_ENTRY_DELETED: return "JOURNAL_ENTRY_DELETED";
    case ERROR_BAD_DEVICE: return "BAD_DEVICE";
    case ERROR_CONNECTION_UNAVAIL: return "CONNECTION_UNAVAIL";
    case ERROR_DEVICE_ALREADY_REMEMBERED: return "DEVICE_ALREADY_REMEMBERED";
    case ERROR_NO_NET_OR_BAD_PATH: return "NO_NET_OR_BAD_PATH";
    case ERROR_BAD_PROVIDER: return "BAD_PROVIDER";
    case ERROR_CANNOT_OPEN_PROFILE: return "CANNOT_OPEN_PROFILE";
    case ERROR_BAD_PROFILE: return "BAD_PROFILE";
    case ERROR_NOT_CONTAINER: return "NOT_CONTAINER";
    case ERROR_EXTENDED_ERROR: return "EXTENDED_ERROR";
    case ERROR_INVALID_GROUPNAME: return "INVALID_GROUPNAME";
    case ERROR_INVALID_COMPUTERNAME: return "INVALID_COMPUTERNAME";
    case ERROR_INVALID_EVENTNAME: return "INVALID_EVENTNAME";
    case ERROR_INVALID_DOMAINNAME: return "INVALID_DOMAINNAME";
    case ERROR_INVALID_SERVICENAME: return "INVALID_SERVICENAME";
    case ERROR_INVALID_NETNAME: return "INVALID_NETNAME";
    case ERROR_INVALID_SHARENAME: return "INVALID_SHARENAME";
    case ERROR_INVALID_PASSWORDNAME: return "INVALID_PASSWORDNAME";
    case ERROR_INVALID_MESSAGENAME: return "INVALID_MESSAGENAME";
    case ERROR_INVALID_MESSAGEDEST: return "INVALID_MESSAGEDEST";
    case ERROR_SESSION_CREDENTIAL_CONFLICT: return "SESSION_CREDENTIAL_CONFLICT";
    case ERROR_REMOTE_SESSION_LIMIT_EXCEEDED: return "REMOTE_SESSION_LIMIT_EXCEEDED";
    case ERROR_DUP_DOMAINNAME: return "DUP_DOMAINNAME";
    case ERROR_NO_NETWORK: return "NO_NETWORK";
    case ERROR_CANCELLED: return "CANCELLED";
    case ERROR_USER_MAPPED_FILE: return "USER_MAPPED_FILE";
    case ERROR_CONNECTION_REFUSED: return "CONNECTION_REFUSED";
    case ERROR_GRACEFUL_DISCONNECT: return "GRACEFUL_DISCONNECT";
    case ERROR_ADDRESS_ALREADY_ASSOCIATED: return "ADDRESS_ALREADY_ASSOCIATED";
    case ERROR_ADDRESS_NOT_ASSOCIATED: return "ADDRESS_NOT_ASSOCIATED";
    case ERROR_CONNECTION_INVALID: return "CONNECTION_INVALID";
    case ERROR_CONNECTION_ACTIVE: return "CONNECTION_ACTIVE";
    case ERROR_NETWORK_UNREACHABLE: return "NETWORK_UNREACHABLE";
    case ERROR_HOST_UNREACHABLE: return "HOST_UNREACHABLE";
    case ERROR_PROTOCOL_UNREACHABLE: return "PROTOCOL_UNREACHABLE";
    case ERROR_PORT_UNREACHABLE: return "PORT_UNREACHABLE";
    case ERROR_REQUEST_ABORTED: return "REQUEST_ABORTED";
    case ERROR_CONNECTION_ABORTED: return "CONNECTION_ABORTED";
    case ERROR_RETRY: return "RETRY";
    case ERROR_CONNECTION_COUNT_LIMIT: return "CONNECTION_COUNT_LIMIT";
    case ERROR_LOGIN_TIME_RESTRICTION: return "LOGIN_TIME_RESTRICTION";
    case ERROR_LOGIN_WKSTA_RESTRICTION: return "LOGIN_WKSTA_RESTRICTION";
    case ERROR_INCORRECT_ADDRESS: return "INCORRECT_ADDRESS";
    case ERROR_ALREADY_REGISTERED: return "ALREADY_REGISTERED";
    case ERROR_SERVICE_NOT_FOUND: return "SERVICE_NOT_FOUND";
    case ERROR_NOT_AUTHENTICATED: return "NOT_AUTHENTICATED";
    case ERROR_NOT_LOGGED_ON: return "NOT_LOGGED_ON";
    case ERROR_CONTINUE: return "CONTINUE";
    case ERROR_ALREADY_INITIALIZED: return "ALREADY_INITIALIZED";
    case ERROR_NO_MORE_DEVICES: return "NO_MORE_DEVICES";
    case ERROR_NO_SUCH_SITE: return "NO_SUCH_SITE";
    case ERROR_DOMAIN_CONTROLLER_EXISTS: return "DOMAIN_CONTROLLER_EXISTS";
    case ERROR_ONLY_IF_CONNECTED: return "ONLY_IF_CONNECTED";
    case ERROR_OVERRIDE_NOCHANGES: return "OVERRIDE_NOCHANGES";
    case ERROR_BAD_USER_PROFILE: return "BAD_USER_PROFILE";
    case ERROR_NOT_SUPPORTED_ON_SBS: return "NOT_SUPPORTED_ON_SBS";
    case ERROR_SERVER_SHUTDOWN_IN_PROGRESS: return "SERVER_SHUTDOWN_IN_PROGRESS";
    case ERROR_HOST_DOWN: return "HOST_DOWN";
    case ERROR_NON_ACCOUNT_SID: return "NON_ACCOUNT_SID";
    case ERROR_NON_DOMAIN_SID: return "NON_DOMAIN_SID";
    case ERROR_APPHELP_BLOCK: return "APPHELP_BLOCK";
    case ERROR_ACCESS_DISABLED_BY_POLICY: return "ACCESS_DISABLED_BY_POLICY";
    case ERROR_REG_NAT_CONSUMPTION: return "REG_NAT_CONSUMPTION";
    case ERROR_CSCSHARE_OFFLINE: return "CSCSHARE_OFFLINE";
    case ERROR_PKINIT_FAILURE: return "PKINIT_FAILURE";
    case ERROR_SMARTCARD_SUBSYSTEM_FAILURE: return "SMARTCARD_SUBSYSTEM_FAILURE";
    case ERROR_DOWNGRADE_DETECTED: return "DOWNGRADE_DETECTED";
    case ERROR_MACHINE_LOCKED: return "MACHINE_LOCKED";
    case ERROR_CALLBACK_SUPPLIED_INVALID_DATA: return "CALLBACK_SUPPLIED_INVALID_DATA";
    case ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED: return "SYNC_FOREGROUND_REFRESH_REQUIRED";
    case ERROR_DRIVER_BLOCKED: return "DRIVER_BLOCKED";
    case ERROR_INVALID_IMPORT_OF_NON_DLL: return "INVALID_IMPORT_OF_NON_DLL";
    case ERROR_ACCESS_DISABLED_WEBBLADE: return "ACCESS_DISABLED_WEBBLADE";
    case ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER: return "ACCESS_DISABLED_WEBBLADE_TAMPER";
    case ERROR_RECOVERY_FAILURE: return "RECOVERY_FAILURE";
    case ERROR_ALREADY_FIBER: return "ALREADY_FIBER";
    case ERROR_ALREADY_THREAD: return "ALREADY_THREAD";
    case ERROR_STACK_BUFFER_OVERRUN: return "STACK_BUFFER_OVERRUN";
    case ERROR_PARAMETER_QUOTA_EXCEEDED: return "PARAMETER_QUOTA_EXCEEDED";
    case ERROR_DEBUGGER_INACTIVE: return "DEBUGGER_INACTIVE";
    case ERROR_DELAY_LOAD_FAILED: return "DELAY_LOAD_FAILED";
    case ERROR_VDM_DISALLOWED: return "VDM_DISALLOWED";
    case ERROR_UNIDENTIFIED_ERROR: return "UNIDENTIFIED_ERROR";
    case ERROR_NOT_ALL_ASSIGNED: return "NOT_ALL_ASSIGNED";
    case ERROR_SOME_NOT_MAPPED: return "SOME_NOT_MAPPED";
    case ERROR_NO_QUOTAS_FOR_ACCOUNT: return "NO_QUOTAS_FOR_ACCOUNT";
    case ERROR_LOCAL_USER_SESSION_KEY: return "LOCAL_USER_SESSION_KEY";
    case ERROR_NULL_LM_PASSWORD: return "NULL_LM_PASSWORD";
    case ERROR_UNKNOWN_REVISION: return "UNKNOWN_REVISION";
    case ERROR_REVISION_MISMATCH: return "REVISION_MISMATCH";
    case ERROR_INVALID_OWNER: return "INVALID_OWNER";
    case ERROR_INVALID_PRIMARY_GROUP: return "INVALID_PRIMARY_GROUP";
    case ERROR_NO_IMPERSONATION_TOKEN: return "NO_IMPERSONATION_TOKEN";
    case ERROR_CANT_DISABLE_MANDATORY: return "CANT_DISABLE_MANDATORY";
    case ERROR_NO_LOGON_SERVERS: return "NO_LOGON_SERVERS";
    case ERROR_NO_SUCH_LOGON_SESSION: return "NO_SUCH_LOGON_SESSION";
    case ERROR_NO_SUCH_PRIVILEGE: return "NO_SUCH_PRIVILEGE";
    case ERROR_PRIVILEGE_NOT_HELD: return "PRIVILEGE_NOT_HELD";
    case ERROR_INVALID_ACCOUNT_NAME: return "INVALID_ACCOUNT_NAME";
    case ERROR_USER_EXISTS: return "USER_EXISTS";
    case ERROR_NO_SUCH_USER: return "NO_SUCH_USER";
    case ERROR_GROUP_EXISTS: return "GROUP_EXISTS";
    case ERROR_NO_SUCH_GROUP: return "NO_SUCH_GROUP";
    case ERROR_MEMBER_IN_GROUP: return "MEMBER_IN_GROUP";
    case ERROR_MEMBER_NOT_IN_GROUP: return "MEMBER_NOT_IN_GROUP";
    case ERROR_LAST_ADMIN: return "LAST_ADMIN";
    case ERROR_WRONG_PASSWORD: return "WRONG_PASSWORD";
    case ERROR_ILL_FORMED_PASSWORD: return "ILL_FORMED_PASSWORD";
    case ERROR_PASSWORD_RESTRICTION: return "PASSWORD_RESTRICTION";
    case ERROR_LOGON_FAILURE: return "LOGON_FAILURE";
    case ERROR_ACCOUNT_RESTRICTION: return "ACCOUNT_RESTRICTION";
    case ERROR_INVALID_LOGON_HOURS: return "INVALID_LOGON_HOURS";
    case ERROR_INVALID_WORKSTATION: return "INVALID_WORKSTATION";
    case ERROR_PASSWORD_EXPIRED: return "PASSWORD_EXPIRED";
    case ERROR_ACCOUNT_DISABLED: return "ACCOUNT_DISABLED";
    case ERROR_NONE_MAPPED: return "NONE_MAPPED";
    case ERROR_TOO_MANY_LUIDS_REQUESTED: return "TOO_MANY_LUIDS_REQUESTED";
    case ERROR_LUIDS_EXHAUSTED: return "LUIDS_EXHAUSTED";
    case ERROR_INVALID_SUB_AUTHORITY: return "INVALID_SUB_AUTHORITY";
    case ERROR_INVALID_ACL: return "INVALID_ACL";
    case ERROR_INVALID_SID: return "INVALID_SID";
    case ERROR_INVALID_SECURITY_DESCR: return "INVALID_SECURITY_DESCR";
    case ERROR_BAD_INHERITANCE_ACL: return "BAD_INHERITANCE_ACL";
    case ERROR_SERVER_DISABLED: return "SERVER_DISABLED";
    case ERROR_SERVER_NOT_DISABLED: return "SERVER_NOT_DISABLED";
    case ERROR_INVALID_ID_AUTHORITY: return "INVALID_ID_AUTHORITY";
    case ERROR_ALLOTTED_SPACE_EXCEEDED: return "ALLOTTED_SPACE_EXCEEDED";
    case ERROR_INVALID_GROUP_ATTRIBUTES: return "INVALID_GROUP_ATTRIBUTES";
    case ERROR_BAD_IMPERSONATION_LEVEL: return "BAD_IMPERSONATION_LEVEL";
    case ERROR_CANT_OPEN_ANONYMOUS: return "CANT_OPEN_ANONYMOUS";
    case ERROR_BAD_VALIDATION_CLASS: return "BAD_VALIDATION_CLASS";
    case ERROR_BAD_TOKEN_TYPE: return "BAD_TOKEN_TYPE";
    case ERROR_NO_SECURITY_ON_OBJECT: return "NO_SECURITY_ON_OBJECT";
    case ERROR_CANT_ACCESS_DOMAIN_INFO: return "CANT_ACCESS_DOMAIN_INFO";
    case ERROR_INVALID_SERVER_STATE: return "INVALID_SERVER_STATE";
    case ERROR_INVALID_DOMAIN_STATE: return "INVALID_DOMAIN_STATE";
    case ERROR_INVALID_DOMAIN_ROLE: return "INVALID_DOMAIN_ROLE";
    case ERROR_NO_SUCH_DOMAIN: return "NO_SUCH_DOMAIN";
    case ERROR_DOMAIN_EXISTS: return "DOMAIN_EXISTS";
    case ERROR_DOMAIN_LIMIT_EXCEEDED: return "DOMAIN_LIMIT_EXCEEDED";
    case ERROR_INTERNAL_DB_CORRUPTION: return "INTERNAL_DB_CORRUPTION";
    case ERROR_INTERNAL_ERROR: return "INTERNAL_ERROR";
    case ERROR_GENERIC_NOT_MAPPED: return "GENERIC_NOT_MAPPED";
    case ERROR_BAD_DESCRIPTOR_FORMAT: return "BAD_DESCRIPTOR_FORMAT";
    case ERROR_NOT_LOGON_PROCESS: return "NOT_LOGON_PROCESS";
    case ERROR_LOGON_SESSION_EXISTS: return "LOGON_SESSION_EXISTS";
    case ERROR_NO_SUCH_PACKAGE: return "NO_SUCH_PACKAGE";
    case ERROR_BAD_LOGON_SESSION_STATE: return "BAD_LOGON_SESSION_STATE";
    case ERROR_LOGON_SESSION_COLLISION: return "LOGON_SESSION_COLLISION";
    case ERROR_INVALID_LOGON_TYPE: return "INVALID_LOGON_TYPE";
    case ERROR_CANNOT_IMPERSONATE: return "CANNOT_IMPERSONATE";
    case ERROR_RXACT_INVALID_STATE: return "RXACT_INVALID_STATE";
    case ERROR_RXACT_COMMIT_FAILURE: return "RXACT_COMMIT_FAILURE";
    case ERROR_SPECIAL_ACCOUNT: return "SPECIAL_ACCOUNT";
    case ERROR_SPECIAL_GROUP: return "SPECIAL_GROUP";
    case ERROR_SPECIAL_USER: return "SPECIAL_USER";
    case ERROR_MEMBERS_PRIMARY_GROUP: return "MEMBERS_PRIMARY_GROUP";
    case ERROR_TOKEN_ALREADY_IN_USE: return "TOKEN_ALREADY_IN_USE";
    case ERROR_NO_SUCH_ALIAS: return "NO_SUCH_ALIAS";
    case ERROR_MEMBER_NOT_IN_ALIAS: return "MEMBER_NOT_IN_ALIAS";
    case ERROR_MEMBER_IN_ALIAS: return "MEMBER_IN_ALIAS";
    case ERROR_ALIAS_EXISTS: return "ALIAS_EXISTS";
    case ERROR_LOGON_NOT_GRANTED: return "LOGON_NOT_GRANTED";
    case ERROR_TOO_MANY_SECRETS: return "TOO_MANY_SECRETS";
    case ERROR_SECRET_TOO_LONG: return "SECRET_TOO_LONG";
    case ERROR_INTERNAL_DB_ERROR: return "INTERNAL_DB_ERROR";
    case ERROR_TOO_MANY_CONTEXT_IDS: return "TOO_MANY_CONTEXT_IDS";
    case ERROR_LOGON_TYPE_NOT_GRANTED: return "LOGON_TYPE_NOT_GRANTED";
    case ERROR_NT_CROSS_ENCRYPTION_REQUIRED: return "NT_CROSS_ENCRYPTION_REQUIRED";
    case ERROR_NO_SUCH_MEMBER: return "NO_SUCH_MEMBER";
    case ERROR_INVALID_MEMBER: return "INVALID_MEMBER";
    case ERROR_TOO_MANY_SIDS: return "TOO_MANY_SIDS";
    case ERROR_LM_CROSS_ENCRYPTION_REQUIRED: return "LM_CROSS_ENCRYPTION_REQUIRED";
    case ERROR_NO_INHERITANCE: return "NO_INHERITANCE";
    case ERROR_FILE_CORRUPT: return "FILE_CORRUPT";
    case ERROR_DISK_CORRUPT: return "DISK_CORRUPT";
    case ERROR_NO_USER_SESSION_KEY: return "NO_USER_SESSION_KEY";
    case ERROR_LICENSE_QUOTA_EXCEEDED: return "LICENSE_QUOTA_EXCEEDED";
    case ERROR_WRONG_TARGET_NAME: return "WRONG_TARGET_NAME";
    case ERROR_MUTUAL_AUTH_FAILED: return "MUTUAL_AUTH_FAILED";
    case ERROR_TIME_SKEW: return "TIME_SKEW";
    case ERROR_CURRENT_DOMAIN_NOT_ALLOWED: return "CURRENT_DOMAIN_NOT_ALLOWED";
    case ERROR_INVALID_WINDOW_HANDLE: return "INVALID_WINDOW_HANDLE";
    case ERROR_INVALID_MENU_HANDLE: return "INVALID_MENU_HANDLE";
    case ERROR_INVALID_CURSOR_HANDLE: return "INVALID_CURSOR_HANDLE";
    case ERROR_INVALID_ACCEL_HANDLE: return "INVALID_ACCEL_HANDLE";
    case ERROR_INVALID_HOOK_HANDLE: return "INVALID_HOOK_HANDLE";
    case ERROR_INVALID_DWP_HANDLE: return "INVALID_DWP_HANDLE";
    case ERROR_TLW_WITH_WSCHILD: return "TLW_WITH_WSCHILD";
    case ERROR_CANNOT_FIND_WND_CLASS: return "CANNOT_FIND_WND_CLASS";
    case ERROR_WINDOW_OF_OTHER_THREAD: return "WINDOW_OF_OTHER_THREAD";
    case ERROR_HOTKEY_ALREADY_REGISTERED: return "HOTKEY_ALREADY_REGISTERED";
    case ERROR_CLASS_ALREADY_EXISTS: return "CLASS_ALREADY_EXISTS";
    case ERROR_CLASS_DOES_NOT_EXIST: return "CLASS_DOES_NOT_EXIST";
    case ERROR_CLASS_HAS_WINDOWS: return "CLASS_HAS_WINDOWS";
    case ERROR_INVALID_INDEX: return "INVALID_INDEX";
    case ERROR_INVALID_ICON_HANDLE: return "INVALID_ICON_HANDLE";
    case ERROR_PRIVATE_DIALOG_INDEX: return "PRIVATE_DIALOG_INDEX";
    case ERROR_LISTBOX_ID_NOT_FOUND: return "LISTBOX_ID_NOT_FOUND";
    case ERROR_NO_WILDCARD_CHARACTERS: return "NO_WILDCARD_CHARACTERS";
    case ERROR_CLIPBOARD_NOT_OPEN: return "CLIPBOARD_NOT_OPEN";
    case ERROR_HOTKEY_NOT_REGISTERED: return "HOTKEY_NOT_REGISTERED";
    case ERROR_WINDOW_NOT_DIALOG: return "WINDOW_NOT_DIALOG";
    case ERROR_CONTROL_ID_NOT_FOUND: return "CONTROL_ID_NOT_FOUND";
    case ERROR_INVALID_COMBOBOX_MESSAGE: return "INVALID_COMBOBOX_MESSAGE";
    case ERROR_WINDOW_NOT_COMBOBOX: return "WINDOW_NOT_COMBOBOX";
    case ERROR_INVALID_EDIT_HEIGHT: return "INVALID_EDIT_HEIGHT";
    case ERROR_DC_NOT_FOUND: return "DC_NOT_FOUND";
    case ERROR_INVALID_HOOK_FILTER: return "INVALID_HOOK_FILTER";
    case ERROR_INVALID_FILTER_PROC: return "INVALID_FILTER_PROC";
    case ERROR_HOOK_NEEDS_HMOD: return "HOOK_NEEDS_HMOD";
    case ERROR_GLOBAL_ONLY_HOOK: return "GLOBAL_ONLY_HOOK";
    case ERROR_JOURNAL_HOOK_SET: return "JOURNAL_HOOK_SET";
    case ERROR_HOOK_NOT_INSTALLED: return "HOOK_NOT_INSTALLED";
    case ERROR_INVALID_LB_MESSAGE: return "INVALID_LB_MESSAGE";
    case ERROR_SETCOUNT_ON_BAD_LB: return "SETCOUNT_ON_BAD_LB";
    case ERROR_LB_WITHOUT_TABSTOPS: return "LB_WITHOUT_TABSTOPS";
    case ERROR_DESTROY_OBJECT_OF_OTHER_THREAD: return "DESTROY_OBJECT_OF_OTHER_THREAD";
    case ERROR_CHILD_WINDOW_MENU: return "CHILD_WINDOW_MENU";
    case ERROR_NO_SYSTEM_MENU: return "NO_SYSTEM_MENU";
    case ERROR_INVALID_MSGBOX_STYLE: return "INVALID_MSGBOX_STYLE";
    case ERROR_INVALID_SPI_VALUE: return "INVALID_SPI_VALUE";
    case ERROR_SCREEN_ALREADY_LOCKED: return "SCREEN_ALREADY_LOCKED";
    case ERROR_HWNDS_HAVE_DIFF_PARENT: return "HWNDS_HAVE_DIFF_PARENT";
    case ERROR_NOT_CHILD_WINDOW: return "NOT_CHILD_WINDOW";
    case ERROR_INVALID_GW_COMMAND: return "INVALID_GW_COMMAND";
    case ERROR_INVALID_THREAD_ID: return "INVALID_THREAD_ID";
    case ERROR_NON_MDICHILD_WINDOW: return "NON_MDICHILD_WINDOW";
    case ERROR_POPUP_ALREADY_ACTIVE: return "POPUP_ALREADY_ACTIVE";
    case ERROR_NO_SCROLLBARS: return "NO_SCROLLBARS";
    case ERROR_INVALID_SCROLLBAR_RANGE: return "INVALID_SCROLLBAR_RANGE";
    case ERROR_INVALID_SHOWWIN_COMMAND: return "INVALID_SHOWWIN_COMMAND";
    case ERROR_NO_SYSTEM_RESOURCES: return "NO_SYSTEM_RESOURCES";
    case ERROR_NONPAGED_SYSTEM_RESOURCES: return "NONPAGED_SYSTEM_RESOURCES";
    case ERROR_PAGED_SYSTEM_RESOURCES: return "PAGED_SYSTEM_RESOURCES";
    case ERROR_WORKING_SET_QUOTA: return "WORKING_SET_QUOTA";
    case ERROR_PAGEFILE_QUOTA: return "PAGEFILE_QUOTA";
    case ERROR_COMMITMENT_LIMIT: return "COMMITMENT_LIMIT";
    case ERROR_MENU_ITEM_NOT_FOUND: return "MENU_ITEM_NOT_FOUND";
    case ERROR_INVALID_KEYBOARD_HANDLE: return "INVALID_KEYBOARD_HANDLE";
    case ERROR_HOOK_TYPE_NOT_ALLOWED: return "HOOK_TYPE_NOT_ALLOWED";
    case ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION: return "REQUIRES_INTERACTIVE_WINDOWSTATION";
    case ERROR_TIMEOUT: return "TIMEOUT";
    case ERROR_INVALID_MONITOR_HANDLE: return "INVALID_MONITOR_HANDLE";
    case ERROR_INCORRECT_SIZE: return "INCORRECT_SIZE";
    case ERROR_EVENTLOG_FILE_CORRUPT: return "EVENTLOG_FILE_CORRUPT";
    case ERROR_EVENTLOG_CANT_START: return "EVENTLOG_CANT_START";
    case ERROR_LOG_FILE_FULL: return "LOG_FILE_FULL";
    case ERROR_EVENTLOG_FILE_CHANGED: return "EVENTLOG_FILE_CHANGED";
    case ERROR_INSTALL_SERVICE_FAILURE: return "INSTALL_SERVICE_FAILURE";
    case ERROR_INSTALL_USEREXIT: return "INSTALL_USEREXIT";
    case ERROR_INSTALL_FAILURE: return "INSTALL_FAILURE";
    case ERROR_INSTALL_SUSPEND: return "INSTALL_SUSPEND";
    case ERROR_UNKNOWN_PRODUCT: return "UNKNOWN_PRODUCT";
    case ERROR_UNKNOWN_FEATURE: return "UNKNOWN_FEATURE";
    case ERROR_UNKNOWN_COMPONENT: return "UNKNOWN_COMPONENT";
    case ERROR_UNKNOWN_PROPERTY: return "UNKNOWN_PROPERTY";
    case ERROR_INVALID_HANDLE_STATE: return "INVALID_HANDLE_STATE";
    case ERROR_BAD_CONFIGURATION: return "BAD_CONFIGURATION";
    case ERROR_INDEX_ABSENT: return "INDEX_ABSENT";
    case ERROR_INSTALL_SOURCE_ABSENT: return "INSTALL_SOURCE_ABSENT";
    case ERROR_INSTALL_PACKAGE_VERSION: return "INSTALL_PACKAGE_VERSION";
    case ERROR_PRODUCT_UNINSTALLED: return "PRODUCT_UNINSTALLED";
    case ERROR_BAD_QUERY_SYNTAX: return "BAD_QUERY_SYNTAX";
    case ERROR_INVALID_FIELD: return "INVALID_FIELD";
    case ERROR_DEVICE_REMOVED: return "DEVICE_REMOVED";
    case ERROR_INSTALL_ALREADY_RUNNING: return "INSTALL_ALREADY_RUNNING";
    case ERROR_INSTALL_PACKAGE_OPEN_FAILED: return "INSTALL_PACKAGE_OPEN_FAILED";
    case ERROR_INSTALL_PACKAGE_INVALID: return "INSTALL_PACKAGE_INVALID";
    case ERROR_INSTALL_UI_FAILURE: return "INSTALL_UI_FAILURE";
    case ERROR_INSTALL_LOG_FAILURE: return "INSTALL_LOG_FAILURE";
    case ERROR_INSTALL_LANGUAGE_UNSUPPORTED: return "INSTALL_LANGUAGE_UNSUPPORTED";
    case ERROR_INSTALL_TRANSFORM_FAILURE: return "INSTALL_TRANSFORM_FAILURE";
    case ERROR_INSTALL_PACKAGE_REJECTED: return "INSTALL_PACKAGE_REJECTED";
    case ERROR_FUNCTION_NOT_CALLED: return "FUNCTION_NOT_CALLED";
    case ERROR_FUNCTION_FAILED: return "FUNCTION_FAILED";
    case ERROR_INVALID_TABLE: return "INVALID_TABLE";
    case ERROR_DATATYPE_MISMATCH: return "DATATYPE_MISMATCH";
    case ERROR_UNSUPPORTED_TYPE: return "UNSUPPORTED_TYPE";
    case ERROR_CREATE_FAILED: return "CREATE_FAILED";
    case ERROR_INSTALL_TEMP_UNWRITABLE: return "INSTALL_TEMP_UNWRITABLE";
    case ERROR_INSTALL_PLATFORM_UNSUPPORTED: return "INSTALL_PLATFORM_UNSUPPORTED";
    case ERROR_INSTALL_NOTUSED: return "INSTALL_NOTUSED";
    case ERROR_PATCH_PACKAGE_OPEN_FAILED: return "PATCH_PACKAGE_OPEN_FAILED";
    case ERROR_PATCH_PACKAGE_INVALID: return "PATCH_PACKAGE_INVALID";
    case ERROR_PATCH_PACKAGE_UNSUPPORTED: return "PATCH_PACKAGE_UNSUPPORTED";
    case ERROR_PRODUCT_VERSION: return "PRODUCT_VERSION";
    case ERROR_INVALID_COMMAND_LINE: return "INVALID_COMMAND_LINE";
    case ERROR_INSTALL_REMOTE_DISALLOWED: return "INSTALL_REMOTE_DISALLOWED";
    case ERROR_SUCCESS_REBOOT_INITIATED: return "SUCCESS_REBOOT_INITIATED";
    case ERROR_PATCH_TARGET_NOT_FOUND: return "PATCH_TARGET_NOT_FOUND";
    case ERROR_PATCH_PACKAGE_REJECTED: return "PATCH_PACKAGE_REJECTED";
    case ERROR_INSTALL_TRANSFORM_REJECTED: return "INSTALL_TRANSFORM_REJECTED";
    case ERROR_INSTALL_REMOTE_PROHIBITED: return "INSTALL_REMOTE_PROHIBITED";
    case ERROR_INVALID_USER_BUFFER: return "INVALID_USER_BUFFER";
    case ERROR_UNRECOGNIZED_MEDIA: return "UNRECOGNIZED_MEDIA";
    case ERROR_NO_TRUST_LSA_SECRET: return "NO_TRUST_LSA_SECRET";
    case ERROR_NO_TRUST_SAM_ACCOUNT: return "NO_TRUST_SAM_ACCOUNT";
    case ERROR_TRUSTED_DOMAIN_FAILURE: return "TRUSTED_DOMAIN_FAILURE";
    case ERROR_TRUSTED_RELATIONSHIP_FAILURE: return "TRUSTED_RELATIONSHIP_FAILURE";
    case ERROR_TRUST_FAILURE: return "TRUST_FAILURE";
    case ERROR_NETLOGON_NOT_STARTED: return "NETLOGON_NOT_STARTED";
    case ERROR_ACCOUNT_EXPIRED: return "ACCOUNT_EXPIRED";
    case ERROR_REDIRECTOR_HAS_OPEN_HANDLES: return "REDIRECTOR_HAS_OPEN_HANDLES";
    case ERROR_PRINTER_DRIVER_ALREADY_INSTALLED: return "PRINTER_DRIVER_ALREADY_INSTALLED";
    case ERROR_UNKNOWN_PORT: return "UNKNOWN_PORT";
    case ERROR_UNKNOWN_PRINTER_DRIVER: return "UNKNOWN_PRINTER_DRIVER";
    case ERROR_UNKNOWN_PRINTPROCESSOR: return "UNKNOWN_PRINTPROCESSOR";
    case ERROR_INVALID_SEPARATOR_FILE: return "INVALID_SEPARATOR_FILE";
    case ERROR_INVALID_PRIORITY: return "INVALID_PRIORITY";
    case ERROR_INVALID_PRINTER_NAME: return "INVALID_PRINTER_NAME";
    case ERROR_PRINTER_ALREADY_EXISTS: return "PRINTER_ALREADY_EXISTS";
    case ERROR_INVALID_PRINTER_COMMAND: return "INVALID_PRINTER_COMMAND";
    case ERROR_INVALID_DATATYPE: return "INVALID_DATATYPE";
    case ERROR_INVALID_ENVIRONMENT: return "INVALID_ENVIRONMENT";
    case ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT: return "NOLOGON_INTERDOMAIN_TRUST_ACCOUNT";
    case ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT: return "NOLOGON_WORKSTATION_TRUST_ACCOUNT";
    case ERROR_NOLOGON_SERVER_TRUST_ACCOUNT: return "NOLOGON_SERVER_TRUST_ACCOUNT";
    case ERROR_DOMAIN_TRUST_INCONSISTENT: return "DOMAIN_TRUST_INCONSISTENT";
    case ERROR_SERVER_HAS_OPEN_HANDLES: return "SERVER_HAS_OPEN_HANDLES";
    case ERROR_RESOURCE_DATA_NOT_FOUND: return "RESOURCE_DATA_NOT_FOUND";
    case ERROR_RESOURCE_TYPE_NOT_FOUND: return "RESOURCE_TYPE_NOT_FOUND";
    case ERROR_RESOURCE_NAME_NOT_FOUND: return "RESOURCE_NAME_NOT_FOUND";
    case ERROR_RESOURCE_LANG_NOT_FOUND: return "RESOURCE_LANG_NOT_FOUND";
    case ERROR_NOT_ENOUGH_QUOTA: return "NOT_ENOUGH_QUOTA";
    case ERROR_INVALID_TIME: return "INVALID_TIME";
    case ERROR_INVALID_FORM_NAME: return "INVALID_FORM_NAME";
    case ERROR_INVALID_FORM_SIZE: return "INVALID_FORM_SIZE";
    case ERROR_ALREADY_WAITING: return "ALREADY_WAITING";
    case ERROR_PRINTER_DELETED: return "PRINTER_DELETED";
    case ERROR_INVALID_PRINTER_STATE: return "INVALID_PRINTER_STATE";
    case ERROR_PASSWORD_MUST_CHANGE: return "PASSWORD_MUST_CHANGE";
    case ERROR_DOMAIN_CONTROLLER_NOT_FOUND: return "DOMAIN_CONTROLLER_NOT_FOUND";
    case ERROR_ACCOUNT_LOCKED_OUT: return "ACCOUNT_LOCKED_OUT";
    case ERROR_NO_SITENAME: return "NO_SITENAME";
    case ERROR_CANT_ACCESS_FILE: return "CANT_ACCESS_FILE";
    case ERROR_CANT_RESOLVE_FILENAME: return "CANT_RESOLVE_FILENAME";
    case ERROR_KM_DRIVER_BLOCKED: return "KM_DRIVER_BLOCKED";
    case ERROR_CONTEXT_EXPIRED: return "CONTEXT_EXPIRED";
    case ERROR_PER_USER_TRUST_QUOTA_EXCEEDED: return "PER_USER_TRUST_QUOTA_EXCEEDED";
    case ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED: return "ALL_USER_TRUST_QUOTA_EXCEEDED";
    case ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED: return "USER_DELETE_TRUST_QUOTA_EXCEEDED";
    case ERROR_AUTHENTICATION_FIREWALL_FAILED: return "AUTHENTICATION_FIREWALL_FAILED";
    case ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED: return "REMOTE_PRINT_CONNECTIONS_BLOCKED";
    case ERROR_INVALID_PIXEL_FORMAT: return "INVALID_PIXEL_FORMAT";
    case ERROR_BAD_DRIVER: return "BAD_DRIVER";
    case ERROR_INVALID_WINDOW_STYLE: return "INVALID_WINDOW_STYLE";
    case ERROR_METAFILE_NOT_SUPPORTED: return "METAFILE_NOT_SUPPORTED";
    case ERROR_TRANSFORM_NOT_SUPPORTED: return "TRANSFORM_NOT_SUPPORTED";
    case ERROR_CLIPPING_NOT_SUPPORTED: return "CLIPPING_NOT_SUPPORTED";
    case ERROR_INVALID_CMM: return "INVALID_CMM";
    case ERROR_INVALID_PROFILE: return "INVALID_PROFILE";
    case ERROR_TAG_NOT_FOUND: return "TAG_NOT_FOUND";
    case ERROR_TAG_NOT_PRESENT: return "TAG_NOT_PRESENT";
    case ERROR_DUPLICATE_TAG: return "DUPLICATE_TAG";
    case ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE: return "PROFILE_NOT_ASSOCIATED_WITH_DEVICE";
    case ERROR_PROFILE_NOT_FOUND: return "PROFILE_NOT_FOUND";
    case ERROR_INVALID_COLORSPACE: return "INVALID_COLORSPACE";
    case ERROR_ICM_NOT_ENABLED: return "ICM_NOT_ENABLED";
    case ERROR_DELETING_ICM_XFORM: return "DELETING_ICM_XFORM";
    case ERROR_INVALID_TRANSFORM: return "INVALID_TRANSFORM";
    case ERROR_COLORSPACE_MISMATCH: return "COLORSPACE_MISMATCH";
    case ERROR_INVALID_COLORINDEX: return "INVALID_COLORINDEX";
    case ERROR_CONNECTED_OTHER_PASSWORD: return "CONNECTED_OTHER_PASSWORD";
    case ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT: return "CONNECTED_OTHER_PASSWORD_DEFAULT";
    case ERROR_BAD_USERNAME: return "BAD_USERNAME";
    case ERROR_NOT_CONNECTED: return "NOT_CONNECTED";
    case ERROR_OPEN_FILES: return "OPEN_FILES";
    case ERROR_ACTIVE_CONNECTIONS: return "ACTIVE_CONNECTIONS";
    case ERROR_DEVICE_IN_USE: return "DEVICE_IN_USE";
    case ERROR_UNKNOWN_PRINT_MONITOR: return "UNKNOWN_PRINT_MONITOR";
    case ERROR_PRINTER_DRIVER_IN_USE: return "PRINTER_DRIVER_IN_USE";
    case ERROR_SPOOL_FILE_NOT_FOUND: return "SPOOL_FILE_NOT_FOUND";
    case ERROR_SPL_NO_STARTDOC: return "SPL_NO_STARTDOC";
    case ERROR_SPL_NO_ADDJOB: return "SPL_NO_ADDJOB";
    case ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED: return "PRINT_PROCESSOR_ALREADY_INSTALLED";
    case ERROR_PRINT_MONITOR_ALREADY_INSTALLED: return "PRINT_MONITOR_ALREADY_INSTALLED";
    case ERROR_INVALID_PRINT_MONITOR: return "INVALID_PRINT_MONITOR";
    case ERROR_PRINT_MONITOR_IN_USE: return "PRINT_MONITOR_IN_USE";
    case ERROR_PRINTER_HAS_JOBS_QUEUED: return "PRINTER_HAS_JOBS_QUEUED";
    case ERROR_SUCCESS_REBOOT_REQUIRED: return "SUCCESS_REBOOT_REQUIRED";
    case ERROR_SUCCESS_RESTART_REQUIRED: return "SUCCESS_RESTART_REQUIRED";
    case ERROR_PRINTER_NOT_FOUND: return "PRINTER_NOT_FOUND";
    case ERROR_PRINTER_DRIVER_WARNED: return "PRINTER_DRIVER_WARNED";
    case ERROR_PRINTER_DRIVER_BLOCKED: return "PRINTER_DRIVER_BLOCKED";
    case ERROR_WINS_INTERNAL: return "WINS_INTERNAL";
    case ERROR_CAN_NOT_DEL_LOCAL_WINS: return "CAN_NOT_DEL_LOCAL_WINS";
    case ERROR_STATIC_INIT: return "STATIC_INIT";
    case ERROR_INC_BACKUP: return "INC_BACKUP";
    case ERROR_FULL_BACKUP: return "FULL_BACKUP";
    case ERROR_REC_NON_EXISTENT: return "REC_NON_EXISTENT";
    case ERROR_RPL_NOT_ALLOWED: return "RPL_NOT_ALLOWED";
    case ERROR_DHCP_ADDRESS_CONFLICT: return "DHCP_ADDRESS_CONFLICT";
    case ERROR_WMI_GUID_NOT_FOUND: return "WMI_GUID_NOT_FOUND";
    case ERROR_WMI_INSTANCE_NOT_FOUND: return "WMI_INSTANCE_NOT_FOUND";
    case ERROR_WMI_ITEMID_NOT_FOUND: return "WMI_ITEMID_NOT_FOUND";
    case ERROR_WMI_TRY_AGAIN: return "WMI_TRY_AGAIN";
    case ERROR_WMI_DP_NOT_FOUND: return "WMI_DP_NOT_FOUND";
    case ERROR_WMI_UNRESOLVED_INSTANCE_REF: return "WMI_UNRESOLVED_INSTANCE_REF";
    case ERROR_WMI_ALREADY_ENABLED: return "WMI_ALREADY_ENABLED";
    case ERROR_WMI_GUID_DISCONNECTED: return "WMI_GUID_DISCONNECTED";
    case ERROR_WMI_SERVER_UNAVAILABLE: return "WMI_SERVER_UNAVAILABLE";
    case ERROR_WMI_DP_FAILED: return "WMI_DP_FAILED";
    case ERROR_WMI_INVALID_MOF: return "WMI_INVALID_MOF";
    case ERROR_WMI_INVALID_REGINFO: return "WMI_INVALID_REGINFO";
    case ERROR_WMI_ALREADY_DISABLED: return "WMI_ALREADY_DISABLED";
    case ERROR_WMI_READ_ONLY: return "WMI_READ_ONLY";
    case ERROR_WMI_SET_FAILURE: return "WMI_SET_FAILURE";
    case ERROR_INVALID_MEDIA: return "INVALID_MEDIA";
    case ERROR_INVALID_LIBRARY: return "INVALID_LIBRARY";
    case ERROR_INVALID_MEDIA_POOL: return "INVALID_MEDIA_POOL";
    case ERROR_DRIVE_MEDIA_MISMATCH: return "DRIVE_MEDIA_MISMATCH";
    case ERROR_MEDIA_OFFLINE: return "MEDIA_OFFLINE";
    case ERROR_LIBRARY_OFFLINE: return "LIBRARY_OFFLINE";
    case ERROR_EMPTY: return "EMPTY";
    case ERROR_NOT_EMPTY: return "NOT_EMPTY";
    case ERROR_MEDIA_UNAVAILABLE: return "MEDIA_UNAVAILABLE";
    case ERROR_RESOURCE_DISABLED: return "RESOURCE_DISABLED";
    case ERROR_INVALID_CLEANER: return "INVALID_CLEANER";
    case ERROR_UNABLE_TO_CLEAN: return "UNABLE_TO_CLEAN";
    case ERROR_OBJECT_NOT_FOUND: return "OBJECT_NOT_FOUND";
    case ERROR_DATABASE_FAILURE: return "DATABASE_FAILURE";
    case ERROR_DATABASE_FULL: return "DATABASE_FULL";
    case ERROR_MEDIA_INCOMPATIBLE: return "MEDIA_INCOMPATIBLE";
    case ERROR_RESOURCE_NOT_PRESENT: return "RESOURCE_NOT_PRESENT";
    case ERROR_INVALID_OPERATION: return "INVALID_OPERATION";
    case ERROR_MEDIA_NOT_AVAILABLE: return "MEDIA_NOT_AVAILABLE";
    case ERROR_DEVICE_NOT_AVAILABLE: return "DEVICE_NOT_AVAILABLE";
    case ERROR_REQUEST_REFUSED: return "REQUEST_REFUSED";
    case ERROR_INVALID_DRIVE_OBJECT: return "INVALID_DRIVE_OBJECT";
    case ERROR_LIBRARY_FULL: return "LIBRARY_FULL";
    case ERROR_MEDIUM_NOT_ACCESSIBLE: return "MEDIUM_NOT_ACCESSIBLE";
    case ERROR_UNABLE_TO_LOAD_MEDIUM: return "UNABLE_TO_LOAD_MEDIUM";
    case ERROR_UNABLE_TO_INVENTORY_DRIVE: return "UNABLE_TO_INVENTORY_DRIVE";
    case ERROR_UNABLE_TO_INVENTORY_SLOT: return "UNABLE_TO_INVENTORY_SLOT";
    case ERROR_UNABLE_TO_INVENTORY_TRANSPORT: return "UNABLE_TO_INVENTORY_TRANSPORT";
    case ERROR_TRANSPORT_FULL: return "TRANSPORT_FULL";
    case ERROR_CONTROLLING_IEPORT: return "CONTROLLING_IEPORT";
    case ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA: return "UNABLE_TO_EJECT_MOUNTED_MEDIA";
    case ERROR_CLEANER_SLOT_SET: return "CLEANER_SLOT_SET";
    case ERROR_CLEANER_SLOT_NOT_SET: return "CLEANER_SLOT_NOT_SET";
    case ERROR_CLEANER_CARTRIDGE_SPENT: return "CLEANER_CARTRIDGE_SPENT";
    case ERROR_UNEXPECTED_OMID: return "UNEXPECTED_OMID";
    case ERROR_CANT_DELETE_LAST_ITEM: return "CANT_DELETE_LAST_ITEM";
    case ERROR_MESSAGE_EXCEEDS_MAX_SIZE: return "MESSAGE_EXCEEDS_MAX_SIZE";
    case ERROR_VOLUME_CONTAINS_SYS_FILES: return "VOLUME_CONTAINS_SYS_FILES";
    case ERROR_INDIGENOUS_TYPE: return "INDIGENOUS_TYPE";
    case ERROR_NO_SUPPORTING_DRIVES: return "NO_SUPPORTING_DRIVES";
    case ERROR_CLEANER_CARTRIDGE_INSTALLED: return "CLEANER_CARTRIDGE_INSTALLED";
    case ERROR_IEPORT_FULL: return "IEPORT_FULL";
    case ERROR_FILE_OFFLINE: return "FILE_OFFLINE";
    case ERROR_REMOTE_STORAGE_NOT_ACTIVE: return "REMOTE_STORAGE_NOT_ACTIVE";
    case ERROR_REMOTE_STORAGE_MEDIA_ERROR: return "REMOTE_STORAGE_MEDIA_ERROR";
    case ERROR_NOT_A_REPARSE_POINT: return "NOT_A_REPARSE_POINT";
    case ERROR_REPARSE_ATTRIBUTE_CONFLICT: return "REPARSE_ATTRIBUTE_CONFLICT";
    case ERROR_INVALID_REPARSE_DATA: return "INVALID_REPARSE_DATA";
    case ERROR_REPARSE_TAG_INVALID: return "REPARSE_TAG_INVALID";
    case ERROR_REPARSE_TAG_MISMATCH: return "REPARSE_TAG_MISMATCH";
    case ERROR_VOLUME_NOT_SIS_ENABLED: return "VOLUME_NOT_SIS_ENABLED";
    case ERROR_DEPENDENT_RESOURCE_EXISTS: return "DEPENDENT_RESOURCE_EXISTS";
    case ERROR_DEPENDENCY_NOT_FOUND: return "DEPENDENCY_NOT_FOUND";
    case ERROR_DEPENDENCY_ALREADY_EXISTS: return "DEPENDENCY_ALREADY_EXISTS";
    case ERROR_RESOURCE_NOT_ONLINE: return "RESOURCE_NOT_ONLINE";
    case ERROR_HOST_NODE_NOT_AVAILABLE: return "HOST_NODE_NOT_AVAILABLE";
    case ERROR_RESOURCE_NOT_AVAILABLE: return "RESOURCE_NOT_AVAILABLE";
    case ERROR_RESOURCE_NOT_FOUND: return "RESOURCE_NOT_FOUND";
    case ERROR_SHUTDOWN_CLUSTER: return "SHUTDOWN_CLUSTER";
    case ERROR_CANT_EVICT_ACTIVE_NODE: return "CANT_EVICT_ACTIVE_NODE";
    case ERROR_OBJECT_ALREADY_EXISTS: return "OBJECT_ALREADY_EXISTS";
    case ERROR_OBJECT_IN_LIST: return "OBJECT_IN_LIST";
    case ERROR_GROUP_NOT_AVAILABLE: return "GROUP_NOT_AVAILABLE";
    case ERROR_GROUP_NOT_FOUND: return "GROUP_NOT_FOUND";
    case ERROR_GROUP_NOT_ONLINE: return "GROUP_NOT_ONLINE";
    case ERROR_HOST_NODE_NOT_RESOURCE_OWNER: return "HOST_NODE_NOT_RESOURCE_OWNER";
    case ERROR_HOST_NODE_NOT_GROUP_OWNER: return "HOST_NODE_NOT_GROUP_OWNER";
    case ERROR_RESMON_CREATE_FAILED: return "RESMON_CREATE_FAILED";
    case ERROR_RESMON_ONLINE_FAILED: return "RESMON_ONLINE_FAILED";
    case ERROR_RESOURCE_ONLINE: return "RESOURCE_ONLINE";
    case ERROR_QUORUM_RESOURCE: return "QUORUM_RESOURCE";
    case ERROR_NOT_QUORUM_CAPABLE: return "NOT_QUORUM_CAPABLE";
    case ERROR_CLUSTER_SHUTTING_DOWN: return "CLUSTER_SHUTTING_DOWN";
    case ERROR_INVALID_STATE: return "INVALID_STATE";
    case ERROR_RESOURCE_PROPERTIES_STORED: return "RESOURCE_PROPERTIES_STORED";
    case ERROR_NOT_QUORUM_CLASS: return "NOT_QUORUM_CLASS";
    case ERROR_CORE_RESOURCE: return "CORE_RESOURCE";
    case ERROR_QUORUM_RESOURCE_ONLINE_FAILED: return "QUORUM_RESOURCE_ONLINE_FAILED";
    case ERROR_QUORUMLOG_OPEN_FAILED: return "QUORUMLOG_OPEN_FAILED";
    case ERROR_CLUSTERLOG_CORRUPT: return "CLUSTERLOG_CORRUPT";
    case ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE: return "CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE";
    case ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE: return "CLUSTERLOG_EXCEEDS_MAXSIZE";
    case ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND: return "CLUSTERLOG_CHKPOINT_NOT_FOUND";
    case ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE: return "CLUSTERLOG_NOT_ENOUGH_SPACE";
    case ERROR_QUORUM_OWNER_ALIVE: return "QUORUM_OWNER_ALIVE";
    case ERROR_NETWORK_NOT_AVAILABLE: return "NETWORK_NOT_AVAILABLE";
    case ERROR_NODE_NOT_AVAILABLE: return "NODE_NOT_AVAILABLE";
    case ERROR_ALL_NODES_NOT_AVAILABLE: return "ALL_NODES_NOT_AVAILABLE";
    case ERROR_RESOURCE_FAILED: return "RESOURCE_FAILED";
    case ERROR_CLUSTER_INVALID_NODE: return "CLUSTER_INVALID_NODE";
    case ERROR_CLUSTER_NODE_EXISTS: return "CLUSTER_NODE_EXISTS";
    case ERROR_CLUSTER_JOIN_IN_PROGRESS: return "CLUSTER_JOIN_IN_PROGRESS";
    case ERROR_CLUSTER_NODE_NOT_FOUND: return "CLUSTER_NODE_NOT_FOUND";
    case ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND: return "CLUSTER_LOCAL_NODE_NOT_FOUND";
    case ERROR_CLUSTER_NETWORK_EXISTS: return "CLUSTER_NETWORK_EXISTS";
    case ERROR_CLUSTER_NETWORK_NOT_FOUND: return "CLUSTER_NETWORK_NOT_FOUND";
    case ERROR_CLUSTER_NETINTERFACE_EXISTS: return "CLUSTER_NETINTERFACE_EXISTS";
    case ERROR_CLUSTER_NETINTERFACE_NOT_FOUND: return "CLUSTER_NETINTERFACE_NOT_FOUND";
    case ERROR_CLUSTER_INVALID_REQUEST: return "CLUSTER_INVALID_REQUEST";
    case ERROR_CLUSTER_INVALID_NETWORK_PROVIDER: return "CLUSTER_INVALID_NETWORK_PROVIDER";
    case ERROR_CLUSTER_NODE_DOWN: return "CLUSTER_NODE_DOWN";
    case ERROR_CLUSTER_NODE_UNREACHABLE: return "CLUSTER_NODE_UNREACHABLE";
    case ERROR_CLUSTER_NODE_NOT_MEMBER: return "CLUSTER_NODE_NOT_MEMBER";
    case ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS: return "CLUSTER_JOIN_NOT_IN_PROGRESS";
    case ERROR_CLUSTER_INVALID_NETWORK: return "CLUSTER_INVALID_NETWORK";
    case ERROR_CLUSTER_NODE_UP: return "CLUSTER_NODE_UP";
    case ERROR_CLUSTER_IPADDR_IN_USE: return "CLUSTER_IPADDR_IN_USE";
    case ERROR_CLUSTER_NODE_NOT_PAUSED: return "CLUSTER_NODE_NOT_PAUSED";
    case ERROR_CLUSTER_NO_SECURITY_CONTEXT: return "CLUSTER_NO_SECURITY_CONTEXT";
    case ERROR_CLUSTER_NETWORK_NOT_INTERNAL: return "CLUSTER_NETWORK_NOT_INTERNAL";
    case ERROR_CLUSTER_NODE_ALREADY_UP: return "CLUSTER_NODE_ALREADY_UP";
    case ERROR_CLUSTER_NODE_ALREADY_DOWN: return "CLUSTER_NODE_ALREADY_DOWN";
    case ERROR_CLUSTER_NETWORK_ALREADY_ONLINE: return "CLUSTER_NETWORK_ALREADY_ONLINE";
    case ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE: return "CLUSTER_NETWORK_ALREADY_OFFLINE";
    case ERROR_CLUSTER_NODE_ALREADY_MEMBER: return "CLUSTER_NODE_ALREADY_MEMBER";
    case ERROR_CLUSTER_LAST_INTERNAL_NETWORK: return "CLUSTER_LAST_INTERNAL_NETWORK";
    case ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS: return "CLUSTER_NETWORK_HAS_DEPENDENTS";
    case ERROR_INVALID_OPERATION_ON_QUORUM: return "INVALID_OPERATION_ON_QUORUM";
    case ERROR_DEPENDENCY_NOT_ALLOWED: return "DEPENDENCY_NOT_ALLOWED";
    case ERROR_CLUSTER_NODE_PAUSED: return "CLUSTER_NODE_PAUSED";
    case ERROR_NODE_CANT_HOST_RESOURCE: return "NODE_CANT_HOST_RESOURCE";
    case ERROR_CLUSTER_NODE_NOT_READY: return "CLUSTER_NODE_NOT_READY";
    case ERROR_CLUSTER_NODE_SHUTTING_DOWN: return "CLUSTER_NODE_SHUTTING_DOWN";
    case ERROR_CLUSTER_JOIN_ABORTED: return "CLUSTER_JOIN_ABORTED";
    case ERROR_CLUSTER_INCOMPATIBLE_VERSIONS: return "CLUSTER_INCOMPATIBLE_VERSIONS";
    case ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED: return "CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED";
    case ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED: return "CLUSTER_SYSTEM_CONFIG_CHANGED";
    case ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND: return "CLUSTER_RESOURCE_TYPE_NOT_FOUND";
    case ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED: return "CLUSTER_RESTYPE_NOT_SUPPORTED";
    case ERROR_CLUSTER_RESNAME_NOT_FOUND: return "CLUSTER_RESNAME_NOT_FOUND";
    case ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED: return "CLUSTER_NO_RPC_PACKAGES_REGISTERED";
    case ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST: return "CLUSTER_OWNER_NOT_IN_PREFLIST";
    case ERROR_CLUSTER_DATABASE_SEQMISMATCH: return "CLUSTER_DATABASE_SEQMISMATCH";
    case ERROR_RESMON_INVALID_STATE: return "RESMON_INVALID_STATE";
    case ERROR_CLUSTER_GUM_NOT_LOCKER: return "CLUSTER_GUM_NOT_LOCKER";
    case ERROR_QUORUM_DISK_NOT_FOUND: return "QUORUM_DISK_NOT_FOUND";
    case ERROR_DATABASE_BACKUP_CORRUPT: return "DATABASE_BACKUP_CORRUPT";
    case ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT: return "CLUSTER_NODE_ALREADY_HAS_DFS_ROOT";
    case ERROR_RESOURCE_PROPERTY_UNCHANGEABLE: return "RESOURCE_PROPERTY_UNCHANGEABLE";
    case ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE: return "CLUSTER_MEMBERSHIP_INVALID_STATE";
    case ERROR_CLUSTER_QUORUMLOG_NOT_FOUND: return "CLUSTER_QUORUMLOG_NOT_FOUND";
    case ERROR_CLUSTER_MEMBERSHIP_HALT: return "CLUSTER_MEMBERSHIP_HALT";
    case ERROR_CLUSTER_INSTANCE_ID_MISMATCH: return "CLUSTER_INSTANCE_ID_MISMATCH";
    case ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP: return "CLUSTER_NETWORK_NOT_FOUND_FOR_IP";
    case ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH: return "CLUSTER_PROPERTY_DATA_TYPE_MISMATCH";
    case ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP: return "CLUSTER_EVICT_WITHOUT_CLEANUP";
    case ERROR_CLUSTER_PARAMETER_MISMATCH: return "CLUSTER_PARAMETER_MISMATCH";
    case ERROR_NODE_CANNOT_BE_CLUSTERED: return "NODE_CANNOT_BE_CLUSTERED";
    case ERROR_CLUSTER_WRONG_OS_VERSION: return "CLUSTER_WRONG_OS_VERSION";
    case ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME: return "CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME";
    case ERROR_CLUSCFG_ALREADY_COMMITTED: return "CLUSCFG_ALREADY_COMMITTED";
    case ERROR_CLUSCFG_ROLLBACK_FAILED: return "CLUSCFG_ROLLBACK_FAILED";
    case ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT: return "CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT";
    case ERROR_CLUSTER_OLD_VERSION: return "CLUSTER_OLD_VERSION";
    case ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME: return "CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME";
    case ERROR_ENCRYPTION_FAILED: return "ENCRYPTION_FAILED";
    case ERROR_DECRYPTION_FAILED: return "DECRYPTION_FAILED";
    case ERROR_FILE_ENCRYPTED: return "FILE_ENCRYPTED";
    case ERROR_NO_RECOVERY_POLICY: return "NO_RECOVERY_POLICY";
    case ERROR_NO_EFS: return "NO_EFS";
    case ERROR_WRONG_EFS: return "WRONG_EFS";
    case ERROR_NO_USER_KEYS: return "NO_USER_KEYS";
    case ERROR_FILE_NOT_ENCRYPTED: return "FILE_NOT_ENCRYPTED";
    case ERROR_NOT_EXPORT_FORMAT: return "NOT_EXPORT_FORMAT";
    case ERROR_FILE_READ_ONLY: return "FILE_READ_ONLY";
    case ERROR_DIR_EFS_DISALLOWED: return "DIR_EFS_DISALLOWED";
    case ERROR_EFS_SERVER_NOT_TRUSTED: return "EFS_SERVER_NOT_TRUSTED";
    case ERROR_BAD_RECOVERY_POLICY: return "BAD_RECOVERY_POLICY";
    case ERROR_EFS_ALG_BLOB_TOO_BIG: return "EFS_ALG_BLOB_TOO_BIG";
    case ERROR_VOLUME_NOT_SUPPORT_EFS: return "VOLUME_NOT_SUPPORT_EFS";
    case ERROR_EFS_DISABLED: return "EFS_DISABLED";
    case ERROR_EFS_VERSION_NOT_SUPPORT: return "EFS_VERSION_NOT_SUPPORT";
    case ERROR_NO_BROWSER_SERVERS_FOUND: return "NO_BROWSER_SERVERS_FOUND";
    case ERROR_CTX_WINSTATION_NAME_INVALID: return "CTX_WINSTATION_NAME_INVALID";
    case ERROR_CTX_INVALID_PD: return "CTX_INVALID_PD";
    case ERROR_CTX_PD_NOT_FOUND: return "CTX_PD_NOT_FOUND";
    case ERROR_CTX_WD_NOT_FOUND: return "CTX_WD_NOT_FOUND";
    case ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY: return "CTX_CANNOT_MAKE_EVENTLOG_ENTRY";
    case ERROR_CTX_SERVICE_NAME_COLLISION: return "CTX_SERVICE_NAME_COLLISION";
    case ERROR_CTX_CLOSE_PENDING: return "CTX_CLOSE_PENDING";
    case ERROR_CTX_NO_OUTBUF: return "CTX_NO_OUTBUF";
    case ERROR_CTX_MODEM_INF_NOT_FOUND: return "CTX_MODEM_INF_NOT_FOUND";
    case ERROR_CTX_INVALID_MODEMNAME: return "CTX_INVALID_MODEMNAME";
    case ERROR_CTX_MODEM_RESPONSE_ERROR: return "CTX_MODEM_RESPONSE_ERROR";
    case ERROR_CTX_MODEM_RESPONSE_TIMEOUT: return "CTX_MODEM_RESPONSE_TIMEOUT";
    case ERROR_CTX_MODEM_RESPONSE_NO_CARRIER: return "CTX_MODEM_RESPONSE_NO_CARRIER";
    case ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE: return "CTX_MODEM_RESPONSE_NO_DIALTONE";
    case ERROR_CTX_MODEM_RESPONSE_BUSY: return "CTX_MODEM_RESPONSE_BUSY";
    case ERROR_CTX_MODEM_RESPONSE_VOICE: return "CTX_MODEM_RESPONSE_VOICE";
    case ERROR_CTX_TD_ERROR: return "CTX_TD_ERROR";
    case ERROR_CTX_WINSTATION_NOT_FOUND: return "CTX_WINSTATION_NOT_FOUND";
    case ERROR_CTX_WINSTATION_ALREADY_EXISTS: return "CTX_WINSTATION_ALREADY_EXISTS";
    case ERROR_CTX_WINSTATION_BUSY: return "CTX_WINSTATION_BUSY";
    case ERROR_CTX_BAD_VIDEO_MODE: return "CTX_BAD_VIDEO_MODE";
    case ERROR_CTX_GRAPHICS_INVALID: return "CTX_GRAPHICS_INVALID";
    case ERROR_CTX_LOGON_DISABLED: return "CTX_LOGON_DISABLED";
    case ERROR_CTX_NOT_CONSOLE: return "CTX_NOT_CONSOLE";
    case ERROR_CTX_CLIENT_QUERY_TIMEOUT: return "CTX_CLIENT_QUERY_TIMEOUT";
    case ERROR_CTX_CONSOLE_DISCONNECT: return "CTX_CONSOLE_DISCONNECT";
    case ERROR_CTX_CONSOLE_CONNECT: return "CTX_CONSOLE_CONNECT";
    case ERROR_CTX_SHADOW_DENIED: return "CTX_SHADOW_DENIED";
    case ERROR_CTX_WINSTATION_ACCESS_DENIED: return "CTX_WINSTATION_ACCESS_DENIED";
    case ERROR_CTX_INVALID_WD: return "CTX_INVALID_WD";
    case ERROR_CTX_SHADOW_INVALID: return "CTX_SHADOW_INVALID";
    case ERROR_CTX_SHADOW_DISABLED: return "CTX_SHADOW_DISABLED";
    case ERROR_CTX_CLIENT_LICENSE_IN_USE: return "CTX_CLIENT_LICENSE_IN_USE";
    case ERROR_CTX_CLIENT_LICENSE_NOT_SET: return "CTX_CLIENT_LICENSE_NOT_SET";
    case ERROR_CTX_LICENSE_NOT_AVAILABLE: return "CTX_LICENSE_NOT_AVAILABLE";
    case ERROR_CTX_LICENSE_CLIENT_INVALID: return "CTX_LICENSE_CLIENT_INVALID";
    case ERROR_CTX_LICENSE_EXPIRED: return "CTX_LICENSE_EXPIRED";
    case ERROR_CTX_SHADOW_NOT_RUNNING: return "CTX_SHADOW_NOT_RUNNING";
    case ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE: return "CTX_SHADOW_ENDED_BY_MODE_CHANGE";
    case ERROR_ACTIVATION_COUNT_EXCEEDED: return "ACTIVATION_COUNT_EXCEEDED";
    case ERROR_DS_NOT_INSTALLED: return "DS_NOT_INSTALLED";
    case ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY: return "DS_MEMBERSHIP_EVALUATED_LOCALLY";
    case ERROR_DS_NO_ATTRIBUTE_OR_VALUE: return "DS_NO_ATTRIBUTE_OR_VALUE";
    case ERROR_DS_INVALID_ATTRIBUTE_SYNTAX: return "DS_INVALID_ATTRIBUTE_SYNTAX";
    case ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED: return "DS_ATTRIBUTE_TYPE_UNDEFINED";
    case ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS: return "DS_ATTRIBUTE_OR_VALUE_EXISTS";
    case ERROR_DS_BUSY: return "DS_BUSY";
    case ERROR_DS_UNAVAILABLE: return "DS_UNAVAILABLE";
    case ERROR_DS_NO_RIDS_ALLOCATED: return "DS_NO_RIDS_ALLOCATED";
    case ERROR_DS_NO_MORE_RIDS: return "DS_NO_MORE_RIDS";
    case ERROR_DS_INCORRECT_ROLE_OWNER: return "DS_INCORRECT_ROLE_OWNER";
    case ERROR_DS_RIDMGR_INIT_ERROR: return "DS_RIDMGR_INIT_ERROR";
    case ERROR_DS_OBJ_CLASS_VIOLATION: return "DS_OBJ_CLASS_VIOLATION";
    case ERROR_DS_CANT_ON_NON_LEAF: return "DS_CANT_ON_NON_LEAF";
    case ERROR_DS_CANT_ON_RDN: return "DS_CANT_ON_RDN";
    case ERROR_DS_CANT_MOD_OBJ_CLASS: return "DS_CANT_MOD_OBJ_CLASS";
    case ERROR_DS_CROSS_DOM_MOVE_ERROR: return "DS_CROSS_DOM_MOVE_ERROR";
    case ERROR_DS_GC_NOT_AVAILABLE: return "DS_GC_NOT_AVAILABLE";
    case ERROR_SHARED_POLICY: return "SHARED_POLICY";
    case ERROR_POLICY_OBJECT_NOT_FOUND: return "POLICY_OBJECT_NOT_FOUND";
    case ERROR_POLICY_ONLY_IN_DS: return "POLICY_ONLY_IN_DS";
    case ERROR_PROMOTION_ACTIVE: return "PROMOTION_ACTIVE";
    case ERROR_NO_PROMOTION_ACTIVE: return "NO_PROMOTION_ACTIVE";
    case ERROR_DS_OPERATIONS_ERROR: return "DS_OPERATIONS_ERROR";
    case ERROR_DS_PROTOCOL_ERROR: return "DS_PROTOCOL_ERROR";
    case ERROR_DS_TIMELIMIT_EXCEEDED: return "DS_TIMELIMIT_EXCEEDED";
    case ERROR_DS_SIZELIMIT_EXCEEDED: return "DS_SIZELIMIT_EXCEEDED";
    case ERROR_DS_ADMIN_LIMIT_EXCEEDED: return "DS_ADMIN_LIMIT_EXCEEDED";
    case ERROR_DS_COMPARE_FALSE: return "DS_COMPARE_FALSE";
    case ERROR_DS_COMPARE_TRUE: return "DS_COMPARE_TRUE";
    case ERROR_DS_AUTH_METHOD_NOT_SUPPORTED: return "DS_AUTH_METHOD_NOT_SUPPORTED";
    case ERROR_DS_STRONG_AUTH_REQUIRED: return "DS_STRONG_AUTH_REQUIRED";
    case ERROR_DS_INAPPROPRIATE_AUTH: return "DS_INAPPROPRIATE_AUTH";
    case ERROR_DS_AUTH_UNKNOWN: return "DS_AUTH_UNKNOWN";
    case ERROR_DS_REFERRAL: return "DS_REFERRAL";
    case ERROR_DS_UNAVAILABLE_CRIT_EXTENSION: return "DS_UNAVAILABLE_CRIT_EXTENSION";
    case ERROR_DS_CONFIDENTIALITY_REQUIRED: return "DS_CONFIDENTIALITY_REQUIRED";
    case ERROR_DS_INAPPROPRIATE_MATCHING: return "DS_INAPPROPRIATE_MATCHING";
    case ERROR_DS_CONSTRAINT_VIOLATION: return "DS_CONSTRAINT_VIOLATION";
    case ERROR_DS_NO_SUCH_OBJECT: return "DS_NO_SUCH_OBJECT";
    case ERROR_DS_ALIAS_PROBLEM: return "DS_ALIAS_PROBLEM";
    case ERROR_DS_INVALID_DN_SYNTAX: return "DS_INVALID_DN_SYNTAX";
    case ERROR_DS_IS_LEAF: return "DS_IS_LEAF";
    case ERROR_DS_ALIAS_DEREF_PROBLEM: return "DS_ALIAS_DEREF_PROBLEM";
    case ERROR_DS_UNWILLING_TO_PERFORM: return "DS_UNWILLING_TO_PERFORM";
    case ERROR_DS_LOOP_DETECT: return "DS_LOOP_DETECT";
    case ERROR_DS_NAMING_VIOLATION: return "DS_NAMING_VIOLATION";
    case ERROR_DS_OBJECT_RESULTS_TOO_LARGE: return "DS_OBJECT_RESULTS_TOO_LARGE";
    case ERROR_DS_AFFECTS_MULTIPLE_DSAS: return "DS_AFFECTS_MULTIPLE_DSAS";
    case ERROR_DS_SERVER_DOWN: return "DS_SERVER_DOWN";
    case ERROR_DS_LOCAL_ERROR: return "DS_LOCAL_ERROR";
    case ERROR_DS_ENCODING_ERROR: return "DS_ENCODING_ERROR";
    case ERROR_DS_DECODING_ERROR: return "DS_DECODING_ERROR";
    case ERROR_DS_FILTER_UNKNOWN: return "DS_FILTER_UNKNOWN";
    case ERROR_DS_PARAM_ERROR: return "DS_PARAM_ERROR";
    case ERROR_DS_NOT_SUPPORTED: return "DS_NOT_SUPPORTED";
    case ERROR_DS_NO_RESULTS_RETURNED: return "DS_NO_RESULTS_RETURNED";
    case ERROR_DS_CONTROL_NOT_FOUND: return "DS_CONTROL_NOT_FOUND";
    case ERROR_DS_CLIENT_LOOP: return "DS_CLIENT_LOOP";
    case ERROR_DS_REFERRAL_LIMIT_EXCEEDED: return "DS_REFERRAL_LIMIT_EXCEEDED";
    case ERROR_DS_SORT_CONTROL_MISSING: return "DS_SORT_CONTROL_MISSING";
    case ERROR_DS_OFFSET_RANGE_ERROR: return "DS_OFFSET_RANGE_ERROR";
    case ERROR_DS_ROOT_MUST_BE_NC: return "DS_ROOT_MUST_BE_NC";
    case ERROR_DS_ADD_REPLICA_INHIBITED: return "DS_ADD_REPLICA_INHIBITED";
    case ERROR_DS_ATT_NOT_DEF_IN_SCHEMA: return "DS_ATT_NOT_DEF_IN_SCHEMA";
    case ERROR_DS_MAX_OBJ_SIZE_EXCEEDED: return "DS_MAX_OBJ_SIZE_EXCEEDED";
    case ERROR_DS_OBJ_STRING_NAME_EXISTS: return "DS_OBJ_STRING_NAME_EXISTS";
    case ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA: return "DS_NO_RDN_DEFINED_IN_SCHEMA";
    case ERROR_DS_RDN_DOESNT_MATCH_SCHEMA: return "DS_RDN_DOESNT_MATCH_SCHEMA";
    case ERROR_DS_NO_REQUESTED_ATTS_FOUND: return "DS_NO_REQUESTED_ATTS_FOUND";
    case ERROR_DS_USER_BUFFER_TO_SMALL: return "DS_USER_BUFFER_TO_SMALL";
    case ERROR_DS_ATT_IS_NOT_ON_OBJ: return "DS_ATT_IS_NOT_ON_OBJ";
    case ERROR_DS_ILLEGAL_MOD_OPERATION: return "DS_ILLEGAL_MOD_OPERATION";
    case ERROR_DS_OBJ_TOO_LARGE: return "DS_OBJ_TOO_LARGE";
    case ERROR_DS_BAD_INSTANCE_TYPE: return "DS_BAD_INSTANCE_TYPE";
    case ERROR_DS_MASTERDSA_REQUIRED: return "DS_MASTERDSA_REQUIRED";
    case ERROR_DS_OBJECT_CLASS_REQUIRED: return "DS_OBJECT_CLASS_REQUIRED";
    case ERROR_DS_MISSING_REQUIRED_ATT: return "DS_MISSING_REQUIRED_ATT";
    case ERROR_DS_ATT_NOT_DEF_FOR_CLASS: return "DS_ATT_NOT_DEF_FOR_CLASS";
    case ERROR_DS_ATT_ALREADY_EXISTS: return "DS_ATT_ALREADY_EXISTS";
    case ERROR_DS_CANT_ADD_ATT_VALUES: return "DS_CANT_ADD_ATT_VALUES";
    case ERROR_DS_SINGLE_VALUE_CONSTRAINT: return "DS_SINGLE_VALUE_CONSTRAINT";
    case ERROR_DS_RANGE_CONSTRAINT: return "DS_RANGE_CONSTRAINT";
    case ERROR_DS_ATT_VAL_ALREADY_EXISTS: return "DS_ATT_VAL_ALREADY_EXISTS";
    case ERROR_DS_CANT_REM_MISSING_ATT: return "DS_CANT_REM_MISSING_ATT";
    case ERROR_DS_CANT_REM_MISSING_ATT_VAL: return "DS_CANT_REM_MISSING_ATT_VAL";
    case ERROR_DS_ROOT_CANT_BE_SUBREF: return "DS_ROOT_CANT_BE_SUBREF";
    case ERROR_DS_NO_CHAINING: return "DS_NO_CHAINING";
    case ERROR_DS_NO_CHAINED_EVAL: return "DS_NO_CHAINED_EVAL";
    case ERROR_DS_NO_PARENT_OBJECT: return "DS_NO_PARENT_OBJECT";
    case ERROR_DS_PARENT_IS_AN_ALIAS: return "DS_PARENT_IS_AN_ALIAS";
    case ERROR_DS_CANT_MIX_MASTER_AND_REPS: return "DS_CANT_MIX_MASTER_AND_REPS";
    case ERROR_DS_CHILDREN_EXIST: return "DS_CHILDREN_EXIST";
    case ERROR_DS_OBJ_NOT_FOUND: return "DS_OBJ_NOT_FOUND";
    case ERROR_DS_ALIASED_OBJ_MISSING: return "DS_ALIASED_OBJ_MISSING";
    case ERROR_DS_BAD_NAME_SYNTAX: return "DS_BAD_NAME_SYNTAX";
    case ERROR_DS_ALIAS_POINTS_TO_ALIAS: return "DS_ALIAS_POINTS_TO_ALIAS";
    case ERROR_DS_CANT_DEREF_ALIAS: return "DS_CANT_DEREF_ALIAS";
    case ERROR_DS_OUT_OF_SCOPE: return "DS_OUT_OF_SCOPE";
    case ERROR_DS_OBJECT_BEING_REMOVED: return "DS_OBJECT_BEING_REMOVED";
    case ERROR_DS_CANT_DELETE_DSA_OBJ: return "DS_CANT_DELETE_DSA_OBJ";
    case ERROR_DS_GENERIC_ERROR: return "DS_GENERIC_ERROR";
    case ERROR_DS_DSA_MUST_BE_INT_MASTER: return "DS_DSA_MUST_BE_INT_MASTER";
    case ERROR_DS_CLASS_NOT_DSA: return "DS_CLASS_NOT_DSA";
    case ERROR_DS_INSUFF_ACCESS_RIGHTS: return "DS_INSUFF_ACCESS_RIGHTS";
    case ERROR_DS_ILLEGAL_SUPERIOR: return "DS_ILLEGAL_SUPERIOR";
    case ERROR_DS_ATTRIBUTE_OWNED_BY_SAM: return "DS_ATTRIBUTE_OWNED_BY_SAM";
    case ERROR_DS_NAME_TOO_MANY_PARTS: return "DS_NAME_TOO_MANY_PARTS";
    case ERROR_DS_NAME_TOO_LONG: return "DS_NAME_TOO_LONG";
    case ERROR_DS_NAME_VALUE_TOO_LONG: return "DS_NAME_VALUE_TOO_LONG";
    case ERROR_DS_NAME_UNPARSEABLE: return "DS_NAME_UNPARSEABLE";
    case ERROR_DS_NAME_TYPE_UNKNOWN: return "DS_NAME_TYPE_UNKNOWN";
    case ERROR_DS_NOT_AN_OBJECT: return "DS_NOT_AN_OBJECT";
    case ERROR_DS_SEC_DESC_TOO_SHORT: return "DS_SEC_DESC_TOO_SHORT";
    case ERROR_DS_SEC_DESC_INVALID: return "DS_SEC_DESC_INVALID";
    case ERROR_DS_NO_DELETED_NAME: return "DS_NO_DELETED_NAME";
    case ERROR_DS_SUBREF_MUST_HAVE_PARENT: return "DS_SUBREF_MUST_HAVE_PARENT";
    case ERROR_DS_NCNAME_MUST_BE_NC: return "DS_NCNAME_MUST_BE_NC";
    case ERROR_DS_CANT_ADD_SYSTEM_ONLY: return "DS_CANT_ADD_SYSTEM_ONLY";
    case ERROR_DS_CLASS_MUST_BE_CONCRETE: return "DS_CLASS_MUST_BE_CONCRETE";
    case ERROR_DS_INVALID_DMD: return "DS_INVALID_DMD";
    case ERROR_DS_OBJ_GUID_EXISTS: return "DS_OBJ_GUID_EXISTS";
    case ERROR_DS_NOT_ON_BACKLINK: return "DS_NOT_ON_BACKLINK";
    case ERROR_DS_NO_CROSSREF_FOR_NC: return "DS_NO_CROSSREF_FOR_NC";
    case ERROR_DS_SHUTTING_DOWN: return "DS_SHUTTING_DOWN";
    case ERROR_DS_UNKNOWN_OPERATION: return "DS_UNKNOWN_OPERATION";
    case ERROR_DS_INVALID_ROLE_OWNER: return "DS_INVALID_ROLE_OWNER";
    case ERROR_DS_COULDNT_CONTACT_FSMO: return "DS_COULDNT_CONTACT_FSMO";
    case ERROR_DS_CROSS_NC_DN_RENAME: return "DS_CROSS_NC_DN_RENAME";
    case ERROR_DS_CANT_MOD_SYSTEM_ONLY: return "DS_CANT_MOD_SYSTEM_ONLY";
    case ERROR_DS_REPLICATOR_ONLY: return "DS_REPLICATOR_ONLY";
    case ERROR_DS_OBJ_CLASS_NOT_DEFINED: return "DS_OBJ_CLASS_NOT_DEFINED";
    case ERROR_DS_OBJ_CLASS_NOT_SUBCLASS: return "DS_OBJ_CLASS_NOT_SUBCLASS";
    case ERROR_DS_NAME_REFERENCE_INVALID: return "DS_NAME_REFERENCE_INVALID";
    case ERROR_DS_CROSS_REF_EXISTS: return "DS_CROSS_REF_EXISTS";
    case ERROR_DS_CANT_DEL_MASTER_CROSSREF: return "DS_CANT_DEL_MASTER_CROSSREF";
    case ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD: return "DS_SUBTREE_NOTIFY_NOT_NC_HEAD";
    case ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX: return "DS_NOTIFY_FILTER_TOO_COMPLEX";
    case ERROR_DS_DUP_RDN: return "DS_DUP_RDN";
    case ERROR_DS_DUP_OID: return "DS_DUP_OID";
    case ERROR_DS_DUP_MAPI_ID: return "DS_DUP_MAPI_ID";
    case ERROR_DS_DUP_SCHEMA_ID_GUID: return "DS_DUP_SCHEMA_ID_GUID";
    case ERROR_DS_DUP_LDAP_DISPLAY_NAME: return "DS_DUP_LDAP_DISPLAY_NAME";
    case ERROR_DS_SEMANTIC_ATT_TEST: return "DS_SEMANTIC_ATT_TEST";
    case ERROR_DS_SYNTAX_MISMATCH: return "DS_SYNTAX_MISMATCH";
    case ERROR_DS_EXISTS_IN_MUST_HAVE: return "DS_EXISTS_IN_MUST_HAVE";
    case ERROR_DS_EXISTS_IN_MAY_HAVE: return "DS_EXISTS_IN_MAY_HAVE";
    case ERROR_DS_NONEXISTENT_MAY_HAVE: return "DS_NONEXISTENT_MAY_HAVE";
    case ERROR_DS_NONEXISTENT_MUST_HAVE: return "DS_NONEXISTENT_MUST_HAVE";
    case ERROR_DS_AUX_CLS_TEST_FAIL: return "DS_AUX_CLS_TEST_FAIL";
    case ERROR_DS_NONEXISTENT_POSS_SUP: return "DS_NONEXISTENT_POSS_SUP";
    case ERROR_DS_SUB_CLS_TEST_FAIL: return "DS_SUB_CLS_TEST_FAIL";
    case ERROR_DS_BAD_RDN_ATT_ID_SYNTAX: return "DS_BAD_RDN_ATT_ID_SYNTAX";
    case ERROR_DS_EXISTS_IN_AUX_CLS: return "DS_EXISTS_IN_AUX_CLS";
    case ERROR_DS_EXISTS_IN_SUB_CLS: return "DS_EXISTS_IN_SUB_CLS";
    case ERROR_DS_EXISTS_IN_POSS_SUP: return "DS_EXISTS_IN_POSS_SUP";
    case ERROR_DS_RECALCSCHEMA_FAILED: return "DS_RECALCSCHEMA_FAILED";
    case ERROR_DS_TREE_DELETE_NOT_FINISHED: return "DS_TREE_DELETE_NOT_FINISHED";
    case ERROR_DS_CANT_DELETE: return "DS_CANT_DELETE";
    case ERROR_DS_ATT_SCHEMA_REQ_ID: return "DS_ATT_SCHEMA_REQ_ID";
    case ERROR_DS_BAD_ATT_SCHEMA_SYNTAX: return "DS_BAD_ATT_SCHEMA_SYNTAX";
    case ERROR_DS_CANT_CACHE_ATT: return "DS_CANT_CACHE_ATT";
    case ERROR_DS_CANT_CACHE_CLASS: return "DS_CANT_CACHE_CLASS";
    case ERROR_DS_CANT_REMOVE_ATT_CACHE: return "DS_CANT_REMOVE_ATT_CACHE";
    case ERROR_DS_CANT_REMOVE_CLASS_CACHE: return "DS_CANT_REMOVE_CLASS_CACHE";
    case ERROR_DS_CANT_RETRIEVE_DN: return "DS_CANT_RETRIEVE_DN";
    case ERROR_DS_MISSING_SUPREF: return "DS_MISSING_SUPREF";
    case ERROR_DS_CANT_RETRIEVE_INSTANCE: return "DS_CANT_RETRIEVE_INSTANCE";
    case ERROR_DS_CODE_INCONSISTENCY: return "DS_CODE_INCONSISTENCY";
    case ERROR_DS_DATABASE_ERROR: return "DS_DATABASE_ERROR";
    case ERROR_DS_GOVERNSID_MISSING: return "DS_GOVERNSID_MISSING";
    case ERROR_DS_MISSING_EXPECTED_ATT: return "DS_MISSING_EXPECTED_ATT";
    case ERROR_DS_NCNAME_MISSING_CR_REF: return "DS_NCNAME_MISSING_CR_REF";
    case ERROR_DS_SECURITY_CHECKING_ERROR: return "DS_SECURITY_CHECKING_ERROR";
    case ERROR_DS_SCHEMA_NOT_LOADED: return "DS_SCHEMA_NOT_LOADED";
    case ERROR_DS_SCHEMA_ALLOC_FAILED: return "DS_SCHEMA_ALLOC_FAILED";
    case ERROR_DS_ATT_SCHEMA_REQ_SYNTAX: return "DS_ATT_SCHEMA_REQ_SYNTAX";
    case ERROR_DS_GCVERIFY_ERROR: return "DS_GCVERIFY_ERROR";
    case ERROR_DS_DRA_SCHEMA_MISMATCH: return "DS_DRA_SCHEMA_MISMATCH";
    case ERROR_DS_CANT_FIND_DSA_OBJ: return "DS_CANT_FIND_DSA_OBJ";
    case ERROR_DS_CANT_FIND_EXPECTED_NC: return "DS_CANT_FIND_EXPECTED_NC";
    case ERROR_DS_CANT_FIND_NC_IN_CACHE: return "DS_CANT_FIND_NC_IN_CACHE";
    case ERROR_DS_CANT_RETRIEVE_CHILD: return "DS_CANT_RETRIEVE_CHILD";
    case ERROR_DS_SECURITY_ILLEGAL_MODIFY: return "DS_SECURITY_ILLEGAL_MODIFY";
    case ERROR_DS_CANT_REPLACE_HIDDEN_REC: return "DS_CANT_REPLACE_HIDDEN_REC";
    case ERROR_DS_BAD_HIERARCHY_FILE: return "DS_BAD_HIERARCHY_FILE";
    case ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED: return "DS_BUILD_HIERARCHY_TABLE_FAILED";
    case ERROR_DS_CONFIG_PARAM_MISSING: return "DS_CONFIG_PARAM_MISSING";
    case ERROR_DS_COUNTING_AB_INDICES_FAILED: return "DS_COUNTING_AB_INDICES_FAILED";
    case ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED: return "DS_HIERARCHY_TABLE_MALLOC_FAILED";
    case ERROR_DS_INTERNAL_FAILURE: return "DS_INTERNAL_FAILURE";
    case ERROR_DS_UNKNOWN_ERROR: return "DS_UNKNOWN_ERROR";
    case ERROR_DS_ROOT_REQUIRES_CLASS_TOP: return "DS_ROOT_REQUIRES_CLASS_TOP";
    case ERROR_DS_REFUSING_FSMO_ROLES: return "DS_REFUSING_FSMO_ROLES";
    case ERROR_DS_MISSING_FSMO_SETTINGS: return "DS_MISSING_FSMO_SETTINGS";
    case ERROR_DS_UNABLE_TO_SURRENDER_ROLES: return "DS_UNABLE_TO_SURRENDER_ROLES";
    case ERROR_DS_DRA_GENERIC: return "DS_DRA_GENERIC";
    case ERROR_DS_DRA_INVALID_PARAMETER: return "DS_DRA_INVALID_PARAMETER";
    case ERROR_DS_DRA_BUSY: return "DS_DRA_BUSY";
    case ERROR_DS_DRA_BAD_DN: return "DS_DRA_BAD_DN";
    case ERROR_DS_DRA_BAD_NC: return "DS_DRA_BAD_NC";
    case ERROR_DS_DRA_DN_EXISTS: return "DS_DRA_DN_EXISTS";
    case ERROR_DS_DRA_INTERNAL_ERROR: return "DS_DRA_INTERNAL_ERROR";
    case ERROR_DS_DRA_INCONSISTENT_DIT: return "DS_DRA_INCONSISTENT_DIT";
    case ERROR_DS_DRA_CONNECTION_FAILED: return "DS_DRA_CONNECTION_FAILED";
    case ERROR_DS_DRA_BAD_INSTANCE_TYPE: return "DS_DRA_BAD_INSTANCE_TYPE";
    case ERROR_DS_DRA_OUT_OF_MEM: return "DS_DRA_OUT_OF_MEM";
    case ERROR_DS_DRA_MAIL_PROBLEM: return "DS_DRA_MAIL_PROBLEM";
    case ERROR_DS_DRA_REF_ALREADY_EXISTS: return "DS_DRA_REF_ALREADY_EXISTS";
    case ERROR_DS_DRA_REF_NOT_FOUND: return "DS_DRA_REF_NOT_FOUND";
    case ERROR_DS_DRA_OBJ_IS_REP_SOURCE: return "DS_DRA_OBJ_IS_REP_SOURCE";
    case ERROR_DS_DRA_DB_ERROR: return "DS_DRA_DB_ERROR";
    case ERROR_DS_DRA_NO_REPLICA: return "DS_DRA_NO_REPLICA";
    case ERROR_DS_DRA_ACCESS_DENIED: return "DS_DRA_ACCESS_DENIED";
    case ERROR_DS_DRA_NOT_SUPPORTED: return "DS_DRA_NOT_SUPPORTED";
    case ERROR_DS_DRA_RPC_CANCELLED: return "DS_DRA_RPC_CANCELLED";
    case ERROR_DS_DRA_SOURCE_DISABLED: return "DS_DRA_SOURCE_DISABLED";
    case ERROR_DS_DRA_SINK_DISABLED: return "DS_DRA_SINK_DISABLED";
    case ERROR_DS_DRA_NAME_COLLISION: return "DS_DRA_NAME_COLLISION";
    case ERROR_DS_DRA_SOURCE_REINSTALLED: return "DS_DRA_SOURCE_REINSTALLED";
    case ERROR_DS_DRA_MISSING_PARENT: return "DS_DRA_MISSING_PARENT";
    case ERROR_DS_DRA_PREEMPTED: return "DS_DRA_PREEMPTED";
    case ERROR_DS_DRA_ABANDON_SYNC: return "DS_DRA_ABANDON_SYNC";
    case ERROR_DS_DRA_SHUTDOWN: return "DS_DRA_SHUTDOWN";
    case ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET: return "DS_DRA_INCOMPATIBLE_PARTIAL_SET";
    case ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA: return "DS_DRA_SOURCE_IS_PARTIAL_REPLICA";
    case ERROR_DS_DRA_EXTN_CONNECTION_FAILED: return "DS_DRA_EXTN_CONNECTION_FAILED";
    case ERROR_DS_INSTALL_SCHEMA_MISMATCH: return "DS_INSTALL_SCHEMA_MISMATCH";
    case ERROR_DS_DUP_LINK_ID: return "DS_DUP_LINK_ID";
    case ERROR_DS_NAME_ERROR_RESOLVING: return "DS_NAME_ERROR_RESOLVING";
    case ERROR_DS_NAME_ERROR_NOT_FOUND: return "DS_NAME_ERROR_NOT_FOUND";
    case ERROR_DS_NAME_ERROR_NOT_UNIQUE: return "DS_NAME_ERROR_NOT_UNIQUE";
    case ERROR_DS_NAME_ERROR_NO_MAPPING: return "DS_NAME_ERROR_NO_MAPPING";
    case ERROR_DS_NAME_ERROR_DOMAIN_ONLY: return "DS_NAME_ERROR_DOMAIN_ONLY";
    case ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING: return "DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING";
    case ERROR_DS_CONSTRUCTED_ATT_MOD: return "DS_CONSTRUCTED_ATT_MOD";
    case ERROR_DS_WRONG_OM_OBJ_CLASS: return "DS_WRONG_OM_OBJ_CLASS";
    case ERROR_DS_DRA_REPL_PENDING: return "DS_DRA_REPL_PENDING";
    case ERROR_DS_DS_REQUIRED: return "DS_DS_REQUIRED";
    case ERROR_DS_INVALID_LDAP_DISPLAY_NAME: return "DS_INVALID_LDAP_DISPLAY_NAME";
    case ERROR_DS_NON_BASE_SEARCH: return "DS_NON_BASE_SEARCH";
    case ERROR_DS_CANT_RETRIEVE_ATTS: return "DS_CANT_RETRIEVE_ATTS";
    case ERROR_DS_BACKLINK_WITHOUT_LINK: return "DS_BACKLINK_WITHOUT_LINK";
    case ERROR_DS_EPOCH_MISMATCH: return "DS_EPOCH_MISMATCH";
    case ERROR_DS_SRC_NAME_MISMATCH: return "DS_SRC_NAME_MISMATCH";
    case ERROR_DS_SRC_AND_DST_NC_IDENTICAL: return "DS_SRC_AND_DST_NC_IDENTICAL";
    case ERROR_DS_DST_NC_MISMATCH: return "DS_DST_NC_MISMATCH";
    case ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC: return "DS_NOT_AUTHORITIVE_FOR_DST_NC";
    case ERROR_DS_SRC_GUID_MISMATCH: return "DS_SRC_GUID_MISMATCH";
    case ERROR_DS_CANT_MOVE_DELETED_OBJECT: return "DS_CANT_MOVE_DELETED_OBJECT";
    case ERROR_DS_PDC_OPERATION_IN_PROGRESS: return "DS_PDC_OPERATION_IN_PROGRESS";
    case ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD: return "DS_CROSS_DOMAIN_CLEANUP_REQD";
    case ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION: return "DS_ILLEGAL_XDOM_MOVE_OPERATION";
    case ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS: return "DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS";
    case ERROR_DS_NC_MUST_HAVE_NC_PARENT: return "DS_NC_MUST_HAVE_NC_PARENT";
    case ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE: return "DS_CR_IMPOSSIBLE_TO_VALIDATE";
    case ERROR_DS_DST_DOMAIN_NOT_NATIVE: return "DS_DST_DOMAIN_NOT_NATIVE";
    case ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER: return "DS_MISSING_INFRASTRUCTURE_CONTAINER";
    case ERROR_DS_CANT_MOVE_ACCOUNT_GROUP: return "DS_CANT_MOVE_ACCOUNT_GROUP";
    case ERROR_DS_CANT_MOVE_RESOURCE_GROUP: return "DS_CANT_MOVE_RESOURCE_GROUP";
    case ERROR_DS_INVALID_SEARCH_FLAG: return "DS_INVALID_SEARCH_FLAG";
    case ERROR_DS_NO_TREE_DELETE_ABOVE_NC: return "DS_NO_TREE_DELETE_ABOVE_NC";
    case ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE: return "DS_COULDNT_LOCK_TREE_FOR_DELETE";
    case ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE: return "DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE";
    case ERROR_DS_SAM_INIT_FAILURE: return "DS_SAM_INIT_FAILURE";
    case ERROR_DS_SENSITIVE_GROUP_VIOLATION: return "DS_SENSITIVE_GROUP_VIOLATION";
    case ERROR_DS_CANT_MOD_PRIMARYGROUPID: return "DS_CANT_MOD_PRIMARYGROUPID";
    case ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD: return "DS_ILLEGAL_BASE_SCHEMA_MOD";
    case ERROR_DS_NONSAFE_SCHEMA_CHANGE: return "DS_NONSAFE_SCHEMA_CHANGE";
    case ERROR_DS_SCHEMA_UPDATE_DISALLOWED: return "DS_SCHEMA_UPDATE_DISALLOWED";
    case ERROR_DS_CANT_CREATE_UNDER_SCHEMA: return "DS_CANT_CREATE_UNDER_SCHEMA";
    case ERROR_DS_INSTALL_NO_SRC_SCH_VERSION: return "DS_INSTALL_NO_SRC_SCH_VERSION";
    case ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE: return "DS_INSTALL_NO_SCH_VERSION_IN_INIFILE";
    case ERROR_DS_INVALID_GROUP_TYPE: return "DS_INVALID_GROUP_TYPE";
    case ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN: return "DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN";
    case ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN: return "DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN";
    case ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER: return "DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER";
    case ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER: return "DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER";
    case ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER: return "DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER";
    case ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER: return "DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER";
    case ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER: return "DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER";
    case ERROR_DS_HAVE_PRIMARY_MEMBERS: return "DS_HAVE_PRIMARY_MEMBERS";
    case ERROR_DS_STRING_SD_CONVERSION_FAILED: return "DS_STRING_SD_CONVERSION_FAILED";
    case ERROR_DS_NAMING_MASTER_GC: return "DS_NAMING_MASTER_GC";
    case ERROR_DS_DNS_LOOKUP_FAILURE: return "DS_DNS_LOOKUP_FAILURE";
    case ERROR_DS_COULDNT_UPDATE_SPNS: return "DS_COULDNT_UPDATE_SPNS";
    case ERROR_DS_CANT_RETRIEVE_SD: return "DS_CANT_RETRIEVE_SD";
    case ERROR_DS_KEY_NOT_UNIQUE: return "DS_KEY_NOT_UNIQUE";
    case ERROR_DS_WRONG_LINKED_ATT_SYNTAX: return "DS_WRONG_LINKED_ATT_SYNTAX";
    case ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD: return "DS_SAM_NEED_BOOTKEY_PASSWORD";
    case ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY: return "DS_SAM_NEED_BOOTKEY_FLOPPY";
    case ERROR_DS_CANT_START: return "DS_CANT_START";
    case ERROR_DS_INIT_FAILURE: return "DS_INIT_FAILURE";
    case ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION: return "DS_NO_PKT_PRIVACY_ON_CONNECTION";
    case ERROR_DS_SOURCE_DOMAIN_IN_FOREST: return "DS_SOURCE_DOMAIN_IN_FOREST";
    case ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST: return "DS_DESTINATION_DOMAIN_NOT_IN_FOREST";
    case ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED: return "DS_DESTINATION_AUDITING_NOT_ENABLED";
    case ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN: return "DS_CANT_FIND_DC_FOR_SRC_DOMAIN";
    case ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER: return "DS_SRC_OBJ_NOT_GROUP_OR_USER";
    case ERROR_DS_SRC_SID_EXISTS_IN_FOREST: return "DS_SRC_SID_EXISTS_IN_FOREST";
    case ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH: return "DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH";
    case ERROR_SAM_INIT_FAILURE: return "SAM_INIT_FAILURE";
    case ERROR_DS_DRA_SCHEMA_INFO_SHIP: return "DS_DRA_SCHEMA_INFO_SHIP";
    case ERROR_DS_DRA_SCHEMA_CONFLICT: return "DS_DRA_SCHEMA_CONFLICT";
    case ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT: return "DS_DRA_EARLIER_SCHEMA_CONFLICT";
    case ERROR_DS_DRA_OBJ_NC_MISMATCH: return "DS_DRA_OBJ_NC_MISMATCH";
    case ERROR_DS_NC_STILL_HAS_DSAS: return "DS_NC_STILL_HAS_DSAS";
    case ERROR_DS_GC_REQUIRED: return "DS_GC_REQUIRED";
    case ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY: return "DS_LOCAL_MEMBER_OF_LOCAL_ONLY";
    case ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS: return "DS_NO_FPO_IN_UNIVERSAL_GROUPS";
    case ERROR_DS_CANT_ADD_TO_GC: return "DS_CANT_ADD_TO_GC";
    case ERROR_DS_NO_CHECKPOINT_WITH_PDC: return "DS_NO_CHECKPOINT_WITH_PDC";
    case ERROR_DS_SOURCE_AUDITING_NOT_ENABLED: return "DS_SOURCE_AUDITING_NOT_ENABLED";
    case ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC: return "DS_CANT_CREATE_IN_NONDOMAIN_NC";
    case ERROR_DS_INVALID_NAME_FOR_SPN: return "DS_INVALID_NAME_FOR_SPN";
    case ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS: return "DS_FILTER_USES_CONTRUCTED_ATTRS";
    case ERROR_DS_UNICODEPWD_NOT_IN_QUOTES: return "DS_UNICODEPWD_NOT_IN_QUOTES";
    case ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED: return "DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED";
    case ERROR_DS_MUST_BE_RUN_ON_DST_DC: return "DS_MUST_BE_RUN_ON_DST_DC";
    case ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER: return "DS_SRC_DC_MUST_BE_SP4_OR_GREATER";
    case ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ: return "DS_CANT_TREE_DELETE_CRITICAL_OBJ";
    case ERROR_DS_INIT_FAILURE_CONSOLE: return "DS_INIT_FAILURE_CONSOLE";
    case ERROR_DS_SAM_INIT_FAILURE_CONSOLE: return "DS_SAM_INIT_FAILURE_CONSOLE";
    case ERROR_DS_FOREST_VERSION_TOO_HIGH: return "DS_FOREST_VERSION_TOO_HIGH";
    case ERROR_DS_DOMAIN_VERSION_TOO_HIGH: return "DS_DOMAIN_VERSION_TOO_HIGH";
    case ERROR_DS_FOREST_VERSION_TOO_LOW: return "DS_FOREST_VERSION_TOO_LOW";
    case ERROR_DS_DOMAIN_VERSION_TOO_LOW: return "DS_DOMAIN_VERSION_TOO_LOW";
    case ERROR_DS_INCOMPATIBLE_VERSION: return "DS_INCOMPATIBLE_VERSION";
    case ERROR_DS_LOW_DSA_VERSION: return "DS_LOW_DSA_VERSION";
    case ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN: return "DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN";
    case ERROR_DS_NOT_SUPPORTED_SORT_ORDER: return "DS_NOT_SUPPORTED_SORT_ORDER";
    case ERROR_DS_NAME_NOT_UNIQUE: return "DS_NAME_NOT_UNIQUE";
    case ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4: return "DS_MACHINE_ACCOUNT_CREATED_PRENT4";
    case ERROR_DS_OUT_OF_VERSION_STORE: return "DS_OUT_OF_VERSION_STORE";
    case ERROR_DS_INCOMPATIBLE_CONTROLS_USED: return "DS_INCOMPATIBLE_CONTROLS_USED";
    case ERROR_DS_NO_REF_DOMAIN: return "DS_NO_REF_DOMAIN";
    case ERROR_DS_RESERVED_LINK_ID: return "DS_RESERVED_LINK_ID";
    case ERROR_DS_LINK_ID_NOT_AVAILABLE: return "DS_LINK_ID_NOT_AVAILABLE";
    case ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER: return "DS_AG_CANT_HAVE_UNIVERSAL_MEMBER";
    case ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE: return "DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE";
    case ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC: return "DS_NO_OBJECT_MOVE_IN_SCHEMA_NC";
    case ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG: return "DS_MODIFYDN_DISALLOWED_BY_FLAG";
    case ERROR_DS_MODIFYDN_WRONG_GRANDPARENT: return "DS_MODIFYDN_WRONG_GRANDPARENT";
    case ERROR_DS_NAME_ERROR_TRUST_REFERRAL: return "DS_NAME_ERROR_TRUST_REFERRAL";
    case ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER: return "NOT_SUPPORTED_ON_STANDARD_SERVER";
    case ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD: return "DS_CANT_ACCESS_REMOTE_PART_OF_AD";
    case ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2: return "DS_CR_IMPOSSIBLE_TO_VALIDATE_V2";
    case ERROR_DS_THREAD_LIMIT_EXCEEDED: return "DS_THREAD_LIMIT_EXCEEDED";
    case ERROR_DS_NOT_CLOSEST: return "DS_NOT_CLOSEST";
    case ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF: return "DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF";
    case ERROR_DS_SINGLE_USER_MODE_FAILED: return "DS_SINGLE_USER_MODE_FAILED";
    case ERROR_DS_NTDSCRIPT_SYNTAX_ERROR: return "DS_NTDSCRIPT_SYNTAX_ERROR";
    case ERROR_DS_NTDSCRIPT_PROCESS_ERROR: return "DS_NTDSCRIPT_PROCESS_ERROR";
    case ERROR_DS_DIFFERENT_REPL_EPOCHS: return "DS_DIFFERENT_REPL_EPOCHS";
    case ERROR_DS_DRS_EXTENSIONS_CHANGED: return "DS_DRS_EXTENSIONS_CHANGED";
    case ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR: return "DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR";
    case ERROR_DS_NO_MSDS_INTID: return "DS_NO_MSDS_INTID";
    case ERROR_DS_DUP_MSDS_INTID: return "DS_DUP_MSDS_INTID";
    case ERROR_DS_EXISTS_IN_RDNATTID: return "DS_EXISTS_IN_RDNATTID";
    case ERROR_DS_AUTHORIZATION_FAILED: return "DS_AUTHORIZATION_FAILED";
    case ERROR_DS_INVALID_SCRIPT: return "DS_INVALID_SCRIPT";
    case ERROR_DS_REMOTE_CROSSREF_OP_FAILED: return "DS_REMOTE_CROSSREF_OP_FAILED";
    case ERROR_DS_CROSS_REF_BUSY: return "DS_CROSS_REF_BUSY";
    case ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN: return "DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN";
    case ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC: return "DS_CANT_DEMOTE_WITH_WRITEABLE_NC";
    case ERROR_DS_DUPLICATE_ID_FOUND: return "DS_DUPLICATE_ID_FOUND";
    case ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT: return "DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT";
    case ERROR_DS_GROUP_CONVERSION_ERROR: return "DS_GROUP_CONVERSION_ERROR";
    case ERROR_DS_CANT_MOVE_APP_BASIC_GROUP: return "DS_CANT_MOVE_APP_BASIC_GROUP";
    case ERROR_DS_CANT_MOVE_APP_QUERY_GROUP: return "DS_CANT_MOVE_APP_QUERY_GROUP";
    case ERROR_DS_ROLE_NOT_VERIFIED: return "DS_ROLE_NOT_VERIFIED";
    case ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL: return "DS_WKO_CONTAINER_CANNOT_BE_SPECIAL";
    case ERROR_DS_DOMAIN_RENAME_IN_PROGRESS: return "DS_DOMAIN_RENAME_IN_PROGRESS";
    case ERROR_DS_EXISTING_AD_CHILD_NC: return "DS_EXISTING_AD_CHILD_NC";
    case ERROR_DS_REPL_LIFETIME_EXCEEDED: return "DS_REPL_LIFETIME_EXCEEDED";
    case ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER: return "DS_DISALLOWED_IN_SYSTEM_CONTAINER";
    case ERROR_DS_LDAP_SEND_QUEUE_FULL: return "DS_LDAP_SEND_QUEUE_FULL";
    case ERROR_DS_DRA_OUT_SCHEDULE_WINDOW: return "DS_DRA_OUT_SCHEDULE_WINDOW";
    case ERROR_SXS_SECTION_NOT_FOUND: return "SXS_SECTION_NOT_FOUND";
    case ERROR_SXS_CANT_GEN_ACTCTX: return "SXS_CANT_GEN_ACTCTX";
    case ERROR_SXS_INVALID_ACTCTXDATA_FORMAT: return "SXS_INVALID_ACTCTXDATA_FORMAT";
    case ERROR_SXS_ASSEMBLY_NOT_FOUND: return "SXS_ASSEMBLY_NOT_FOUND";
    case ERROR_SXS_MANIFEST_FORMAT_ERROR: return "SXS_MANIFEST_FORMAT_ERROR";
    case ERROR_SXS_MANIFEST_PARSE_ERROR: return "SXS_MANIFEST_PARSE_ERROR";
    case ERROR_SXS_ACTIVATION_CONTEXT_DISABLED: return "SXS_ACTIVATION_CONTEXT_DISABLED";
    case ERROR_SXS_KEY_NOT_FOUND: return "SXS_KEY_NOT_FOUND";
    case ERROR_SXS_VERSION_CONFLICT: return "SXS_VERSION_CONFLICT";
    case ERROR_SXS_WRONG_SECTION_TYPE: return "SXS_WRONG_SECTION_TYPE";
    case ERROR_SXS_THREAD_QUERIES_DISABLED: return "SXS_THREAD_QUERIES_DISABLED";
    case ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET: return "SXS_PROCESS_DEFAULT_ALREADY_SET";
    case ERROR_SXS_UNKNOWN_ENCODING_GROUP: return "SXS_UNKNOWN_ENCODING_GROUP";
    case ERROR_SXS_UNKNOWN_ENCODING: return "SXS_UNKNOWN_ENCODING";
    case ERROR_SXS_INVALID_XML_NAMESPACE_URI: return "SXS_INVALID_XML_NAMESPACE_URI";
    case ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED: return "SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED";
    case ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED: return "SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED";
    case ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE: return "SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE";
    case ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE: return "SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE";
    case ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE: return "SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE";
    case ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT: return "SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT";
    case ERROR_SXS_DUPLICATE_DLL_NAME: return "SXS_DUPLICATE_DLL_NAME";
    case ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME: return "SXS_DUPLICATE_WINDOWCLASS_NAME";
    case ERROR_SXS_DUPLICATE_CLSID: return "SXS_DUPLICATE_CLSID";
    case ERROR_SXS_DUPLICATE_IID: return "SXS_DUPLICATE_IID";
    case ERROR_SXS_DUPLICATE_TLBID: return "SXS_DUPLICATE_TLBID";
    case ERROR_SXS_DUPLICATE_PROGID: return "SXS_DUPLICATE_PROGID";
    case ERROR_SXS_DUPLICATE_ASSEMBLY_NAME: return "SXS_DUPLICATE_ASSEMBLY_NAME";
    case ERROR_SXS_FILE_HASH_MISMATCH: return "SXS_FILE_HASH_MISMATCH";
    case ERROR_SXS_POLICY_PARSE_ERROR: return "SXS_POLICY_PARSE_ERROR";
    case ERROR_SXS_XML_E_MISSINGQUOTE: return "SXS_XML_E_MISSINGQUOTE";
    case ERROR_SXS_XML_E_COMMENTSYNTAX: return "SXS_XML_E_COMMENTSYNTAX";
    case ERROR_SXS_XML_E_BADSTARTNAMECHAR: return "SXS_XML_E_BADSTARTNAMECHAR";
    case ERROR_SXS_XML_E_BADNAMECHAR: return "SXS_XML_E_BADNAMECHAR";
    case ERROR_SXS_XML_E_BADCHARINSTRING: return "SXS_XML_E_BADCHARINSTRING";
    case ERROR_SXS_XML_E_XMLDECLSYNTAX: return "SXS_XML_E_XMLDECLSYNTAX";
    case ERROR_SXS_XML_E_BADCHARDATA: return "SXS_XML_E_BADCHARDATA";
    case ERROR_SXS_XML_E_MISSINGWHITESPACE: return "SXS_XML_E_MISSINGWHITESPACE";
    case ERROR_SXS_XML_E_EXPECTINGTAGEND: return "SXS_XML_E_EXPECTINGTAGEND";
    case ERROR_SXS_XML_E_MISSINGSEMICOLON: return "SXS_XML_E_MISSINGSEMICOLON";
    case ERROR_SXS_XML_E_UNBALANCEDPAREN: return "SXS_XML_E_UNBALANCEDPAREN";
    case ERROR_SXS_XML_E_INTERNALERROR: return "SXS_XML_E_INTERNALERROR";
    case ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE: return "SXS_XML_E_UNEXPECTED_WHITESPACE";
    case ERROR_SXS_XML_E_INCOMPLETE_ENCODING: return "SXS_XML_E_INCOMPLETE_ENCODING";
    case ERROR_SXS_XML_E_MISSING_PAREN: return "SXS_XML_E_MISSING_PAREN";
    case ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE: return "SXS_XML_E_EXPECTINGCLOSEQUOTE";
    case ERROR_SXS_XML_E_MULTIPLE_COLONS: return "SXS_XML_E_MULTIPLE_COLONS";
    case ERROR_SXS_XML_E_INVALID_DECIMAL: return "SXS_XML_E_INVALID_DECIMAL";
    case ERROR_SXS_XML_E_INVALID_HEXIDECIMAL: return "SXS_XML_E_INVALID_HEXIDECIMAL";
    case ERROR_SXS_XML_E_INVALID_UNICODE: return "SXS_XML_E_INVALID_UNICODE";
    case ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK: return "SXS_XML_E_WHITESPACEORQUESTIONMARK";
    case ERROR_SXS_XML_E_UNEXPECTEDENDTAG: return "SXS_XML_E_UNEXPECTEDENDTAG";
    case ERROR_SXS_XML_E_UNCLOSEDTAG: return "SXS_XML_E_UNCLOSEDTAG";
    case ERROR_SXS_XML_E_DUPLICATEATTRIBUTE: return "SXS_XML_E_DUPLICATEATTRIBUTE";
    case ERROR_SXS_XML_E_MULTIPLEROOTS: return "SXS_XML_E_MULTIPLEROOTS";
    case ERROR_SXS_XML_E_INVALIDATROOTLEVEL: return "SXS_XML_E_INVALIDATROOTLEVEL";
    case ERROR_SXS_XML_E_BADXMLDECL: return "SXS_XML_E_BADXMLDECL";
    case ERROR_SXS_XML_E_MISSINGROOT: return "SXS_XML_E_MISSINGROOT";
    case ERROR_SXS_XML_E_UNEXPECTEDEOF: return "SXS_XML_E_UNEXPECTEDEOF";
    case ERROR_SXS_XML_E_BADPEREFINSUBSET: return "SXS_XML_E_BADPEREFINSUBSET";
    case ERROR_SXS_XML_E_UNCLOSEDSTARTTAG: return "SXS_XML_E_UNCLOSEDSTARTTAG";
    case ERROR_SXS_XML_E_UNCLOSEDENDTAG: return "SXS_XML_E_UNCLOSEDENDTAG";
    case ERROR_SXS_XML_E_UNCLOSEDSTRING: return "SXS_XML_E_UNCLOSEDSTRING";
    case ERROR_SXS_XML_E_UNCLOSEDCOMMENT: return "SXS_XML_E_UNCLOSEDCOMMENT";
    case ERROR_SXS_XML_E_UNCLOSEDDECL: return "SXS_XML_E_UNCLOSEDDECL";
    case ERROR_SXS_XML_E_UNCLOSEDCDATA: return "SXS_XML_E_UNCLOSEDCDATA";
    case ERROR_SXS_XML_E_RESERVEDNAMESPACE: return "SXS_XML_E_RESERVEDNAMESPACE";
    case ERROR_SXS_XML_E_INVALIDENCODING: return "SXS_XML_E_INVALIDENCODING";
    case ERROR_SXS_XML_E_INVALIDSWITCH: return "SXS_XML_E_INVALIDSWITCH";
    case ERROR_SXS_XML_E_BADXMLCASE: return "SXS_XML_E_BADXMLCASE";
    case ERROR_SXS_XML_E_INVALID_STANDALONE: return "SXS_XML_E_INVALID_STANDALONE";
    case ERROR_SXS_XML_E_UNEXPECTED_STANDALONE: return "SXS_XML_E_UNEXPECTED_STANDALONE";
    case ERROR_SXS_XML_E_INVALID_VERSION: return "SXS_XML_E_INVALID_VERSION";
    case ERROR_SXS_XML_E_MISSINGEQUALS: return "SXS_XML_E_MISSINGEQUALS";
    case ERROR_SXS_PROTECTION_RECOVERY_FAILED: return "SXS_PROTECTION_RECOVERY_FAILED";
    case ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT: return "SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT";
    case ERROR_SXS_PROTECTION_CATALOG_NOT_VALID: return "SXS_PROTECTION_CATALOG_NOT_VALID";
    case ERROR_SXS_UNTRANSLATABLE_HRESULT: return "SXS_UNTRANSLATABLE_HRESULT";
    case ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING: return "SXS_PROTECTION_CATALOG_FILE_MISSING";
    case ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE: return "SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE";
    case ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME: return "SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME";
    case ERROR_SXS_ASSEMBLY_MISSING: return "SXS_ASSEMBLY_MISSING";
    case ERROR_SXS_CORRUPT_ACTIVATION_STACK: return "SXS_CORRUPT_ACTIVATION_STACK";
    case ERROR_SXS_CORRUPTION: return "SXS_CORRUPTION";
    case ERROR_SXS_EARLY_DEACTIVATION: return "SXS_EARLY_DEACTIVATION";
    case ERROR_SXS_INVALID_DEACTIVATION: return "SXS_INVALID_DEACTIVATION";
    case ERROR_SXS_MULTIPLE_DEACTIVATION: return "SXS_MULTIPLE_DEACTIVATION";
    case ERROR_SXS_PROCESS_TERMINATION_REQUESTED: return "SXS_PROCESS_TERMINATION_REQUESTED";
    case ERROR_SXS_RELEASE_ACTIVATION_CONTEXT: return "SXS_RELEASE_ACTIVATION_CONTEXT";
    case ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY: return "SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY";
    case ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE: return "SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE";
    case ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME: return "SXS_INVALID_IDENTITY_ATTRIBUTE_NAME";
    case ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE: return "SXS_IDENTITY_DUPLICATE_ATTRIBUTE";
    case ERROR_SXS_IDENTITY_PARSE_ERROR: return "SXS_IDENTITY_PARSE_ERROR";
    case ERROR_MALFORMED_SUBSTITUTION_STRING: return "MALFORMED_SUBSTITUTION_STRING";
    case ERROR_SXS_INCORRECT_PUBLIC_KEY_TOKEN: return "SXS_INCORRECT_PUBLIC_KEY_TOKEN";
    case ERROR_UNMAPPED_SUBSTITUTION_STRING: return "UNMAPPED_SUBSTITUTION_STRING";
    case ERROR_SXS_ASSEMBLY_NOT_LOCKED: return "SXS_ASSEMBLY_NOT_LOCKED";
    case ERROR_SXS_COMPONENT_STORE_CORRUPT: return "SXS_COMPONENT_STORE_CORRUPT";
    case ERROR_ADVANCED_INSTALLER_FAILED: return "ADVANCED_INSTALLER_FAILED";
    case ERROR_XML_ENCODING_MISMATCH: return "XML_ENCODING_MISMATCH";
    case ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT: return "SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT";
    case ERROR_SXS_IDENTITIES_DIFFERENT: return "SXS_IDENTITIES_DIFFERENT";
    case ERROR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT: return "SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT";
    case ERROR_SXS_FILE_NOT_PART_OF_ASSEMBLY: return "SXS_FILE_NOT_PART_OF_ASSEMBLY";
    case ERROR_SXS_MANIFEST_TOO_BIG: return "SXS_MANIFEST_TOO_BIG";
    case ERROR_SXS_SETTING_NOT_REGISTERED: return "SXS_SETTING_NOT_REGISTERED";
    case ERROR_SXS_TRANSACTION_CLOSURE_INCOMPLETE: return "SXS_TRANSACTION_CLOSURE_INCOMPLETE";
    case ERROR_SMI_PRIMITIVE_INSTALLER_FAILED: return "SMI_PRIMITIVE_INSTALLER_FAILED";
    case ERROR_GENERIC_COMMAND_FAILED: return "GENERIC_COMMAND_FAILED";
    case ERROR_SXS_FILE_HASH_MISSING: return "SXS_FILE_HASH_MISSING";
    case ERROR_IPSEC_QM_POLICY_EXISTS: return "IPSEC_QM_POLICY_EXISTS";
    case ERROR_IPSEC_QM_POLICY_NOT_FOUND: return "IPSEC_QM_POLICY_NOT_FOUND";
    case ERROR_IPSEC_QM_POLICY_IN_USE: return "IPSEC_QM_POLICY_IN_USE";
    case ERROR_IPSEC_MM_POLICY_EXISTS: return "IPSEC_MM_POLICY_EXISTS";
    case ERROR_IPSEC_MM_POLICY_NOT_FOUND: return "IPSEC_MM_POLICY_NOT_FOUND";
    case ERROR_IPSEC_MM_POLICY_IN_USE: return "IPSEC_MM_POLICY_IN_USE";
    case ERROR_IPSEC_MM_FILTER_EXISTS: return "IPSEC_MM_FILTER_EXISTS";
    case ERROR_IPSEC_MM_FILTER_NOT_FOUND: return "IPSEC_MM_FILTER_NOT_FOUND";
    case ERROR_IPSEC_TRANSPORT_FILTER_EXISTS: return "IPSEC_TRANSPORT_FILTER_EXISTS";
    case ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND: return "IPSEC_TRANSPORT_FILTER_NOT_FOUND";
    case ERROR_IPSEC_MM_AUTH_EXISTS: return "IPSEC_MM_AUTH_EXISTS";
    case ERROR_IPSEC_MM_AUTH_NOT_FOUND: return "IPSEC_MM_AUTH_NOT_FOUND";
    case ERROR_IPSEC_MM_AUTH_IN_USE: return "IPSEC_MM_AUTH_IN_USE";
    case ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND: return "IPSEC_DEFAULT_MM_POLICY_NOT_FOUND";
    case ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND: return "IPSEC_DEFAULT_MM_AUTH_NOT_FOUND";
    case ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND: return "IPSEC_DEFAULT_QM_POLICY_NOT_FOUND";
    case ERROR_IPSEC_TUNNEL_FILTER_EXISTS: return "IPSEC_TUNNEL_FILTER_EXISTS";
    case ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND: return "IPSEC_TUNNEL_FILTER_NOT_FOUND";
    case ERROR_IPSEC_MM_FILTER_PENDING_DELETION: return "IPSEC_MM_FILTER_PENDING_DELETION";
    case ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION: return "IPSEC_TRANSPORT_FILTER_PENDING_DELETION";
    case ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION: return "IPSEC_TUNNEL_FILTER_PENDING_DELETION";
    case ERROR_IPSEC_MM_POLICY_PENDING_DELETION: return "IPSEC_MM_POLICY_PENDING_DELETION";
    case ERROR_IPSEC_MM_AUTH_PENDING_DELETION: return "IPSEC_MM_AUTH_PENDING_DELETION";
    case ERROR_IPSEC_QM_POLICY_PENDING_DELETION: return "IPSEC_QM_POLICY_PENDING_DELETION";
    case ERROR_IPSEC_IKE_NEG_STATUS_BEGIN: return "IPSEC_IKE_NEG_STATUS_BEGIN";
    case ERROR_IPSEC_IKE_AUTH_FAIL: return "IPSEC_IKE_AUTH_FAIL";
    case ERROR_IPSEC_IKE_ATTRIB_FAIL: return "IPSEC_IKE_ATTRIB_FAIL";
    case ERROR_IPSEC_IKE_NEGOTIATION_PENDING: return "IPSEC_IKE_NEGOTIATION_PENDING";
    case ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR: return "IPSEC_IKE_GENERAL_PROCESSING_ERROR";
    case ERROR_IPSEC_IKE_TIMED_OUT: return "IPSEC_IKE_TIMED_OUT";
    case ERROR_IPSEC_IKE_NO_CERT: return "IPSEC_IKE_NO_CERT";
    case ERROR_IPSEC_IKE_SA_DELETED: return "IPSEC_IKE_SA_DELETED";
    case ERROR_IPSEC_IKE_SA_REAPED: return "IPSEC_IKE_SA_REAPED";
    case ERROR_IPSEC_IKE_MM_ACQUIRE_DROP: return "IPSEC_IKE_MM_ACQUIRE_DROP";
    case ERROR_IPSEC_IKE_QM_ACQUIRE_DROP: return "IPSEC_IKE_QM_ACQUIRE_DROP";
    case ERROR_IPSEC_IKE_QUEUE_DROP_MM: return "IPSEC_IKE_QUEUE_DROP_MM";
    case ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM: return "IPSEC_IKE_QUEUE_DROP_NO_MM";
    case ERROR_IPSEC_IKE_DROP_NO_RESPONSE: return "IPSEC_IKE_DROP_NO_RESPONSE";
    case ERROR_IPSEC_IKE_MM_DELAY_DROP: return "IPSEC_IKE_MM_DELAY_DROP";
    case ERROR_IPSEC_IKE_QM_DELAY_DROP: return "IPSEC_IKE_QM_DELAY_DROP";
    case ERROR_IPSEC_IKE_ERROR: return "IPSEC_IKE_ERROR";
    case ERROR_IPSEC_IKE_CRL_FAILED: return "IPSEC_IKE_CRL_FAILED";
    case ERROR_IPSEC_IKE_INVALID_KEY_USAGE: return "IPSEC_IKE_INVALID_KEY_USAGE";
    case ERROR_IPSEC_IKE_INVALID_CERT_TYPE: return "IPSEC_IKE_INVALID_CERT_TYPE";
    case ERROR_IPSEC_IKE_NO_PRIVATE_KEY: return "IPSEC_IKE_NO_PRIVATE_KEY";
    case ERROR_IPSEC_IKE_DH_FAIL: return "IPSEC_IKE_DH_FAIL";
    case ERROR_IPSEC_IKE_INVALID_HEADER: return "IPSEC_IKE_INVALID_HEADER";
    case ERROR_IPSEC_IKE_NO_POLICY: return "IPSEC_IKE_NO_POLICY";
    case ERROR_IPSEC_IKE_INVALID_SIGNATURE: return "IPSEC_IKE_INVALID_SIGNATURE";
    case ERROR_IPSEC_IKE_KERBEROS_ERROR: return "IPSEC_IKE_KERBEROS_ERROR";
    case ERROR_IPSEC_IKE_NO_PUBLIC_KEY: return "IPSEC_IKE_NO_PUBLIC_KEY";
    case ERROR_IPSEC_IKE_PROCESS_ERR: return "IPSEC_IKE_PROCESS_ERR";
    case ERROR_IPSEC_IKE_PROCESS_ERR_SA: return "IPSEC_IKE_PROCESS_ERR_SA";
    case ERROR_IPSEC_IKE_PROCESS_ERR_PROP: return "IPSEC_IKE_PROCESS_ERR_PROP";
    case ERROR_IPSEC_IKE_PROCESS_ERR_TRANS: return "IPSEC_IKE_PROCESS_ERR_TRANS";
    case ERROR_IPSEC_IKE_PROCESS_ERR_KE: return "IPSEC_IKE_PROCESS_ERR_KE";
    case ERROR_IPSEC_IKE_PROCESS_ERR_ID: return "IPSEC_IKE_PROCESS_ERR_ID";
    case ERROR_IPSEC_IKE_PROCESS_ERR_CERT: return "IPSEC_IKE_PROCESS_ERR_CERT";
    case ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ: return "IPSEC_IKE_PROCESS_ERR_CERT_REQ";
    case ERROR_IPSEC_IKE_PROCESS_ERR_HASH: return "IPSEC_IKE_PROCESS_ERR_HASH";
    case ERROR_IPSEC_IKE_PROCESS_ERR_SIG: return "IPSEC_IKE_PROCESS_ERR_SIG";
    case ERROR_IPSEC_IKE_PROCESS_ERR_NONCE: return "IPSEC_IKE_PROCESS_ERR_NONCE";
    case ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY: return "IPSEC_IKE_PROCESS_ERR_NOTIFY";
    case ERROR_IPSEC_IKE_PROCESS_ERR_DELETE: return "IPSEC_IKE_PROCESS_ERR_DELETE";
    case ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR: return "IPSEC_IKE_PROCESS_ERR_VENDOR";
    case ERROR_IPSEC_IKE_INVALID_PAYLOAD: return "IPSEC_IKE_INVALID_PAYLOAD";
    case ERROR_IPSEC_IKE_LOAD_SOFT_SA: return "IPSEC_IKE_LOAD_SOFT_SA";
    case ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN: return "IPSEC_IKE_SOFT_SA_TORN_DOWN";
    case ERROR_IPSEC_IKE_INVALID_COOKIE: return "IPSEC_IKE_INVALID_COOKIE";
    case ERROR_IPSEC_IKE_NO_PEER_CERT: return "IPSEC_IKE_NO_PEER_CERT";
    case ERROR_IPSEC_IKE_PEER_CRL_FAILED: return "IPSEC_IKE_PEER_CRL_FAILED";
    case ERROR_IPSEC_IKE_POLICY_CHANGE: return "IPSEC_IKE_POLICY_CHANGE";
    case ERROR_IPSEC_IKE_NO_MM_POLICY: return "IPSEC_IKE_NO_MM_POLICY";
    case ERROR_IPSEC_IKE_NOTCBPRIV: return "IPSEC_IKE_NOTCBPRIV";
    case ERROR_IPSEC_IKE_SECLOADFAIL: return "IPSEC_IKE_SECLOADFAIL";
    case ERROR_IPSEC_IKE_FAILSSPINIT: return "IPSEC_IKE_FAILSSPINIT";
    case ERROR_IPSEC_IKE_FAILQUERYSSP: return "IPSEC_IKE_FAILQUERYSSP";
    case ERROR_IPSEC_IKE_SRVACQFAIL: return "IPSEC_IKE_SRVACQFAIL";
    case ERROR_IPSEC_IKE_SRVQUERYCRED: return "IPSEC_IKE_SRVQUERYCRED";
    case ERROR_IPSEC_IKE_GETSPIFAIL: return "IPSEC_IKE_GETSPIFAIL";
    case ERROR_IPSEC_IKE_INVALID_FILTER: return "IPSEC_IKE_INVALID_FILTER";
    case ERROR_IPSEC_IKE_OUT_OF_MEMORY: return "IPSEC_IKE_OUT_OF_MEMORY";
    case ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED: return "IPSEC_IKE_ADD_UPDATE_KEY_FAILED";
    case ERROR_IPSEC_IKE_INVALID_POLICY: return "IPSEC_IKE_INVALID_POLICY";
    case ERROR_IPSEC_IKE_UNKNOWN_DOI: return "IPSEC_IKE_UNKNOWN_DOI";
    case ERROR_IPSEC_IKE_INVALID_SITUATION: return "IPSEC_IKE_INVALID_SITUATION";
    case ERROR_IPSEC_IKE_DH_FAILURE: return "IPSEC_IKE_DH_FAILURE";
    case ERROR_IPSEC_IKE_INVALID_GROUP: return "IPSEC_IKE_INVALID_GROUP";
    case ERROR_IPSEC_IKE_ENCRYPT: return "IPSEC_IKE_ENCRYPT";
    case ERROR_IPSEC_IKE_DECRYPT: return "IPSEC_IKE_DECRYPT";
    case ERROR_IPSEC_IKE_POLICY_MATCH: return "IPSEC_IKE_POLICY_MATCH";
    case ERROR_IPSEC_IKE_UNSUPPORTED_ID: return "IPSEC_IKE_UNSUPPORTED_ID";
    case ERROR_IPSEC_IKE_INVALID_HASH: return "IPSEC_IKE_INVALID_HASH";
    case ERROR_IPSEC_IKE_INVALID_HASH_ALG: return "IPSEC_IKE_INVALID_HASH_ALG";
    case ERROR_IPSEC_IKE_INVALID_HASH_SIZE: return "IPSEC_IKE_INVALID_HASH_SIZE";
    case ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG: return "IPSEC_IKE_INVALID_ENCRYPT_ALG";
    case ERROR_IPSEC_IKE_INVALID_AUTH_ALG: return "IPSEC_IKE_INVALID_AUTH_ALG";
    case ERROR_IPSEC_IKE_INVALID_SIG: return "IPSEC_IKE_INVALID_SIG";
    case ERROR_IPSEC_IKE_LOAD_FAILED: return "IPSEC_IKE_LOAD_FAILED";
    case ERROR_IPSEC_IKE_RPC_DELETE: return "IPSEC_IKE_RPC_DELETE";
    case ERROR_IPSEC_IKE_BENIGN_REINIT: return "IPSEC_IKE_BENIGN_REINIT";
    case ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY: return "IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY";
    case ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN: return "IPSEC_IKE_INVALID_CERT_KEYLEN";
    case ERROR_IPSEC_IKE_MM_LIMIT: return "IPSEC_IKE_MM_LIMIT";
    case ERROR_IPSEC_IKE_NEGOTIATION_DISABLED: return "IPSEC_IKE_NEGOTIATION_DISABLED";
    case ERROR_IPSEC_IKE_QM_LIMIT: return "IPSEC_IKE_QM_LIMIT";
    case ERROR_IPSEC_IKE_MM_EXPIRED: return "IPSEC_IKE_MM_EXPIRED";
    case ERROR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID: return "IPSEC_IKE_PEER_MM_ASSUMED_INVALID";
    case ERROR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH: return "IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH";
    case ERROR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID: return "IPSEC_IKE_UNEXPECTED_MESSAGE_ID";
    case ERROR_IPSEC_IKE_INVALID_AUTH_PAYLOAD: return "IPSEC_IKE_INVALID_AUTH_PAYLOAD";
    case ERROR_IPSEC_IKE_DOS_COOKIE_SENT: return "IPSEC_IKE_DOS_COOKIE_SENT";
    case ERROR_IPSEC_IKE_SHUTTING_DOWN: return "IPSEC_IKE_SHUTTING_DOWN";
    case ERROR_IPSEC_IKE_CGA_AUTH_FAILED: return "IPSEC_IKE_CGA_AUTH_FAILED";
    case ERROR_IPSEC_IKE_PROCESS_ERR_NATOA: return "IPSEC_IKE_PROCESS_ERR_NATOA";
    case ERROR_IPSEC_IKE_INVALID_MM_FOR_QM: return "IPSEC_IKE_INVALID_MM_FOR_QM";
    case ERROR_IPSEC_IKE_QM_EXPIRED: return "IPSEC_IKE_QM_EXPIRED";
    case ERROR_IPSEC_IKE_TOO_MANY_FILTERS: return "IPSEC_IKE_TOO_MANY_FILTERS";
    case ERROR_IPSEC_IKE_NEG_STATUS_END: return "IPSEC_IKE_NEG_STATUS_END";
    case ERROR_IPSEC_IKE_KILL_DUMMY_NAP_TUNNEL: return "IPSEC_IKE_KILL_DUMMY_NAP_TUNNEL";
    case ERROR_IPSEC_IKE_INNER_IP_ASSIGNMENT_FAILURE: return "IPSEC_IKE_INNER_IP_ASSIGNMENT_FAILURE";
    case ERROR_IPSEC_IKE_REQUIRE_CP_PAYLOAD_MISSING: return "IPSEC_IKE_REQUIRE_CP_PAYLOAD_MISSING";
    case ERROR_IPSEC_KEY_MODULE_IMPERSONATION_NEGOTIATION_PENDING: return "IPSEC_KEY_MODULE_IMPERSONATION_NEGOTIATION_PENDING";
    case ERROR_IPSEC_IKE_COEXISTENCE_SUPPRESS: return "IPSEC_IKE_COEXISTENCE_SUPPRESS";
    case ERROR_IPSEC_IKE_RATELIMIT_DROP: return "IPSEC_IKE_RATELIMIT_DROP";
    case ERROR_IPSEC_IKE_PEER_DOESNT_SUPPORT_MOBIKE: return "IPSEC_IKE_PEER_DOESNT_SUPPORT_MOBIKE";
    case ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE: return "IPSEC_IKE_AUTHORIZATION_FAILURE";
    case ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_FAILURE: return "IPSEC_IKE_STRONG_CRED_AUTHORIZATION_FAILURE";
    case ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE_WITH_OPTIONAL_RETRY: return "IPSEC_IKE_AUTHORIZATION_FAILURE_WITH_OPTIONAL_RETRY";
    case ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_AND_CERTMAP_FAILURE: return "IPSEC_IKE_STRONG_CRED_AUTHORIZATION_AND_CERTMAP_FAILURE";
    case ERROR_IPSEC_IKE_NEG_STATUS_EXTENDED_END: return "IPSEC_IKE_NEG_STATUS_EXTENDED_END";
    case ERROR_IPSEC_BAD_SPI: return "IPSEC_BAD_SPI";
    case ERROR_IPSEC_SA_LIFETIME_EXPIRED: return "IPSEC_SA_LIFETIME_EXPIRED";
    case ERROR_IPSEC_WRONG_SA: return "IPSEC_WRONG_SA";
    case ERROR_IPSEC_REPLAY_CHECK_FAILED: return "IPSEC_REPLAY_CHECK_FAILED";
    case ERROR_IPSEC_INVALID_PACKET: return "IPSEC_INVALID_PACKET";
    case ERROR_IPSEC_INTEGRITY_CHECK_FAILED: return "IPSEC_INTEGRITY_CHECK_FAILED";
    case ERROR_IPSEC_CLEAR_TEXT_DROP: return "IPSEC_CLEAR_TEXT_DROP";
    case ERROR_IPSEC_AUTH_FIREWALL_DROP: return "IPSEC_AUTH_FIREWALL_DROP";
    case ERROR_IPSEC_THROTTLE_DROP: return "IPSEC_THROTTLE_DROP";
    case ERROR_IPSEC_DOSP_BLOCK: return "IPSEC_DOSP_BLOCK";
    case ERROR_IPSEC_DOSP_RECEIVED_MULTICAST: return "IPSEC_DOSP_RECEIVED_MULTICAST";
    case ERROR_IPSEC_DOSP_INVALID_PACKET: return "IPSEC_DOSP_INVALID_PACKET";
    case ERROR_IPSEC_DOSP_STATE_LOOKUP_FAILED: return "IPSEC_DOSP_STATE_LOOKUP_FAILED";
    case ERROR_IPSEC_DOSP_MAX_ENTRIES: return "IPSEC_DOSP_MAX_ENTRIES";
    case ERROR_IPSEC_DOSP_KEYMOD_NOT_ALLOWED: return "IPSEC_DOSP_KEYMOD_NOT_ALLOWED";
    case ERROR_IPSEC_DOSP_NOT_INSTALLED: return "IPSEC_DOSP_NOT_INSTALLED";
    case ERROR_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES: return "IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES";
    case ERROR_EVT_INVALID_CHANNEL_PATH: return "EVT_INVALID_CHANNEL_PATH";
    case ERROR_EVT_INVALID_QUERY: return "EVT_INVALID_QUERY";
    case ERROR_EVT_PUBLISHER_METADATA_NOT_FOUND: return "EVT_PUBLISHER_METADATA_NOT_FOUND";
    case ERROR_EVT_EVENT_TEMPLATE_NOT_FOUND: return "EVT_EVENT_TEMPLATE_NOT_FOUND";
    case ERROR_EVT_INVALID_PUBLISHER_NAME: return "EVT_INVALID_PUBLISHER_NAME";
    case ERROR_EVT_INVALID_EVENT_DATA: return "EVT_INVALID_EVENT_DATA";
    case ERROR_EVT_CHANNEL_NOT_FOUND: return "EVT_CHANNEL_NOT_FOUND";
    case ERROR_EVT_MALFORMED_XML_TEXT: return "EVT_MALFORMED_XML_TEXT";
    case ERROR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL: return "EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL";
    case ERROR_EVT_CONFIGURATION_ERROR: return "EVT_CONFIGURATION_ERROR";
    case ERROR_EVT_QUERY_RESULT_STALE: return "EVT_QUERY_RESULT_STALE";
    case ERROR_EVT_QUERY_RESULT_INVALID_POSITION: return "EVT_QUERY_RESULT_INVALID_POSITION";
    case ERROR_EVT_NON_VALIDATING_MSXML: return "EVT_NON_VALIDATING_MSXML";
    case ERROR_EVT_FILTER_ALREADYSCOPED: return "EVT_FILTER_ALREADYSCOPED";
    case ERROR_EVT_FILTER_NOTELTSET: return "EVT_FILTER_NOTELTSET";
    case ERROR_EVT_FILTER_INVARG: return "EVT_FILTER_INVARG";
    case ERROR_EVT_FILTER_INVTEST: return "EVT_FILTER_INVTEST";
    case ERROR_EVT_FILTER_INVTYPE: return "EVT_FILTER_INVTYPE";
    case ERROR_EVT_FILTER_PARSEERR: return "EVT_FILTER_PARSEERR";
    case ERROR_EVT_FILTER_UNSUPPORTEDOP: return "EVT_FILTER_UNSUPPORTEDOP";
    case ERROR_EVT_FILTER_UNEXPECTEDTOKEN: return "EVT_FILTER_UNEXPECTEDTOKEN";
    case ERROR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL: return "EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL";
    case ERROR_EVT_INVALID_CHANNEL_PROPERTY_VALUE: return "EVT_INVALID_CHANNEL_PROPERTY_VALUE";
    case ERROR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE: return "EVT_INVALID_PUBLISHER_PROPERTY_VALUE";
    case ERROR_EVT_CHANNEL_CANNOT_ACTIVATE: return "EVT_CHANNEL_CANNOT_ACTIVATE";
    case ERROR_EVT_FILTER_TOO_COMPLEX: return "EVT_FILTER_TOO_COMPLEX";
    case ERROR_EVT_MESSAGE_NOT_FOUND: return "EVT_MESSAGE_NOT_FOUND";
    case ERROR_EVT_MESSAGE_ID_NOT_FOUND: return "EVT_MESSAGE_ID_NOT_FOUND";
    case ERROR_EVT_UNRESOLVED_VALUE_INSERT: return "EVT_UNRESOLVED_VALUE_INSERT";
    case ERROR_EVT_UNRESOLVED_PARAMETER_INSERT: return "EVT_UNRESOLVED_PARAMETER_INSERT";
    case ERROR_EVT_MAX_INSERTS_REACHED: return "EVT_MAX_INSERTS_REACHED";
    case ERROR_EVT_EVENT_DEFINITION_NOT_FOUND: return "EVT_EVENT_DEFINITION_NOT_FOUND";
    case ERROR_EVT_MESSAGE_LOCALE_NOT_FOUND: return "EVT_MESSAGE_LOCALE_NOT_FOUND";
    case ERROR_EVT_VERSION_TOO_OLD: return "EVT_VERSION_TOO_OLD";
    case ERROR_EVT_VERSION_TOO_NEW: return "EVT_VERSION_TOO_NEW";
    case ERROR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY: return "EVT_CANNOT_OPEN_CHANNEL_OF_QUERY";
    case ERROR_EVT_PUBLISHER_DISABLED: return "EVT_PUBLISHER_DISABLED";
    case ERROR_EVT_FILTER_OUT_OF_RANGE: return "EVT_FILTER_OUT_OF_RANGE";
    case ERROR_EC_SUBSCRIPTION_CANNOT_ACTIVATE: return "EC_SUBSCRIPTION_CANNOT_ACTIVATE";
    case ERROR_EC_LOG_DISABLED: return "EC_LOG_DISABLED";
    case ERROR_EC_CIRCULAR_FORWARDING: return "EC_CIRCULAR_FORWARDING";
    case ERROR_EC_CREDSTORE_FULL: return "EC_CREDSTORE_FULL";
    case ERROR_EC_CRED_NOT_FOUND: return "EC_CRED_NOT_FOUND";
    case ERROR_EC_NO_ACTIVE_CHANNEL: return "EC_NO_ACTIVE_CHANNEL";
    case ERROR_MUI_FILE_NOT_FOUND: return "MUI_FILE_NOT_FOUND";
    case ERROR_MUI_INVALID_FILE: return "MUI_INVALID_FILE";
    case ERROR_MUI_INVALID_RC_CONFIG: return "MUI_INVALID_RC_CONFIG";
    case ERROR_MUI_INVALID_LOCALE_NAME: return "MUI_INVALID_LOCALE_NAME";
    case ERROR_MUI_INVALID_ULTIMATEFALLBACK_NAME: return "MUI_INVALID_ULTIMATEFALLBACK_NAME";
    case ERROR_MUI_FILE_NOT_LOADED: return "MUI_FILE_NOT_LOADED";
    case ERROR_RESOURCE_ENUM_USER_STOP: return "RESOURCE_ENUM_USER_STOP";
    case ERROR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED: return "MUI_INTLSETTINGS_UILANG_NOT_INSTALLED";
    case ERROR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME: return "MUI_INTLSETTINGS_INVALID_LOCALE_NAME";
    case ERROR_MRM_RUNTIME_NO_DEFAULT_OR_NEUTRAL_RESOURCE: return "MRM_RUNTIME_NO_DEFAULT_OR_NEUTRAL_RESOURCE";
    case ERROR_MRM_INVALID_PRICONFIG: return "MRM_INVALID_PRICONFIG";
    case ERROR_MRM_INVALID_FILE_TYPE: return "MRM_INVALID_FILE_TYPE";
    case ERROR_MRM_UNKNOWN_QUALIFIER: return "MRM_UNKNOWN_QUALIFIER";
    case ERROR_MRM_INVALID_QUALIFIER_VALUE: return "MRM_INVALID_QUALIFIER_VALUE";
    case ERROR_MRM_NO_CANDIDATE: return "MRM_NO_CANDIDATE";
    case ERROR_MRM_NO_MATCH_OR_DEFAULT_CANDIDATE: return "MRM_NO_MATCH_OR_DEFAULT_CANDIDATE";
    case ERROR_MRM_RESOURCE_TYPE_MISMATCH: return "MRM_RESOURCE_TYPE_MISMATCH";
    case ERROR_MRM_DUPLICATE_MAP_NAME: return "MRM_DUPLICATE_MAP_NAME";
    case ERROR_MRM_DUPLICATE_ENTRY: return "MRM_DUPLICATE_ENTRY";
    case ERROR_MRM_INVALID_RESOURCE_IDENTIFIER: return "MRM_INVALID_RESOURCE_IDENTIFIER";
    case ERROR_MRM_FILEPATH_TOO_LONG: return "MRM_FILEPATH_TOO_LONG";
    case ERROR_MRM_UNSUPPORTED_DIRECTORY_TYPE: return "MRM_UNSUPPORTED_DIRECTORY_TYPE";
    case ERROR_MRM_INVALID_PRI_FILE: return "MRM_INVALID_PRI_FILE";
    case ERROR_MRM_NAMED_RESOURCE_NOT_FOUND: return "MRM_NAMED_RESOURCE_NOT_FOUND";
    case ERROR_MRM_MAP_NOT_FOUND: return "MRM_MAP_NOT_FOUND";
    case ERROR_MRM_UNSUPPORTED_PROFILE_TYPE: return "MRM_UNSUPPORTED_PROFILE_TYPE";
    case ERROR_MRM_INVALID_QUALIFIER_OPERATOR: return "MRM_INVALID_QUALIFIER_OPERATOR";
    case ERROR_MRM_INDETERMINATE_QUALIFIER_VALUE: return "MRM_INDETERMINATE_QUALIFIER_VALUE";
    case ERROR_MRM_AUTOMERGE_ENABLED: return "MRM_AUTOMERGE_ENABLED";
    case ERROR_MRM_TOO_MANY_RESOURCES: return "MRM_TOO_MANY_RESOURCES";
    case ERROR_MCA_INVALID_CAPABILITIES_STRING: return "MCA_INVALID_CAPABILITIES_STRING";
    case ERROR_MCA_INVALID_VCP_VERSION: return "MCA_INVALID_VCP_VERSION";
    case ERROR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION: return "MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION";
    case ERROR_MCA_MCCS_VERSION_MISMATCH: return "MCA_MCCS_VERSION_MISMATCH";
    case ERROR_MCA_UNSUPPORTED_MCCS_VERSION: return "MCA_UNSUPPORTED_MCCS_VERSION";
    case ERROR_MCA_INTERNAL_ERROR: return "MCA_INTERNAL_ERROR";
    case ERROR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED: return "MCA_INVALID_TECHNOLOGY_TYPE_RETURNED";
    case ERROR_MCA_UNSUPPORTED_COLOR_TEMPERATURE: return "MCA_UNSUPPORTED_COLOR_TEMPERATURE";
    case ERROR_AMBIGUOUS_SYSTEM_DEVICE: return "AMBIGUOUS_SYSTEM_DEVICE";
    case ERROR_SYSTEM_DEVICE_NOT_FOUND: return "SYSTEM_DEVICE_NOT_FOUND";
    case ERROR_HASH_NOT_SUPPORTED: return "HASH_NOT_SUPPORTED";
    case ERROR_HASH_NOT_PRESENT: return "HASH_NOT_PRESENT";
    case ERROR_SECONDARY_IC_PROVIDER_NOT_REGISTERED: return "SECONDARY_IC_PROVIDER_NOT_REGISTERED";
    case ERROR_GPIO_CLIENT_INFORMATION_INVALID: return "GPIO_CLIENT_INFORMATION_INVALID";
    case ERROR_GPIO_VERSION_NOT_SUPPORTED: return "GPIO_VERSION_NOT_SUPPORTED";
    case ERROR_GPIO_INVALID_REGISTRATION_PACKET: return "GPIO_INVALID_REGISTRATION_PACKET";
    case ERROR_GPIO_OPERATION_DENIED: return "GPIO_OPERATION_DENIED";
    case ERROR_GPIO_INCOMPATIBLE_CONNECT_MODE: return "GPIO_INCOMPATIBLE_CONNECT_MODE";
    case ERROR_GPIO_INTERRUPT_ALREADY_UNMASKED: return "GPIO_INTERRUPT_ALREADY_UNMASKED";
    case ERROR_CANNOT_SWITCH_RUNLEVEL: return "CANNOT_SWITCH_RUNLEVEL";
    case ERROR_INVALID_RUNLEVEL_SETTING: return "INVALID_RUNLEVEL_SETTING";
    case ERROR_RUNLEVEL_SWITCH_TIMEOUT: return "RUNLEVEL_SWITCH_TIMEOUT";
    case ERROR_RUNLEVEL_SWITCH_AGENT_TIMEOUT: return "RUNLEVEL_SWITCH_AGENT_TIMEOUT";
    case ERROR_RUNLEVEL_SWITCH_IN_PROGRESS: return "RUNLEVEL_SWITCH_IN_PROGRESS";
    case ERROR_SERVICES_FAILED_AUTOSTART: return "SERVICES_FAILED_AUTOSTART";
    case ERROR_COM_TASK_STOP_PENDING: return "COM_TASK_STOP_PENDING";
    case ERROR_INSTALL_OPEN_PACKAGE_FAILED: return "INSTALL_OPEN_PACKAGE_FAILED";
    case ERROR_INSTALL_PACKAGE_NOT_FOUND: return "INSTALL_PACKAGE_NOT_FOUND";
    case ERROR_INSTALL_INVALID_PACKAGE: return "INSTALL_INVALID_PACKAGE";
    case ERROR_INSTALL_RESOLVE_DEPENDENCY_FAILED: return "INSTALL_RESOLVE_DEPENDENCY_FAILED";
    case ERROR_INSTALL_OUT_OF_DISK_SPACE: return "INSTALL_OUT_OF_DISK_SPACE";
    case ERROR_INSTALL_NETWORK_FAILURE: return "INSTALL_NETWORK_FAILURE";
    case ERROR_INSTALL_REGISTRATION_FAILURE: return "INSTALL_REGISTRATION_FAILURE";
    case ERROR_INSTALL_DEREGISTRATION_FAILURE: return "INSTALL_DEREGISTRATION_FAILURE";
    case ERROR_INSTALL_CANCEL: return "INSTALL_CANCEL";
    case ERROR_INSTALL_FAILED: return "INSTALL_FAILED";
    case ERROR_REMOVE_FAILED: return "REMOVE_FAILED";
    case ERROR_PACKAGE_ALREADY_EXISTS: return "PACKAGE_ALREADY_EXISTS";
    case ERROR_NEEDS_REMEDIATION: return "NEEDS_REMEDIATION";
    case ERROR_INSTALL_PREREQUISITE_FAILED: return "INSTALL_PREREQUISITE_FAILED";
    case ERROR_PACKAGE_REPOSITORY_CORRUPTED: return "PACKAGE_REPOSITORY_CORRUPTED";
    case ERROR_INSTALL_POLICY_FAILURE: return "INSTALL_POLICY_FAILURE";
    case ERROR_PACKAGE_UPDATING: return "PACKAGE_UPDATING";
    case ERROR_DEPLOYMENT_BLOCKED_BY_POLICY: return "DEPLOYMENT_BLOCKED_BY_POLICY";
    case ERROR_PACKAGES_IN_USE: return "PACKAGES_IN_USE";
    case ERROR_RECOVERY_FILE_CORRUPT: return "RECOVERY_FILE_CORRUPT";
    case ERROR_INVALID_STAGED_SIGNATURE: return "INVALID_STAGED_SIGNATURE";
    case ERROR_DELETING_EXISTING_APPLICATIONDATA_STORE_FAILED: return "DELETING_EXISTING_APPLICATIONDATA_STORE_FAILED";
    case ERROR_INSTALL_PACKAGE_DOWNGRADE: return "INSTALL_PACKAGE_DOWNGRADE";
    case ERROR_SYSTEM_NEEDS_REMEDIATION: return "SYSTEM_NEEDS_REMEDIATION";
    case ERROR_APPX_INTEGRITY_FAILURE_CLR_NGEN: return "APPX_INTEGRITY_FAILURE_CLR_NGEN";
    case ERROR_RESILIENCY_FILE_CORRUPT: return "RESILIENCY_FILE_CORRUPT";
    case ERROR_INSTALL_FIREWALL_SERVICE_NOT_RUNNING: return "INSTALL_FIREWALL_SERVICE_NOT_RUNNING";
    case ERROR_STATE_LOAD_STORE_FAILED: return "STATE_LOAD_STORE_FAILED";
    case ERROR_STATE_GET_VERSION_FAILED: return "STATE_GET_VERSION_FAILED";
    case ERROR_STATE_SET_VERSION_FAILED: return "STATE_SET_VERSION_FAILED";
    case ERROR_STATE_STRUCTURED_RESET_FAILED: return "STATE_STRUCTURED_RESET_FAILED";
    case ERROR_STATE_OPEN_CONTAINER_FAILED: return "STATE_OPEN_CONTAINER_FAILED";
    case ERROR_STATE_CREATE_CONTAINER_FAILED: return "STATE_CREATE_CONTAINER_FAILED";
    case ERROR_STATE_DELETE_CONTAINER_FAILED: return "STATE_DELETE_CONTAINER_FAILED";
    case ERROR_STATE_READ_SETTING_FAILED: return "STATE_READ_SETTING_FAILED";
    case ERROR_STATE_WRITE_SETTING_FAILED: return "STATE_WRITE_SETTING_FAILED";
    case ERROR_STATE_DELETE_SETTING_FAILED: return "STATE_DELETE_SETTING_FAILED";
    case ERROR_STATE_QUERY_SETTING_FAILED: return "STATE_QUERY_SETTING_FAILED";
    case ERROR_STATE_READ_COMPOSITE_SETTING_FAILED: return "STATE_READ_COMPOSITE_SETTING_FAILED";
    case ERROR_STATE_WRITE_COMPOSITE_SETTING_FAILED: return "STATE_WRITE_COMPOSITE_SETTING_FAILED";
    case ERROR_STATE_ENUMERATE_CONTAINER_FAILED: return "STATE_ENUMERATE_CONTAINER_FAILED";
    case ERROR_STATE_ENUMERATE_SETTINGS_FAILED: return "STATE_ENUMERATE_SETTINGS_FAILED";
    case ERROR_STATE_COMPOSITE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED: return "STATE_COMPOSITE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED";
    case ERROR_STATE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED: return "STATE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED";
    case ERROR_STATE_SETTING_NAME_SIZE_LIMIT_EXCEEDED: return "STATE_SETTING_NAME_SIZE_LIMIT_EXCEEDED";
    case ERROR_STATE_CONTAINER_NAME_SIZE_LIMIT_EXCEEDED: return "STATE_CONTAINER_NAME_SIZE_LIMIT_EXCEEDED";
    case ERROR_API_UNAVAILABLE: return "API_UNAVAILABLE";
    case ERROR_AUDITING_DISABLED: return "AUDITING_DISABLED";
    case ERROR_ALL_SIDS_FILTERED: return "ALL_SIDS_FILTERED";
    default: return NULL;
    }
}

#endif // MR_WIN32
