:- module training_cars_mid.

% synopsis: Describes the facts that capture the characteristics
%           of cars pulling up to gas stations, and their purchases.
% author:   Douglas M. Auclair (DMA)
% date:     March 21, 2006

:- interface.

:- import_module assoc_list.
:- import_module string.

:- type class
	--->	class(string).

:- type attributes
	--->	attributes(assoc_list(string, string.poly_type)).

:- pred car(int::in, class::out, attributes::out) is semidet.

:- implementation.

:- import_module pair, list, string.

% automatically generated facts follow:

car(0, class("fill up only"), attributes(["state/province" - s("WA"), "tag" - s("IPD050"), "year" - i(2004), "month" - i(12), "day" - i(26), "hour" - i(15), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(27), "weekdays" - i(3), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(195), "standard deviation from mean" - i(293), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(25)])).
car(1, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("88434BH"), "year" - i(2005), "month" - i(1), "day" - i(5), "hour" - i(17), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(122), "record history (days)" - i(145), "weekdays" - i(108), "weekends" - i(14), "preferred day" - s("thursday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(104), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(31)])).
car(2, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6DNI590"), "year" - i(2004), "month" - i(11), "day" - i(5), "hour" - i(16), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(18), "record history (days)" - i(146), "weekdays" - i(15), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(66), "standard deviation from mean" - i(266), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(55), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("17YH"), "preferred pump %" - i(44)])).
car(3, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2876SPL"), "year" - i(2004), "month" - i(12), "day" - i(17), "hour" - i(21), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(35), "record history (days)" - i(147), "weekdays" - i(21), "weekends" - i(14), "preferred day" - s("saturday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(34), "standard deviation from mean" - i(197), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(31)])).
car(4, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1374AVL"), "year" - i(2004), "month" - i(10), "day" - i(4), "hour" - i(13), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(828), "standard deviation from mean" - i(0), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(100)])).
car(5, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9YNI627"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(43), "station" - s("shell"), "fill-ups" - i(73), "record history (days)" - i(149), "weekdays" - i(46), "weekends" - i(27), "preferred day" - s("monday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(64), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(64), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(32)])).
car(6, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2QOX837"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(7), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(46), "record history (days)" - i(165), "weekdays" - i(33), "weekends" - i(13), "preferred day" - s("friday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(12), "standard deviation from mean" - i(75), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(73)])).
car(7, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI137"), "year" - i(2005), "month" - i(2), "day" - i(13), "hour" - i(21), "minute" - i(51), "station" - s("shell"), "fill-ups" - i(60), "record history (days)" - i(148), "weekdays" - i(43), "weekends" - i(17), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(178), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(65), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(16)])).
car(8, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6CNI548"), "year" - i(2004), "month" - i(10), "day" - i(24), "hour" - i(12), "minute" - i(36), "station" - s("shell"), "fill-ups" - i(10), "record history (days)" - i(109), "weekdays" - i(4), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(60), "mean time of visit (minutes after midnight)" - i(85), "standard deviation from mean" - i(243), "different locations" - i(3), "preferred station" - s("chevron"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("17YH"), "preferred pump %" - i(60)])).
car(9, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI405"), "year" - i(2005), "month" - i(2), "day" - i(2), "hour" - i(13), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(56), "record history (days)" - i(147), "weekdays" - i(44), "weekends" - i(12), "preferred day" - s("monday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(105), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(23)])).
car(10, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4715MJM"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(21), "minute" - i(36), "station" - s("pilot"), "fill-ups" - i(50), "record history (days)" - i(160), "weekdays" - i(33), "weekends" - i(17), "preferred day" - s("tuesday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(192), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(44)])).
car(11, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9CNI705"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(168), "weekdays" - i(12), "weekends" - i(10), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(53), "standard deviation from mean" - i(240), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(31)])).
car(12, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI905"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(16), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(143), "weekdays" - i(10), "weekends" - i(15), "preferred day" - s("sunday"), "day preference %" - i(56), "mean time of visit (minutes after midnight)" - i(46), "standard deviation from mean" - i(216), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(60)])).
car(13, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8XNI025"), "year" - i(2005), "month" - i(1), "day" - i(23), "hour" - i(18), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(28), "record history (days)" - i(146), "weekdays" - i(22), "weekends" - i(6), "preferred day" - s("monday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(107), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(35)])).
car(14, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2TNI107"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(21), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(36), "record history (days)" - i(141), "weekdays" - i(22), "weekends" - i(14), "preferred day" - s("saturday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(25), "standard deviation from mean" - i(149), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(55)])).
car(15, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4ZNI107"), "year" - i(2005), "month" - i(1), "day" - i(23), "hour" - i(11), "minute" - i(40), "station" - s("shell"), "fill-ups" - i(18), "record history (days)" - i(146), "weekdays" - i(10), "weekends" - i(8), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(53), "standard deviation from mean" - i(216), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(27)])).
car(16, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3UNI917"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(13), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(139), "weekdays" - i(16), "weekends" - i(6), "preferred day" - s("thursday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(237), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(31)])).
car(17, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7SNI617"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(22), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(141), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(232), "standard deviation from mean" - i(476), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(55)])).
car(18, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI973"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(12), "minute" - i(15), "station" - s("mobil"), "fill-ups" - i(75), "record history (days)" - i(148), "weekdays" - i(59), "weekends" - i(16), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(94), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(30)])).
car(19, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6SNI083"), "year" - i(2005), "month" - i(2), "day" - i(10), "hour" - i(20), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(170), "weekdays" - i(19), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(64), "standard deviation from mean" - i(281), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(27)])).
car(20, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4ZNI568"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(8), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(75), "record history (days)" - i(162), "weekdays" - i(48), "weekends" - i(27), "preferred day" - s("monday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(63), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(34)])).
car(21, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7SNI074"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(19), "minute" - i(0), "station" - s("mobil"), "fill-ups" - i(46), "record history (days)" - i(146), "weekdays" - i(30), "weekends" - i(16), "preferred day" - s("monday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(27), "standard deviation from mean" - i(179), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(89), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(69)])).
car(22, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2095NJM"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(15), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(44), "record history (days)" - i(142), "weekdays" - i(35), "weekends" - i(9), "preferred day" - s("monday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(182), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(22)])).
car(23, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("21387AH"), "year" - i(2004), "month" - i(10), "day" - i(12), "hour" - i(17), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(47), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(325), "standard deviation from mean" - i(376), "different locations" - i(3), "preferred station" - s("Cumberland Farms"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("54VH"), "preferred pump %" - i(25)])).
car(24, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6SNI473"), "year" - i(2005), "month" - i(1), "day" - i(16), "hour" - i(0), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(134), "weekdays" - i(6), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(151), "standard deviation from mean" - i(375), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(25, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI217"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(15), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(51), "record history (days)" - i(151), "weekdays" - i(28), "weekends" - i(23), "preferred day" - s("saturday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(101), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(26, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9ZNI923"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(9), "minute" - i(5), "station" - s("shell"), "fill-ups" - i(26), "record history (days)" - i(142), "weekdays" - i(10), "weekends" - i(16), "preferred day" - s("sunday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(117), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(65), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(30)])).
car(27, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8CNI123"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(10), "minute" - i(51), "station" - s("shell"), "fill-ups" - i(26), "record history (days)" - i(147), "weekdays" - i(19), "weekends" - i(7), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(34), "standard deviation from mean" - i(162), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(26)])).
car(28, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI467"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(14), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(14), "record history (days)" - i(135), "weekdays" - i(9), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(57), "standard deviation from mean" - i(198), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(78), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(28)])).
car(29, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("34279AH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(21), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(45), "record history (days)" - i(170), "weekdays" - i(33), "weekends" - i(12), "preferred day" - s("friday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(13), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(22)])).
car(30, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7TNI889"), "year" - i(2004), "month" - i(11), "day" - i(1), "hour" - i(9), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(57), "record history (days)" - i(152), "weekdays" - i(50), "weekends" - i(7), "preferred day" - s("wednesday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(12), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(42)])).
car(31, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6SNI432"), "year" - i(2005), "month" - i(1), "day" - i(11), "hour" - i(19), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(32), "record history (days)" - i(147), "weekdays" - i(29), "weekends" - i(3), "preferred day" - s("friday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(43), "standard deviation from mean" - i(239), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(100)])).
car(32, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8ENI110"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(23), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(51), "record history (days)" - i(142), "weekdays" - i(43), "weekends" - i(8), "preferred day" - s("wednesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(1), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(33, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3XNI510"), "year" - i(2004), "month" - i(12), "day" - i(23), "hour" - i(12), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(15), "record history (days)" - i(136), "weekdays" - i(7), "weekends" - i(8), "preferred day" - s("sunday"), "day preference %" - i(53), "mean time of visit (minutes after midnight)" - i(76), "standard deviation from mean" - i(276), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(33)])).
car(34, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2WNI720"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(11), "minute" - i(32), "station" - s("shell"), "fill-ups" - i(69), "record history (days)" - i(157), "weekdays" - i(55), "weekends" - i(14), "preferred day" - s("thursday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(20), "standard deviation from mean" - i(161), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(23)])).
car(35, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3XNI132"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(16), "minute" - i(45), "station" - s("shell"), "fill-ups" - i(18), "record history (days)" - i(147), "weekdays" - i(8), "weekends" - i(10), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(64), "standard deviation from mean" - i(259), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(72), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(27)])).
car(36, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2XNI232"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(22), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(37), "record history (days)" - i(152), "weekdays" - i(27), "weekends" - i(10), "preferred day" - s("monday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(21), "standard deviation from mean" - i(125), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(32)])).
car(37, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0BNI942"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(9), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(139), "weekdays" - i(26), "weekends" - i(5), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(43), "standard deviation from mean" - i(234), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(19)])).
car(38, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ZNI364"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(9), "minute" - i(40), "station" - s("mobil"), "fill-ups" - i(81), "record history (days)" - i(148), "weekdays" - i(64), "weekends" - i(17), "preferred day" - s("monday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(65), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(43)])).
car(39, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("91698AH"), "year" - i(2004), "month" - i(10), "day" - i(6), "hour" - i(13), "minute" - i(8), "station" - s("shell"), "fill-ups" - i(3), "record history (days)" - i(24), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(367), "standard deviation from mean" - i(424), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(66), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(66)])).
car(40, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("86778AH"), "year" - i(2005), "month" - i(1), "day" - i(30), "hour" - i(13), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(114), "record history (days)" - i(148), "weekdays" - i(88), "weekends" - i(26), "preferred day" - s("friday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(52), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(65), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(21)])).
car(41, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("53289AH"), "year" - i(2004), "month" - i(12), "day" - i(17), "hour" - i(7), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(64), "record history (days)" - i(144), "weekdays" - i(47), "weekends" - i(17), "preferred day" - s("friday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(60), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(40)])).
car(42, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("77199AH"), "year" - i(2004), "month" - i(12), "day" - i(22), "hour" - i(9), "minute" - i(45), "station" - s("mobil"), "fill-ups" - i(54), "record history (days)" - i(147), "weekdays" - i(41), "weekends" - i(13), "preferred day" - s("friday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(77), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(64), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(29)])).
car(43, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("58609AH"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(22), "minute" - i(42), "station" - s("shell"), "fill-ups" - i(8), "record history (days)" - i(142), "weekdays" - i(8), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(1), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(62), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(37)])).
car(44, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2UNI147"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(19), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(8), "record history (days)" - i(81), "weekdays" - i(5), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(85), "standard deviation from mean" - i(212), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(37)])).
car(45, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9ZNI893"), "year" - i(2005), "month" - i(1), "day" - i(7), "hour" - i(12), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(102), "record history (days)" - i(141), "weekdays" - i(85), "weekends" - i(17), "preferred day" - s("thursday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(81), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(29)])).
car(46, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8XNI993"), "year" - i(2004), "month" - i(12), "day" - i(4), "hour" - i(14), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(56), "record history (days)" - i(149), "weekdays" - i(45), "weekends" - i(11), "preferred day" - s("tuesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(69), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(19)])).
car(47, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI093"), "year" - i(2005), "month" - i(1), "day" - i(22), "hour" - i(17), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(143), "weekdays" - i(14), "weekends" - i(5), "preferred day" - s("saturday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(55), "standard deviation from mean" - i(228), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(63)])).
car(48, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7SNI493"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(11), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(27), "record history (days)" - i(143), "weekdays" - i(16), "weekends" - i(11), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(38), "standard deviation from mean" - i(190), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(51)])).
car(49, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8080AII"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(10), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(52), "record history (days)" - i(168), "weekdays" - i(47), "weekends" - i(5), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(114), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(65), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(21)])).
car(50, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("84129DH"), "year" - i(2005), "month" - i(1), "day" - i(25), "hour" - i(12), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(194), "record history (days)" - i(132), "weekdays" - i(158), "weekends" - i(36), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(66), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(51), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(38)])).
car(51, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3223YII"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(160), "record history (days)" - i(172), "weekdays" - i(137), "weekends" - i(23), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(51), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(23)])).
car(52, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4435RHI"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(16), "minute" - i(14), "station" - s("shell"), "fill-ups" - i(100), "record history (days)" - i(137), "weekdays" - i(88), "weekends" - i(12), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(100), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(74), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(22)])).
car(53, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3716EHI"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(17), "minute" - i(7), "station" - s("Cumberland Farms"), "fill-ups" - i(65), "record history (days)" - i(123), "weekdays" - i(53), "weekends" - i(12), "preferred day" - s("tuesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(146), "different locations" - i(4), "preferred station" - s("shell"), "preferred station %" - i(47), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(21)])).
car(54, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6DNI445"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(15), "minute" - i(18), "station" - s("shell"), "fill-ups" - i(17), "record history (days)" - i(168), "weekdays" - i(15), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(63), "standard deviation from mean" - i(236), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(64), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(23)])).
car(55, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI955"), "year" - i(2004), "month" - i(11), "day" - i(12), "hour" - i(12), "minute" - i(37), "station" - s("shell"), "fill-ups" - i(27), "record history (days)" - i(146), "weekdays" - i(18), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(39), "standard deviation from mean" - i(198), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(51), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(25)])).
car(56, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2133BHI"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(14), "minute" - i(5), "station" - s("shell"), "fill-ups" - i(77), "record history (days)" - i(160), "weekdays" - i(72), "weekends" - i(5), "preferred day" - s("tuesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(85), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(28)])).
car(57, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2ZMX575"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(22), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(52), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(187), "standard deviation from mean" - i(133), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(100)])).
car(58, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ZNI516"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(20), "minute" - i(30), "station" - s("mobil"), "fill-ups" - i(49), "record history (days)" - i(147), "weekdays" - i(38), "weekends" - i(11), "preferred day" - s("friday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(27), "standard deviation from mean" - i(182), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(77), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(28)])).
car(59, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3546UII"), "year" - i(2005), "month" - i(1), "day" - i(2), "hour" - i(20), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(147), "weekdays" - i(5), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(145), "standard deviation from mean" - i(331), "different locations" - i(3), "preferred station" - s("racetrac"), "preferred station %" - i(42), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("97PX"), "preferred pump %" - i(42)])).
car(60, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("90734BH"), "year" - i(2005), "month" - i(2), "day" - i(16), "hour" - i(15), "minute" - i(23), "station" - s("mobil"), "fill-ups" - i(72), "record history (days)" - i(138), "weekdays" - i(58), "weekends" - i(14), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(126), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(41)])).
car(61, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5VNI949"), "year" - i(2005), "month" - i(2), "day" - i(7), "hour" - i(21), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(122), "weekdays" - i(11), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(91), "standard deviation from mean" - i(289), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(25)])).
car(62, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI906"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(11), "minute" - i(17), "station" - s("mobil"), "fill-ups" - i(43), "record history (days)" - i(148), "weekdays" - i(28), "weekends" - i(15), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(25), "standard deviation from mean" - i(160), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(74), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(23)])).
car(63, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI006"), "year" - i(2005), "month" - i(1), "day" - i(30), "hour" - i(11), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(8), "record history (days)" - i(136), "weekdays" - i(2), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(62), "mean time of visit (minutes after midnight)" - i(106), "standard deviation from mean" - i(265), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(100)])).
car(64, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3WNI306"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(19), "minute" - i(20), "station" - s("mobil"), "fill-ups" - i(34), "record history (days)" - i(162), "weekdays" - i(26), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(39), "standard deviation from mean" - i(214), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(55)])).
car(65, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6XNI606"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(1), "minute" - i(20), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(157), "weekdays" - i(15), "weekends" - i(7), "preferred day" - s("monday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(58), "standard deviation from mean" - i(264), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(31)])).
car(66, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9CNI816"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(16), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(39), "record history (days)" - i(155), "weekdays" - i(29), "weekends" - i(10), "preferred day" - s("saturday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(11), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(20)])).
car(67, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2376HHI"), "year" - i(2005), "month" - i(2), "day" - i(17), "hour" - i(10), "minute" - i(30), "station" - s("mobil"), "fill-ups" - i(82), "record history (days)" - i(154), "weekdays" - i(62), "weekends" - i(20), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(94), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(21)])).
car(68, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9805RHI"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(0), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(49), "record history (days)" - i(148), "weekdays" - i(38), "weekends" - i(11), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(17), "standard deviation from mean" - i(121), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(69), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(20)])).
car(69, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI238"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(11), "minute" - i(14), "station" - s("shell"), "fill-ups" - i(24), "record history (days)" - i(139), "weekdays" - i(21), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(149), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(70, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6028DA"), "year" - i(2005), "month" - i(1), "day" - i(14), "hour" - i(22), "minute" - i(0), "station" - s("amoco"), "fill-ups" - i(9), "record history (days)" - i(129), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(149), "standard deviation from mean" - i(399), "different locations" - i(4), "preferred station" - s("amoco"), "preferred station %" - i(44), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("77VM"), "preferred pump %" - i(11)])).
car(71, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0TNI109"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(18), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(51), "record history (days)" - i(148), "weekdays" - i(34), "weekends" - i(17), "preferred day" - s("thursday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(1), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(64), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(19)])).
car(72, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0WNI309"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(19), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(148), "weekdays" - i(18), "weekends" - i(4), "preferred day" - s("monday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(59), "standard deviation from mean" - i(259), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(27)])).
car(73, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2117OJM"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(13), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(25), "weekdays" - i(6), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(220), "standard deviation from mean" - i(450), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(33)])).
car(74, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7JNI640"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(12), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(14), "record history (days)" - i(34), "weekdays" - i(12), "weekends" - i(2), "preferred day" - s("monday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(190), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(78), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(35)])).
car(75, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5650RII"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(14), "minute" - i(17), "station" - s("shell"), "fill-ups" - i(11), "record history (days)" - i(125), "weekdays" - i(8), "weekends" - i(3), "preferred day" - s("friday"), "day preference %" - i(45), "mean time of visit (minutes after midnight)" - i(86), "standard deviation from mean" - i(262), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(36)])).
car(76, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7SNI224"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(13), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(157), "weekdays" - i(8), "weekends" - i(5), "preferred day" - s("thursday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(104), "standard deviation from mean" - i(348), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(15), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(38)])).
car(77, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3560AII"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(16), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(141), "record history (days)" - i(171), "weekdays" - i(122), "weekends" - i(19), "preferred day" - s("friday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(47), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(31)])).
car(78, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5SNI658"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(17), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(45), "record history (days)" - i(155), "weekdays" - i(23), "weekends" - i(22), "preferred day" - s("sunday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(151), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(55)])).
car(79, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7XNI120"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(15), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(170), "weekdays" - i(18), "weekends" - i(7), "preferred day" - s("tuesday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(55), "standard deviation from mean" - i(262), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(72), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(16)])).
car(80, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8CNI601"), "year" - i(2005), "month" - i(1), "day" - i(27), "hour" - i(11), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(56), "record history (days)" - i(146), "weekdays" - i(49), "weekends" - i(7), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(20), "standard deviation from mean" - i(144), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(28)])).
car(81, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6CNI401"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(3), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(113), "record history (days)" - i(148), "weekdays" - i(79), "weekends" - i(34), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(12), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(38)])).
car(82, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7393EII"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(21), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(21), "weekdays" - i(4), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(214), "standard deviation from mean" - i(438), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(83, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3WNI865"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(23), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(89), "record history (days)" - i(147), "weekdays" - i(64), "weekends" - i(25), "preferred day" - s("thursday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(146), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(84, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI565"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(21), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(59), "record history (days)" - i(172), "weekdays" - i(39), "weekends" - i(20), "preferred day" - s("thursday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(171), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(42)])).
car(85, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0YNI375"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(0), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(36), "record history (days)" - i(139), "weekdays" - i(29), "weekends" - i(7), "preferred day" - s("tuesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(21), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(41)])).
car(86, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0YNI795"), "year" - i(2005), "month" - i(1), "day" - i(16), "hour" - i(13), "minute" - i(11), "station" - s("shell"), "fill-ups" - i(122), "record history (days)" - i(148), "weekdays" - i(100), "weekends" - i(22), "preferred day" - s("friday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(59), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(66)])).
car(87, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI395"), "year" - i(2004), "month" - i(11), "day" - i(22), "hour" - i(23), "minute" - i(56), "station" - s("mobil"), "fill-ups" - i(38), "record history (days)" - i(147), "weekdays" - i(27), "weekends" - i(11), "preferred day" - s("thursday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(4), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(23)])).
car(88, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9691WII"), "year" - i(2004), "month" - i(12), "day" - i(31), "hour" - i(22), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(102), "weekdays" - i(3), "weekends" - i(10), "preferred day" - s("saturday"), "day preference %" - i(46), "mean time of visit (minutes after midnight)" - i(91), "standard deviation from mean" - i(303), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(69), "% pay cashier (instead of at pump)" - i(15), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(38)])).
car(89, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI505"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(7), "minute" - i(19), "station" - s("mobil"), "fill-ups" - i(33), "record history (days)" - i(144), "weekdays" - i(14), "weekends" - i(19), "preferred day" - s("saturday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(77), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(42)])).
car(90, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("13719AH"), "year" - i(2004), "month" - i(9), "day" - i(17), "hour" - i(18), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(113), "weekdays" - i(12), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(38), "mean time of visit (minutes after midnight)" - i(72), "standard deviation from mean" - i(240), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(23), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(61)])).
car(91, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("59789AH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(16), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(69), "record history (days)" - i(165), "weekdays" - i(40), "weekends" - i(29), "preferred day" - s("saturday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(148), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(33)])).
car(92, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0227YHI"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(11), "minute" - i(19), "station" - s("shell"), "fill-ups" - i(45), "record history (days)" - i(172), "weekdays" - i(42), "weekends" - i(3), "preferred day" - s("monday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(127), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(31)])).
car(93, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI735"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(10), "minute" - i(20), "station" - s("mobil"), "fill-ups" - i(59), "record history (days)" - i(165), "weekdays" - i(54), "weekends" - i(5), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(167), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(94, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3BNI074"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(10), "minute" - i(14), "station" - s("shell"), "fill-ups" - i(71), "record history (days)" - i(150), "weekdays" - i(66), "weekends" - i(5), "preferred day" - s("friday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(158), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(25)])).
car(95, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8999VHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(19), "minute" - i(5), "station" - s("shell"), "fill-ups" - i(32), "record history (days)" - i(172), "weekdays" - i(31), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(40), "standard deviation from mean" - i(217), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(34)])).
car(96, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3301VHI"), "year" - i(2005), "month" - i(1), "day" - i(17), "hour" - i(14), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(141), "weekdays" - i(3), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(199), "standard deviation from mean" - i(300), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(25)])).
car(97, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6176YHI"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(14), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(32), "record history (days)" - i(161), "weekdays" - i(23), "weekends" - i(9), "preferred day" - s("thursday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(46), "standard deviation from mean" - i(248), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(21)])).
car(98, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2286YHI"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(30), "station" - s("shell"), "fill-ups" - i(65), "record history (days)" - i(148), "weekdays" - i(54), "weekends" - i(11), "preferred day" - s("wednesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(76), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(21)])).
car(99, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1442AHI"), "year" - i(2004), "month" - i(9), "day" - i(29), "hour" - i(11), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(30), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(354), "standard deviation from mean" - i(409), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(66)])).
car(100, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0113BHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(17), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(43), "record history (days)" - i(149), "weekdays" - i(30), "weekends" - i(13), "preferred day" - s("saturday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(158), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(23)])).
car(101, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5913BHI"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(14), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(146), "weekdays" - i(22), "weekends" - i(4), "preferred day" - s("wednesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(45), "standard deviation from mean" - i(222), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(23)])).
car(102, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4323BHI"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(16), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(145), "weekdays" - i(22), "weekends" - i(7), "preferred day" - s("thursday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(32), "standard deviation from mean" - i(167), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(31)])).
car(103, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8549CHI"), "year" - i(2004), "month" - i(10), "day" - i(24), "hour" - i(11), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(1), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(486), "standard deviation from mean" - i(344), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(66)])).
car(104, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6044CHI"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(10), "minute" - i(36), "station" - s("shell"), "fill-ups" - i(20), "record history (days)" - i(144), "weekdays" - i(13), "weekends" - i(7), "preferred day" - s("monday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(231), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(20)])).
car(105, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3279EHI"), "year" - i(2004), "month" - i(12), "day" - i(15), "hour" - i(17), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(8), "record history (days)" - i(81), "weekdays" - i(4), "weekends" - i(4), "preferred day" - s("saturday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(99), "standard deviation from mean" - i(247), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(106, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9261EHI"), "year" - i(2005), "month" - i(1), "day" - i(1), "hour" - i(0), "minute" - i(23), "station" - s("mobil"), "fill-ups" - i(10), "record history (days)" - i(131), "weekdays" - i(3), "weekends" - i(7), "preferred day" - s("sunday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(114), "standard deviation from mean" - i(305), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(40)])).
car(107, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7986EHI"), "year" - i(2004), "month" - i(11), "day" - i(12), "hour" - i(17), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(63), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(461), "standard deviation from mean" - i(327), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(108, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4119HHI"), "year" - i(2004), "month" - i(11), "day" - i(7), "hour" - i(19), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(18), "record history (days)" - i(149), "weekdays" - i(6), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(61), "mean time of visit (minutes after midnight)" - i(74), "standard deviation from mean" - i(289), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(72)])).
car(109, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9126HHI"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(16), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(28), "record history (days)" - i(166), "weekdays" - i(15), "weekends" - i(13), "preferred day" - s("saturday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(46), "standard deviation from mean" - i(231), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(89), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(25)])).
car(110, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6646HHI"), "year" - i(2004), "month" - i(11), "day" - i(20), "hour" - i(1), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(148), "weekdays" - i(4), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(9), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(16)])).
car(111, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1156HHI"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(11), "minute" - i(59), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(146), "weekdays" - i(14), "weekends" - i(10), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(58), "standard deviation from mean" - i(267), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(37)])).
car(112, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3856HHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(18), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(170), "weekdays" - i(15), "weekends" - i(9), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(58), "standard deviation from mean" - i(270), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(45)])).
car(113, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5266HHI"), "year" - i(2005), "month" - i(1), "day" - i(31), "hour" - i(8), "minute" - i(17), "station" - s("shell"), "fill-ups" - i(23), "record history (days)" - i(147), "weekdays" - i(16), "weekends" - i(7), "preferred day" - s("tuesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(51), "standard deviation from mean" - i(236), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(65), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(26)])).
car(114, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7366HHI"), "year" - i(2005), "month" - i(1), "day" - i(15), "hour" - i(18), "minute" - i(42), "station" - s("shell"), "fill-ups" - i(103), "record history (days)" - i(148), "weekdays" - i(85), "weekends" - i(18), "preferred day" - s("friday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(89), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(32)])).
car(115, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8666HHI"), "year" - i(2005), "month" - i(2), "day" - i(17), "hour" - i(10), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(147), "weekdays" - i(19), "weekends" - i(10), "preferred day" - s("thursday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(37), "standard deviation from mean" - i(184), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(27)])).
car(116, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5186HHI"), "year" - i(2005), "month" - i(2), "day" - i(24), "hour" - i(10), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(71), "record history (days)" - i(161), "weekdays" - i(56), "weekends" - i(15), "preferred day" - s("tuesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(107), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(56), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(15)])).
car(117, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6286HHI"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(21), "minute" - i(52), "station" - s("shell"), "fill-ups" - i(81), "record history (days)" - i(146), "weekdays" - i(52), "weekends" - i(29), "preferred day" - s("sunday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(17), "standard deviation from mean" - i(152), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(22)])).
car(118, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7017HHI"), "year" - i(2005), "month" - i(1), "day" - i(17), "hour" - i(18), "minute" - i(26), "station" - s("mobil"), "fill-ups" - i(40), "record history (days)" - i(146), "weekdays" - i(32), "weekends" - i(8), "preferred day" - s("thursday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(191), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(22)])).
car(119, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0293MHI"), "year" - i(2005), "month" - i(1), "day" - i(22), "hour" - i(22), "minute" - i(27), "station" - s("shell"), "fill-ups" - i(8), "record history (days)" - i(141), "weekdays" - i(4), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(172), "standard deviation from mean" - i(428), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(25)])).
car(120, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6437MHI"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(20), "minute" - i(37), "station" - s("shell"), "fill-ups" - i(8), "record history (days)" - i(161), "weekdays" - i(3), "weekends" - i(5), "preferred day" - s("saturday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(118), "standard deviation from mean" - i(294), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(37)])).
car(121, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7593NHI"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(13), "minute" - i(25), "station" - s("shell"), "fill-ups" - i(9), "record history (days)" - i(146), "weekdays" - i(5), "weekends" - i(4), "preferred day" - s("friday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(90), "standard deviation from mean" - i(241), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(33)])).
car(122, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6760OHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(14), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(85), "record history (days)" - i(148), "weekdays" - i(60), "weekends" - i(25), "preferred day" - s("tuesday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(9), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(89), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(29)])).
car(123, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5376OHI"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(20), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(23), "record history (days)" - i(158), "weekdays" - i(22), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(39), "mean time of visit (minutes after midnight)" - i(46), "standard deviation from mean" - i(215), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(30)])).
car(124, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6614PII"), "year" - i(2004), "month" - i(5), "day" - i(14), "hour" - i(15), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(30), "weekdays" - i(6), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(168), "standard deviation from mean" - i(382), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(42)])).
car(125, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8661QII"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(22), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(17), "record history (days)" - i(125), "weekdays" - i(10), "weekends" - i(7), "preferred day" - s("friday"), "day preference %" - i(35), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(26), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(29)])).
car(126, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3901RII"), "year" - i(2005), "month" - i(2), "day" - i(8), "hour" - i(17), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(140), "weekdays" - i(9), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(117), "standard deviation from mean" - i(335), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(45)])).
car(127, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9727RII"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(18), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(160), "weekdays" - i(13), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(26), "standard deviation from mean" - i(125), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(36)])).
car(128, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7879TII"), "year" - i(2004), "month" - i(7), "day" - i(10), "hour" - i(0), "minute" - i(23), "station" - s("mobil"), "fill-ups" - i(14), "record history (days)" - i(123), "weekdays" - i(11), "weekends" - i(3), "preferred day" - s("friday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(10), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(28)])).
car(129, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4780UII"), "year" - i(2005), "month" - i(2), "day" - i(22), "hour" - i(20), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(153), "weekdays" - i(11), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(38), "mean time of visit (minutes after midnight)" - i(53), "standard deviation from mean" - i(179), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(38)])).
car(130, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1563UII"), "year" - i(2004), "month" - i(12), "day" - i(27), "hour" - i(19), "minute" - i(26), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(97), "weekdays" - i(5), "weekends" - i(2), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(128), "standard deviation from mean" - i(291), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(28)])).
car(131, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4091VII"), "year" - i(2004), "month" - i(12), "day" - i(13), "hour" - i(12), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(131), "weekdays" - i(6), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(97), "standard deviation from mean" - i(278), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(25)])).
car(132, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4076VII"), "year" - i(2004), "month" - i(12), "day" - i(16), "hour" - i(15), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(142), "weekdays" - i(15), "weekends" - i(9), "preferred day" - s("friday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(41), "standard deviation from mean" - i(189), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(29)])).
car(133, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8197VII"), "year" - i(2004), "month" - i(5), "day" - i(29), "hour" - i(19), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(84), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(386), "standard deviation from mean" - i(446), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(66), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(134, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9293WII"), "year" - i(2004), "month" - i(12), "day" - i(21), "hour" - i(4), "minute" - i(40), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(92), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("wednesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(57), "standard deviation from mean" - i(66), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(66)])).
car(135, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7TNI968"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(20), "minute" - i(33), "station" - s("shell"), "fill-ups" - i(81), "record history (days)" - i(160), "weekdays" - i(76), "weekends" - i(5), "preferred day" - s("tuesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(136), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(24)])).
car(136, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI568"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(15), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(18), "record history (days)" - i(164), "weekdays" - i(11), "weekends" - i(7), "preferred day" - s("saturday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(77), "standard deviation from mean" - i(311), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(22)])).
car(137, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0DNI568"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(23), "minute" - i(15), "station" - s("mobil"), "fill-ups" - i(46), "record history (days)" - i(158), "weekdays" - i(35), "weekends" - i(11), "preferred day" - s("friday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(8), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(23)])).
car(138, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4CNI491"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(10), "minute" - i(18), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(145), "weekdays" - i(14), "weekends" - i(5), "preferred day" - s("friday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(75), "standard deviation from mean" - i(303), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(36)])).
car(139, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0TNI101"), "year" - i(2004), "month" - i(11), "day" - i(19), "hour" - i(21), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(137), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(400), "standard deviation from mean" - i(462), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(140, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI625"), "year" - i(2004), "month" - i(8), "day" - i(2), "hour" - i(20), "minute" - i(36), "station" - s("shell"), "fill-ups" - i(4), "record history (days)" - i(129), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("friday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(336), "standard deviation from mean" - i(505), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(50)])).
car(141, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0944CPO"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(16), "minute" - i(28), "station" - s("shell"), "fill-ups" - i(34), "record history (days)" - i(168), "weekdays" - i(23), "weekends" - i(11), "preferred day" - s("friday"), "day preference %" - i(35), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(134), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(14)])).
car(142, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ENI032"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(15), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(16), "record history (days)" - i(143), "weekdays" - i(11), "weekends" - i(5), "preferred day" - s("thursday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(57), "standard deviation from mean" - i(209), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(62)])).
car(143, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7SNI587"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(10), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(147), "weekdays" - i(23), "weekends" - i(6), "preferred day" - s("tuesday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(44), "standard deviation from mean" - i(230), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(24)])).
car(144, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2665VII"), "year" - i(2004), "month" - i(7), "day" - i(19), "hour" - i(23), "minute" - i(56), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(75), "weekdays" - i(16), "weekends" - i(4), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(41), "standard deviation from mean" - i(176), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(40)])).
car(145, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9DNI553"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(13), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(78), "record history (days)" - i(147), "weekdays" - i(58), "weekends" - i(20), "preferred day" - s("wednesday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(113), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(98)])).
car(146, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("81436BH"), "year" - i(2004), "month" - i(12), "day" - i(31), "hour" - i(10), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(105), "weekdays" - i(3), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(226), "standard deviation from mean" - i(339), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(75)])).
car(147, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6DNI126"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(16), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(27), "record history (days)" - i(159), "weekdays" - i(23), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(50), "standard deviation from mean" - i(242), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(37)])).
car(148, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI914"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(19), "minute" - i(31), "station" - s("7-Eleven"), "fill-ups" - i(26), "record history (days)" - i(161), "weekdays" - i(17), "weekends" - i(9), "preferred day" - s("monday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(141), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(15)])).
car(149, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("86317DH"), "year" - i(2005), "month" - i(1), "day" - i(6), "hour" - i(14), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(33), "record history (days)" - i(142), "weekdays" - i(25), "weekends" - i(8), "preferred day" - s("wednesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(133), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(27)])).
car(150, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4294LJM"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(11), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(108), "record history (days)" - i(167), "weekdays" - i(91), "weekends" - i(17), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(67), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(23)])).
car(151, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2XNI386"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(10), "minute" - i(25), "station" - s("shell"), "fill-ups" - i(33), "record history (days)" - i(162), "weekdays" - i(27), "weekends" - i(6), "preferred day" - s("monday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(137), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(72)])).
car(152, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5VNI741"), "year" - i(2005), "month" - i(1), "day" - i(31), "hour" - i(22), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(145), "weekdays" - i(6), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(164), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(27)])).
car(153, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3VNI941"), "year" - i(2005), "month" - i(1), "day" - i(19), "hour" - i(9), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(79), "record history (days)" - i(147), "weekdays" - i(60), "weekends" - i(19), "preferred day" - s("wednesday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(80), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(20)])).
car(154, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6VNI241"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(10), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(17), "record history (days)" - i(168), "weekdays" - i(7), "weekends" - i(10), "preferred day" - s("sunday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(95), "standard deviation from mean" - i(347), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(35)])).
car(155, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1565WII"), "year" - i(2004), "month" - i(12), "day" - i(1), "hour" - i(10), "minute" - i(18), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(125), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(301), "standard deviation from mean" - i(348), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(66)])).
car(156, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2203YII"), "year" - i(2005), "month" - i(2), "day" - i(8), "hour" - i(15), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(138), "weekdays" - i(8), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(60), "standard deviation from mean" - i(173), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(36)])).
car(157, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8623YII"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(16), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(48), "record history (days)" - i(166), "weekdays" - i(37), "weekends" - i(11), "preferred day" - s("friday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(132), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(27)])).
car(158, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7506YII"), "year" - i(2005), "month" - i(2), "day" - i(11), "hour" - i(21), "minute" - i(45), "station" - s("shell"), "fill-ups" - i(7), "record history (days)" - i(127), "weekdays" - i(4), "weekends" - i(3), "preferred day" - s("friday"), "day preference %" - i(57), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(24), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(28)])).
car(159, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9416YII"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(14), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(42), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(452), "standard deviation from mean" - i(320), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(50)])).
car(160, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6791AII"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(17), "minute" - i(7), "station" - s("shell"), "fill-ups" - i(36), "record history (days)" - i(132), "weekdays" - i(26), "weekends" - i(10), "preferred day" - s("monday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(21), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(55), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(19)])).
car(161, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0195AII"), "year" - i(2005), "month" - i(1), "day" - i(25), "hour" - i(14), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(130), "weekdays" - i(10), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(117), "standard deviation from mean" - i(355), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(54), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(27)])).
car(162, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9805AII"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(0), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(154), "weekdays" - i(5), "weekends" - i(7), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(21), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(163, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4946III"), "year" - i(2005), "month" - i(2), "day" - i(19), "hour" - i(20), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(6), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(380), "standard deviation from mean" - i(269), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(100)])).
car(164, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ENI357"), "year" - i(2005), "month" - i(1), "day" - i(19), "hour" - i(21), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(140), "weekdays" - i(12), "weekends" - i(8), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(52), "standard deviation from mean" - i(208), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(35)])).
car(165, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7TNI900"), "year" - i(2005), "month" - i(1), "day" - i(26), "hour" - i(10), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(148), "weekdays" - i(21), "weekends" - i(4), "preferred day" - s("friday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(27), "standard deviation from mean" - i(130), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(64)])).
car(166, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ZNI000"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(4), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(69), "record history (days)" - i(148), "weekdays" - i(54), "weekends" - i(15), "preferred day" - s("thursday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(74), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(30)])).
car(167, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2TNI100"), "year" - i(2005), "month" - i(2), "day" - i(8), "hour" - i(12), "minute" - i(23), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(144), "weekdays" - i(10), "weekends" - i(3), "preferred day" - s("monday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(116), "standard deviation from mean" - i(352), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(38)])).
car(168, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI200"), "year" - i(2005), "month" - i(1), "day" - i(13), "hour" - i(15), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(55), "record history (days)" - i(146), "weekdays" - i(48), "weekends" - i(7), "preferred day" - s("thursday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(20), "standard deviation from mean" - i(143), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(60)])).
car(169, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0WNI404"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(19), "minute" - i(25), "station" - s("shell"), "fill-ups" - i(19), "record history (days)" - i(140), "weekdays" - i(8), "weekends" - i(11), "preferred day" - s("saturday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(72), "standard deviation from mean" - i(298), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(26)])).
car(170, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI714"), "year" - i(2005), "month" - i(2), "day" - i(22), "hour" - i(11), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(38), "record history (days)" - i(152), "weekdays" - i(32), "weekends" - i(6), "preferred day" - s("friday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(130), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(47)])).
car(171, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2XNI614"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(9), "minute" - i(3), "station" - s("shell"), "fill-ups" - i(21), "record history (days)" - i(148), "weekdays" - i(16), "weekends" - i(5), "preferred day" - s("monday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(14), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(28)])).
car(172, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9YNI983"), "year" - i(2004), "month" - i(12), "day" - i(21), "hour" - i(8), "minute" - i(36), "station" - s("shell"), "fill-ups" - i(16), "record history (days)" - i(146), "weekdays" - i(5), "weekends" - i(11), "preferred day" - s("sunday"), "day preference %" - i(56), "mean time of visit (minutes after midnight)" - i(40), "standard deviation from mean" - i(152), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(43)])).
car(173, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6805NJM"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(13), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(165), "weekdays" - i(21), "weekends" - i(8), "preferred day" - s("monday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(18), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(34)])).
car(174, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI856"), "year" - i(2005), "month" - i(1), "day" - i(15), "hour" - i(13), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(15), "record history (days)" - i(91), "weekdays" - i(11), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(7), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(66)])).
car(175, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2TNI317"), "year" - i(2005), "month" - i(1), "day" - i(12), "hour" - i(13), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(39), "record history (days)" - i(145), "weekdays" - i(31), "weekends" - i(8), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(146), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(58), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(20)])).
car(176, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2395UII"), "year" - i(2005), "month" - i(1), "day" - i(15), "hour" - i(11), "minute" - i(13), "station" - s("shell"), "fill-ups" - i(2), "record history (days)" - i(26), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(394), "standard deviation from mean" - i(279), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(50)])).
car(177, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("66222AH"), "year" - i(2004), "month" - i(12), "day" - i(21), "hour" - i(19), "minute" - i(15), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(126), "weekdays" - i(2), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(181), "standard deviation from mean" - i(272), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(178, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2TNI815"), "year" - i(2005), "month" - i(1), "day" - i(28), "hour" - i(16), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(144), "weekdays" - i(12), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(98), "standard deviation from mean" - i(298), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(50)])).
car(179, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4DNI403"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(10), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(35), "record history (days)" - i(164), "weekdays" - i(31), "weekends" - i(4), "preferred day" - s("monday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(20), "standard deviation from mean" - i(114), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(20)])).
car(180, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5443RHI"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(21), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(53), "record history (days)" - i(148), "weekdays" - i(39), "weekends" - i(14), "preferred day" - s("thursday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(155), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(47)])).
car(181, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1081AHI"), "year" - i(2005), "month" - i(1), "day" - i(23), "hour" - i(14), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(112), "weekdays" - i(5), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(44), "mean time of visit (minutes after midnight)" - i(97), "standard deviation from mean" - i(261), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(44)])).
car(182, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7234RHI"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(1), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(119), "record history (days)" - i(149), "weekdays" - i(91), "weekends" - i(28), "preferred day" - s("saturday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(124), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(99), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(22)])).
car(183, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("VOQ1266"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(52), "record history (days)" - i(148), "weekdays" - i(38), "weekends" - i(14), "preferred day" - s("wednesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(10), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(53)])).
car(184, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7SNI876"), "year" - i(2004), "month" - i(10), "day" - i(13), "hour" - i(21), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(140), "weekdays" - i(11), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(104), "standard deviation from mean" - i(330), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(33)])).
car(185, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5VNI876"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(8), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(129), "record history (days)" - i(93), "weekdays" - i(92), "weekends" - i(37), "preferred day" - s("monday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(104), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(67), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(17)])).
car(186, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9CNI867"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(12), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(40), "record history (days)" - i(147), "weekdays" - i(23), "weekends" - i(17), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(34), "standard deviation from mean" - i(216), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(65), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(40)])).
car(187, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3VNI958"), "year" - i(2005), "month" - i(2), "day" - i(10), "hour" - i(18), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(33), "record history (days)" - i(147), "weekdays" - i(26), "weekends" - i(7), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(27), "standard deviation from mean" - i(148), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(24)])).
car(188, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0BNI962"), "year" - i(2004), "month" - i(11), "day" - i(11), "hour" - i(19), "minute" - i(46), "station" - s("shell"), "fill-ups" - i(19), "record history (days)" - i(148), "weekdays" - i(16), "weekends" - i(3), "preferred day" - s("monday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(11), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(26)])).
car(189, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ENI962"), "year" - i(2004), "month" - i(12), "day" - i(12), "hour" - i(21), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(23), "record history (days)" - i(113), "weekdays" - i(17), "weekends" - i(6), "preferred day" - s("friday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(44), "standard deviation from mean" - i(199), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(30)])).
car(190, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI162"), "year" - i(2005), "month" - i(2), "day" - i(3), "hour" - i(11), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(32), "record history (days)" - i(137), "weekdays" - i(25), "weekends" - i(7), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(125), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(34)])).
car(191, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("35582BH"), "year" - i(2004), "month" - i(12), "day" - i(15), "hour" - i(10), "minute" - i(17), "station" - s("mobil"), "fill-ups" - i(23), "record history (days)" - i(144), "weekdays" - i(23), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(39), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(140), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(21)])).
car(192, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3ZNI333"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(56), "station" - s("mobil"), "fill-ups" - i(76), "record history (days)" - i(171), "weekdays" - i(45), "weekends" - i(31), "preferred day" - s("sunday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(151), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(72)])).
car(193, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7ZNI403"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(8), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(23), "record history (days)" - i(158), "weekdays" - i(12), "weekends" - i(11), "preferred day" - s("sunday"), "day preference %" - i(39), "mean time of visit (minutes after midnight)" - i(37), "standard deviation from mean" - i(167), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(52)])).
car(194, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3WNI310"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(10), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(164), "weekdays" - i(6), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(72), "standard deviation from mean" - i(218), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(27)])).
car(195, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7871VJE"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(14), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(129), "weekdays" - i(10), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(10), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(27)])).
car(196, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI382"), "year" - i(2005), "month" - i(1), "day" - i(26), "hour" - i(7), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(138), "weekdays" - i(13), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(43), "standard deviation from mean" - i(137), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(76)])).
car(197, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8XNI277"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(16), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(166), "weekdays" - i(10), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(69), "standard deviation from mean" - i(210), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(25)])).
car(198, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI781"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(15), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(115), "record history (days)" - i(171), "weekdays" - i(85), "weekends" - i(30), "preferred day" - s("friday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(87), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(27)])).
car(199, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5VNI991"), "year" - i(2005), "month" - i(1), "day" - i(30), "hour" - i(10), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(145), "weekdays" - i(8), "weekends" - i(21), "preferred day" - s("sunday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(49), "standard deviation from mean" - i(253), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(55)])).
car(200, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7XNI159"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(15), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(162), "weekdays" - i(14), "weekends" - i(11), "preferred day" - s("thursday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(44), "standard deviation from mean" - i(202), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(36)])).
car(201, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("25350BH"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(9), "station" - s("shell"), "fill-ups" - i(112), "record history (days)" - i(149), "weekdays" - i(95), "weekends" - i(17), "preferred day" - s("wednesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(11), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(33)])).
car(202, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI384"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(17), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(158), "weekdays" - i(28), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(29), "standard deviation from mean" - i(146), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(31)])).
car(203, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2UUB140"), "year" - i(2004), "month" - i(5), "day" - i(28), "hour" - i(19), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(85), "weekdays" - i(10), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(97), "standard deviation from mean" - i(309), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(58)])).
car(204, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8XNI569"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(23), "minute" - i(45), "station" - s("mobil"), "fill-ups" - i(58), "record history (days)" - i(157), "weekdays" - i(53), "weekends" - i(5), "preferred day" - s("monday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(17), "standard deviation from mean" - i(125), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(31)])).
car(205, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0WNI399"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(13), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(35), "record history (days)" - i(169), "weekdays" - i(25), "weekends" - i(10), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(20), "standard deviation from mean" - i(115), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(20)])).
car(206, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("39434BH"), "year" - i(2005), "month" - i(1), "day" - i(19), "hour" - i(12), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(148), "weekdays" - i(28), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(39), "standard deviation from mean" - i(204), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(22)])).
car(207, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6XNI501"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(17), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(153), "weekdays" - i(20), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(61), "standard deviation from mean" - i(276), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(70)])).
car(208, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI690"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(13), "minute" - i(49), "station" - s("Cumberland Farms"), "fill-ups" - i(16), "record history (days)" - i(146), "weekdays" - i(9), "weekends" - i(7), "preferred day" - s("sunday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(66), "standard deviation from mean" - i(212), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(25)])).
car(209, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("13004AH"), "year" - i(2004), "month" - i(6), "day" - i(15), "hour" - i(13), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(20), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("friday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(23), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(25)])).
car(210, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI586"), "year" - i(2005), "month" - i(1), "day" - i(30), "hour" - i(16), "minute" - i(37), "station" - s("shell"), "fill-ups" - i(46), "record history (days)" - i(148), "weekdays" - i(35), "weekends" - i(11), "preferred day" - s("tuesday"), "day preference %" - i(34), "mean time of visit (minutes after midnight)" - i(26), "standard deviation from mean" - i(169), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(15)])).
car(211, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6072DA"), "year" - i(2005), "month" - i(2), "day" - i(24), "hour" - i(19), "minute" - i(38), "station" - s("bp"), "fill-ups" - i(8), "record history (days)" - i(130), "weekdays" - i(6), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(114), "standard deviation from mean" - i(282), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(62), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(50)])).
car(212, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1394DA"), "year" - i(2005), "month" - i(1), "day" - i(11), "hour" - i(14), "minute" - i(7), "station" - s("bp"), "fill-ups" - i(2), "record history (days)" - i(72), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(460), "standard deviation from mean" - i(325), "different locations" - i(2), "preferred station" - s("bp"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27VM"), "preferred pump %" - i(50)])).
car(213, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1605DA"), "year" - i(2004), "month" - i(11), "day" - i(18), "hour" - i(8), "minute" - i(56), "station" - s("amoco"), "fill-ups" - i(6), "record history (days)" - i(137), "weekdays" - i(4), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(125), "standard deviation from mean" - i(257), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(50)])).
car(214, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9JNI937"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(13), "minute" - i(19), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(32), "weekdays" - i(4), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(111), "standard deviation from mean" - i(200), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(60)])).
car(215, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6DNI895"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(15), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(114), "record history (days)" - i(146), "weekdays" - i(89), "weekends" - i(25), "preferred day" - s("monday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(109), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(42)])).
car(216, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5FNI201"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(19), "minute" - i(49), "station" - s("citgo"), "fill-ups" - i(37), "record history (days)" - i(151), "weekdays" - i(29), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(21), "standard deviation from mean" - i(126), "different locations" - i(3), "preferred station" - s("shell"), "preferred station %" - i(70), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(21)])).
car(217, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("59110DH"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(16), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(27), "record history (days)" - i(164), "weekdays" - i(25), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(59), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(257), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(55)])).
car(218, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4257SHI"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(20), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(135), "weekdays" - i(4), "weekends" - i(2), "preferred day" - s("monday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(130), "standard deviation from mean" - i(266), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(66)])).
car(219, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI964"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(14), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(53), "record history (days)" - i(160), "weekdays" - i(37), "weekends" - i(16), "preferred day" - s("tuesday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(136), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(33)])).
car(220, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6973RHI"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(22), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(158), "weekdays" - i(20), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(42), "standard deviation from mean" - i(214), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(24)])).
car(221, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI872"), "year" - i(2005), "month" - i(1), "day" - i(5), "hour" - i(7), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(36), "record history (days)" - i(146), "weekdays" - i(16), "weekends" - i(20), "preferred day" - s("saturday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(89), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(44)])).
car(222, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6915MJM"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(17), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(138), "weekdays" - i(15), "weekends" - i(11), "preferred day" - s("saturday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(33), "standard deviation from mean" - i(158), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(57)])).
car(223, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9175MJM"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(18), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(90), "record history (days)" - i(143), "weekdays" - i(75), "weekends" - i(15), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(106), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(34)])).
car(224, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4684NJM"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(19), "minute" - i(51), "station" - s("mobil"), "fill-ups" - i(54), "record history (days)" - i(171), "weekdays" - i(32), "weekends" - i(22), "preferred day" - s("saturday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(25), "standard deviation from mean" - i(184), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(70), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(225, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6VNI878"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(15), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(40), "record history (days)" - i(168), "weekdays" - i(23), "weekends" - i(17), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(101), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(52)])).
car(226, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9893VII"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(13), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(123), "weekdays" - i(0), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(126), "standard deviation from mean" - i(258), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(33)])).
car(227, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6346HHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(18), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(168), "record history (days)" - i(172), "weekdays" - i(123), "weekends" - i(45), "preferred day" - s("monday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(11), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(28)])).
car(228, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3982NHI"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(14), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(132), "weekdays" - i(5), "weekends" - i(8), "preferred day" - s("saturday"), "day preference %" - i(61), "mean time of visit (minutes after midnight)" - i(112), "standard deviation from mean" - i(338), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(69)])).
car(229, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2599DA"), "year" - i(2005), "month" - i(1), "day" - i(28), "hour" - i(13), "minute" - i(34), "station" - s("chevron"), "fill-ups" - i(4), "record history (days)" - i(21), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("friday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(183), "standard deviation from mean" - i(275), "different locations" - i(2), "preferred station" - s("chevron"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17YH"), "preferred pump %" - i(75)])).
car(230, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2586LUI"), "year" - i(2004), "month" - i(8), "day" - i(8), "hour" - i(0), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(7), "weekdays" - i(0), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(322), "standard deviation from mean" - i(484), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(50)])).
car(231, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1614LJM"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(17), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(138), "weekdays" - i(9), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(159), "standard deviation from mean" - i(425), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(44)])).
car(232, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8XNI362"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(6), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(30), "record history (days)" - i(120), "weekdays" - i(19), "weekends" - i(11), "preferred day" - s("sunday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(43), "standard deviation from mean" - i(229), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(33)])).
car(233, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3817HHI"), "year" - i(2005), "month" - i(2), "day" - i(11), "hour" - i(22), "minute" - i(33), "station" - s("shell"), "fill-ups" - i(30), "record history (days)" - i(147), "weekdays" - i(19), "weekends" - i(11), "preferred day" - s("saturday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(168), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(53)])).
car(234, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0064LJM"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(15), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(177), "weekdays" - i(10), "weekends" - i(16), "preferred day" - s("saturday"), "day preference %" - i(34), "mean time of visit (minutes after midnight)" - i(47), "standard deviation from mean" - i(234), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(34)])).
car(235, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8CNI504"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(12), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(54), "record history (days)" - i(148), "weekdays" - i(40), "weekends" - i(14), "preferred day" - s("thursday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(171), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(27)])).
car(236, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2WNI884"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(19), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(39), "record history (days)" - i(147), "weekdays" - i(23), "weekends" - i(16), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(8), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(25)])).
car(237, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7875DA"), "year" - i(2004), "month" - i(12), "day" - i(19), "hour" - i(11), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(123), "weekdays" - i(2), "weekends" - i(4), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(165), "standard deviation from mean" - i(338), "different locations" - i(4), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(33)])).
car(238, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8ENI866"), "year" - i(2005), "month" - i(1), "day" - i(29), "hour" - i(9), "minute" - i(51), "station" - s("mobil"), "fill-ups" - i(82), "record history (days)" - i(148), "weekdays" - i(59), "weekends" - i(23), "preferred day" - s("thursday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(3), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(60)])).
car(239, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7CNI528"), "year" - i(2004), "month" - i(12), "day" - i(10), "hour" - i(8), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(145), "weekdays" - i(25), "weekends" - i(6), "preferred day" - s("friday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(126), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(45)])).
car(240, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6ENI151"), "year" - i(2005), "month" - i(2), "day" - i(3), "hour" - i(14), "minute" - i(2), "station" - s("shell"), "fill-ups" - i(14), "record history (days)" - i(147), "weekdays" - i(9), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(99), "standard deviation from mean" - i(345), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(35)])).
car(241, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7TNI551"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(23), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(32), "record history (days)" - i(166), "weekdays" - i(19), "weekends" - i(13), "preferred day" - s("sunday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(154), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(242, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("91673AH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(11), "minute" - i(53), "station" - s("shell"), "fill-ups" - i(90), "record history (days)" - i(171), "weekdays" - i(79), "weekends" - i(11), "preferred day" - s("friday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(83), "different locations" - i(3), "preferred station" - s("shell"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(26)])).
car(243, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("73354AH"), "year" - i(2004), "month" - i(11), "day" - i(30), "hour" - i(10), "minute" - i(12), "station" - s("shell"), "fill-ups" - i(16), "record history (days)" - i(72), "weekdays" - i(16), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(43), "mean time of visit (minutes after midnight)" - i(61), "standard deviation from mean" - i(223), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(31)])).
car(244, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("63454AH"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(14), "minute" - i(1), "station" - s("shell"), "fill-ups" - i(2), "record history (days)" - i(19), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(488), "standard deviation from mean" - i(346), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(50)])).
car(245, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("04454AH"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(23), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(158), "weekdays" - i(14), "weekends" - i(5), "preferred day" - s("wednesday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(2), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(52), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(26)])).
car(246, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("82965AH"), "year" - i(2005), "month" - i(1), "day" - i(13), "hour" - i(22), "minute" - i(15), "station" - s("shell"), "fill-ups" - i(17), "record history (days)" - i(135), "weekdays" - i(14), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(47), "mean time of visit (minutes after midnight)" - i(62), "standard deviation from mean" - i(233), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(58), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(23)])).
car(247, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("75756AH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(23), "station" - s("mobil"), "fill-ups" - i(108), "record history (days)" - i(149), "weekdays" - i(89), "weekends" - i(19), "preferred day" - s("tuesday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(119), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(24)])).
car(248, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("15166AH"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(10), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(167), "weekdays" - i(15), "weekends" - i(9), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(26), "standard deviation from mean" - i(118), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(41)])).
car(249, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("41018BH"), "year" - i(2005), "month" - i(1), "day" - i(14), "hour" - i(13), "minute" - i(26), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(143), "weekdays" - i(1), "weekends" - i(5), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(34), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(250, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("68128BH"), "year" - i(2004), "month" - i(7), "day" - i(12), "hour" - i(19), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(79), "weekdays" - i(2), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(207), "standard deviation from mean" - i(311), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(251, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("52389BH"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(1), "station" - s("shell"), "fill-ups" - i(75), "record history (days)" - i(149), "weekdays" - i(51), "weekends" - i(24), "preferred day" - s("sunday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(116), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(24)])).
car(252, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("67300BH"), "year" - i(2004), "month" - i(12), "day" - i(2), "hour" - i(19), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(100), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(539), "standard deviation from mean" - i(381), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(50)])).
car(253, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("19020BH"), "year" - i(2005), "month" - i(1), "day" - i(22), "hour" - i(11), "minute" - i(17), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(131), "weekdays" - i(2), "weekends" - i(3), "preferred day" - s("saturday"), "day preference %" - i(60), "mean time of visit (minutes after midnight)" - i(255), "standard deviation from mean" - i(457), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(60)])).
car(254, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("66382BH"), "year" - i(2005), "month" - i(1), "day" - i(28), "hour" - i(11), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(60), "record history (days)" - i(147), "weekdays" - i(50), "weekends" - i(10), "preferred day" - s("friday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(100), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(86)])).
car(255, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("65812BH"), "year" - i(2004), "month" - i(9), "day" - i(30), "hour" - i(10), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(147), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(79), "standard deviation from mean" - i(212), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(55), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(256, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("91342BH"), "year" - i(2004), "month" - i(11), "day" - i(12), "hour" - i(20), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(34), "weekdays" - i(1), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(268), "standard deviation from mean" - i(481), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(40)])).
car(257, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("51983BH"), "year" - i(2004), "month" - i(10), "day" - i(30), "hour" - i(19), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(148), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(276), "standard deviation from mean" - i(319), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(66)])).
car(258, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("29203BH"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(11), "minute" - i(42), "station" - s("shell"), "fill-ups" - i(23), "record history (days)" - i(142), "weekdays" - i(16), "weekends" - i(7), "preferred day" - s("wednesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(51), "standard deviation from mean" - i(223), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(26)])).
car(259, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("99203BH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(13), "minute" - i(18), "station" - s("shell"), "fill-ups" - i(25), "record history (days)" - i(166), "weekdays" - i(20), "weekends" - i(5), "preferred day" - s("tuesday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(37), "standard deviation from mean" - i(171), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(44)])).
car(260, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("98323BH"), "year" - i(2005), "month" - i(1), "day" - i(25), "hour" - i(13), "minute" - i(11), "station" - s("shell"), "fill-ups" - i(10), "record history (days)" - i(144), "weekdays" - i(5), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(116), "standard deviation from mean" - i(331), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(30)])).
car(261, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("20523BH"), "year" - i(2004), "month" - i(10), "day" - i(14), "hour" - i(22), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(145), "weekdays" - i(6), "weekends" - i(13), "preferred day" - s("saturday"), "day preference %" - i(63), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(125), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(21)])).
car(262, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("42866BH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(159), "record history (days)" - i(149), "weekdays" - i(127), "weekends" - i(32), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(83), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(51), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(12)])).
car(263, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("58808DH"), "year" - i(2004), "month" - i(8), "day" - i(21), "hour" - i(14), "minute" - i(58), "station" - s("shell"), "fill-ups" - i(3), "record history (days)" - i(54), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(361), "standard deviation from mean" - i(418), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(33)])).
car(264, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("57519DH"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(11), "minute" - i(40), "station" - s("mobil"), "fill-ups" - i(43), "record history (days)" - i(147), "weekdays" - i(35), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(154), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(76), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(30)])).
car(265, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("55719DH"), "year" - i(2005), "month" - i(2), "day" - i(7), "hour" - i(11), "minute" - i(33), "station" - s("shell"), "fill-ups" - i(99), "record history (days)" - i(147), "weekdays" - i(78), "weekends" - i(21), "preferred day" - s("monday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(74), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(59), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(17)])).
car(266, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("12129DH"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(12), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(16), "record history (days)" - i(119), "weekdays" - i(5), "weekends" - i(11), "preferred day" - s("sunday"), "day preference %" - i(43), "mean time of visit (minutes after midnight)" - i(36), "standard deviation from mean" - i(132), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(43)])).
car(267, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("15159DH"), "year" - i(2005), "month" - i(2), "day" - i(19), "hour" - i(12), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(132), "weekdays" - i(0), "weekends" - i(5), "preferred day" - s("saturday"), "day preference %" - i(80), "mean time of visit (minutes after midnight)" - i(196), "standard deviation from mean" - i(352), "different locations" - i(3), "preferred station" - s("pilot"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27XG"), "preferred pump %" - i(40)])).
car(268, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("25169DH"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(14), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(84), "record history (days)" - i(166), "weekdays" - i(76), "weekends" - i(8), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(125), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(32)])).
car(269, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("91930DH"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(6), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(46), "weekdays" - i(3), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(60), "mean time of visit (minutes after midnight)" - i(195), "standard deviation from mean" - i(351), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(40)])).
car(270, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI616"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(12), "minute" - i(23), "station" - s("shell"), "fill-ups" - i(39), "record history (days)" - i(163), "weekdays" - i(28), "weekends" - i(11), "preferred day" - s("friday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(27), "standard deviation from mean" - i(162), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(76), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(20)])).
car(271, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8ENI726"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(16), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(37), "record history (days)" - i(123), "weekdays" - i(29), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(30), "standard deviation from mean" - i(177), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(27)])).
car(272, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4VNI798"), "year" - i(2005), "month" - i(1), "day" - i(23), "hour" - i(18), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(103), "weekdays" - i(6), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(102), "standard deviation from mean" - i(232), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(33)])).
car(273, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1556ZII"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(55), "station" - s("shell"), "fill-ups" - i(28), "record history (days)" - i(148), "weekdays" - i(20), "weekends" - i(8), "preferred day" - s("thursday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(35), "standard deviation from mean" - i(181), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(25)])).
car(274, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2KPD746"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(13), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(109), "record history (days)" - i(168), "weekdays" - i(80), "weekends" - i(29), "preferred day" - s("tuesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(58), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(22)])).
car(275, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5796HHI"), "year" - i(2005), "month" - i(2), "day" - i(13), "hour" - i(22), "minute" - i(31), "station" - s("Cumberland Farms"), "fill-ups" - i(27), "record history (days)" - i(150), "weekdays" - i(21), "weekends" - i(6), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(51), "standard deviation from mean" - i(240), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(22)])).
car(276, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("AF585"), "year" - i(2005), "month" - i(1), "day" - i(29), "hour" - i(18), "minute" - i(0), "station" - s("shell"), "fill-ups" - i(120), "record history (days)" - i(148), "weekdays" - i(105), "weekends" - i(15), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(76), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(59), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(20)])).
car(277, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI096"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(13), "minute" - i(7), "station" - s("shell"), "fill-ups" - i(62), "record history (days)" - i(164), "weekdays" - i(49), "weekends" - i(13), "preferred day" - s("thursday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(117), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(79), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(27)])).
car(278, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4576YHI"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(19), "minute" - i(17), "station" - s("mobil"), "fill-ups" - i(35), "record history (days)" - i(159), "weekdays" - i(15), "weekends" - i(20), "preferred day" - s("sunday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(38), "standard deviation from mean" - i(220), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(37)])).
car(279, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5032QHI"), "year" - i(2004), "month" - i(4), "day" - i(6), "hour" - i(22), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(32), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("friday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(447), "standard deviation from mean" - i(517), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(66)])).
car(280, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8556WII"), "year" - i(2004), "month" - i(12), "day" - i(22), "hour" - i(0), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(99), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(561), "standard deviation from mean" - i(397), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(281, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5732AHI"), "year" - i(2005), "month" - i(1), "day" - i(18), "hour" - i(18), "minute" - i(20), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(123), "weekdays" - i(2), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(234), "standard deviation from mean" - i(420), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(40)])).
car(282, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1676DA"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(0), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(134), "weekdays" - i(13), "weekends" - i(6), "preferred day" - s("saturday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(48), "standard deviation from mean" - i(198), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(52), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(36)])).
car(283, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("63819AH"), "year" - i(2005), "month" - i(1), "day" - i(15), "hour" - i(11), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(34), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(567), "standard deviation from mean" - i(401), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(50)])).
car(284, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("80709AH"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(23), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(148), "weekdays" - i(18), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(48), "standard deviation from mean" - i(227), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(65)])).
car(285, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7367MHI"), "year" - i(2005), "month" - i(2), "day" - i(7), "hour" - i(17), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(148), "weekdays" - i(22), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(42), "standard deviation from mean" - i(231), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(35)])).
car(286, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0DNI369"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(11), "minute" - i(8), "station" - s("shell"), "fill-ups" - i(23), "record history (days)" - i(162), "weekdays" - i(18), "weekends" - i(5), "preferred day" - s("wednesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(110), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(52), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(26)])).
car(287, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7TNI469"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(10), "minute" - i(23), "station" - s("shell"), "fill-ups" - i(19), "record history (days)" - i(148), "weekdays" - i(17), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(40), "standard deviation from mean" - i(169), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(21)])).
car(288, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5FNI669"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(1), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(44), "record history (days)" - i(151), "weekdays" - i(35), "weekends" - i(9), "preferred day" - s("tuesday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(4), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(29)])).
car(289, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI450"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(19), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(144), "weekdays" - i(14), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(34), "mean time of visit (minutes after midnight)" - i(55), "standard deviation from mean" - i(260), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(69)])).
car(290, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("56567HQ"), "year" - i(2004), "month" - i(3), "day" - i(17), "hour" - i(18), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(13), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(258), "standard deviation from mean" - i(299), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(291, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("61866HQ"), "year" - i(2005), "month" - i(2), "day" - i(3), "hour" - i(14), "minute" - i(55), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(117), "weekdays" - i(9), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(133), "standard deviation from mean" - i(356), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(55), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(292, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8XNI371"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(16), "minute" - i(40), "station" - s("shell"), "fill-ups" - i(4), "record history (days)" - i(141), "weekdays" - i(1), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(348), "standard deviation from mean" - i(522), "different locations" - i(1), "preferred station" - s("shell"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(50)])).
car(293, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8ZNI729"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(17), "minute" - i(0), "station" - s("mobil"), "fill-ups" - i(35), "record history (days)" - i(146), "weekdays" - i(29), "weekends" - i(6), "preferred day" - s("tuesday"), "day preference %" - i(34), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(179), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(22)])).
car(294, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI969"), "year" - i(2005), "month" - i(1), "day" - i(18), "hour" - i(17), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(121), "weekdays" - i(8), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(91), "standard deviation from mean" - i(243), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(33)])).
car(295, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8FNI134"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(13), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(28), "record history (days)" - i(117), "weekdays" - i(20), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(160), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(25)])).
car(296, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9DNI864"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(14), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(14), "record history (days)" - i(149), "weekdays" - i(10), "weekends" - i(4), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(108), "standard deviation from mean" - i(361), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(15), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(28)])).
car(297, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6SNI503"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(12), "minute" - i(51), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(141), "weekdays" - i(14), "weekends" - i(6), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(75), "standard deviation from mean" - i(304), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(30)])).
car(298, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5JNI774"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(42), "weekdays" - i(15), "weekends" - i(5), "preferred day" - s("monday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(53), "standard deviation from mean" - i(226), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(35)])).
car(299, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0YNI639"), "year" - i(2005), "month" - i(2), "day" - i(17), "hour" - i(19), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(79), "record history (days)" - i(132), "weekdays" - i(67), "weekends" - i(12), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(114), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(29)])).
car(300, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8CNI849"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(20), "minute" - i(24), "station" - s("shell"), "fill-ups" - i(22), "record history (days)" - i(146), "weekdays" - i(12), "weekends" - i(10), "preferred day" - s("saturday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(60), "standard deviation from mean" - i(264), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(27)])).
car(301, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8CNI149"), "year" - i(2005), "month" - i(2), "day" - i(13), "hour" - i(18), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(144), "weekdays" - i(5), "weekends" - i(20), "preferred day" - s("saturday"), "day preference %" - i(48), "mean time of visit (minutes after midnight)" - i(49), "standard deviation from mean" - i(237), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(20)])).
car(302, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3UNI549"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(17), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(178), "weekdays" - i(25), "weekends" - i(4), "preferred day" - s("wednesday"), "day preference %" - i(34), "mean time of visit (minutes after midnight)" - i(44), "standard deviation from mean" - i(219), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(27)])).
car(303, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2UNI022"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(17), "minute" - i(55), "station" - s("shell"), "fill-ups" - i(8), "record history (days)" - i(96), "weekdays" - i(6), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(177), "standard deviation from mean" - i(438), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(62), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(37)])).
car(304, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0DNI022"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(19), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(30), "record history (days)" - i(148), "weekdays" - i(17), "weekends" - i(13), "preferred day" - s("sunday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(9), "different locations" - i(4), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(43)])).
car(305, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8ENI136"), "year" - i(2004), "month" - i(11), "day" - i(25), "hour" - i(13), "minute" - i(19), "station" - s("sheetz"), "fill-ups" - i(14), "record history (days)" - i(143), "weekdays" - i(9), "weekends" - i(5), "preferred day" - s("thursday"), "day preference %" - i(42), "mean time of visit (minutes after midnight)" - i(98), "standard deviation from mean" - i(342), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(78), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(21)])).
car(306, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5260AII"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(12), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(17), "record history (days)" - i(136), "weekdays" - i(14), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(63), "standard deviation from mean" - i(248), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(47)])).
car(307, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("12229DH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(26), "station" - s("mobil"), "fill-ups" - i(153), "record history (days)" - i(148), "weekdays" - i(120), "weekends" - i(33), "preferred day" - s("tuesday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(112), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(22)])).
car(308, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7295NJM"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(11), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(146), "weekdays" - i(18), "weekends" - i(6), "preferred day" - s("saturday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(39), "standard deviation from mean" - i(186), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(309, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9TNI044"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(10), "minute" - i(52), "station" - s("shell"), "fill-ups" - i(82), "record history (days)" - i(173), "weekdays" - i(73), "weekends" - i(9), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(124), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(15)])).
car(310, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI002"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(16), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(168), "weekdays" - i(18), "weekends" - i(4), "preferred day" - s("friday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(34), "standard deviation from mean" - i(153), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(40)])).
car(311, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3TNI917"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(8), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(98), "record history (days)" - i(165), "weekdays" - i(91), "weekends" - i(7), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(72), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(28)])).
car(312, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("77456BH"), "year" - i(2004), "month" - i(10), "day" - i(27), "hour" - i(13), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(30), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(294), "standard deviation from mean" - i(339), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(313, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0DNI195"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(34), "record history (days)" - i(171), "weekdays" - i(18), "weekends" - i(16), "preferred day" - s("sunday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(26), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(52), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(20)])).
car(314, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1337YHI"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(14), "minute" - i(49), "station" - s("shell"), "fill-ups" - i(83), "record history (days)" - i(165), "weekdays" - i(64), "weekends" - i(19), "preferred day" - s("thursday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(99), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(62), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(14)])).
car(315, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7034LJM"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(13), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(74), "weekdays" - i(3), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(118), "standard deviation from mean" - i(241), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(50)])).
car(316, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI317"), "year" - i(2004), "month" - i(11), "day" - i(29), "hour" - i(12), "minute" - i(20), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(147), "weekdays" - i(4), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(110), "standard deviation from mean" - i(250), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(71)])).
car(317, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5FNI834"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(12), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(47), "record history (days)" - i(162), "weekdays" - i(28), "weekends" - i(19), "preferred day" - s("saturday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(32), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(21)])).
car(318, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("46963DH"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(22), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(33), "weekdays" - i(4), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(188), "standard deviation from mean" - i(427), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(57)])).
car(319, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4CNI591"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(17), "station" - s("shell"), "fill-ups" - i(45), "record history (days)" - i(171), "weekdays" - i(35), "weekends" - i(10), "preferred day" - s("monday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(3), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(77), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(28)])).
car(320, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5FNI163"), "year" - i(2005), "month" - i(2), "day" - i(16), "hour" - i(11), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(143), "weekdays" - i(8), "weekends" - i(11), "preferred day" - s("sunday"), "day preference %" - i(52), "mean time of visit (minutes after midnight)" - i(12), "standard deviation from mean" - i(50), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(31)])).
car(321, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6573RHI"), "year" - i(2004), "month" - i(8), "day" - i(29), "hour" - i(20), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(147), "record history (days)" - i(123), "weekdays" - i(84), "weekends" - i(63), "preferred day" - s("sunday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(56), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(54), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(15)])).
car(322, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5359III"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(15), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(22), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(663), "standard deviation from mean" - i(469), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(100)])).
car(323, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI111"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(9), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(101), "record history (days)" - i(170), "weekdays" - i(79), "weekends" - i(22), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(102), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(23)])).
car(324, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7XNI311"), "year" - i(2004), "month" - i(8), "day" - i(1), "hour" - i(1), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(67), "record history (days)" - i(133), "weekdays" - i(48), "weekends" - i(19), "preferred day" - s("sunday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(75), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(52), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(29)])).
car(325, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0TNI107"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(23), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(57), "record history (days)" - i(148), "weekdays" - i(47), "weekends" - i(10), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(169), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(40)])).
car(326, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1093DA"), "year" - i(2004), "month" - i(10), "day" - i(7), "hour" - i(12), "minute" - i(37), "station" - s("citgo"), "fill-ups" - i(13), "record history (days)" - i(150), "weekdays" - i(9), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(69), "standard deviation from mean" - i(231), "different locations" - i(4), "preferred station" - s("mobil"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(15)])).
car(327, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI408"), "year" - i(2005), "month" - i(2), "day" - i(19), "hour" - i(12), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(179), "weekdays" - i(25), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(159), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(27)])).
car(328, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7CNI718"), "year" - i(2005), "month" - i(2), "day" - i(13), "hour" - i(11), "minute" - i(18), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(147), "weekdays" - i(12), "weekends" - i(10), "preferred day" - s("sunday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(34), "standard deviation from mean" - i(150), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(31)])).
car(329, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("12199"), "year" - i(2004), "month" - i(8), "day" - i(28), "hour" - i(19), "minute" - i(36), "station" - s("shell"), "fill-ups" - i(9), "record history (days)" - i(20), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(148), "standard deviation from mean" - i(397), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(330, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4ZNI599"), "year" - i(2005), "month" - i(1), "day" - i(12), "hour" - i(11), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(33), "record history (days)" - i(147), "weekdays" - i(28), "weekends" - i(5), "preferred day" - s("wednesday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(101), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(30)])).
car(331, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9782RHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(105), "record history (days)" - i(148), "weekdays" - i(91), "weekends" - i(14), "preferred day" - s("thursday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(134), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(20)])).
car(332, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5FNI214"), "year" - i(2005), "month" - i(1), "day" - i(21), "hour" - i(19), "minute" - i(18), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(108), "weekdays" - i(12), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(46), "standard deviation from mean" - i(146), "different locations" - i(3), "preferred station" - s("shell"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(23)])).
car(333, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("20999BH"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(13), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(168), "weekdays" - i(17), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(113), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(23)])).
car(334, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3762RHI"), "year" - i(2005), "month" - i(1), "day" - i(19), "hour" - i(15), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(34), "record history (days)" - i(145), "weekdays" - i(31), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(36), "standard deviation from mean" - i(201), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(35)])).
car(335, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7087DA"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(20), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(136), "weekdays" - i(5), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(121), "standard deviation from mean" - i(249), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(33)])).
car(336, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6SNI833"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(17), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(162), "weekdays" - i(21), "weekends" - i(10), "preferred day" - s("monday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(153), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(35)])).
car(337, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("58786AH"), "year" - i(2004), "month" - i(12), "day" - i(19), "hour" - i(19), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(145), "weekdays" - i(2), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(113), "standard deviation from mean" - i(231), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(50)])).
car(338, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0XNI320"), "year" - i(2005), "month" - i(1), "day" - i(13), "hour" - i(21), "minute" - i(29), "station" - s("shell"), "fill-ups" - i(41), "record history (days)" - i(147), "weekdays" - i(31), "weekends" - i(10), "preferred day" - s("tuesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(108), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(26)])).
car(339, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3215DA"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(19), "minute" - i(1), "station" - s("crown"), "fill-ups" - i(3), "record history (days)" - i(99), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(246), "standard deviation from mean" - i(284), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(33), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("37GH"), "preferred pump %" - i(33)])).
car(340, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9TNI250"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(69), "record history (days)" - i(172), "weekdays" - i(43), "weekends" - i(26), "preferred day" - s("sunday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(80), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(39)])).
car(341, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9TNI451"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(16), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(32), "record history (days)" - i(148), "weekdays" - i(24), "weekends" - i(8), "preferred day" - s("friday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(21), "standard deviation from mean" - i(113), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(28)])).
car(342, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ZNI244"), "year" - i(2005), "month" - i(1), "day" - i(12), "hour" - i(15), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(111), "weekdays" - i(5), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(120), "standard deviation from mean" - i(246), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(33)])).
car(343, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI754"), "year" - i(2005), "month" - i(2), "day" - i(7), "hour" - i(21), "minute" - i(15), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(148), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(150), "standard deviation from mean" - i(401), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(344, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2VNI054"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(21), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(96), "record history (days)" - i(170), "weekdays" - i(72), "weekends" - i(24), "preferred day" - s("tuesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(5), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(25)])).
car(345, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0YNI154"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(10), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(142), "weekdays" - i(17), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(4), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(20)])).
car(346, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4DNI254"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(10), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(32), "record history (days)" - i(140), "weekdays" - i(14), "weekends" - i(18), "preferred day" - s("saturday"), "day preference %" - i(43), "mean time of visit (minutes after midnight)" - i(36), "standard deviation from mean" - i(191), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(21)])).
car(347, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2UNI977"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(20), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(30), "record history (days)" - i(155), "weekdays" - i(21), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(39), "standard deviation from mean" - i(202), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(348, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2TNI987"), "year" - i(2005), "month" - i(1), "day" - i(16), "hour" - i(9), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(37), "record history (days)" - i(144), "weekdays" - i(21), "weekends" - i(16), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(39), "standard deviation from mean" - i(229), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(32)])).
car(349, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5VNI087"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(11), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(139), "weekdays" - i(11), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(210), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(35)])).
car(350, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0TNI287"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(16), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(62), "record history (days)" - i(163), "weekdays" - i(39), "weekends" - i(23), "preferred day" - s("saturday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(21), "standard deviation from mean" - i(169), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(51), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(30)])).
car(351, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3VNI005"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(11), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(57), "record history (days)" - i(172), "weekdays" - i(42), "weekends" - i(15), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(164), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(26)])).
car(352, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8ZNI205"), "year" - i(2004), "month" - i(12), "day" - i(28), "hour" - i(21), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(147), "weekdays" - i(21), "weekends" - i(10), "preferred day" - s("tuesday"), "day preference %" - i(35), "mean time of visit (minutes after midnight)" - i(25), "standard deviation from mean" - i(135), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(25)])).
car(353, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3UNI505"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(18), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(53), "record history (days)" - i(142), "weekdays" - i(45), "weekends" - i(8), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(94), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(41)])).
car(354, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ZNI715"), "year" - i(2005), "month" - i(2), "day" - i(16), "hour" - i(20), "minute" - i(11), "station" - s("shell"), "fill-ups" - i(14), "record history (days)" - i(108), "weekdays" - i(7), "weekends" - i(7), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(73), "standard deviation from mean" - i(245), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(15), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(42)])).
car(355, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ENI715"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(19), "minute" - i(20), "station" - s("mobil"), "fill-ups" - i(46), "record history (days)" - i(170), "weekdays" - i(30), "weekends" - i(16), "preferred day" - s("friday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(30), "standard deviation from mean" - i(197), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(50)])).
car(356, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7CNI915"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(14), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(67), "record history (days)" - i(141), "weekdays" - i(61), "weekends" - i(6), "preferred day" - s("wednesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(108), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(49)])).
car(357, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI015"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(0), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(39), "record history (days)" - i(163), "weekdays" - i(27), "weekends" - i(12), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(36), "standard deviation from mean" - i(220), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(30)])).
car(358, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3VNI597"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(129), "record history (days)" - i(149), "weekdays" - i(100), "weekends" - i(29), "preferred day" - s("tuesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(127), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(34)])).
car(359, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ZNI907"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(11), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(83), "record history (days)" - i(148), "weekdays" - i(61), "weekends" - i(22), "preferred day" - s("tuesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(137), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(21)])).
car(360, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI129"), "year" - i(2004), "month" - i(10), "day" - i(3), "hour" - i(5), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(95), "weekdays" - i(8), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(91), "standard deviation from mean" - i(277), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(54)])).
car(361, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0XNI039"), "year" - i(2004), "month" - i(12), "day" - i(2), "hour" - i(16), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(21), "record history (days)" - i(145), "weekdays" - i(21), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(240), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(38)])).
car(362, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2142QHI"), "year" - i(2004), "month" - i(12), "day" - i(25), "hour" - i(15), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(140), "weekdays" - i(3), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(211), "standard deviation from mean" - i(378), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(83)])).
car(363, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3510RHI"), "year" - i(2005), "month" - i(1), "day" - i(6), "hour" - i(13), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(148), "weekdays" - i(17), "weekends" - i(7), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(33), "standard deviation from mean" - i(141), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(364, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9952RHI"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(9), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(158), "weekdays" - i(15), "weekends" - i(7), "preferred day" - s("wednesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(34), "standard deviation from mean" - i(149), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(31)])).
car(365, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4013RHI"), "year" - i(2005), "month" - i(2), "day" - i(4), "hour" - i(11), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(74), "record history (days)" - i(148), "weekdays" - i(61), "weekends" - i(13), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(83), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(79)])).
car(366, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1723RHI"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(18), "minute" - i(6), "station" - s("shell"), "fill-ups" - i(30), "record history (days)" - i(147), "weekdays" - i(27), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(30), "standard deviation from mean" - i(163), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(40)])).
car(367, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6473RHI"), "year" - i(2005), "month" - i(1), "day" - i(21), "hour" - i(20), "minute" - i(53), "station" - s("shell"), "fill-ups" - i(39), "record history (days)" - i(140), "weekdays" - i(26), "weekends" - i(13), "preferred day" - s("monday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(184), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(53)])).
car(368, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7304RHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(14), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(37), "record history (days)" - i(164), "weekdays" - i(28), "weekends" - i(9), "preferred day" - s("wednesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(168), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(72), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(35)])).
car(369, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6924RHI"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(1), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(64), "record history (days)" - i(176), "weekdays" - i(54), "weekends" - i(10), "preferred day" - s("friday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(30), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(31)])).
car(370, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7634RHI"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(16), "minute" - i(51), "station" - s("mobil"), "fill-ups" - i(42), "record history (days)" - i(156), "weekdays" - i(33), "weekends" - i(9), "preferred day" - s("tuesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(26), "standard deviation from mean" - i(161), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(371, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6834RHI"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(21), "minute" - i(16), "station" - s("shell"), "fill-ups" - i(70), "record history (days)" - i(151), "weekdays" - i(56), "weekends" - i(14), "preferred day" - s("wednesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(146), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(37)])).
car(372, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3205RHI"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(8), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(139), "record history (days)" - i(148), "weekdays" - i(103), "weekends" - i(36), "preferred day" - s("friday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(48), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(53)])).
car(373, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3535RHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(17), "minute" - i(23), "station" - s("mobil"), "fill-ups" - i(150), "record history (days)" - i(149), "weekdays" - i(115), "weekends" - i(35), "preferred day" - s("wednesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(85), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(28)])).
car(374, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0835RHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(19), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(164), "record history (days)" - i(148), "weekdays" - i(112), "weekends" - i(52), "preferred day" - s("sunday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(105), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(21)])).
car(375, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5545RHI"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(23), "minute" - i(34), "station" - s("shell"), "fill-ups" - i(22), "record history (days)" - i(163), "weekdays" - i(13), "weekends" - i(9), "preferred day" - s("sunday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(11), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(31)])).
car(376, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7365RHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(17), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(192), "record history (days)" - i(149), "weekdays" - i(132), "weekends" - i(60), "preferred day" - s("saturday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(74), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(99), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(39)])).
car(377, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9846RHI"), "year" - i(2005), "month" - i(1), "day" - i(18), "hour" - i(16), "minute" - i(59), "station" - s("shell"), "fill-ups" - i(13), "record history (days)" - i(132), "weekdays" - i(12), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(58), "standard deviation from mean" - i(186), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(53), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(30)])).
car(378, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8359SHI"), "year" - i(2004), "month" - i(12), "day" - i(29), "hour" - i(14), "minute" - i(4), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(141), "weekdays" - i(6), "weekends" - i(7), "preferred day" - s("sunday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(84), "standard deviation from mean" - i(255), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(76), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(30)])).
car(379, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5653SHI"), "year" - i(2005), "month" - i(1), "day" - i(20), "hour" - i(14), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(146), "weekdays" - i(11), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(90), "standard deviation from mean" - i(303), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(38)])).
car(380, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3WNI478"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(56), "station" - s("shell"), "fill-ups" - i(124), "record history (days)" - i(173), "weekdays" - i(105), "weekends" - i(19), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(108), "different locations" - i(4), "preferred station" - s("shell"), "preferred station %" - i(54), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(22)])).
car(381, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8CNI043"), "year" - i(2005), "month" - i(1), "day" - i(30), "hour" - i(13), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(27), "record history (days)" - i(137), "weekdays" - i(15), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(29), "standard deviation from mean" - i(146), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(77)])).
car(382, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6DNI646"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(17), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(36), "record history (days)" - i(163), "weekdays" - i(26), "weekends" - i(10), "preferred day" - s("friday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(32), "standard deviation from mean" - i(185), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(27)])).
car(383, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("86887DH"), "year" - i(2004), "month" - i(10), "day" - i(18), "hour" - i(15), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(10), "record history (days)" - i(136), "weekdays" - i(10), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(69), "standard deviation from mean" - i(197), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(20)])).
car(384, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1913YII"), "year" - i(2004), "month" - i(8), "day" - i(6), "hour" - i(14), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(58), "weekdays" - i(10), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(83), "standard deviation from mean" - i(267), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(66)])).
car(385, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5SNI748"), "year" - i(2004), "month" - i(12), "day" - i(1), "hour" - i(8), "minute" - i(27), "station" - s("shell"), "fill-ups" - i(107), "record history (days)" - i(148), "weekdays" - i(88), "weekends" - i(19), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(62), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(77), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(64)])).
car(386, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7TNI748"), "year" - i(2005), "month" - i(1), "day" - i(23), "hour" - i(8), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(21), "record history (days)" - i(143), "weekdays" - i(10), "weekends" - i(11), "preferred day" - s("sunday"), "day preference %" - i(47), "mean time of visit (minutes after midnight)" - i(26), "standard deviation from mean" - i(114), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(28)])).
car(387, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI148"), "year" - i(2005), "month" - i(1), "day" - i(25), "hour" - i(14), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(40), "record history (days)" - i(144), "weekdays" - i(36), "weekends" - i(4), "preferred day" - s("wednesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(30), "standard deviation from mean" - i(185), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(37)])).
car(388, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("22254AH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(20), "minute" - i(30), "station" - s("mobil"), "fill-ups" - i(38), "record history (days)" - i(171), "weekdays" - i(25), "weekends" - i(13), "preferred day" - s("saturday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(115), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(23)])).
car(389, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ZNI038"), "year" - i(2005), "month" - i(2), "day" - i(19), "hour" - i(19), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(180), "weekdays" - i(6), "weekends" - i(13), "preferred day" - s("sunday"), "day preference %" - i(57), "mean time of visit (minutes after midnight)" - i(81), "standard deviation from mean" - i(317), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(17), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(78)])).
car(390, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2BNI825"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(11), "minute" - i(56), "station" - s("mobil"), "fill-ups" - i(54), "record history (days)" - i(171), "weekdays" - i(39), "weekends" - i(15), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(109), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(24)])).
car(391, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI115"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(84), "record history (days)" - i(170), "weekdays" - i(65), "weekends" - i(19), "preferred day" - s("tuesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(133), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(89), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(392, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2UNI841"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(15), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(18), "record history (days)" - i(144), "weekdays" - i(10), "weekends" - i(8), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(61), "standard deviation from mean" - i(240), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(77), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(22)])).
car(393, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("35505BH"), "year" - i(2005), "month" - i(1), "day" - i(22), "hour" - i(14), "minute" - i(10), "station" - s("shell"), "fill-ups" - i(7), "record history (days)" - i(124), "weekdays" - i(6), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(174), "standard deviation from mean" - i(395), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(42)])).
car(394, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2FTW741"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(21), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(15), "record history (days)" - i(148), "weekdays" - i(6), "weekends" - i(9), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(100), "standard deviation from mean" - i(349), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(80)])).
car(395, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3HNI526"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(0), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(40), "record history (days)" - i(52), "weekdays" - i(30), "weekends" - i(10), "preferred day" - s("saturday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(7), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(35)])).
car(396, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6JNI482"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(12), "minute" - i(4), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(22), "weekdays" - i(0), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(75), "mean time of visit (minutes after midnight)" - i(237), "standard deviation from mean" - i(356), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(50)])).
car(397, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8CNI081"), "year" - i(2005), "month" - i(1), "day" - i(29), "hour" - i(19), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(113), "weekdays" - i(22), "weekends" - i(7), "preferred day" - s("thursday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(42), "standard deviation from mean" - i(208), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(41)])).
car(398, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("29412DH"), "year" - i(2005), "month" - i(2), "day" - i(13), "hour" - i(1), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(26), "weekdays" - i(2), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(190), "standard deviation from mean" - i(285), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(399, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1083LJM"), "year" - i(2004), "month" - i(8), "day" - i(12), "hour" - i(19), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(42), "record history (days)" - i(160), "weekdays" - i(28), "weekends" - i(14), "preferred day" - s("sunday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(158), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(50)])).
car(400, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0WNI431"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(20), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(16), "record history (days)" - i(146), "weekdays" - i(10), "weekends" - i(6), "preferred day" - s("thursday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(70), "standard deviation from mean" - i(264), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(37)])).
car(401, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9XNI446"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(11), "minute" - i(44), "station" - s("shell"), "fill-ups" - i(53), "record history (days)" - i(161), "weekdays" - i(32), "weekends" - i(21), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(101), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(30)])).
car(402, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4VNI137"), "year" - i(2005), "month" - i(1), "day" - i(16), "hour" - i(17), "minute" - i(34), "station" - s("shell"), "fill-ups" - i(2), "record history (days)" - i(67), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(471), "standard deviation from mean" - i(333), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(50)])).
car(403, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9YNI035"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(18), "minute" - i(57), "station" - s("shell"), "fill-ups" - i(21), "record history (days)" - i(168), "weekdays" - i(9), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(56), "standard deviation from mean" - i(249), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(33)])).
car(404, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0CNI934"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(14), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(48), "record history (days)" - i(155), "weekdays" - i(18), "weekends" - i(30), "preferred day" - s("sunday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(127), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(35)])).
car(405, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI570"), "year" - i(2005), "month" - i(2), "day" - i(17), "hour" - i(19), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(175), "weekdays" - i(8), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(44), "mean time of visit (minutes after midnight)" - i(129), "standard deviation from mean" - i(345), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(33)])).
car(406, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7XNI807"), "year" - i(2005), "month" - i(1), "day" - i(17), "hour" - i(12), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(98), "record history (days)" - i(125), "weekdays" - i(90), "weekends" - i(8), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(94), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(90)])).
car(407, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9546VII"), "year" - i(2005), "month" - i(1), "day" - i(1), "hour" - i(15), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(8), "record history (days)" - i(131), "weekdays" - i(5), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(162), "standard deviation from mean" - i(403), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(50)])).
car(408, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0TNI366"), "year" - i(2005), "month" - i(1), "day" - i(10), "hour" - i(15), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(10), "record history (days)" - i(143), "weekdays" - i(9), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(82), "standard deviation from mean" - i(236), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(409, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1897YHI"), "year" - i(2005), "month" - i(1), "day" - i(26), "hour" - i(21), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(57), "record history (days)" - i(147), "weekdays" - i(45), "weekends" - i(12), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(177), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(64), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(15)])).
car(410, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9CNI825"), "year" - i(2005), "month" - i(2), "day" - i(3), "hour" - i(14), "minute" - i(40), "station" - s("shell"), "fill-ups" - i(24), "record history (days)" - i(148), "weekdays" - i(17), "weekends" - i(7), "preferred day" - s("friday"), "day preference %" - i(45), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(3), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(45)])).
car(411, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI750"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(10), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(32), "record history (days)" - i(159), "weekdays" - i(26), "weekends" - i(6), "preferred day" - s("friday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(21), "standard deviation from mean" - i(118), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(25)])).
car(412, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7TNI731"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(16), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(28), "record history (days)" - i(147), "weekdays" - i(20), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(6), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(46)])).
car(413, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3VNI131"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(14), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(33), "record history (days)" - i(166), "weekdays" - i(20), "weekends" - i(13), "preferred day" - s("thursday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(40), "standard deviation from mean" - i(222), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(21)])).
car(414, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5SNI688"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(11), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(165), "weekdays" - i(14), "weekends" - i(10), "preferred day" - s("wednesday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(48), "standard deviation from mean" - i(225), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(25)])).
car(415, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2TNI970"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(18), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(35), "record history (days)" - i(147), "weekdays" - i(29), "weekends" - i(6), "preferred day" - s("friday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(40), "standard deviation from mean" - i(229), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(25)])).
car(416, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6744RHI"), "year" - i(2005), "month" - i(1), "day" - i(27), "hour" - i(14), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(17), "record history (days)" - i(144), "weekdays" - i(14), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(38), "standard deviation from mean" - i(148), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(29)])).
car(417, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7067VHI"), "year" - i(2004), "month" - i(6), "day" - i(19), "hour" - i(12), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(72), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(483), "standard deviation from mean" - i(342), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(50)])).
car(418, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3VNI176"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(16), "minute" - i(26), "station" - s("mobil"), "fill-ups" - i(27), "record history (days)" - i(158), "weekdays" - i(22), "weekends" - i(5), "preferred day" - s("thursday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(114), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(59), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(18)])).
car(419, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI276"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(20), "minute" - i(13), "station" - s("shell"), "fill-ups" - i(28), "record history (days)" - i(146), "weekdays" - i(23), "weekends" - i(5), "preferred day" - s("wednesday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(98), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(67), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(53)])).
car(420, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI282"), "year" - i(2005), "month" - i(1), "day" - i(23), "hour" - i(14), "minute" - i(18), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(78), "weekdays" - i(2), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(275), "standard deviation from mean" - i(493), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("67HG"), "preferred pump %" - i(20)])).
car(421, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6VNI292"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(10), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(148), "weekdays" - i(19), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(42), "mean time of visit (minutes after midnight)" - i(75), "standard deviation from mean" - i(301), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(84)])).
car(422, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7TNI802"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(14), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(161), "weekdays" - i(20), "weekends" - i(5), "preferred day" - s("friday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(30), "standard deviation from mean" - i(145), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(56)])).
car(423, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8XNI786"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(23), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(34), "record history (days)" - i(151), "weekdays" - i(23), "weekends" - i(11), "preferred day" - s("saturday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(161), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(26)])).
car(424, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5CNI186"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(16), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(50), "record history (days)" - i(145), "weekdays" - i(35), "weekends" - i(15), "preferred day" - s("thursday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(5), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(42)])).
car(425, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI130"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(20), "minute" - i(42), "station" - s("shell"), "fill-ups" - i(23), "record history (days)" - i(126), "weekdays" - i(11), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(39), "mean time of visit (minutes after midnight)" - i(55), "standard deviation from mean" - i(254), "different locations" - i(3), "preferred station" - s("shell"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(91)])).
car(426, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8CNI330"), "year" - i(2005), "month" - i(1), "day" - i(25), "hour" - i(17), "minute" - i(4), "station" - s("mobil"), "fill-ups" - i(38), "record history (days)" - i(148), "weekdays" - i(26), "weekends" - i(12), "preferred day" - s("monday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(95), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(39)])).
car(427, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI536"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(16), "minute" - i(50), "station" - s("shell"), "fill-ups" - i(59), "record history (days)" - i(145), "weekdays" - i(30), "weekends" - i(29), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(123), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(28)])).
car(428, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0YNI746"), "year" - i(2005), "month" - i(2), "day" - i(24), "hour" - i(21), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(37), "record history (days)" - i(157), "weekdays" - i(31), "weekends" - i(6), "preferred day" - s("thursday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(134), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(21)])).
car(429, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5CNI398"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(11), "minute" - i(30), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(132), "weekdays" - i(13), "weekends" - i(6), "preferred day" - s("saturday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(71), "standard deviation from mean" - i(295), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(89), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(36)])).
car(430, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ENI598"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(13), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(167), "weekdays" - i(24), "weekends" - i(5), "preferred day" - s("thursday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(35), "standard deviation from mean" - i(179), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(20)])).
car(431, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI579"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(12), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(45), "record history (days)" - i(159), "weekdays" - i(32), "weekends" - i(13), "preferred day" - s("tuesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(121), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(24)])).
car(432, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2UNI189"), "year" - i(2004), "month" - i(11), "day" - i(30), "hour" - i(18), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(1), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(518), "standard deviation from mean" - i(366), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(433, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3925ZJM"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(14), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(140), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(475), "standard deviation from mean" - i(549), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(66)])).
car(434, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8033LJM"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(8), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(214), "record history (days)" - i(148), "weekdays" - i(167), "weekends" - i(47), "preferred day" - s("friday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(40), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(21)])).
car(435, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6233LJM"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(14), "minute" - i(54), "station" - s("shell"), "fill-ups" - i(95), "record history (days)" - i(144), "weekdays" - i(79), "weekends" - i(16), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(96), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(21)])).
car(436, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5433LJM"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(14), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(145), "record history (days)" - i(147), "weekdays" - i(132), "weekends" - i(13), "preferred day" - s("tuesday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(81), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(40)])).
car(437, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3794LJM"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(15), "minute" - i(40), "station" - s("mobil"), "fill-ups" - i(28), "record history (days)" - i(130), "weekdays" - i(23), "weekends" - i(5), "preferred day" - s("tuesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(142), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(57)])).
car(438, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6054LJM"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(16), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(105), "record history (days)" - i(148), "weekdays" - i(81), "weekends" - i(24), "preferred day" - s("wednesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(18), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(439, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7484LJM"), "year" - i(2005), "month" - i(1), "day" - i(19), "hour" - i(0), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(143), "weekdays" - i(29), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(10), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(29)])).
car(440, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8FNI039"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(11), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(152), "weekdays" - i(3), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(221), "standard deviation from mean" - i(255), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(441, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3FNI920"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(8), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(113), "record history (days)" - i(171), "weekdays" - i(87), "weekends" - i(26), "preferred day" - s("friday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(56), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(31)])).
car(442, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("19029DH"), "year" - i(2005), "month" - i(2), "day" - i(17), "hour" - i(18), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(48), "record history (days)" - i(178), "weekdays" - i(41), "weekends" - i(7), "preferred day" - s("monday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(26), "standard deviation from mean" - i(174), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(31)])).
car(443, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI355"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(10), "minute" - i(33), "station" - s("shell"), "fill-ups" - i(71), "record history (days)" - i(132), "weekdays" - i(55), "weekends" - i(16), "preferred day" - s("thursday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(4), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(18)])).
car(444, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0XNI791"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(14), "minute" - i(45), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(134), "weekdays" - i(13), "weekends" - i(6), "preferred day" - s("friday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(37), "standard deviation from mean" - i(155), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(47)])).
car(445, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6ENI253"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(17), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(34), "record history (days)" - i(158), "weekdays" - i(25), "weekends" - i(9), "preferred day" - s("monday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(27), "standard deviation from mean" - i(148), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(44)])).
car(446, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7576RHI"), "year" - i(2005), "month" - i(1), "day" - i(18), "hour" - i(16), "minute" - i(46), "station" - s("shell"), "fill-ups" - i(14), "record history (days)" - i(138), "weekdays" - i(12), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(50), "standard deviation from mean" - i(174), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(28)])).
car(447, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI760"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(11), "minute" - i(5), "station" - s("shell"), "fill-ups" - i(123), "record history (days)" - i(171), "weekdays" - i(103), "weekends" - i(20), "preferred day" - s("tuesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(69), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(25)])).
car(448, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("06890"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(16), "minute" - i(5), "station" - s("wawa"), "fill-ups" - i(10), "record history (days)" - i(163), "weekdays" - i(8), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(2), "different locations" - i(3), "preferred station" - s("wawa"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("37LG"), "preferred pump %" - i(40)])).
car(449, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9DNI224"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(16), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(103), "weekdays" - i(4), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(124), "standard deviation from mean" - i(254), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(33)])).
car(450, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4CNI744"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(56), "station" - s("mobil"), "fill-ups" - i(105), "record history (days)" - i(168), "weekdays" - i(92), "weekends" - i(13), "preferred day" - s("tuesday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(71), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(99), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(28)])).
car(451, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2XNI303"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(17), "minute" - i(25), "station" - s("shell"), "fill-ups" - i(56), "record history (days)" - i(170), "weekdays" - i(47), "weekends" - i(9), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(145), "different locations" - i(4), "preferred station" - s("shell"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(21)])).
car(452, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5VNI613"), "year" - i(2005), "month" - i(2), "day" - i(13), "hour" - i(11), "minute" - i(17), "station" - s("shell"), "fill-ups" - i(7), "record history (days)" - i(150), "weekdays" - i(4), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(180), "standard deviation from mean" - i(409), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(28)])).
car(453, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3992LJM"), "year" - i(2005), "month" - i(1), "day" - i(27), "hour" - i(15), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(56), "record history (days)" - i(146), "weekdays" - i(47), "weekends" - i(9), "preferred day" - s("wednesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(135), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(25)])).
car(454, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8551YHI"), "year" - i(2005), "month" - i(2), "day" - i(11), "hour" - i(22), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(139), "weekdays" - i(2), "weekends" - i(3), "preferred day" - s("saturday"), "day preference %" - i(60), "mean time of visit (minutes after midnight)" - i(265), "standard deviation from mean" - i(475), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(40)])).
car(455, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7169TII"), "year" - i(2004), "month" - i(8), "day" - i(15), "hour" - i(11), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(1), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(499), "standard deviation from mean" - i(353), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(456, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3730VHI"), "year" - i(2005), "month" - i(1), "day" - i(17), "hour" - i(10), "minute" - i(40), "station" - s("mobil"), "fill-ups" - i(15), "record history (days)" - i(136), "weekdays" - i(15), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(47), "standard deviation from mean" - i(163), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(33)])).
car(457, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6056HHI"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(17), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(18), "record history (days)" - i(160), "weekdays" - i(12), "weekends" - i(6), "preferred day" - s("tuesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(60), "standard deviation from mean" - i(244), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(458, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1853UII"), "year" - i(2005), "month" - i(1), "day" - i(15), "hour" - i(12), "minute" - i(16), "station" - s("shell"), "fill-ups" - i(8), "record history (days)" - i(114), "weekdays" - i(4), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(128), "standard deviation from mean" - i(319), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(37)])).
car(459, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2HNI653"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(11), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(53), "weekdays" - i(22), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(135), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(66)])).
car(460, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("13634IG"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(13), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(148), "weekdays" - i(8), "weekends" - i(5), "preferred day" - s("saturday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(90), "standard deviation from mean" - i(303), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(53)])).
car(461, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9319HHI"), "year" - i(2005), "month" - i(2), "day" - i(7), "hour" - i(8), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(18), "record history (days)" - i(141), "weekdays" - i(17), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(122), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(44)])).
car(462, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("56785AH"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(12), "minute" - i(20), "station" - s("shell"), "fill-ups" - i(29), "record history (days)" - i(161), "weekdays" - i(25), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(27), "standard deviation from mean" - i(143), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(55), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(27)])).
car(463, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI194"), "year" - i(2005), "month" - i(1), "day" - i(27), "hour" - i(18), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(142), "weekdays" - i(21), "weekends" - i(10), "preferred day" - s("tuesday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(13), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(51)])).
car(464, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7XNI158"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(17), "minute" - i(36), "station" - s("shell"), "fill-ups" - i(45), "record history (days)" - i(163), "weekdays" - i(30), "weekends" - i(15), "preferred day" - s("saturday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(30), "standard deviation from mean" - i(192), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(42)])).
car(465, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("34566AH"), "year" - i(2004), "month" - i(12), "day" - i(12), "hour" - i(14), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(77), "record history (days)" - i(147), "weekdays" - i(42), "weekends" - i(35), "preferred day" - s("saturday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(153), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(89), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(22)])).
car(466, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5573LJM"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(10), "minute" - i(14), "station" - s("shell"), "fill-ups" - i(15), "record history (days)" - i(161), "weekdays" - i(3), "weekends" - i(12), "preferred day" - s("saturday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(75), "standard deviation from mean" - i(273), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(26)])).
car(467, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2VNI655"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(9), "minute" - i(14), "station" - s("shell"), "fill-ups" - i(2), "record history (days)" - i(130), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(490), "standard deviation from mean" - i(346), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(50)])).
car(468, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RTU950"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(9), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(165), "weekdays" - i(20), "weekends" - i(6), "preferred day" - s("wednesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(38), "standard deviation from mean" - i(186), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(469, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("QUC883"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(22), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(161), "weekdays" - i(17), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(156), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(65)])).
car(470, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RTC627"), "year" - i(2004), "month" - i(8), "day" - i(6), "hour" - i(16), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(103), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(450), "standard deviation from mean" - i(520), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(33)])).
car(471, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("YRC737"), "year" - i(2004), "month" - i(6), "day" - i(18), "hour" - i(4), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(57), "record history (days)" - i(106), "weekdays" - i(52), "weekends" - i(5), "preferred day" - s("thursday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(123), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(24)])).
car(472, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KCZ437"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(17), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(170), "weekdays" - i(10), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(112), "standard deviation from mean" - i(356), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(473, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("387WQT"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(11), "minute" - i(4), "station" - s("mobil"), "fill-ups" - i(78), "record history (days)" - i(171), "weekdays" - i(66), "weekends" - i(12), "preferred day" - s("tuesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(120), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(82)])).
car(474, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("4425Y"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(16), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(122), "record history (days)" - i(149), "weekdays" - i(91), "weekends" - i(31), "preferred day" - s("wednesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(87), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(24)])).
car(475, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("768VYY"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(10), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(65), "record history (days)" - i(171), "weekdays" - i(62), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(93), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(476, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("2846Z"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(0), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(38), "record history (days)" - i(158), "weekdays" - i(23), "weekends" - i(15), "preferred day" - s("saturday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(183), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(26)])).
car(477, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("7437Z"), "year" - i(2004), "month" - i(9), "day" - i(18), "hour" - i(23), "minute" - i(16), "station" - s("Cumberland Farms"), "fill-ups" - i(6), "record history (days)" - i(12), "weekdays" - i(5), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(208), "standard deviation from mean" - i(373), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(40), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(33)])).
car(478, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UPV225"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(21), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(108), "record history (days)" - i(171), "weekdays" - i(76), "weekends" - i(32), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(108), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(30)])).
car(479, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TUC525"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(19), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(23), "record history (days)" - i(155), "weekdays" - i(10), "weekends" - i(13), "preferred day" - s("sunday"), "day preference %" - i(43), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(33), "different locations" - i(4), "preferred station" - s("mobil"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(43)])).
car(480, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SCD735"), "year" - i(2004), "month" - i(7), "day" - i(29), "hour" - i(21), "minute" - i(34), "station" - s("shell"), "fill-ups" - i(20), "record history (days)" - i(22), "weekdays" - i(16), "weekends" - i(4), "preferred day" - s("thursday"), "day preference %" - i(45), "mean time of visit (minutes after midnight)" - i(64), "standard deviation from mean" - i(243), "different locations" - i(3), "preferred station" - s("Cumberland Farms"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("37VH"), "preferred pump %" - i(20)])).
car(481, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("HVD317"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(23), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(125), "weekdays" - i(1), "weekends" - i(5), "preferred day" - s("saturday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(28), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(66)])).
car(482, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KTA727"), "year" - i(2004), "month" - i(5), "day" - i(5), "hour" - i(15), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(62), "weekdays" - i(9), "weekends" - i(4), "preferred day" - s("thursday"), "day preference %" - i(38), "mean time of visit (minutes after midnight)" - i(46), "standard deviation from mean" - i(155), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(76)])).
car(483, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UKA873"), "year" - i(2004), "month" - i(5), "day" - i(30), "hour" - i(23), "minute" - i(0), "station" - s("mobil"), "fill-ups" - i(8), "record history (days)" - i(85), "weekdays" - i(4), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(160), "standard deviation from mean" - i(396), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(25)])).
car(484, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SDC973"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(21), "minute" - i(52), "station" - s("pilot"), "fill-ups" - i(2), "record history (days)" - i(134), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(456), "standard deviation from mean" - i(323), "different locations" - i(2), "preferred station" - s("pilot"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(485, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LPC883"), "year" - i(2005), "month" - i(2), "day" - i(19), "hour" - i(22), "minute" - i(42), "station" - s("shell"), "fill-ups" - i(12), "record history (days)" - i(140), "weekdays" - i(3), "weekends" - i(9), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(112), "standard deviation from mean" - i(356), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(41)])).
car(486, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("7002Y"), "year" - i(2005), "month" - i(1), "day" - i(10), "hour" - i(9), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(95), "record history (days)" - i(148), "weekdays" - i(68), "weekends" - i(27), "preferred day" - s("wednesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(86), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(29)])).
car(487, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RQR223"), "year" - i(2004), "month" - i(12), "day" - i(30), "hour" - i(13), "minute" - i(37), "station" - s("shell"), "fill-ups" - i(30), "record history (days)" - i(106), "weekdays" - i(23), "weekends" - i(7), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(17), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(26)])).
car(488, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LYR323"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(63), "record history (days)" - i(148), "weekdays" - i(48), "weekends" - i(15), "preferred day" - s("thursday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(17), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(31)])).
car(489, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("JVCJPN"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(21), "minute" - i(28), "station" - s("shell"), "fill-ups" - i(30), "record history (days)" - i(171), "weekdays" - i(24), "weekends" - i(6), "preferred day" - s("monday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(24), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(16)])).
car(490, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("70651QN"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(18), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(60), "record history (days)" - i(170), "weekdays" - i(45), "weekends" - i(15), "preferred day" - s("thursday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(25), "standard deviation from mean" - i(184), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(23)])).
car(491, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TTQ376"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(13), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(145), "weekdays" - i(10), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(104), "standard deviation from mean" - i(332), "different locations" - i(2), "preferred station" - s("chevron"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("17YH"), "preferred pump %" - i(75)])).
car(492, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("FTW132"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(8), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(152), "record history (days)" - i(148), "weekdays" - i(113), "weekends" - i(39), "preferred day" - s("friday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(45), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(99), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(50)])).
car(493, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("EQC210"), "year" - i(2004), "month" - i(5), "day" - i(27), "hour" - i(3), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(76), "weekdays" - i(5), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(270), "standard deviation from mean" - i(483), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(40)])).
car(494, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CJC310"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(118), "record history (days)" - i(148), "weekdays" - i(89), "weekends" - i(29), "preferred day" - s("thursday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(3), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(43)])).
car(495, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UUB832"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(10), "minute" - i(50), "station" - s("shell"), "fill-ups" - i(100), "record history (days)" - i(149), "weekdays" - i(75), "weekends" - i(25), "preferred day" - s("friday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(14), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(32)])).
car(496, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("JAW532"), "year" - i(2005), "month" - i(1), "day" - i(31), "hour" - i(0), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(138), "weekdays" - i(5), "weekends" - i(2), "preferred day" - s("monday"), "day preference %" - i(42), "mean time of visit (minutes after midnight)" - i(84), "standard deviation from mean" - i(173), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(28)])).
car(497, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UUB842"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(212), "record history (days)" - i(148), "weekdays" - i(149), "weekends" - i(63), "preferred day" - s("wednesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(2), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(40)])).
car(498, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("HYU042"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(83), "record history (days)" - i(172), "weekdays" - i(70), "weekends" - i(13), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(139), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(20)])).
car(499, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("O9AH"), "year" - i(2005), "month" - i(1), "day" - i(28), "hour" - i(22), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(8), "record history (days)" - i(128), "weekdays" - i(7), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(134), "standard deviation from mean" - i(333), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(37)])).
car(500, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RTW857"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(21), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(183), "record history (days)" - i(149), "weekdays" - i(129), "weekends" - i(54), "preferred day" - s("monday"), "day preference %" - i(15), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(88), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(68)])).
car(501, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DOD793"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(248), "record history (days)" - i(173), "weekdays" - i(192), "weekends" - i(56), "preferred day" - s("thursday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(66), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(92)])).
car(502, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LKW893"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(22), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(123), "record history (days)" - i(171), "weekdays" - i(90), "weekends" - i(33), "preferred day" - s("monday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(4), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(42)])).
car(503, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KNA393"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(8), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(111), "record history (days)" - i(167), "weekdays" - i(101), "weekends" - i(10), "preferred day" - s("thursday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(12), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(41)])).
car(504, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CEV693"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(2), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(130), "record history (days)" - i(148), "weekdays" - i(93), "weekends" - i(37), "preferred day" - s("saturday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(15), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(27)])).
car(505, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("9601MR"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(74), "record history (days)" - i(109), "weekdays" - i(60), "weekends" - i(14), "preferred day" - s("wednesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(158), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(72)])).
car(506, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("0103BR"), "year" - i(2005), "month" - i(2), "day" - i(11), "hour" - i(13), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(10), "record history (days)" - i(110), "weekdays" - i(4), "weekends" - i(6), "preferred day" - s("saturday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(94), "standard deviation from mean" - i(268), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(40)])).
car(507, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CGW286"), "year" - i(2004), "month" - i(8), "day" - i(26), "hour" - i(22), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(106), "weekdays" - i(6), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(42), "mean time of visit (minutes after midnight)" - i(57), "standard deviation from mean" - i(132), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(42)])).
car(508, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SUD855"), "year" - i(2004), "month" - i(7), "day" - i(14), "hour" - i(18), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(61), "weekdays" - i(3), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(273), "standard deviation from mean" - i(489), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(40)])).
car(509, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RVD955"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(20), "minute" - i(26), "station" - s("shell"), "fill-ups" - i(29), "record history (days)" - i(161), "weekdays" - i(12), "weekends" - i(17), "preferred day" - s("sunday"), "day preference %" - i(34), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(68), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(27)])).
car(510, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("YRC055"), "year" - i(2004), "month" - i(8), "day" - i(21), "hour" - i(1), "minute" - i(4), "station" - s("mobil"), "fill-ups" - i(65), "record history (days)" - i(170), "weekdays" - i(36), "weekends" - i(29), "preferred day" - s("saturday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(157), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(30)])).
car(511, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("WSA155"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(15), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(144), "weekdays" - i(15), "weekends" - i(16), "preferred day" - s("sunday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(47), "standard deviation from mean" - i(245), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(61)])).
car(512, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("NNC183"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(17), "minute" - i(52), "station" - s("shell"), "fill-ups" - i(9), "record history (days)" - i(128), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(149), "standard deviation from mean" - i(371), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(55), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(55)])).
car(513, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CKA795"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(11), "minute" - i(8), "station" - s("shell"), "fill-ups" - i(42), "record history (days)" - i(149), "weekdays" - i(26), "weekends" - i(16), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(29), "standard deviation from mean" - i(186), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(78), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(26)])).
car(514, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VXR673"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(7), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(121), "record history (days)" - i(148), "weekdays" - i(97), "weekends" - i(24), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(45), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(52)])).
car(515, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UAX798"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(20), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(142), "record history (days)" - i(148), "weekdays" - i(116), "weekends" - i(26), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(50), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(54), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(19)])).
car(516, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("HXT594"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(22), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(41), "record history (days)" - i(163), "weekdays" - i(29), "weekends" - i(12), "preferred day" - s("wednesday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(33), "standard deviation from mean" - i(209), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(36)])).
car(517, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("925CJA"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(114), "record history (days)" - i(168), "weekdays" - i(82), "weekends" - i(32), "preferred day" - s("monday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(70), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(24)])).
car(518, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("6BU106"), "year" - i(2004), "month" - i(10), "day" - i(27), "hour" - i(15), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(937), "standard deviation from mean" - i(0), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(100)])).
car(519, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("HIX664"), "year" - i(2004), "month" - i(7), "day" - i(18), "hour" - i(17), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(119), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(429), "standard deviation from mean" - i(495), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(33)])).
car(520, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("QUW874"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(18), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(157), "weekdays" - i(3), "weekends" - i(3), "preferred day" - s("saturday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(177), "standard deviation from mean" - i(363), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(50)])).
car(521, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("PTZ447"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(20), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(55), "record history (days)" - i(168), "weekdays" - i(21), "weekends" - i(34), "preferred day" - s("sunday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(76), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(56)])).
car(522, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("NGC234"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(14), "minute" - i(43), "station" - s("shell"), "fill-ups" - i(9), "record history (days)" - i(141), "weekdays" - i(9), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(55), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(37), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(22)])).
car(523, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VVS515"), "year" - i(2005), "month" - i(2), "day" - i(24), "hour" - i(23), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(154), "weekdays" - i(23), "weekends" - i(6), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(0), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(72)])).
car(524, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("497WAA"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(23), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(44), "record history (days)" - i(156), "weekdays" - i(35), "weekends" - i(9), "preferred day" - s("monday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(32), "standard deviation from mean" - i(210), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(20)])).
car(525, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("1669DA"), "year" - i(2004), "month" - i(8), "day" - i(4), "hour" - i(0), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(63), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("wednesday"), "day preference %" - i(44), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(52), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(44)])).
car(526, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TKB509"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(20), "minute" - i(33), "station" - s("wawa"), "fill-ups" - i(129), "record history (days)" - i(148), "weekdays" - i(91), "weekends" - i(38), "preferred day" - s("tuesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(86), "different locations" - i(3), "preferred station" - s("wawa"), "preferred station %" - i(58), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("37LG"), "preferred pump %" - i(52)])).
car(527, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VNU609"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(1), "minute" - i(30), "station" - s("mobil"), "fill-ups" - i(62), "record history (days)" - i(148), "weekdays" - i(32), "weekends" - i(30), "preferred day" - s("sunday"), "day preference %" - i(38), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(5), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(27)])).
car(528, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SOB719"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(5), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(132), "weekdays" - i(6), "weekends" - i(3), "preferred day" - s("monday"), "day preference %" - i(44), "mean time of visit (minutes after midnight)" - i(47), "standard deviation from mean" - i(126), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(55)])).
car(529, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("JNB919"), "year" - i(2004), "month" - i(11), "day" - i(13), "hour" - i(12), "minute" - i(28), "station" - s("Cumberland Farms"), "fill-ups" - i(14), "record history (days)" - i(141), "weekdays" - i(8), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(113), "standard deviation from mean" - i(344), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(57), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("54VH"), "preferred pump %" - i(21)])).
car(530, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("1501KR"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(17), "minute" - i(4), "station" - s("mobil"), "fill-ups" - i(15), "record history (days)" - i(141), "weekdays" - i(8), "weekends" - i(7), "preferred day" - s("saturday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(17), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(53)])).
car(531, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SWF029"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(19), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(62), "record history (days)" - i(147), "weekdays" - i(43), "weekends" - i(19), "preferred day" - s("friday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(11), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(62), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(17)])).
car(532, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("29097RP"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(20), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(86), "record history (days)" - i(167), "weekdays" - i(77), "weekends" - i(9), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(141), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(66)])).
car(533, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TGZ860"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(20), "minute" - i(56), "station" - s("shell"), "fill-ups" - i(139), "record history (days)" - i(149), "weekdays" - i(112), "weekends" - i(27), "preferred day" - s("friday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(81), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(79), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(31)])).
car(534, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("J8RWK"), "year" - i(2005), "month" - i(2), "day" - i(17), "hour" - i(15), "minute" - i(17), "station" - s("shell"), "fill-ups" - i(9), "record history (days)" - i(108), "weekdays" - i(8), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(158), "standard deviation from mean" - i(423), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(77), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(55)])).
car(535, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("896OFY"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(13), "minute" - i(59), "station" - s("mobil"), "fill-ups" - i(28), "record history (days)" - i(165), "weekdays" - i(20), "weekends" - i(8), "preferred day" - s("saturday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(40), "standard deviation from mean" - i(207), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(536, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("NDU706"), "year" - i(2005), "month" - i(2), "day" - i(24), "hour" - i(18), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(23), "record history (days)" - i(158), "weekdays" - i(13), "weekends" - i(10), "preferred day" - s("sunday"), "day preference %" - i(39), "mean time of visit (minutes after midnight)" - i(51), "standard deviation from mean" - i(231), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(78), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(30)])).
car(537, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DPZ631"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(154), "record history (days)" - i(172), "weekdays" - i(95), "weekends" - i(59), "preferred day" - s("saturday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(8), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(24)])).
car(538, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("BCZ481"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(0), "minute" - i(23), "station" - s("mobil"), "fill-ups" - i(10), "record history (days)" - i(155), "weekdays" - i(6), "weekends" - i(4), "preferred day" - s("monday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(13), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(539, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("JNB565"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(8), "minute" - i(15), "station" - s("mobil"), "fill-ups" - i(112), "record history (days)" - i(170), "weekdays" - i(79), "weekends" - i(33), "preferred day" - s("saturday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(113), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(30)])).
car(540, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("BQC175"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(23), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(137), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(333), "standard deviation from mean" - i(385), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(33)])).
car(541, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SXB575"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(7), "minute" - i(18), "station" - s("mobil"), "fill-ups" - i(149), "record history (days)" - i(163), "weekdays" - i(108), "weekends" - i(41), "preferred day" - s("saturday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(40), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(53)])).
car(542, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("WQD185"), "year" - i(2005), "month" - i(1), "day" - i(10), "hour" - i(9), "minute" - i(25), "station" - s("shell"), "fill-ups" - i(13), "record history (days)" - i(143), "weekdays" - i(13), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(46), "mean time of visit (minutes after midnight)" - i(91), "standard deviation from mean" - i(290), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(53)])).
car(543, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("44285"), "year" - i(2004), "month" - i(6), "day" - i(6), "hour" - i(12), "minute" - i(37), "station" - s("shell"), "fill-ups" - i(48), "record history (days)" - i(91), "weekdays" - i(37), "weekends" - i(11), "preferred day" - s("monday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(21), "standard deviation from mean" - i(143), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(56), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(20)])).
car(544, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LRF485"), "year" - i(2005), "month" - i(1), "day" - i(17), "hour" - i(17), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(34), "record history (days)" - i(134), "weekdays" - i(25), "weekends" - i(9), "preferred day" - s("monday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(1), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(79), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(47)])).
car(545, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("HDQ544"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(8), "minute" - i(59), "station" - s("shell"), "fill-ups" - i(59), "record history (days)" - i(171), "weekdays" - i(53), "weekends" - i(6), "preferred day" - s("friday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(69), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(69), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(22)])).
car(546, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("WPA8"), "year" - i(2004), "month" - i(11), "day" - i(11), "hour" - i(6), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(83), "weekdays" - i(5), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(96), "standard deviation from mean" - i(172), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(80)])).
car(547, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("B279"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(0), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(173), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(21), "standard deviation from mean" - i(24), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("07HH"), "preferred pump %" - i(33)])).
car(548, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("WGA992"), "year" - i(2005), "month" - i(2), "day" - i(13), "hour" - i(21), "minute" - i(30), "station" - s("shell"), "fill-ups" - i(37), "record history (days)" - i(146), "weekdays" - i(17), "weekends" - i(20), "preferred day" - s("sunday"), "day preference %" - i(43), "mean time of visit (minutes after midnight)" - i(38), "standard deviation from mean" - i(223), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(32)])).
car(549, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("158EFA"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(1), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(27), "record history (days)" - i(146), "weekdays" - i(18), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(28), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(40)])).
car(550, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("BQT601"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(12), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(59), "record history (days)" - i(170), "weekdays" - i(52), "weekends" - i(7), "preferred day" - s("wednesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(112), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(45)])).
car(551, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("YRC866"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(22), "minute" - i(49), "station" - s("shell"), "fill-ups" - i(14), "record history (days)" - i(147), "weekdays" - i(2), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(57), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(82), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(14)])).
car(552, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RVZ095"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(23), "minute" - i(35), "station" - s("shell"), "fill-ups" - i(68), "record history (days)" - i(156), "weekdays" - i(54), "weekends" - i(14), "preferred day" - s("wednesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(2), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(30)])).
car(553, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("NBA866"), "year" - i(2005), "month" - i(1), "day" - i(9), "hour" - i(19), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(98), "weekdays" - i(2), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(47), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(25)])).
car(554, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XWC477"), "year" - i(2004), "month" - i(12), "day" - i(5), "hour" - i(23), "minute" - i(14), "station" - s("shell"), "fill-ups" - i(19), "record history (days)" - i(143), "weekdays" - i(9), "weekends" - i(10), "preferred day" - s("sunday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(39), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(47)])).
car(555, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("199LN8"), "year" - i(2005), "month" - i(2), "day" - i(10), "hour" - i(21), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(23), "record history (days)" - i(145), "weekdays" - i(21), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(57), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(60)])).
car(556, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("E172TN"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(19), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(62), "record history (days)" - i(164), "weekdays" - i(47), "weekends" - i(15), "preferred day" - s("tuesday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(20), "standard deviation from mean" - i(157), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(27)])).
car(557, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("YEV342"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(0), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(44), "record history (days)" - i(150), "weekdays" - i(30), "weekends" - i(14), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(30), "standard deviation from mean" - i(192), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(20)])).
car(558, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("EXX752"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(17), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(152), "record history (days)" - i(148), "weekdays" - i(114), "weekends" - i(38), "preferred day" - s("friday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(85), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(19)])).
car(559, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SUD152"), "year" - i(2005), "month" - i(1), "day" - i(19), "hour" - i(1), "minute" - i(17), "station" - s("mobil"), "fill-ups" - i(14), "record history (days)" - i(146), "weekdays" - i(8), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(35), "mean time of visit (minutes after midnight)" - i(66), "standard deviation from mean" - i(232), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(64), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(35)])).
car(560, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RTW068"), "year" - i(2005), "month" - i(2), "day" - i(24), "hour" - i(23), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(133), "weekdays" - i(17), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(45), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(5), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(40)])).
car(561, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("OCA428"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(20), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(99), "record history (days)" - i(148), "weekdays" - i(80), "weekends" - i(19), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(12), "standard deviation from mean" - i(124), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(49)])).
car(562, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DPZ521"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(4), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(154), "record history (days)" - i(149), "weekdays" - i(124), "weekends" - i(30), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(106), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(29)])).
car(563, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UMW074"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(15), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(64), "record history (days)" - i(171), "weekdays" - i(49), "weekends" - i(15), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(144), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(89), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(64)])).
car(564, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("YJC474"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(23), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(28), "record history (days)" - i(164), "weekdays" - i(20), "weekends" - i(8), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(34), "standard deviation from mean" - i(170), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(25)])).
car(565, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KTC884"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(6), "station" - s("shell"), "fill-ups" - i(108), "record history (days)" - i(148), "weekdays" - i(96), "weekends" - i(12), "preferred day" - s("wednesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(53), "different locations" - i(3), "preferred station" - s("shell"), "preferred station %" - i(54), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(27)])).
car(566, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VJC184"), "year" - i(2004), "month" - i(3), "day" - i(30), "hour" - i(16), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(354), "standard deviation from mean" - i(250), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(50)])).
car(567, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DQC684"), "year" - i(2005), "month" - i(2), "day" - i(10), "hour" - i(18), "minute" - i(49), "station" - s("shell"), "fill-ups" - i(8), "record history (days)" - i(147), "weekdays" - i(8), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(27), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(37)])).
car(568, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XCD684"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(23), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(238), "record history (days)" - i(170), "weekdays" - i(186), "weekends" - i(52), "preferred day" - s("friday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(78), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(22)])).
car(569, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("PYU968"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(18), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(14), "record history (days)" - i(146), "weekdays" - i(7), "weekends" - i(7), "preferred day" - s("sunday"), "day preference %" - i(42), "mean time of visit (minutes after midnight)" - i(97), "standard deviation from mean" - i(338), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(42)])).
car(570, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("WTQ978"), "year" - i(2004), "month" - i(10), "day" - i(21), "hour" - i(10), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(127), "weekdays" - i(21), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(25), "standard deviation from mean" - i(115), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(571, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("HGX001"), "year" - i(2005), "month" - i(2), "day" - i(3), "hour" - i(12), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(8), "record history (days)" - i(138), "weekdays" - i(7), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(155), "standard deviation from mean" - i(352), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(25)])).
car(572, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RRD811"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(7), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(100), "record history (days)" - i(169), "weekdays" - i(64), "weekends" - i(36), "preferred day" - s("saturday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(142), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(43)])).
car(573, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RRD677"), "year" - i(2005), "month" - i(2), "day" - i(7), "hour" - i(9), "minute" - i(0), "station" - s("mobil"), "fill-ups" - i(126), "record history (days)" - i(146), "weekdays" - i(78), "weekends" - i(48), "preferred day" - s("saturday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(22), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(56)])).
car(574, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("896IXN"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(1), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(159), "weekdays" - i(21), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(33), "standard deviation from mean" - i(146), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(72), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(22)])).
car(575, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("06339QP"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(22), "minute" - i(37), "station" - s("shell"), "fill-ups" - i(2), "record history (days)" - i(4), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(435), "standard deviation from mean" - i(308), "different locations" - i(1), "preferred station" - s("shell"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(50)])).
car(576, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("M259"), "year" - i(2005), "month" - i(2), "day" - i(11), "hour" - i(22), "minute" - i(27), "station" - s("shell"), "fill-ups" - i(9), "record history (days)" - i(147), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(73), "standard deviation from mean" - i(181), "different locations" - i(3), "preferred station" - s("shell"), "preferred station %" - i(77), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(77)])).
car(577, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UGD106"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(9), "minute" - i(51), "station" - s("mobil"), "fill-ups" - i(65), "record history (days)" - i(148), "weekdays" - i(36), "weekends" - i(29), "preferred day" - s("sunday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(18), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(26)])).
car(578, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("65479QP"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(3), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(44), "record history (days)" - i(172), "weekdays" - i(32), "weekends" - i(12), "preferred day" - s("monday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(201), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(70), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(34)])).
car(579, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RVD708"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(38), "station" - s("shell"), "fill-ups" - i(140), "record history (days)" - i(148), "weekdays" - i(87), "weekends" - i(53), "preferred day" - s("saturday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(4), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(72), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(33)])).
car(580, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RYS250"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(54), "record history (days)" - i(170), "weekdays" - i(36), "weekends" - i(18), "preferred day" - s("thursday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(23), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(31)])).
car(581, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CWS977"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(20), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(90), "record history (days)" - i(168), "weekdays" - i(78), "weekends" - i(12), "preferred day" - s("monday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(78), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(54), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(16)])).
car(582, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LES141"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(14), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(118), "weekdays" - i(1), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(259), "standard deviation from mean" - i(389), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(25)])).
car(583, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("857550F"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(16), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(20), "weekdays" - i(2), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(271), "standard deviation from mean" - i(485), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(40)])).
car(584, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("523YII"), "year" - i(2005), "month" - i(1), "day" - i(10), "hour" - i(21), "minute" - i(14), "station" - s("Cumberland Farms"), "fill-ups" - i(2), "record history (days)" - i(3), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(399), "standard deviation from mean" - i(282), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27VH"), "preferred pump %" - i(50)])).
car(585, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("040208F"), "year" - i(2004), "month" - i(3), "day" - i(30), "hour" - i(12), "minute" - i(15), "station" - s("shell"), "fill-ups" - i(20), "record history (days)" - i(22), "weekdays" - i(19), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(41), "standard deviation from mean" - i(176), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(70)])).
car(586, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CGW190"), "year" - i(2004), "month" - i(6), "day" - i(30), "hour" - i(14), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(113), "record history (days)" - i(118), "weekdays" - i(90), "weekends" - i(23), "preferred day" - s("wednesday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(84), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(20)])).
car(587, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("PGB490"), "year" - i(2005), "month" - i(2), "day" - i(4), "hour" - i(7), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(135), "record history (days)" - i(147), "weekdays" - i(106), "weekends" - i(29), "preferred day" - s("wednesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(41), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(42)])).
car(588, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("OCB690"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(13), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(125), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(394), "standard deviation from mean" - i(455), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(33)])).
car(589, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XGA300"), "year" - i(2004), "month" - i(5), "day" - i(2), "hour" - i(19), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(56), "weekdays" - i(1), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(85), "mean time of visit (minutes after midnight)" - i(157), "standard deviation from mean" - i(356), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(42)])).
car(590, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CJC500"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(22), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(113), "record history (days)" - i(162), "weekdays" - i(82), "weekends" - i(31), "preferred day" - s("thursday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(54), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(99), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(45)])).
car(591, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TYC600"), "year" - i(2004), "month" - i(10), "day" - i(28), "hour" - i(19), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(152), "weekdays" - i(22), "weekends" - i(9), "preferred day" - s("friday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(52), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(70), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(32)])).
car(592, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VRB014"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(8), "minute" - i(31), "station" - s("shell"), "fill-ups" - i(175), "record history (days)" - i(149), "weekdays" - i(137), "weekends" - i(38), "preferred day" - s("friday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(78), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(57), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(20)])).
car(593, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("OUT414"), "year" - i(2005), "month" - i(2), "day" - i(2), "hour" - i(23), "minute" - i(46), "station" - s("shell"), "fill-ups" - i(12), "record history (days)" - i(130), "weekdays" - i(7), "weekends" - i(5), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(27), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(33)])).
car(594, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RDR024"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(89), "record history (days)" - i(171), "weekdays" - i(66), "weekends" - i(23), "preferred day" - s("thursday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(70), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(29)])).
car(595, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XTX801"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(10), "minute" - i(16), "station" - s("shell"), "fill-ups" - i(221), "record history (days)" - i(149), "weekdays" - i(186), "weekends" - i(35), "preferred day" - s("tuesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(71), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(34)])).
car(596, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("EKC479"), "year" - i(2004), "month" - i(5), "day" - i(10), "hour" - i(23), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(56), "weekdays" - i(3), "weekends" - i(3), "preferred day" - s("saturday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(16), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(16)])).
car(597, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("QVD242"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(8), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(129), "record history (days)" - i(172), "weekdays" - i(109), "weekends" - i(20), "preferred day" - s("thursday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(61), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(51), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(21)])).
car(598, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("PGB189"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(137), "record history (days)" - i(161), "weekdays" - i(92), "weekends" - i(45), "preferred day" - s("friday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(94), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(71)])).
car(599, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SDX623"), "year" - i(2004), "month" - i(6), "day" - i(29), "hour" - i(18), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(27), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(378), "standard deviation from mean" - i(436), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(66)])).
car(600, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TBB463"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(30), "record history (days)" - i(161), "weekdays" - i(27), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(10), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(26)])).
car(601, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("38943PP"), "year" - i(2004), "month" - i(5), "day" - i(29), "hour" - i(17), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(58), "weekdays" - i(4), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(200), "standard deviation from mean" - i(359), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(60)])).
car(602, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CBW522"), "year" - i(2004), "month" - i(9), "day" - i(17), "hour" - i(17), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(145), "weekdays" - i(6), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(42), "mean time of visit (minutes after midnight)" - i(168), "standard deviation from mean" - i(383), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(28), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(57)])).
car(603, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("HPV768"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(21), "minute" - i(26), "station" - s("mobil"), "fill-ups" - i(106), "record history (days)" - i(164), "weekdays" - i(82), "weekends" - i(24), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(112), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(24)])).
car(604, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("PUD040"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(15), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(154), "record history (days)" - i(171), "weekdays" - i(110), "weekends" - i(44), "preferred day" - s("sunday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(92), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(22)])).
car(605, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("ZBB566"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(19), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(161), "weekdays" - i(14), "weekends" - i(11), "preferred day" - s("monday"), "day preference %" - i(48), "mean time of visit (minutes after midnight)" - i(44), "standard deviation from mean" - i(202), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(40)])).
car(606, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VDF566"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(19), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(126), "weekdays" - i(2), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(57), "mean time of visit (minutes after midnight)" - i(195), "standard deviation from mean" - i(443), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(28), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(57)])).
car(607, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LKZ666"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(19), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(78), "record history (days)" - i(148), "weekdays" - i(72), "weekends" - i(6), "preferred day" - s("wednesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(2), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(29)])).
car(608, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VDF256"), "year" - i(2005), "month" - i(2), "day" - i(22), "hour" - i(23), "minute" - i(50), "station" - s("shell"), "fill-ups" - i(6), "record history (days)" - i(36), "weekdays" - i(5), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(232), "standard deviation from mean" - i(474), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(16)])).
car(609, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("NNA326"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(51), "station" - s("shell"), "fill-ups" - i(2), "record history (days)" - i(155), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(365), "standard deviation from mean" - i(258), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(50)])).
car(610, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("9935Y"), "year" - i(2004), "month" - i(12), "day" - i(8), "hour" - i(19), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(64), "record history (days)" - i(145), "weekdays" - i(47), "weekends" - i(17), "preferred day" - s("thursday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(17), "standard deviation from mean" - i(132), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(29)])).
car(611, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("FPC705"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(16), "minute" - i(41), "station" - s("shell"), "fill-ups" - i(78), "record history (days)" - i(148), "weekdays" - i(67), "weekends" - i(11), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(122), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(55), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(19)])).
car(612, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UGD658"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(22), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(145), "weekdays" - i(2), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(46), "standard deviation from mean" - i(96), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(83)])).
car(613, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DEQ862"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(1), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(155), "record history (days)" - i(147), "weekdays" - i(98), "weekends" - i(57), "preferred day" - s("saturday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(14), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(40)])).
car(614, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DDF078"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(8), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(126), "record history (days)" - i(162), "weekdays" - i(97), "weekends" - i(29), "preferred day" - s("wednesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(61), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(57)])).
car(615, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VRB033"), "year" - i(2005), "month" - i(2), "day" - i(22), "hour" - i(10), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(67), "record history (days)" - i(136), "weekdays" - i(54), "weekends" - i(13), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(139), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(20)])).
car(616, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("QVD312"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(42), "station" - s("shell"), "fill-ups" - i(120), "record history (days)" - i(148), "weekdays" - i(94), "weekends" - i(26), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(11), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(72), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(40)])).
car(617, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("HTA949"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(64), "record history (days)" - i(148), "weekdays" - i(40), "weekends" - i(24), "preferred day" - s("sunday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(13), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(70), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(31)])).
car(618, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("NI270"), "year" - i(2005), "month" - i(2), "day" - i(11), "hour" - i(11), "minute" - i(44), "station" - s("Cumberland Farms"), "fill-ups" - i(7), "record history (days)" - i(145), "weekdays" - i(4), "weekends" - i(3), "preferred day" - s("saturday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(289), "standard deviation from mean" - i(334), "different locations" - i(2), "preferred station" - s("Cumberland Farms"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("54VH"), "preferred pump %" - i(28)])).
car(619, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("09TRP"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(19), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(71), "record history (days)" - i(148), "weekdays" - i(56), "weekends" - i(15), "preferred day" - s("monday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(154), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(57)])).
car(620, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("9UVP"), "year" - i(2004), "month" - i(12), "day" - i(1), "hour" - i(8), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(49), "record history (days)" - i(145), "weekdays" - i(40), "weekends" - i(9), "preferred day" - s("thursday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(68), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(44)])).
car(621, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("FPC050"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(12), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(70), "record history (days)" - i(167), "weekdays" - i(43), "weekends" - i(27), "preferred day" - s("sunday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(17), "standard deviation from mean" - i(143), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(71)])).
car(622, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TYC150"), "year" - i(2005), "month" - i(1), "day" - i(30), "hour" - i(20), "minute" - i(19), "station" - s("shell"), "fill-ups" - i(19), "record history (days)" - i(147), "weekdays" - i(7), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(26), "standard deviation from mean" - i(108), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(26)])).
car(623, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RRD150"), "year" - i(2004), "month" - i(7), "day" - i(3), "hour" - i(1), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(64), "record history (days)" - i(113), "weekdays" - i(47), "weekends" - i(17), "preferred day" - s("thursday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(149), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(50)])).
car(624, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("YJO350"), "year" - i(2004), "month" - i(7), "day" - i(24), "hour" - i(2), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(112), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(18), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(100)])).
car(625, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("FBZ450"), "year" - i(2004), "month" - i(10), "day" - i(27), "hour" - i(23), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(8), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(337), "standard deviation from mean" - i(238), "different locations" - i(2), "preferred station" - s("pilot"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(626, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("PRF681"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(219), "record history (days)" - i(154), "weekdays" - i(155), "weekends" - i(64), "preferred day" - s("saturday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(94), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(49)])).
car(627, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("20592QP"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(1), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(148), "weekdays" - i(26), "weekends" - i(3), "preferred day" - s("monday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(32), "standard deviation from mean" - i(168), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(34)])).
car(628, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("QYC091"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(2), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(16), "record history (days)" - i(150), "weekdays" - i(8), "weekends" - i(8), "preferred day" - s("sunday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(93), "standard deviation from mean" - i(336), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(37)])).
car(629, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("OGC532"), "year" - i(2004), "month" - i(8), "day" - i(13), "hour" - i(0), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(36), "record history (days)" - i(101), "weekdays" - i(30), "weekends" - i(6), "preferred day" - s("thursday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(99), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(25)])).
car(630, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LRF097"), "year" - i(2005), "month" - i(1), "day" - i(5), "hour" - i(21), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(95), "weekdays" - i(3), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(21), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(631, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("193INX"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(12), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(148), "weekdays" - i(3), "weekends" - i(3), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(112), "standard deviation from mean" - i(200), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(632, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("JNB427"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(11), "minute" - i(45), "station" - s("shell"), "fill-ups" - i(146), "record history (days)" - i(172), "weekdays" - i(113), "weekends" - i(33), "preferred day" - s("thursday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(57), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(25)])).
car(633, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XGA249"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(0), "minute" - i(51), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(110), "weekdays" - i(4), "weekends" - i(3), "preferred day" - s("monday"), "day preference %" - i(57), "mean time of visit (minutes after midnight)" - i(235), "standard deviation from mean" - i(480), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(57)])).
car(634, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RVD548"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(13), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(39), "record history (days)" - i(172), "weekdays" - i(38), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(35), "standard deviation from mean" - i(204), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(84)])).
car(635, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("Z176"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(12), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(60), "record history (days)" - i(160), "weekdays" - i(45), "weekends" - i(15), "preferred day" - s("monday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(77), "different locations" - i(4), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(25)])).
car(636, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("62HHI"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(8), "minute" - i(55), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(111), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("friday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(306), "standard deviation from mean" - i(216), "different locations" - i(3), "preferred station" - s("Cumberland Farms"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("54VH"), "preferred pump %" - i(50)])).
car(637, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("JXX407"), "year" - i(2005), "month" - i(2), "day" - i(7), "hour" - i(0), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(147), "weekdays" - i(18), "weekends" - i(8), "preferred day" - s("monday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(47), "standard deviation from mean" - i(234), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(19)])).
car(638, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("7488DA"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(21), "minute" - i(48), "station" - s("texaco"), "fill-ups" - i(2), "record history (days)" - i(143), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(523), "standard deviation from mean" - i(371), "different locations" - i(1), "preferred station" - s("texaco"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("07XM"), "preferred pump %" - i(50)])).
car(639, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KCZ712"), "year" - i(2005), "month" - i(2), "day" - i(17), "hour" - i(19), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(55), "record history (days)" - i(131), "weekdays" - i(33), "weekends" - i(22), "preferred day" - s("saturday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(3), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(27)])).
car(640, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("OMX735"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(17), "minute" - i(59), "station" - s("mobil"), "fill-ups" - i(28), "record history (days)" - i(147), "weekdays" - i(23), "weekends" - i(5), "preferred day" - s("thursday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(42), "standard deviation from mean" - i(210), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(21)])).
car(641, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("2346"), "year" - i(2005), "month" - i(2), "day" - i(13), "hour" - i(10), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(151), "weekdays" - i(7), "weekends" - i(4), "preferred day" - s("wednesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(110), "standard deviation from mean" - i(313), "different locations" - i(4), "preferred station" - s("pilot"), "preferred station %" - i(45), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(27)])).
car(642, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("3BMH96"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(19), "minute" - i(26), "station" - s("pilot"), "fill-ups" - i(8), "record history (days)" - i(172), "weekdays" - i(7), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(46), "different locations" - i(2), "preferred station" - s("pilot"), "preferred station %" - i(62), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("27XG"), "preferred pump %" - i(37)])).
car(643, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("1751LR"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(1), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(112), "record history (days)" - i(170), "weekdays" - i(88), "weekends" - i(24), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(30), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(29)])).
car(644, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("R259"), "year" - i(2004), "month" - i(10), "day" - i(19), "hour" - i(0), "minute" - i(7), "station" - s("shell"), "fill-ups" - i(5), "record history (days)" - i(94), "weekdays" - i(3), "weekends" - i(2), "preferred day" - s("wednesday"), "day preference %" - i(60), "mean time of visit (minutes after midnight)" - i(205), "standard deviation from mean" - i(369), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(60)])).
car(645, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("YRC026"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(56), "station" - s("mobil"), "fill-ups" - i(160), "record history (days)" - i(148), "weekdays" - i(110), "weekends" - i(50), "preferred day" - s("saturday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(7), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(59)])).
car(646, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("OIB245"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(7), "minute" - i(30), "station" - s("mobil"), "fill-ups" - i(17), "record history (days)" - i(167), "weekdays" - i(10), "weekends" - i(7), "preferred day" - s("saturday"), "day preference %" - i(35), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(55), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(52), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(29)])).
car(647, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XTX309"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(168), "weekdays" - i(14), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(38), "mean time of visit (minutes after midnight)" - i(36), "standard deviation from mean" - i(178), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(30)])).
car(648, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("YRC786"), "year" - i(2004), "month" - i(10), "day" - i(18), "hour" - i(14), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(86), "record history (days)" - i(152), "weekdays" - i(66), "weekends" - i(20), "preferred day" - s("friday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(150), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(37)])).
car(649, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UUB969"), "year" - i(2005), "month" - i(1), "day" - i(28), "hour" - i(12), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(141), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(2), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(650, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RVD025"), "year" - i(2004), "month" - i(8), "day" - i(27), "hour" - i(17), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(55), "record history (days)" - i(85), "weekdays" - i(46), "weekends" - i(9), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(137), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(56)])).
car(651, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XDQ618"), "year" - i(2004), "month" - i(7), "day" - i(4), "hour" - i(0), "minute" - i(7), "station" - s("shell"), "fill-ups" - i(37), "record history (days)" - i(118), "weekdays" - i(15), "weekends" - i(22), "preferred day" - s("saturday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(172), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(45)])).
car(652, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DQA540"), "year" - i(2005), "month" - i(1), "day" - i(28), "hour" - i(19), "minute" - i(59), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(148), "weekdays" - i(8), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(105), "standard deviation from mean" - i(319), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(72), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(27)])).
car(653, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UF567"), "year" - i(2005), "month" - i(1), "day" - i(20), "hour" - i(15), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(31), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(500), "standard deviation from mean" - i(354), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(654, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("PGB170"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(15), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(35), "record history (days)" - i(131), "weekdays" - i(17), "weekends" - i(18), "preferred day" - s("saturday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(48), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(31)])).
car(655, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("QVD529"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(19), "minute" - i(51), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(147), "weekdays" - i(6), "weekends" - i(6), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(38), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(656, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("2U90F5"), "year" - i(2004), "month" - i(8), "day" - i(28), "hour" - i(14), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(-6), "weekdays" - i(13), "weekends" - i(6), "preferred day" - s("saturday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(62), "standard deviation from mean" - i(256), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(42)])).
car(657, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RVQ866"), "year" - i(2004), "month" - i(12), "day" - i(16), "hour" - i(23), "minute" - i(48), "station" - s("shell"), "fill-ups" - i(14), "record history (days)" - i(143), "weekdays" - i(10), "weekends" - i(4), "preferred day" - s("thursday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(109), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(57), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(42)])).
car(658, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("OYF018"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(22), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(10), "record history (days)" - i(140), "weekdays" - i(4), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(147), "standard deviation from mean" - i(392), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(60)])).
car(659, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("NTW518"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(22), "minute" - i(30), "station" - s("shell"), "fill-ups" - i(8), "record history (days)" - i(146), "weekdays" - i(3), "weekends" - i(5), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(188), "standard deviation from mean" - i(427), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(37)])).
car(660, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("JNB451"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(34), "record history (days)" - i(171), "weekdays" - i(21), "weekends" - i(13), "preferred day" - s("thursday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(87), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(26)])).
car(661, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("7DMH51"), "year" - i(2005), "month" - i(1), "day" - i(14), "hour" - i(14), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(60), "record history (days)" - i(139), "weekdays" - i(48), "weekends" - i(12), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(17), "standard deviation from mean" - i(128), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(40)])).
car(662, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("75AH"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(14), "minute" - i(33), "station" - s("Cumberland Farms"), "fill-ups" - i(64), "record history (days)" - i(160), "weekdays" - i(55), "weekends" - i(9), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(37), "standard deviation from mean" - i(205), "different locations" - i(3), "preferred station" - s("Cumberland Farms"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("54VH"), "preferred pump %" - i(50)])).
car(663, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("10BH"), "year" - i(2005), "month" - i(1), "day" - i(26), "hour" - i(14), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(15), "record history (days)" - i(142), "weekdays" - i(12), "weekends" - i(3), "preferred day" - s("friday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(42), "standard deviation from mean" - i(153), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(40)])).
car(664, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XCD912"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(2), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(47), "record history (days)" - i(167), "weekdays" - i(30), "weekends" - i(17), "preferred day" - s("monday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(13), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(25)])).
car(665, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DEA112"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(105), "record history (days)" - i(172), "weekdays" - i(95), "weekends" - i(10), "preferred day" - s("friday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(65), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(33)])).
car(666, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KUR826"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(20), "minute" - i(4), "station" - s("mobil"), "fill-ups" - i(150), "record history (days)" - i(149), "weekdays" - i(127), "weekends" - i(23), "preferred day" - s("thursday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(96), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(67), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(21)])).
car(667, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("OXD026"), "year" - i(2004), "month" - i(11), "day" - i(28), "hour" - i(19), "minute" - i(0), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(115), "weekdays" - i(0), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(453), "standard deviation from mean" - i(524), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(25)])).
car(668, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("ZKX126"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(7), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(148), "record history (days)" - i(148), "weekdays" - i(110), "weekends" - i(38), "preferred day" - s("friday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(42), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(99), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(41)])).
car(669, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VEC736"), "year" - i(2004), "month" - i(8), "day" - i(3), "hour" - i(10), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(14), "record history (days)" - i(134), "weekdays" - i(9), "weekends" - i(5), "preferred day" - s("tuesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(102), "standard deviation from mean" - i(355), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(50)])).
car(670, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CJC736"), "year" - i(2004), "month" - i(8), "day" - i(29), "hour" - i(0), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(66), "record history (days)" - i(46), "weekdays" - i(51), "weekends" - i(15), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(94), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(36)])).
car(671, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TGZ988"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(16), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(148), "weekdays" - i(24), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(53), "standard deviation from mean" - i(251), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(64)])).
car(672, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("PXD088"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(16), "minute" - i(55), "station" - s("shell"), "fill-ups" - i(5), "record history (days)" - i(143), "weekdays" - i(0), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(80), "mean time of visit (minutes after midnight)" - i(227), "standard deviation from mean" - i(408), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(20)])).
car(673, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("YRC288"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(17), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(77), "record history (days)" - i(160), "weekdays" - i(50), "weekends" - i(27), "preferred day" - s("sunday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(0), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(23)])).
car(674, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RYD288"), "year" - i(2004), "month" - i(10), "day" - i(26), "hour" - i(17), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(15), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(37), "standard deviation from mean" - i(26), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(66)])).
car(675, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RPW688"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(8), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(121), "record history (days)" - i(146), "weekdays" - i(87), "weekends" - i(34), "preferred day" - s("wednesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(53), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(59), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(18)])).
car(676, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KPR298"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(16), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(152), "record history (days)" - i(148), "weekdays" - i(115), "weekends" - i(37), "preferred day" - s("friday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(85), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(94)])).
car(677, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("EGR079"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(22), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(153), "weekdays" - i(11), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(79), "standard deviation from mean" - i(253), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(678, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SAF557"), "year" - i(2004), "month" - i(11), "day" - i(26), "hour" - i(19), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(14), "record history (days)" - i(22), "weekdays" - i(10), "weekends" - i(4), "preferred day" - s("saturday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(95), "standard deviation from mean" - i(333), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(21)])).
car(679, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("5412"), "year" - i(2004), "month" - i(8), "day" - i(16), "hour" - i(23), "minute" - i(20), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(118), "weekdays" - i(5), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(92), "standard deviation from mean" - i(189), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(66)])).
car(680, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("FWT430"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(7), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(10), "record history (days)" - i(135), "weekdays" - i(7), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(53), "standard deviation from mean" - i(151), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(30)])).
car(681, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KVU905"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(8), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(116), "record history (days)" - i(147), "weekdays" - i(107), "weekends" - i(9), "preferred day" - s("tuesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(52), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(39)])).
car(682, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DEA110"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(32), "station" - s("shell"), "fill-ups" - i(51), "record history (days)" - i(151), "weekdays" - i(31), "weekends" - i(20), "preferred day" - s("saturday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(92), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(72), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(23)])).
car(683, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("278TBW"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(23), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(54), "record history (days)" - i(170), "weekdays" - i(35), "weekends" - i(19), "preferred day" - s("monday"), "day preference %" - i(35), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(10), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(55)])).
car(684, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TGZ204"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(53), "record history (days)" - i(148), "weekdays" - i(33), "weekends" - i(20), "preferred day" - s("thursday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(4), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(77), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(37)])).
car(685, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UAX968"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(22), "minute" - i(28), "station" - s("shell"), "fill-ups" - i(20), "record history (days)" - i(177), "weekdays" - i(8), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(63), "standard deviation from mean" - i(270), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(45), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("17YH"), "preferred pump %" - i(20)])).
car(686, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("497PQZ"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(12), "minute" - i(26), "station" - s("mobil"), "fill-ups" - i(68), "record history (days)" - i(147), "weekdays" - i(51), "weekends" - i(17), "preferred day" - s("wednesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(17), "standard deviation from mean" - i(137), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(35)])).
car(687, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("981ON8"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(8), "minute" - i(30), "station" - s("mobil"), "fill-ups" - i(79), "record history (days)" - i(139), "weekdays" - i(56), "weekends" - i(23), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(11), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(27)])).
car(688, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("JJD769"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(20), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(53), "record history (days)" - i(146), "weekdays" - i(52), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(27), "standard deviation from mean" - i(190), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(22)])).
car(689, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CJC869"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(23), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(18), "record history (days)" - i(160), "weekdays" - i(3), "weekends" - i(15), "preferred day" - s("sunday"), "day preference %" - i(44), "mean time of visit (minutes after midnight)" - i(77), "standard deviation from mean" - i(311), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(38)])).
car(690, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("EDD669"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(21), "minute" - i(51), "station" - s("mobil"), "fill-ups" - i(138), "record history (days)" - i(146), "weekdays" - i(101), "weekends" - i(37), "preferred day" - s("saturday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(117), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(23)])).
car(691, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XTX550"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(111), "record history (days)" - i(167), "weekdays" - i(73), "weekends" - i(38), "preferred day" - s("sunday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(10), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(32)])).
car(692, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("495YHQ"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(8), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(160), "record history (days)" - i(172), "weekdays" - i(136), "weekends" - i(24), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(52), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(78), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(29)])).
car(693, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("652PKQ"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(20), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(139), "record history (days)" - i(148), "weekdays" - i(102), "weekends" - i(37), "preferred day" - s("friday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(115), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(39)])).
car(694, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DEA561"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(22), "minute" - i(30), "station" - s("mobil"), "fill-ups" - i(39), "record history (days)" - i(165), "weekdays" - i(24), "weekends" - i(15), "preferred day" - s("monday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(2), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(58)])).
car(695, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("OEC771"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(20), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(166), "weekdays" - i(22), "weekends" - i(9), "preferred day" - s("sunday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(35), "standard deviation from mean" - i(183), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(70), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(19)])).
car(696, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UIW462"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(23), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(16), "record history (days)" - i(161), "weekdays" - i(4), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(56), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(21), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(43)])).
car(697, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("QIV574"), "year" - i(2004), "month" - i(11), "day" - i(6), "hour" - i(0), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(116), "record history (days)" - i(151), "weekdays" - i(94), "weekends" - i(22), "preferred day" - s("tuesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(9), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(85)])).
car(698, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KEB098"), "year" - i(2004), "month" - i(8), "day" - i(3), "hour" - i(0), "minute" - i(1), "station" - s("shell"), "fill-ups" - i(4), "record history (days)" - i(36), "weekdays" - i(2), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(261), "standard deviation from mean" - i(393), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(25)])).
car(699, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("WSN735"), "year" - i(2004), "month" - i(8), "day" - i(29), "hour" - i(10), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(65), "weekdays" - i(3), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(237), "standard deviation from mean" - i(424), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(60)])).
car(700, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("BRU835"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(23), "minute" - i(19), "station" - s("mobil"), "fill-ups" - i(55), "record history (days)" - i(179), "weekdays" - i(37), "weekends" - i(18), "preferred day" - s("saturday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(141), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(701, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RVD035"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(15), "minute" - i(43), "station" - s("shell"), "fill-ups" - i(8), "record history (days)" - i(157), "weekdays" - i(6), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(168), "standard deviation from mean" - i(416), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(37)])).
car(702, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TYF749"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(11), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(177), "record history (days)" - i(172), "weekdays" - i(122), "weekends" - i(55), "preferred day" - s("sunday"), "day preference %" - i(15), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(16), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(19)])).
car(703, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LSQ959"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(23), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(28), "record history (days)" - i(161), "weekdays" - i(18), "weekends" - i(10), "preferred day" - s("monday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(39), "standard deviation from mean" - i(191), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(46)])).
car(704, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("32MJM"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(15), "minute" - i(59), "station" - s("Cumberland Farms"), "fill-ups" - i(14), "record history (days)" - i(139), "weekdays" - i(11), "weekends" - i(3), "preferred day" - s("monday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(297), "standard deviation from mean" - i(446), "different locations" - i(1), "preferred station" - s("Cumberland Farms"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("54VH"), "preferred pump %" - i(64)])).
car(705, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UVZ685"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(12), "minute" - i(45), "station" - s("mobil"), "fill-ups" - i(41), "record history (days)" - i(171), "weekdays" - i(34), "weekends" - i(7), "preferred day" - s("wednesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(18), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(56)])).
car(706, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CNI823"), "year" - i(2004), "month" - i(12), "day" - i(11), "hour" - i(15), "minute" - i(4), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(144), "weekdays" - i(16), "weekends" - i(4), "preferred day" - s("friday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(67), "standard deviation from mean" - i(278), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(30)])).
car(707, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("WV7YX"), "year" - i(2004), "month" - i(10), "day" - i(29), "hour" - i(0), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(41), "standard deviation from mean" - i(0), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(100)])).
car(708, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VNR871"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(2), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(33), "record history (days)" - i(161), "weekdays" - i(22), "weekends" - i(11), "preferred day" - s("sunday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(12), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(27)])).
car(709, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SWF706"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(15), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(130), "weekdays" - i(9), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(82), "standard deviation from mean" - i(248), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(710, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("FPC489"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(7), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(137), "record history (days)" - i(148), "weekdays" - i(109), "weekends" - i(28), "preferred day" - s("tuesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(46), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(40)])).
car(711, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TYC440"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(8), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(138), "record history (days)" - i(148), "weekdays" - i(121), "weekends" - i(17), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(48), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(26)])).
car(712, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RVD812"), "year" - i(2004), "month" - i(6), "day" - i(1), "hour" - i(23), "minute" - i(38), "station" - s("sheetz"), "fill-ups" - i(2), "record history (days)" - i(52), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(67), "standard deviation from mean" - i(47), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("17HH"), "preferred pump %" - i(50)])).
car(713, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SXB047"), "year" - i(2005), "month" - i(2), "day" - i(24), "hour" - i(0), "minute" - i(26), "station" - s("mobil"), "fill-ups" - i(91), "record history (days)" - i(137), "weekdays" - i(65), "weekends" - i(26), "preferred day" - s("saturday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(19), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(53)])).
car(714, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TSS893"), "year" - i(2004), "month" - i(6), "day" - i(9), "hour" - i(0), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(35), "record history (days)" - i(96), "weekdays" - i(32), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(37), "standard deviation from mean" - i(218), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(31)])).
car(715, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TYC752"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(2), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(73), "record history (days)" - i(146), "weekdays" - i(63), "weekends" - i(10), "preferred day" - s("tuesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(155), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(27)])).
car(716, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("743QHU"), "year" - i(2004), "month" - i(5), "day" - i(27), "hour" - i(9), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(79), "weekdays" - i(5), "weekends" - i(8), "preferred day" - s("saturday"), "day preference %" - i(46), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(49), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(15), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(84)])).
car(717, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TGZ211"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(68), "record history (days)" - i(171), "weekdays" - i(45), "weekends" - i(23), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(5), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(27)])).
car(718, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VRB721"), "year" - i(2005), "month" - i(2), "day" - i(22), "hour" - i(7), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(108), "record history (days)" - i(135), "weekdays" - i(100), "weekends" - i(8), "preferred day" - s("friday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(48), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(71)])).
car(719, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("YX9AROO"), "year" - i(2005), "month" - i(1), "day" - i(26), "hour" - i(10), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(10), "record history (days)" - i(133), "weekdays" - i(6), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(60), "standard deviation from mean" - i(161), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(80)])).
car(720, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UGD805"), "year" - i(2005), "month" - i(1), "day" - i(22), "hour" - i(16), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(56), "record history (days)" - i(74), "weekdays" - i(38), "weekends" - i(18), "preferred day" - s("tuesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(84), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(67)])).
car(721, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RRD718"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(0), "minute" - i(30), "station" - s("mobil"), "fill-ups" - i(117), "record history (days)" - i(148), "weekdays" - i(82), "weekends" - i(35), "preferred day" - s("sunday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(16), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(29)])).
car(722, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XDT589"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(16), "minute" - i(7), "station" - s("shell"), "fill-ups" - i(123), "record history (days)" - i(171), "weekdays" - i(82), "weekends" - i(41), "preferred day" - s("monday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(84), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(89), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(24)])).
car(723, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("FPC689"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(23), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(148), "record history (days)" - i(146), "weekdays" - i(102), "weekends" - i(46), "preferred day" - s("monday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(2), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(26)])).
car(724, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("NWA799"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(8), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(103), "record history (days)" - i(145), "weekdays" - i(86), "weekends" - i(17), "preferred day" - s("thursday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(54), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(99), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(73)])).
car(725, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("AF099"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(14), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(167), "weekdays" - i(15), "weekends" - i(5), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(64), "standard deviation from mean" - i(274), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(15), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(45)])).
car(726, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SYQ299"), "year" - i(2005), "month" - i(2), "day" - i(24), "hour" - i(8), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(107), "record history (days)" - i(161), "weekdays" - i(83), "weekends" - i(24), "preferred day" - s("wednesday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(53), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(22)])).
car(727, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("OMX659"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(20), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(46), "record history (days)" - i(162), "weekdays" - i(25), "weekends" - i(21), "preferred day" - s("sunday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(150), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(89), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(28)])).
car(728, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("WTA978"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(98), "record history (days)" - i(148), "weekdays" - i(81), "weekends" - i(17), "preferred day" - s("friday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(61), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(35)])).
car(729, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("BVC597"), "year" - i(2005), "month" - i(2), "day" - i(16), "hour" - i(21), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(55), "record history (days)" - i(148), "weekdays" - i(35), "weekends" - i(20), "preferred day" - s("monday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(7), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(36)])).
car(730, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("OB7W"), "year" - i(2004), "month" - i(6), "day" - i(17), "hour" - i(16), "minute" - i(14), "station" - s("pilot"), "fill-ups" - i(2), "record history (days)" - i(55), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(727), "standard deviation from mean" - i(0), "different locations" - i(2), "preferred station" - s("pilot"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(50)])).
car(731, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UUB628"), "year" - i(2004), "month" - i(12), "day" - i(24), "hour" - i(12), "minute" - i(17), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(145), "weekdays" - i(15), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(61), "standard deviation from mean" - i(238), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(42)])).
car(732, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CNI489"), "year" - i(2004), "month" - i(12), "day" - i(26), "hour" - i(18), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(109), "weekdays" - i(8), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(90), "standard deviation from mean" - i(257), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(100)])).
car(733, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("BED044"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(7), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(101), "record history (days)" - i(148), "weekdays" - i(84), "weekends" - i(17), "preferred day" - s("friday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(48), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(69)])).
car(734, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("HDC754"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(13), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(107), "record history (days)" - i(170), "weekdays" - i(92), "weekends" - i(15), "preferred day" - s("thursday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(56), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(41)])).
car(735, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LYB167"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(19), "minute" - i(36), "station" - s("shell"), "fill-ups" - i(11), "record history (days)" - i(146), "weekdays" - i(3), "weekends" - i(8), "preferred day" - s("sunday"), "day preference %" - i(54), "mean time of visit (minutes after midnight)" - i(103), "standard deviation from mean" - i(296), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(72), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(36)])).
car(736, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SSU367"), "year" - i(2004), "month" - i(7), "day" - i(1), "hour" - i(17), "minute" - i(34), "station" - s("Cumberland Farms"), "fill-ups" - i(5), "record history (days)" - i(66), "weekdays" - i(5), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(264), "standard deviation from mean" - i(473), "different locations" - i(3), "preferred station" - s("shell"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(40)])).
car(737, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("QXD667"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(18), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(14), "record history (days)" - i(163), "weekdays" - i(12), "weekends" - i(2), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(65), "standard deviation from mean" - i(228), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(64)])).
car(738, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KOD477"), "year" - i(2005), "month" - i(1), "day" - i(17), "hour" - i(18), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(64), "record history (days)" - i(142), "weekdays" - i(57), "weekends" - i(7), "preferred day" - s("friday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(21), "standard deviation from mean" - i(156), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(37)])).
car(739, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LYX577"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(21), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(94), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(475), "standard deviation from mean" - i(549), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(33)])).
car(740, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CKA887"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(15), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(42), "record history (days)" - i(161), "weekdays" - i(28), "weekends" - i(14), "preferred day" - s("friday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(20), "standard deviation from mean" - i(131), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(21)])).
car(741, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("BSF087"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(16), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(143), "weekdays" - i(5), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(44), "mean time of visit (minutes after midnight)" - i(126), "standard deviation from mean" - i(337), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(742, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("HDW187"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(21), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(47), "record history (days)" - i(142), "weekdays" - i(29), "weekends" - i(18), "preferred day" - s("monday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(204), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(27)])).
car(743, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("QBC287"), "year" - i(2004), "month" - i(4), "day" - i(6), "hour" - i(18), "minute" - i(45), "station" - s("shell"), "fill-ups" - i(2), "record history (days)" - i(5), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(572), "standard deviation from mean" - i(404), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(50)])).
car(744, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LRF587"), "year" - i(2005), "month" - i(1), "day" - i(15), "hour" - i(17), "minute" - i(2), "station" - s("Cumberland Farms"), "fill-ups" - i(12), "record history (days)" - i(126), "weekdays" - i(8), "weekends" - i(4), "preferred day" - s("saturday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(19), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(745, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SYD797"), "year" - i(2004), "month" - i(11), "day" - i(29), "hour" - i(16), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(56), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(557), "standard deviation from mean" - i(394), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(50)])).
car(746, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("NWA205"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(8), "minute" - i(39), "station" - s("shell"), "fill-ups" - i(106), "record history (days)" - i(148), "weekdays" - i(97), "weekends" - i(9), "preferred day" - s("wednesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(55), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(55), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(24)])).
car(747, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RVZ305"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(15), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(38), "record history (days)" - i(145), "weekdays" - i(35), "weekends" - i(3), "preferred day" - s("monday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(125), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(21)])).
car(748, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LRF315"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(20), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(101), "record history (days)" - i(143), "weekdays" - i(73), "weekends" - i(28), "preferred day" - s("tuesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(93), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(28)])).
car(749, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("FDC497"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(78), "record history (days)" - i(171), "weekdays" - i(32), "weekends" - i(46), "preferred day" - s("sunday"), "day preference %" - i(42), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(3), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(56)])).
car(750, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("PVF829"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(14), "minute" - i(30), "station" - s("mobil"), "fill-ups" - i(99), "record history (days)" - i(148), "weekdays" - i(77), "weekends" - i(22), "preferred day" - s("thursday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(6), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(69), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(44)])).
car(751, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TJF629"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(16), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(105), "record history (days)" - i(97), "weekdays" - i(80), "weekends" - i(25), "preferred day" - s("friday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(100), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(99), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(23)])).
car(752, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SXB039"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(22), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(63), "record history (days)" - i(162), "weekdays" - i(28), "weekends" - i(35), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(28), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(58)])).
car(753, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("289RGW"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(0), "minute" - i(0), "station" - s("mobil"), "fill-ups" - i(18), "record history (days)" - i(141), "weekdays" - i(11), "weekends" - i(7), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(15), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(27)])).
car(754, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RYS978"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(1), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(43), "record history (days)" - i(167), "weekdays" - i(28), "weekends" - i(15), "preferred day" - s("saturday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(7), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(39)])).
car(755, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("WSA078"), "year" - i(2005), "month" - i(1), "day" - i(9), "hour" - i(3), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(129), "weekdays" - i(2), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(22), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(50)])).
car(756, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VWA533"), "year" - i(2004), "month" - i(10), "day" - i(1), "hour" - i(10), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(56), "record history (days)" - i(151), "weekdays" - i(45), "weekends" - i(11), "preferred day" - s("wednesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(17), "standard deviation from mean" - i(131), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(25)])).
car(757, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("BXW253"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(1), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(140), "weekdays" - i(6), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(42), "mean time of visit (minutes after midnight)" - i(183), "standard deviation from mean" - i(375), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(42)])).
car(758, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("484WAA"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(21), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(105), "record history (days)" - i(148), "weekdays" - i(80), "weekends" - i(25), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(1), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(50)])).
car(759, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TGZ948"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(10), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(142), "record history (days)" - i(172), "weekdays" - i(114), "weekends" - i(28), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(57), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(89), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(19)])).
car(760, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("901ITQ"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(10), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(128), "record history (days)" - i(149), "weekdays" - i(88), "weekends" - i(40), "preferred day" - s("friday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(100), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(66)])).
car(761, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("NNA319"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(17), "minute" - i(0), "station" - s("mobil"), "fill-ups" - i(121), "record history (days)" - i(146), "weekdays" - i(77), "weekends" - i(44), "preferred day" - s("sunday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(12), "standard deviation from mean" - i(129), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(23)])).
car(762, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UED485"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(14), "minute" - i(45), "station" - s("mobil"), "fill-ups" - i(10), "record history (days)" - i(134), "weekdays" - i(2), "weekends" - i(8), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(112), "standard deviation from mean" - i(300), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(30)])).
car(763, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TYC722"), "year" - i(2005), "month" - i(1), "day" - i(31), "hour" - i(18), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(50), "record history (days)" - i(148), "weekdays" - i(40), "weekends" - i(10), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(131), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(22)])).
car(764, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RYS148"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(13), "minute" - i(0), "station" - s("shell"), "fill-ups" - i(106), "record history (days)" - i(148), "weekdays" - i(74), "weekends" - i(32), "preferred day" - s("monday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(98), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(99), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(28)])).
car(765, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RVD099"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(8), "minute" - i(41), "station" - s("shell"), "fill-ups" - i(118), "record history (days)" - i(148), "weekdays" - i(104), "weekends" - i(14), "preferred day" - s("friday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(51), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(32)])).
car(766, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("YSD976"), "year" - i(2005), "month" - i(2), "day" - i(17), "hour" - i(3), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(93), "record history (days)" - i(148), "weekdays" - i(73), "weekends" - i(20), "preferred day" - s("thursday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(35), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(87)])).
car(767, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("WGT246"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(23), "minute" - i(44), "station" - s("shell"), "fill-ups" - i(14), "record history (days)" - i(167), "weekdays" - i(10), "weekends" - i(4), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(85), "standard deviation from mean" - i(296), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(57), "% pay cashier (instead of at pump)" - i(28), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(21)])).
car(768, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CNI407"), "year" - i(2005), "month" - i(2), "day" - i(11), "hour" - i(12), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(143), "weekdays" - i(14), "weekends" - i(8), "preferred day" - s("friday"), "day preference %" - i(45), "mean time of visit (minutes after midnight)" - i(48), "standard deviation from mean" - i(196), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(72), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(63)])).
car(769, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("278QRX"), "year" - i(2004), "month" - i(11), "day" - i(15), "hour" - i(16), "minute" - i(40), "station" - s("mobil"), "fill-ups" - i(55), "record history (days)" - i(148), "weekdays" - i(47), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(106), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(30)])).
car(770, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("PTS009"), "year" - i(2005), "month" - i(2), "day" - i(10), "hour" - i(14), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(15), "record history (days)" - i(135), "weekdays" - i(10), "weekends" - i(5), "preferred day" - s("saturday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(46), "standard deviation from mean" - i(167), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(33)])).
car(771, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DPA787"), "year" - i(2004), "month" - i(8), "day" - i(5), "hour" - i(18), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(137), "record history (days)" - i(154), "weekdays" - i(108), "weekends" - i(29), "preferred day" - s("friday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(118), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(36)])).
car(772, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DKZ216"), "year" - i(2004), "month" - i(8), "day" - i(27), "hour" - i(8), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(88), "record history (days)" - i(144), "weekdays" - i(87), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(51), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(54)])).
car(773, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("OYF678"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(11), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(154), "record history (days)" - i(165), "weekdays" - i(112), "weekends" - i(42), "preferred day" - s("saturday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(51), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(23)])).
car(774, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("964SDS"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(19), "minute" - i(51), "station" - s("mobil"), "fill-ups" - i(143), "record history (days)" - i(148), "weekdays" - i(129), "weekends" - i(14), "preferred day" - s("thursday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(111), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(69)])).
car(775, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CKA956"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(23), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(162), "weekdays" - i(23), "weekends" - i(8), "preferred day" - s("monday"), "day preference %" - i(38), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(7), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(22)])).
car(776, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("OWR463"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(22), "minute" - i(23), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(160), "weekdays" - i(14), "weekends" - i(6), "preferred day" - s("tuesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(5), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(777, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DOD443"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(13), "station" - s("shell"), "fill-ups" - i(90), "record history (days)" - i(143), "weekdays" - i(77), "weekends" - i(13), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(65), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(31)])).
car(778, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RVD368"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(0), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(58), "record history (days)" - i(146), "weekdays" - i(31), "weekends" - i(27), "preferred day" - s("saturday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(34), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(27)])).
car(779, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("HVT042"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(23), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(46), "record history (days)" - i(143), "weekdays" - i(29), "weekends" - i(17), "preferred day" - s("sunday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(185), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(54)])).
car(780, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("873HGU"), "year" - i(2005), "month" - i(1), "day" - i(23), "hour" - i(16), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(146), "weekdays" - i(10), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(38), "mean time of visit (minutes after midnight)" - i(115), "standard deviation from mean" - i(348), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(69), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(23)])).
car(781, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("QQH5QZ"), "year" - i(2005), "month" - i(2), "day" - i(16), "hour" - i(21), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(145), "weekdays" - i(3), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(352), "standard deviation from mean" - i(528), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(75)])).
car(782, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("0660Y"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(4), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(21), "record history (days)" - i(147), "weekdays" - i(6), "weekends" - i(15), "preferred day" - s("sunday"), "day preference %" - i(38), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(82), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(42)])).
car(783, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("17178A"), "year" - i(2004), "month" - i(8), "day" - i(22), "hour" - i(9), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(98), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(668), "standard deviation from mean" - i(472), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(50)])).
car(784, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("706UYY"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(40), "station" - s("shell"), "fill-ups" - i(92), "record history (days)" - i(172), "weekdays" - i(66), "weekends" - i(26), "preferred day" - s("thursday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(106), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(30)])).
car(785, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DNI043"), "year" - i(2005), "month" - i(2), "day" - i(17), "hour" - i(10), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(148), "weekdays" - i(7), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(172), "standard deviation from mean" - i(391), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(28), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(71)])).
car(786, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TGZ872"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(9), "minute" - i(21), "station" - s("shell"), "fill-ups" - i(24), "record history (days)" - i(163), "weekdays" - i(14), "weekends" - i(10), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(25), "standard deviation from mean" - i(120), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(70), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(29)])).
car(787, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("90RCO9"), "year" - i(2004), "month" - i(11), "day" - i(19), "hour" - i(14), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(105), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(540), "standard deviation from mean" - i(382), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(50)])).
car(788, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("JXX309"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(22), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(42), "record history (days)" - i(167), "weekdays" - i(28), "weekends" - i(14), "preferred day" - s("sunday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(12), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(789, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LYB394"), "year" - i(2004), "month" - i(7), "day" - i(29), "hour" - i(4), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(147), "weekdays" - i(6), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(44), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(64), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(88)])).
car(790, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KVA904"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(6), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(158), "record history (days)" - i(149), "weekdays" - i(114), "weekends" - i(44), "preferred day" - s("monday"), "day preference %" - i(15), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(14), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(49)])).
car(791, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XCZ772"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(22), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(46), "record history (days)" - i(160), "weekdays" - i(30), "weekends" - i(16), "preferred day" - s("monday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(89), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(43)])).
car(792, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TYC272"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(11), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(51), "record history (days)" - i(145), "weekdays" - i(44), "weekends" - i(7), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(111), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(47)])).
car(793, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KIB702"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(19), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(102), "record history (days)" - i(148), "weekdays" - i(93), "weekends" - i(9), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(12), "standard deviation from mean" - i(123), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(25)])).
car(794, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KCZ902"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(10), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(153), "record history (days)" - i(167), "weekdays" - i(118), "weekends" - i(35), "preferred day" - s("wednesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(58), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(99), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(45)])).
car(795, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XTX102"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(10), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(119), "record history (days)" - i(169), "weekdays" - i(91), "weekends" - i(28), "preferred day" - s("saturday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(51), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(29)])).
car(796, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XTX602"), "year" - i(2004), "month" - i(11), "day" - i(29), "hour" - i(0), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(10), "record history (days)" - i(142), "weekdays" - i(7), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(144), "standard deviation from mean" - i(385), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(20)])).
car(797, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("FDC786"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(22), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(51), "record history (days)" - i(163), "weekdays" - i(37), "weekends" - i(14), "preferred day" - s("friday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(7), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(29)])).
car(798, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("HMU086"), "year" - i(2004), "month" - i(12), "day" - i(8), "hour" - i(23), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(27), "record history (days)" - i(147), "weekdays" - i(25), "weekends" - i(2), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(47), "standard deviation from mean" - i(232), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(29)])).
car(799, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TJF386"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(21), "minute" - i(24), "station" - s("shell"), "fill-ups" - i(9), "record history (days)" - i(110), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(55), "mean time of visit (minutes after midnight)" - i(122), "standard deviation from mean" - i(325), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(77), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(22)])).
car(800, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("TYC520"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(88), "record history (days)" - i(138), "weekdays" - i(73), "weekends" - i(15), "preferred day" - s("wednesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(122), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(32)])).
car(801, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("9N620"), "year" - i(2004), "month" - i(9), "day" - i(27), "hour" - i(18), "minute" - i(18), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(106), "weekdays" - i(5), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(180), "standard deviation from mean" - i(369), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(50)])).
car(802, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("MM336"), "year" - i(2004), "month" - i(12), "day" - i(25), "hour" - i(0), "minute" - i(26), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(121), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(463), "standard deviation from mean" - i(536), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(66)])).
car(803, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("LRF436"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(21), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(193), "record history (days)" - i(148), "weekdays" - i(142), "weekends" - i(51), "preferred day" - s("monday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(98), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(26)])).
car(804, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("FPC046"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(13), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(250), "record history (days)" - i(137), "weekdays" - i(175), "weekends" - i(75), "preferred day" - s("saturday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(59), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(99), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(64)])).
car(805, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("NGS889"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(89), "record history (days)" - i(169), "weekdays" - i(58), "weekends" - i(31), "preferred day" - s("sunday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(143), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(69)])).
car(806, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("QCQ989"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(20), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(8), "record history (days)" - i(128), "weekdays" - i(6), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(163), "standard deviation from mean" - i(406), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(62)])).
car(807, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RVD799"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(3), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(125), "record history (days)" - i(172), "weekdays" - i(79), "weekends" - i(46), "preferred day" - s("sunday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(123), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(55)])).
car(808, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VMH28"), "year" - i(2004), "month" - i(12), "day" - i(15), "hour" - i(10), "minute" - i(33), "station" - s("Cumberland Farms"), "fill-ups" - i(3), "record history (days)" - i(148), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(771), "standard deviation from mean" - i(0), "different locations" - i(3), "preferred station" - s("pilot"), "preferred station %" - i(33), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("97HH"), "preferred pump %" - i(33)])).
car(809, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("5484DA"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(14), "minute" - i(16), "station" - s("shell"), "fill-ups" - i(4), "record history (days)" - i(148), "weekdays" - i(3), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(190), "standard deviation from mean" - i(285), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(810, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UNI155"), "year" - i(2004), "month" - i(7), "day" - i(16), "hour" - i(16), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(122), "weekdays" - i(6), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(193), "standard deviation from mean" - i(224), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(33)])).
car(811, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("JTF267"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(0), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(43), "record history (days)" - i(146), "weekdays" - i(28), "weekends" - i(15), "preferred day" - s("saturday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(6), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(76), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(23)])).
car(812, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RVD128"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(49), "weekdays" - i(1), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(75), "mean time of visit (minutes after midnight)" - i(226), "standard deviation from mean" - i(340), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(25)])).
car(813, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KTC688"), "year" - i(2004), "month" - i(11), "day" - i(2), "hour" - i(19), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(145), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(393), "standard deviation from mean" - i(454), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(33)])).
car(814, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("UGD770"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(53), "station" - s("shell"), "fill-ups" - i(135), "record history (days)" - i(169), "weekdays" - i(105), "weekends" - i(30), "preferred day" - s("thursday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(79), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(57), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(19)])).
car(815, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("VRB070"), "year" - i(2004), "month" - i(4), "day" - i(8), "hour" - i(18), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(34), "weekdays" - i(6), "weekends" - i(0), "preferred day" - s("friday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(226), "standard deviation from mean" - i(461), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(66)])).
car(816, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("CGI070"), "year" - i(2005), "month" - i(1), "day" - i(12), "hour" - i(23), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(39), "record history (days)" - i(143), "weekdays" - i(31), "weekends" - i(8), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(36), "standard deviation from mean" - i(209), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(30)])).
car(817, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XTX270"), "year" - i(2004), "month" - i(12), "day" - i(29), "hour" - i(20), "minute" - i(40), "station" - s("mobil"), "fill-ups" - i(44), "record history (days)" - i(146), "weekdays" - i(35), "weekends" - i(9), "preferred day" - s("thursday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(17), "standard deviation from mean" - i(113), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(72), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(43)])).
car(818, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("ZKQ570"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(18), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(108), "record history (days)" - i(147), "weekdays" - i(91), "weekends" - i(17), "preferred day" - s("friday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(115), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(99), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(26)])).
car(819, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("JNB980"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(20), "minute" - i(8), "station" - s("shell"), "fill-ups" - i(68), "record history (days)" - i(156), "weekdays" - i(42), "weekends" - i(26), "preferred day" - s("saturday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(20), "standard deviation from mean" - i(161), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(38)])).
car(820, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DOD834"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(16), "minute" - i(55), "station" - s("mobil"), "fill-ups" - i(16), "record history (days)" - i(161), "weekdays" - i(13), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(43), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(0), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(31)])).
car(821, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("XCD934"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(20), "minute" - i(4), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(160), "weekdays" - i(17), "weekends" - i(9), "preferred day" - s("sunday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(55), "standard deviation from mean" - i(264), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(96)])).
car(822, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("BAS844"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(7), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(128), "record history (days)" - i(148), "weekdays" - i(113), "weekends" - i(15), "preferred day" - s("thursday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(46), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(40)])).
car(823, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("RYS713"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(20), "minute" - i(3), "station" - s("shell"), "fill-ups" - i(58), "record history (days)" - i(163), "weekdays" - i(41), "weekends" - i(17), "preferred day" - s("tuesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(102), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(32)])).
car(824, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("JBZ513"), "year" - i(2004), "month" - i(12), "day" - i(25), "hour" - i(21), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(533), "standard deviation from mean" - i(378), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(50)])).
car(825, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("497N"), "year" - i(2004), "month" - i(3), "day" - i(12), "hour" - i(10), "minute" - i(19), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(4), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(619), "standard deviation from mean" - i(0), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("54VH"), "preferred pump %" - i(50)])).
car(826, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("ZAZWFW"), "year" - i(2004), "month" - i(12), "day" - i(31), "hour" - i(22), "minute" - i(13), "station" - s("shell"), "fill-ups" - i(9), "record history (days)" - i(149), "weekdays" - i(5), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(44), "mean time of visit (minutes after midnight)" - i(38), "standard deviation from mean" - i(102), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(77), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(827, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("EJU378"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(21), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(171), "weekdays" - i(14), "weekends" - i(5), "preferred day" - s("monday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(8), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(21)])).
car(828, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("892RUZ"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(17), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(28), "record history (days)" - i(167), "weekdays" - i(18), "weekends" - i(10), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(55), "standard deviation from mean" - i(270), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(42)])).
car(829, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("974GTY"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(8), "minute" - i(59), "station" - s("shell"), "fill-ups" - i(57), "record history (days)" - i(147), "weekdays" - i(47), "weekends" - i(10), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(81), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(29)])).
car(830, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("SDZ450"), "year" - i(2004), "month" - i(12), "day" - i(9), "hour" - i(14), "minute" - i(55), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(143), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(69), "standard deviation from mean" - i(80), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(66)])).
car(831, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("6847P8"), "year" - i(2004), "month" - i(4), "day" - i(9), "hour" - i(0), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(21), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(387), "standard deviation from mean" - i(274), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(832, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("KUR299"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(0), "minute" - i(18), "station" - s("mobil"), "fill-ups" - i(64), "record history (days)" - i(147), "weekdays" - i(49), "weekends" - i(15), "preferred day" - s("wednesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(23), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(64)])).
car(833, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("HUW948"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(16), "minute" - i(56), "station" - s("mobil"), "fill-ups" - i(45), "record history (days)" - i(147), "weekdays" - i(41), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(26), "standard deviation from mean" - i(166), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(35)])).
car(834, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("BVC639"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(17), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(33), "record history (days)" - i(142), "weekdays" - i(24), "weekends" - i(9), "preferred day" - s("friday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(176), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(93)])).
car(835, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("NGS557"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(8), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(39), "record history (days)" - i(156), "weekdays" - i(30), "weekends" - i(9), "preferred day" - s("wednesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(90), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(61)])).
car(836, class("fill up only"), attributes(["state/province" - s("AZ"), "tag" - s("DEA081"), "year" - i(2005), "month" - i(2), "day" - i(8), "hour" - i(12), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(133), "weekdays" - i(4), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(141), "standard deviation from mean" - i(252), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(40)])).
car(837, class("fill up only"), attributes(["state/province" - s("CA"), "tag" - s("05413J1"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(20), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(77), "record history (days)" - i(149), "weekdays" - i(73), "weekends" - i(4), "preferred day" - s("thursday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(142), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(40)])).
car(838, class("fill up only"), attributes(["state/province" - s("CA"), "tag" - s("61185DP"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(15), "minute" - i(7), "station" - s("shell"), "fill-ups" - i(15), "record history (days)" - i(50), "weekdays" - i(10), "weekends" - i(5), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(21), "standard deviation from mean" - i(80), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(53), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(20)])).
car(839, class("fill up only"), attributes(["state/province" - s("CA"), "tag" - s("441IGS0"), "year" - i(2004), "month" - i(7), "day" - i(8), "hour" - i(21), "minute" - i(59), "station" - s("shell"), "fill-ups" - i(3), "record history (days)" - i(45), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(436), "standard deviation from mean" - i(504), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(33), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("97HH"), "preferred pump %" - i(33)])).
car(840, class("fill up only"), attributes(["state/province" - s("CA"), "tag" - s("113SIV0"), "year" - i(2005), "month" - i(1), "day" - i(6), "hour" - i(0), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(26), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(131), "standard deviation from mean" - i(151), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(66)])).
car(841, class("fill up only"), attributes(["state/province" - s("CA"), "tag" - s("92606O9"), "year" - i(2004), "month" - i(11), "day" - i(24), "hour" - i(11), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(63), "record history (days)" - i(82), "weekdays" - i(51), "weekends" - i(12), "preferred day" - s("tuesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(138), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(58), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(19)])).
car(842, class("fill up only"), attributes(["state/province" - s("CA"), "tag" - s("695MXX0"), "year" - i(2004), "month" - i(12), "day" - i(7), "hour" - i(20), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(57), "weekdays" - i(5), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(190), "standard deviation from mean" - i(341), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(60), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(83)])).
car(843, class("fill up only"), attributes(["state/province" - s("CA"), "tag" - s("760HVZ8"), "year" - i(2005), "month" - i(1), "day" - i(15), "hour" - i(17), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(49), "weekdays" - i(3), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(418), "standard deviation from mean" - i(483), "different locations" - i(2), "preferred station" - s("exxon"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("90NL"), "preferred pump %" - i(40)])).
car(844, class("fill up only"), attributes(["state/province" - s("IN"), "tag" - s("259326"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(14), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(10), "record history (days)" - i(32), "weekdays" - i(8), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(126), "standard deviation from mean" - i(359), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(30)])).
car(845, class("additional purchases"), attributes(["state/province" - s("OR"), "tag" - s("614NXM"), "year" - i(2005), "month" - i(1), "day" - i(3), "hour" - i(14), "minute" - i(53), "station" - s("shell"), "fill-ups" - i(2), "record history (days)" - i(142), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(489), "standard deviation from mean" - i(346), "different locations" - i(1), "preferred station" - s("shell"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(100)])).
car(846, class("additional purchases"), attributes(["state/province" - s("BC"), "tag" - s("SYZ603"), "year" - i(2004), "month" - i(4), "day" - i(24), "hour" - i(13), "minute" - i(38), "station" - s("wawa03"), "fill-ups" - i(2), "record history (days)" - i(2), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(371), "standard deviation from mean" - i(262), "different locations" - i(2), "preferred station" - s("wawa03"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("07UL"), "preferred pump %" - i(50)])).
car(847, class("additional purchases"), attributes(["state/province" - s("BC"), "tag" - s("FWT962"), "year" - i(2004), "month" - i(7), "day" - i(3), "hour" - i(21), "minute" - i(57), "station" - s("wawa03"), "fill-ups" - i(3), "record history (days)" - i(95), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(460), "standard deviation from mean" - i(532), "different locations" - i(1), "preferred station" - s("wawa03"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("27UL"), "preferred pump %" - i(66)])).
car(848, class("additional purchases"), attributes(["state/province" - s("BC"), "tag" - s("967PLQ"), "year" - i(2004), "month" - i(11), "day" - i(20), "hour" - i(13), "minute" - i(38), "station" - s("wawa05"), "fill-ups" - i(4), "record history (days)" - i(148), "weekdays" - i(1), "weekends" - i(3), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(237), "standard deviation from mean" - i(355), "different locations" - i(3), "preferred station" - s("wawa02"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("07UL"), "preferred pump %" - i(25)])).
car(849, class("additional purchases"), attributes(["state/province" - s("BC"), "tag" - s("46242C"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(20), "minute" - i(9), "station" - s("wawa07"), "fill-ups" - i(8), "record history (days)" - i(126), "weekdays" - i(8), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(62), "mean time of visit (minutes after midnight)" - i(118), "standard deviation from mean" - i(293), "different locations" - i(4), "preferred station" - s("wawa04"), "preferred station %" - i(37), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("37EK"), "preferred pump %" - i(25)])).
car(850, class("additional purchases"), attributes(["state/province" - s("BC"), "tag" - s("161GKS"), "year" - i(2004), "month" - i(6), "day" - i(18), "hour" - i(21), "minute" - i(54), "station" - s("wawa07"), "fill-ups" - i(15), "record history (days)" - i(100), "weekdays" - i(12), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(84), "standard deviation from mean" - i(305), "different locations" - i(2), "preferred station" - s("wawa07"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("97ZL"), "preferred pump %" - i(93)])).
car(851, class("additional purchases"), attributes(["state/province" - s("BC"), "tag" - s("73813C"), "year" - i(2005), "month" - i(1), "day" - i(27), "hour" - i(15), "minute" - i(56), "station" - s("wawa08"), "fill-ups" - i(4), "record history (days)" - i(6), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(150), "standard deviation from mean" - i(225), "different locations" - i(1), "preferred station" - s("wawa08"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("57R:"), "preferred pump %" - i(75)])).
car(852, class("additional purchases"), attributes(["state/province" - s("UT"), "tag" - s("JMC349"), "year" - i(2005), "month" - i(1), "day" - i(28), "hour" - i(22), "minute" - i(56), "station" - s("pilot"), "fill-ups" - i(3), "record history (days)" - i(109), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(113), "standard deviation from mean" - i(130), "different locations" - i(1), "preferred station" - s("pilot"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("47XG"), "preferred pump %" - i(33)])).
car(853, class("additional purchases"), attributes(["state/province" - s("NC"), "tag" - s("1539LNE"), "year" - i(2004), "month" - i(10), "day" - i(15), "hour" - i(4), "minute" - i(5), "station" - s("getty13"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(106), "standard deviation from mean" - i(75), "different locations" - i(1), "preferred station" - s("getty13"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("97IH"), "preferred pump %" - i(100)])).
car(854, class("additional purchases"), attributes(["state/province" - s("FL"), "tag" - s("KI1VG"), "year" - i(2004), "month" - i(11), "day" - i(3), "hour" - i(7), "minute" - i(34), "station" - s("getty17"), "fill-ups" - i(2), "record history (days)" - i(10), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(260), "standard deviation from mean" - i(185), "different locations" - i(2), "preferred station" - s("getty"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("17UH"), "preferred pump %" - i(50)])).
car(855, class("additional purchases"), attributes(["state/province" - s("VA"), "tag" - s("NLWKJHSG"), "year" - i(2005), "month" - i(2), "day" - i(2), "hour" - i(17), "minute" - i(6), "station" - s("wawa11"), "fill-ups" - i(9), "record history (days)" - i(49), "weekdays" - i(8), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(55), "mean time of visit (minutes after midnight)" - i(86), "standard deviation from mean" - i(232), "different locations" - i(3), "preferred station" - s("wawa11"), "preferred station %" - i(55), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("97F/"), "preferred pump %" - i(55)])).
car(856, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("107BYS"), "year" - i(2004), "month" - i(10), "day" - i(8), "hour" - i(12), "minute" - i(0), "station" - s("texaco3"), "fill-ups" - i(7), "record history (days)" - i(46), "weekdays" - i(4), "weekends" - i(3), "preferred day" - s("saturday"), "day preference %" - i(42), "mean time of visit (minutes after midnight)" - i(103), "standard deviation from mean" - i(235), "different locations" - i(1), "preferred station" - s("texaco3"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(42), "payment method" - s("credit"), "preferred pump" - s("07KA"), "preferred pump %" - i(85)])).
car(857, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("5886"), "year" - i(2005), "month" - i(2), "day" - i(3), "hour" - i(17), "minute" - i(56), "station" - s("7-Eleven"), "fill-ups" - i(5), "record history (days)" - i(158), "weekdays" - i(3), "weekends" - i(2), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(133), "standard deviation from mean" - i(238), "different locations" - i(2), "preferred station" - s("7-Eleven"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("97HI"), "preferred pump %" - i(40)])).
car(858, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("337VBT"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(23), "minute" - i(32), "station" - s("texaco3"), "fill-ups" - i(10), "record history (days)" - i(94), "weekdays" - i(6), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(43), "standard deviation from mean" - i(123), "different locations" - i(1), "preferred station" - s("texaco3"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("07KA"), "preferred pump %" - i(100)])).
car(859, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("940YDT"), "year" - i(2005), "month" - i(1), "day" - i(25), "hour" - i(22), "minute" - i(45), "station" - s("citgo"), "fill-ups" - i(4), "record history (days)" - i(27), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(281), "standard deviation from mean" - i(422), "different locations" - i(2), "preferred station" - s("citgo"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("37FG"), "preferred pump %" - i(75)])).
car(860, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("DER624"), "year" - i(2004), "month" - i(12), "day" - i(17), "hour" - i(20), "minute" - i(33), "station" - s("6-Twelve"), "fill-ups" - i(17), "record history (days)" - i(60), "weekdays" - i(13), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(57), "standard deviation from mean" - i(209), "different locations" - i(3), "preferred station" - s("6-Twelve"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("07QG"), "preferred pump %" - i(23)])).
car(861, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("391EZT"), "year" - i(2005), "month" - i(1), "day" - i(25), "hour" - i(17), "minute" - i(41), "station" - s("citgo"), "fill-ups" - i(8), "record history (days)" - i(154), "weekdays" - i(6), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(118), "standard deviation from mean" - i(293), "different locations" - i(3), "preferred station" - s("6-Twelve"), "preferred station %" - i(37), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("37HI"), "preferred pump %" - i(25)])).
car(862, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("549LQS"), "year" - i(2004), "month" - i(11), "day" - i(13), "hour" - i(4), "minute" - i(13), "station" - s("texaco3"), "fill-ups" - i(42), "record history (days)" - i(82), "weekdays" - i(34), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(15), "different locations" - i(1), "preferred station" - s("texaco3"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07KA"), "preferred pump %" - i(97)])).
car(863, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("917BXT"), "year" - i(2005), "month" - i(1), "day" - i(1), "hour" - i(12), "minute" - i(33), "station" - s("6-Twelve"), "fill-ups" - i(31), "record history (days)" - i(131), "weekdays" - i(22), "weekends" - i(9), "preferred day" - s("friday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(41), "different locations" - i(1), "preferred station" - s("6-Twelve"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("17QG"), "preferred pump %" - i(35)])).
car(864, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("859BUT"), "year" - i(2004), "month" - i(10), "day" - i(24), "hour" - i(5), "minute" - i(39), "station" - s("6-Twelve"), "fill-ups" - i(3), "record history (days)" - i(28), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(430), "standard deviation from mean" - i(498), "different locations" - i(2), "preferred station" - s("7-Eleven"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("89HI"), "preferred pump %" - i(33)])).
car(865, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("024ZVT"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(18), "minute" - i(10), "station" - s("7-Eleven"), "fill-ups" - i(5), "record history (days)" - i(148), "weekdays" - i(4), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(180), "standard deviation from mean" - i(323), "different locations" - i(2), "preferred station" - s("7-Eleven"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("89HI"), "preferred pump %" - i(20)])).
car(866, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("254VMQ"), "year" - i(2004), "month" - i(12), "day" - i(1), "hour" - i(9), "minute" - i(30), "station" - s("texaco2"), "fill-ups" - i(20), "record history (days)" - i(100), "weekdays" - i(15), "weekends" - i(5), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(73), "standard deviation from mean" - i(274), "different locations" - i(3), "preferred station" - s("texaco2"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("07ER"), "preferred pump %" - i(45)])).
car(867, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("168WBT"), "year" - i(2004), "month" - i(9), "day" - i(18), "hour" - i(12), "minute" - i(17), "station" - s("texaco3"), "fill-ups" - i(5), "record history (days)" - i(25), "weekdays" - i(4), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(81), "standard deviation from mean" - i(146), "different locations" - i(1), "preferred station" - s("texaco3"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("07KA"), "preferred pump %" - i(100)])).
car(868, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("912WZT"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(16), "minute" - i(42), "station" - s("7-Eleven"), "fill-ups" - i(2), "record history (days)" - i(22), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(329), "standard deviation from mean" - i(233), "different locations" - i(2), "preferred station" - s("7-Eleven"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("89HI"), "preferred pump %" - i(50)])).
car(869, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("266VBT"), "year" - i(2005), "month" - i(1), "day" - i(15), "hour" - i(23), "minute" - i(59), "station" - s("texaco3"), "fill-ups" - i(3), "record history (days)" - i(100), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(368), "standard deviation from mean" - i(426), "different locations" - i(1), "preferred station" - s("texaco3"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(66), "payment method" - s("credit"), "preferred pump" - s("07KA"), "preferred pump %" - i(100)])).
car(870, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("YEB535"), "year" - i(2004), "month" - i(10), "day" - i(21), "hour" - i(11), "minute" - i(10), "station" - s("texaco3"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("friday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(335), "standard deviation from mean" - i(237), "different locations" - i(1), "preferred station" - s("texaco3"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("97KA"), "preferred pump %" - i(100)])).
car(871, class("additional purchases"), attributes(["state/province" - s("NM"), "tag" - s("346VVT"), "year" - i(2004), "month" - i(10), "day" - i(28), "hour" - i(7), "minute" - i(13), "station" - s("texaco3"), "fill-ups" - i(2), "record history (days)" - i(4), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(104), "standard deviation from mean" - i(74), "different locations" - i(1), "preferred station" - s("texaco3"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("07KA"), "preferred pump %" - i(100)])).
car(872, class("additional purchases"), attributes(["state/province" - s("NS"), "tag" - s("53638FC"), "year" - i(2004), "month" - i(11), "day" - i(28), "hour" - i(9), "minute" - i(32), "station" - s("crown12"), "fill-ups" - i(3), "record history (days)" - i(17), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(222), "standard deviation from mean" - i(257), "different locations" - i(2), "preferred station" - s("crown12"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("67YL"), "preferred pump %" - i(33)])).
car(873, class("additional purchases"), attributes(["state/province" - s("PQ"), "tag" - s("18938QY"), "year" - i(2004), "month" - i(11), "day" - i(18), "hour" - i(7), "minute" - i(48), "station" - s("crown29"), "fill-ups" - i(12), "record history (days)" - i(87), "weekdays" - i(12), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(59), "standard deviation from mean" - i(188), "different locations" - i(2), "preferred station" - s("crown29"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("88SP"), "preferred pump %" - i(50)])).
car(874, class("additional purchases"), attributes(["state/province" - s("PQ"), "tag" - s("01884Y"), "year" - i(2004), "month" - i(12), "day" - i(22), "hour" - i(10), "minute" - i(56), "station" - s("crown25"), "fill-ups" - i(43), "record history (days)" - i(78), "weekdays" - i(35), "weekends" - i(8), "preferred day" - s("thursday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(85), "different locations" - i(4), "preferred station" - s("crown29"), "preferred station %" - i(44), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("97IO"), "preferred pump %" - i(37)])).
car(875, class("additional purchases"), attributes(["state/province" - s("TN"), "tag" - s("287967G"), "year" - i(2005), "month" - i(2), "day" - i(24), "hour" - i(11), "minute" - i(19), "station" - s("citgo5"), "fill-ups" - i(10), "record history (days)" - i(145), "weekdays" - i(5), "weekends" - i(5), "preferred day" - s("thursday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(57), "standard deviation from mean" - i(162), "different locations" - i(1), "preferred station" - s("citgo5"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("08H/"), "preferred pump %" - i(50)])).
car(876, class("additional purchases"), attributes(["state/province" - s("TN"), "tag" - s("220958G"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(14), "minute" - i(51), "station" - s("getty18"), "fill-ups" - i(8), "record history (days)" - i(151), "weekdays" - i(8), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(129), "standard deviation from mean" - i(321), "different locations" - i(3), "preferred station" - s("citgo5"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("57BP"), "preferred pump %" - i(25)])).
car(877, class("additional purchases"), attributes(["state/province" - s("NV"), "tag" - s("40288HY"), "year" - i(2004), "month" - i(7), "day" - i(31), "hour" - i(16), "minute" - i(55), "station" - s("exxon2"), "fill-ups" - i(2), "record history (days)" - i(29), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(703), "standard deviation from mean" - i(498), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("67YM"), "preferred pump %" - i(50)])).
car(878, class("additional purchases"), attributes(["state/province" - s("NY"), "tag" - s("0144TNP"), "year" - i(2005), "month" - i(2), "day" - i(8), "hour" - i(20), "minute" - i(19), "station" - s("crown20"), "fill-ups" - i(8), "record history (days)" - i(79), "weekdays" - i(6), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(117), "standard deviation from mean" - i(291), "different locations" - i(2), "preferred station" - s("crown20"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("97EQ"), "preferred pump %" - i(50)])).
car(879, class("additional purchases"), attributes(["state/province" - s("IA"), "tag" - s("VSF556"), "year" - i(2005), "month" - i(2), "day" - i(22), "hour" - i(17), "minute" - i(20), "station" - s("getty14"), "fill-ups" - i(2), "record history (days)" - i(129), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(92), "standard deviation from mean" - i(65), "different locations" - i(2), "preferred station" - s("getty14"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("28AH"), "preferred pump %" - i(50)])).
car(880, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("35BKA9"), "year" - i(2004), "month" - i(10), "day" - i(13), "hour" - i(21), "minute" - i(7), "station" - s("getty08"), "fill-ups" - i(7), "record history (days)" - i(53), "weekdays" - i(6), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(32), "different locations" - i(1), "preferred station" - s("getty08"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("77GH"), "preferred pump %" - i(28)])).
car(881, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("98SBB3"), "year" - i(2005), "month" - i(1), "day" - i(1), "hour" - i(18), "minute" - i(51), "station" - s("crown"), "fill-ups" - i(23), "record history (days)" - i(126), "weekdays" - i(10), "weekends" - i(13), "preferred day" - s("sunday"), "day preference %" - i(39), "mean time of visit (minutes after midnight)" - i(56), "standard deviation from mean" - i(190), "different locations" - i(2), "preferred station" - s("crown"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07BP"), "preferred pump %" - i(43)])).
car(882, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("75AWH9"), "year" - i(2004), "month" - i(10), "day" - i(3), "hour" - i(21), "minute" - i(3), "station" - s("getty13"), "fill-ups" - i(2), "record history (days)" - i(8), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(497), "standard deviation from mean" - i(351), "different locations" - i(2), "preferred station" - s("getty13"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("97IH"), "preferred pump %" - i(50)])).
car(883, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("88LSZ3"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(21), "minute" - i(14), "station" - s("getty11"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(496), "standard deviation from mean" - i(351), "different locations" - i(2), "preferred station" - s("getty16"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("97SJ"), "preferred pump %" - i(50)])).
car(884, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("44DMQ4"), "year" - i(2004), "month" - i(8), "day" - i(29), "hour" - i(15), "minute" - i(49), "station" - s("getty11"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(474), "standard deviation from mean" - i(336), "different locations" - i(1), "preferred station" - s("getty11"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("27DH"), "preferred pump %" - i(100)])).
car(885, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("499755"), "year" - i(2004), "month" - i(8), "day" - i(29), "hour" - i(18), "minute" - i(10), "station" - s("getty08"), "fill-ups" - i(49), "record history (days)" - i(7), "weekdays" - i(31), "weekends" - i(18), "preferred day" - s("saturday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(11), "different locations" - i(11), "preferred station" - s("getty06"), "preferred station %" - i(28), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("76AH"), "preferred pump %" - i(8)])).
car(886, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("LIJ34T"), "year" - i(2004), "month" - i(12), "day" - i(24), "hour" - i(19), "minute" - i(42), "station" - s("citgo"), "fill-ups" - i(3), "record history (days)" - i(11), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(440), "standard deviation from mean" - i(509), "different locations" - i(1), "preferred station" - s("citgo"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("37FG"), "preferred pump %" - i(33)])).
car(887, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("24ZHL1"), "year" - i(2004), "month" - i(10), "day" - i(10), "hour" - i(17), "minute" - i(52), "station" - s("getty17"), "fill-ups" - i(2), "record history (days)" - i(1), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(1072), "standard deviation from mean" - i(0), "different locations" - i(1), "preferred station" - s("getty17"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("76UH"), "preferred pump %" - i(50)])).
car(888, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("FDC51O"), "year" - i(2004), "month" - i(10), "day" - i(19), "hour" - i(22), "minute" - i(51), "station" - s("crown"), "fill-ups" - i(10), "record history (days)" - i(11), "weekdays" - i(9), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(60), "mean time of visit (minutes after midnight)" - i(79), "standard deviation from mean" - i(161), "different locations" - i(2), "preferred station" - s("getty05"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("76EH"), "preferred pump %" - i(20)])).
car(889, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("70DWQ8"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(16), "minute" - i(20), "station" - s("getty17"), "fill-ups" - i(2), "record history (days)" - i(133), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(639), "standard deviation from mean" - i(452), "different locations" - i(2), "preferred station" - s("getty17"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("47GH"), "preferred pump %" - i(50)])).
car(890, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("FQS88I"), "year" - i(2004), "month" - i(8), "day" - i(29), "hour" - i(17), "minute" - i(30), "station" - s("getty10"), "fill-ups" - i(2), "record history (days)" - i(-16), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(534), "standard deviation from mean" - i(378), "different locations" - i(1), "preferred station" - s("getty10"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("37KH"), "preferred pump %" - i(100)])).
car(891, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("FJW27J"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(12), "minute" - i(2), "station" - s("citgo"), "fill-ups" - i(6), "record history (days)" - i(75), "weekdays" - i(5), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(140), "standard deviation from mean" - i(287), "different locations" - i(1), "preferred station" - s("citgo"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17FG"), "preferred pump %" - i(83)])).
car(892, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("ZEO89K"), "year" - i(2005), "month" - i(1), "day" - i(31), "hour" - i(12), "minute" - i(25), "station" - s("citgo"), "fill-ups" - i(41), "record history (days)" - i(161), "weekdays" - i(36), "weekends" - i(5), "preferred day" - s("monday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(17), "standard deviation from mean" - i(110), "different locations" - i(1), "preferred station" - s("citgo"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("27FG"), "preferred pump %" - i(34)])).
car(893, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("ZDX26L"), "year" - i(2004), "month" - i(10), "day" - i(19), "hour" - i(4), "minute" - i(44), "station" - s("citgo"), "fill-ups" - i(14), "record history (days)" - i(33), "weekdays" - i(12), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(86), "standard deviation from mean" - i(300), "different locations" - i(1), "preferred station" - s("citgo"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("47FG"), "preferred pump %" - i(50)])).
car(894, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("ZMV72J"), "year" - i(2004), "month" - i(12), "day" - i(27), "hour" - i(0), "minute" - i(2), "station" - s("getty11"), "fill-ups" - i(9), "record history (days)" - i(97), "weekdays" - i(8), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(133), "standard deviation from mean" - i(240), "different locations" - i(3), "preferred station" - s("getty11"), "preferred station %" - i(44), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("76KH"), "preferred pump %" - i(22)])).
car(895, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("FPV21K"), "year" - i(2004), "month" - i(9), "day" - i(23), "hour" - i(20), "minute" - i(57), "station" - s("getty13"), "fill-ups" - i(3), "record history (days)" - i(7), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(392), "standard deviation from mean" - i(453), "different locations" - i(1), "preferred station" - s("getty13"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("97IH"), "preferred pump %" - i(66)])).
car(896, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("KWL37M"), "year" - i(2004), "month" - i(11), "day" - i(10), "hour" - i(14), "minute" - i(2), "station" - s("getty17"), "fill-ups" - i(4), "record history (days)" - i(6), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(354), "standard deviation from mean" - i(532), "different locations" - i(2), "preferred station" - s("getty17"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17UH"), "preferred pump %" - i(50)])).
car(897, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("O77MXM"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(11), "minute" - i(28), "station" - s("getty"), "fill-ups" - i(4), "record history (days)" - i(143), "weekdays" - i(3), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(221), "standard deviation from mean" - i(332), "different locations" - i(3), "preferred station" - s("getty02"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("27AJ"), "preferred pump %" - i(25)])).
car(898, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("DQX26E"), "year" - i(2004), "month" - i(12), "day" - i(29), "hour" - i(15), "minute" - i(52), "station" - s("getty01"), "fill-ups" - i(3), "record history (days)" - i(103), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(282), "standard deviation from mean" - i(326), "different locations" - i(3), "preferred station" - s("getty16"), "preferred station %" - i(33), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17AJ"), "preferred pump %" - i(33)])).
car(899, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("TSB82G"), "year" - i(2005), "month" - i(1), "day" - i(20), "hour" - i(21), "minute" - i(47), "station" - s("getty11"), "fill-ups" - i(21), "record history (days)" - i(92), "weekdays" - i(19), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(69), "standard deviation from mean" - i(210), "different locations" - i(1), "preferred station" - s("getty11"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("76DH"), "preferred pump %" - i(47)])).
car(900, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("983O7E"), "year" - i(2004), "month" - i(12), "day" - i(16), "hour" - i(21), "minute" - i(22), "station" - s("getty06"), "fill-ups" - i(8), "record history (days)" - i(67), "weekdays" - i(6), "weekends" - i(2), "preferred day" - s("monday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(165), "standard deviation from mean" - i(337), "different locations" - i(2), "preferred station" - s("getty06"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("07AH"), "preferred pump %" - i(50)])).
car(901, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("NAR420"), "year" - i(2005), "month" - i(1), "day" - i(18), "hour" - i(17), "minute" - i(54), "station" - s("citgo"), "fill-ups" - i(3), "record history (days)" - i(5), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(342), "standard deviation from mean" - i(395), "different locations" - i(2), "preferred station" - s("citgo"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17FG"), "preferred pump %" - i(66)])).
car(902, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("OIM29X"), "year" - i(2005), "month" - i(1), "day" - i(13), "hour" - i(20), "minute" - i(6), "station" - s("texaco9"), "fill-ups" - i(4), "record history (days)" - i(138), "weekdays" - i(2), "weekends" - i(2), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(324), "standard deviation from mean" - i(486), "different locations" - i(2), "preferred station" - s("texaco9"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("97RJ"), "preferred pump %" - i(50)])).
car(903, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("BIV68Z"), "year" - i(2004), "month" - i(10), "day" - i(28), "hour" - i(17), "minute" - i(26), "station" - s("citgo"), "fill-ups" - i(2), "record history (days)" - i(3), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(473), "standard deviation from mean" - i(335), "different locations" - i(1), "preferred station" - s("citgo"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("47FG"), "preferred pump %" - i(100)])).
car(904, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("XIM89J"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(16), "minute" - i(12), "station" - s("getty11"), "fill-ups" - i(28), "record history (days)" - i(148), "weekdays" - i(14), "weekends" - i(14), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(49), "standard deviation from mean" - i(179), "different locations" - i(2), "preferred station" - s("getty11"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("76DH"), "preferred pump %" - i(46)])).
car(905, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("NEO08K"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(27), "station" - s("6-Twelve"), "fill-ups" - i(52), "record history (days)" - i(153), "weekdays" - i(35), "weekends" - i(17), "preferred day" - s("monday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(25), "standard deviation from mean" - i(183), "different locations" - i(2), "preferred station" - s("6-Twelve"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17QG"), "preferred pump %" - i(25)])).
car(906, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("EUM61C"), "year" - i(2005), "month" - i(1), "day" - i(30), "hour" - i(16), "minute" - i(32), "station" - s("getty16"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(992), "standard deviation from mean" - i(0), "different locations" - i(2), "preferred station" - s("getty16"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("07SJ"), "preferred pump %" - i(50)])).
car(907, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("LJM74F"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(7), "minute" - i(28), "station" - s("getty02"), "fill-ups" - i(9), "record history (days)" - i(143), "weekdays" - i(3), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(101), "standard deviation from mean" - i(272), "different locations" - i(2), "preferred station" - s("getty02"), "preferred station %" - i(77), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("17AJ"), "preferred pump %" - i(44)])).
car(908, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("OBW63G"), "year" - i(2004), "month" - i(10), "day" - i(23), "hour" - i(19), "minute" - i(33), "station" - s("getty11"), "fill-ups" - i(12), "record history (days)" - i(39), "weekdays" - i(9), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(112), "standard deviation from mean" - i(357), "different locations" - i(3), "preferred station" - s("getty11"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("17DH"), "preferred pump %" - i(25)])).
car(909, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("39JSV9"), "year" - i(2005), "month" - i(1), "day" - i(18), "hour" - i(7), "minute" - i(57), "station" - s("7-Eleven"), "fill-ups" - i(4), "record history (days)" - i(107), "weekdays" - i(2), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(75), "standard deviation from mean" - i(113), "different locations" - i(2), "preferred station" - s("7-Eleven"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("37FG"), "preferred pump %" - i(50)])).
car(910, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("NAV45W"), "year" - i(2005), "month" - i(1), "day" - i(18), "hour" - i(7), "minute" - i(56), "station" - s("getty08"), "fill-ups" - i(95), "record history (days)" - i(148), "weekdays" - i(77), "weekends" - i(18), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(47), "different locations" - i(2), "preferred station" - s("getty08"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("67GH"), "preferred pump %" - i(29)])).
car(911, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("25ILM3"), "year" - i(2005), "month" - i(2), "day" - i(13), "hour" - i(10), "minute" - i(43), "station" - s("getty08"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(321), "standard deviation from mean" - i(227), "different locations" - i(1), "preferred station" - s("getty08"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("88GH"), "preferred pump %" - i(100)])).
car(912, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("TAP74L"), "year" - i(2004), "month" - i(12), "day" - i(25), "hour" - i(6), "minute" - i(14), "station" - s("6-Twelve"), "fill-ups" - i(2), "record history (days)" - i(2), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(574), "standard deviation from mean" - i(406), "different locations" - i(1), "preferred station" - s("6-Twelve"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("37QG"), "preferred pump %" - i(50)])).
car(913, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("K05NMM"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(14), "minute" - i(48), "station" - s("getty08"), "fill-ups" - i(2), "record history (days)" - i(70), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(888), "standard deviation from mean" - i(0), "different locations" - i(2), "preferred station" - s("getty17"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("88GH"), "preferred pump %" - i(50)])).
car(914, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("EIF44K"), "year" - i(2004), "month" - i(11), "day" - i(19), "hour" - i(14), "minute" - i(43), "station" - s("getty06"), "fill-ups" - i(3), "record history (days)" - i(60), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("friday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(255), "standard deviation from mean" - i(181), "different locations" - i(2), "preferred station" - s("getty07"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("38AH"), "preferred pump %" - i(66)])).
car(915, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("BDB39L"), "year" - i(2004), "month" - i(10), "day" - i(10), "hour" - i(13), "minute" - i(56), "station" - s("7-Eleven"), "fill-ups" - i(6), "record history (days)" - i(16), "weekdays" - i(3), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(228), "standard deviation from mean" - i(467), "different locations" - i(3), "preferred station" - s("7-Eleven"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("67HI"), "preferred pump %" - i(16)])).
car(916, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("XNN92M"), "year" - i(2004), "month" - i(11), "day" - i(1), "hour" - i(21), "minute" - i(38), "station" - s("getty06"), "fill-ups" - i(9), "record history (days)" - i(4), "weekdays" - i(4), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(260), "standard deviation from mean" - i(466), "different locations" - i(2), "preferred station" - s("getty06"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(40), "payment method" - s("credit"), "preferred pump" - s("76AH"), "preferred pump %" - i(33)])).
car(917, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("5332R4"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(16), "minute" - i(22), "station" - s("6-Twelve"), "fill-ups" - i(11), "record history (days)" - i(170), "weekdays" - i(11), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(108), "standard deviation from mean" - i(326), "different locations" - i(3), "preferred station" - s("6-Twelve"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("57QG"), "preferred pump %" - i(18)])).
car(918, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("HPJ23P"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(14), "minute" - i(54), "station" - s("getty08"), "fill-ups" - i(7), "record history (days)" - i(175), "weekdays" - i(4), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(202), "standard deviation from mean" - i(458), "different locations" - i(2), "preferred station" - s("getty08"), "preferred station %" - i(57), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("77GH"), "preferred pump %" - i(14)])).
car(919, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("HBV68I"), "year" - i(2004), "month" - i(10), "day" - i(24), "hour" - i(5), "minute" - i(39), "station" - s("7-Eleven"), "fill-ups" - i(3), "record history (days)" - i(36), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(460), "standard deviation from mean" - i(532), "different locations" - i(2), "preferred station" - s("7-Eleven"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("27HI"), "preferred pump %" - i(33)])).
car(920, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("0195FL"), "year" - i(2004), "month" - i(9), "day" - i(24), "hour" - i(17), "minute" - i(59), "station" - s("getty06"), "fill-ups" - i(2), "record history (days)" - i(4), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(450), "standard deviation from mean" - i(318), "different locations" - i(2), "preferred station" - s("getty07"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("18AH"), "preferred pump %" - i(50)])).
car(921, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("NMS90U"), "year" - i(2004), "month" - i(10), "day" - i(2), "hour" - i(20), "minute" - i(50), "station" - s("getty05"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(1250), "standard deviation from mean" - i(0), "different locations" - i(1), "preferred station" - s("getty05"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("76EH"), "preferred pump %" - i(50)])).
car(922, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("CKF99Y"), "year" - i(2004), "month" - i(10), "day" - i(28), "hour" - i(1), "minute" - i(40), "station" - s("getty06"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(100), "standard deviation from mean" - i(0), "different locations" - i(2), "preferred station" - s("getty07"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("56AH"), "preferred pump %" - i(50)])).
car(923, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("98RMG1"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(15), "minute" - i(35), "station" - s("getty06"), "fill-ups" - i(17), "record history (days)" - i(131), "weekdays" - i(12), "weekends" - i(5), "preferred day" - s("friday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(103), "standard deviation from mean" - i(277), "different locations" - i(1), "preferred station" - s("getty06"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("76AH"), "preferred pump %" - i(47)])).
car(924, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("QCJ06F"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(13), "minute" - i(57), "station" - s("getty01"), "fill-ups" - i(6), "record history (days)" - i(130), "weekdays" - i(5), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(169), "standard deviation from mean" - i(304), "different locations" - i(3), "preferred station" - s("getty01"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("07ZH"), "preferred pump %" - i(50)])).
car(925, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("CPL88G"), "year" - i(2004), "month" - i(12), "day" - i(20), "hour" - i(16), "minute" - i(13), "station" - s("getty08"), "fill-ups" - i(7), "record history (days)" - i(89), "weekdays" - i(4), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(145), "standard deviation from mean" - i(329), "different locations" - i(2), "preferred station" - s("getty08"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("88GH"), "preferred pump %" - i(42)])).
car(926, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("1NJG49"), "year" - i(2004), "month" - i(12), "day" - i(15), "hour" - i(13), "minute" - i(50), "station" - s("getty07"), "fill-ups" - i(2), "record history (days)" - i(31), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(615), "standard deviation from mean" - i(435), "different locations" - i(2), "preferred station" - s("getty07"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("18AH"), "preferred pump %" - i(50)])).
car(927, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("24WNQ4"), "year" - i(2004), "month" - i(10), "day" - i(24), "hour" - i(1), "minute" - i(56), "station" - s("getty02"), "fill-ups" - i(26), "record history (days)" - i(39), "weekdays" - i(17), "weekends" - i(9), "preferred day" - s("wednesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(45), "standard deviation from mean" - i(218), "different locations" - i(3), "preferred station" - s("getty"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("97DR"), "preferred pump %" - i(34)])).
car(928, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("HJH97T"), "year" - i(2005), "month" - i(1), "day" - i(21), "hour" - i(8), "minute" - i(29), "station" - s("getty07"), "fill-ups" - i(114), "record history (days)" - i(72), "weekdays" - i(93), "weekends" - i(21), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(174), "different locations" - i(2), "preferred station" - s("getty07"), "preferred station %" - i(67), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("56AH"), "preferred pump %" - i(38)])).
car(929, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("LDV10M"), "year" - i(2004), "month" - i(10), "day" - i(12), "hour" - i(22), "minute" - i(38), "station" - s("getty02"), "fill-ups" - i(2), "record history (days)" - i(15), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(460), "standard deviation from mean" - i(326), "different locations" - i(2), "preferred station" - s("getty"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("07AJ"), "preferred pump %" - i(50)])).
car(930, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("V59CFM"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(18), "minute" - i(55), "station" - s("getty08"), "fill-ups" - i(4), "record history (days)" - i(44), "weekdays" - i(3), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(195), "standard deviation from mean" - i(292), "different locations" - i(1), "preferred station" - s("getty08"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("98GH"), "preferred pump %" - i(25)])).
car(931, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("52HSY3"), "year" - i(2004), "month" - i(12), "day" - i(18), "hour" - i(23), "minute" - i(28), "station" - s("getty16"), "fill-ups" - i(6), "record history (days)" - i(70), "weekdays" - i(2), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(285), "standard deviation from mean" - i(427), "different locations" - i(2), "preferred station" - s("getty11"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("97SJ"), "preferred pump %" - i(33)])).
car(932, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("YJC66U"), "year" - i(2004), "month" - i(9), "day" - i(23), "hour" - i(13), "minute" - i(44), "station" - s("getty07"), "fill-ups" - i(2), "record history (days)" - i(2), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(437), "standard deviation from mean" - i(310), "different locations" - i(2), "preferred station" - s("getty07"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("48AH"), "preferred pump %" - i(50)])).
car(933, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("JJA36Y"), "year" - i(2004), "month" - i(12), "day" - i(6), "hour" - i(22), "minute" - i(10), "station" - s("getty07"), "fill-ups" - i(17), "record history (days)" - i(28), "weekdays" - i(15), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(90), "standard deviation from mean" - i(274), "different locations" - i(2), "preferred station" - s("getty07"), "preferred station %" - i(70), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("56AH"), "preferred pump %" - i(23)])).
car(934, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("HAO85Z"), "year" - i(2005), "month" - i(1), "day" - i(30), "hour" - i(2), "minute" - i(21), "station" - s("crown"), "fill-ups" - i(6), "record history (days)" - i(1), "weekdays" - i(0), "weekends" - i(6), "preferred day" - s("saturday"), "day preference %" - i(83), "mean time of visit (minutes after midnight)" - i(78), "standard deviation from mean" - i(90), "different locations" - i(2), "preferred station" - s("crown"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("76BP"), "preferred pump %" - i(50)])).
car(935, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("ESW81O"), "year" - i(2004), "month" - i(8), "day" - i(29), "hour" - i(14), "minute" - i(43), "station" - s("getty07"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(883), "standard deviation from mean" - i(0), "different locations" - i(1), "preferred station" - s("getty07"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("56AH"), "preferred pump %" - i(50)])).
car(936, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("FJA82M"), "year" - i(2004), "month" - i(10), "day" - i(27), "hour" - i(13), "minute" - i(9), "station" - s("getty05"), "fill-ups" - i(2), "record history (days)" - i(11), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(789), "standard deviation from mean" - i(0), "different locations" - i(2), "preferred station" - s("getty05"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("07EH"), "preferred pump %" - i(50)])).
car(937, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("QNO75E"), "year" - i(2005), "month" - i(1), "day" - i(28), "hour" - i(22), "minute" - i(30), "station" - s("citgo"), "fill-ups" - i(2), "record history (days)" - i(24), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(645), "standard deviation from mean" - i(457), "different locations" - i(1), "preferred station" - s("citgo"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("47FG"), "preferred pump %" - i(50)])).
car(938, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("QCM51I"), "year" - i(2004), "month" - i(11), "day" - i(27), "hour" - i(2), "minute" - i(26), "station" - s("getty02"), "fill-ups" - i(6), "record history (days)" - i(94), "weekdays" - i(2), "weekends" - i(4), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(151), "standard deviation from mean" - i(309), "different locations" - i(1), "preferred station" - s("getty02"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17AJ"), "preferred pump %" - i(50)])).
car(939, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("VPS18J"), "year" - i(2004), "month" - i(12), "day" - i(5), "hour" - i(15), "minute" - i(10), "station" - s("6-Twelve"), "fill-ups" - i(10), "record history (days)" - i(104), "weekdays" - i(7), "weekends" - i(3), "preferred day" - s("saturday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(53), "standard deviation from mean" - i(151), "different locations" - i(1), "preferred station" - s("6-Twelve"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07QG"), "preferred pump %" - i(50)])).
car(940, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("16CSM7"), "year" - i(2004), "month" - i(9), "day" - i(28), "hour" - i(14), "minute" - i(47), "station" - s("getty13"), "fill-ups" - i(2), "record history (days)" - i(31), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(380), "standard deviation from mean" - i(269), "different locations" - i(2), "preferred station" - s("getty13"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("17AJ"), "preferred pump %" - i(50)])).
car(941, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("496845"), "year" - i(2004), "month" - i(9), "day" - i(23), "hour" - i(11), "minute" - i(3), "station" - s("getty07"), "fill-ups" - i(3), "record history (days)" - i(29), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(430), "standard deviation from mean" - i(498), "different locations" - i(2), "preferred station" - s("getty07"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("28AH"), "preferred pump %" - i(33)])).
car(942, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("BXV32X"), "year" - i(2005), "month" - i(1), "day" - i(22), "hour" - i(20), "minute" - i(36), "station" - s("getty11"), "fill-ups" - i(4), "record history (days)" - i(147), "weekdays" - i(0), "weekends" - i(4), "preferred day" - s("saturday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(282), "standard deviation from mean" - i(326), "different locations" - i(3), "preferred station" - s("getty11"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("07AJ"), "preferred pump %" - i(25)])).
car(943, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("ZWH06C"), "year" - i(2004), "month" - i(10), "day" - i(20), "hour" - i(19), "minute" - i(44), "station" - s("getty07"), "fill-ups" - i(6), "record history (days)" - i(11), "weekdays" - i(5), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(282), "standard deviation from mean" - i(423), "different locations" - i(2), "preferred station" - s("getty07"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("48AH"), "preferred pump %" - i(33)])).
car(944, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("6184JM"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(5), "minute" - i(58), "station" - s("getty06"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(358), "standard deviation from mean" - i(0), "different locations" - i(1), "preferred station" - s("getty06"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("76AH"), "preferred pump %" - i(50)])).
car(945, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("01OYJ2"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(22), "minute" - i(56), "station" - s("getty11"), "fill-ups" - i(40), "record history (days)" - i(166), "weekdays" - i(29), "weekends" - i(11), "preferred day" - s("tuesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(137), "different locations" - i(2), "preferred station" - s("getty11"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(19), "payment method" - s("credit"), "preferred pump" - s("76DH"), "preferred pump %" - i(47)])).
car(946, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("LQB66J"), "year" - i(2004), "month" - i(9), "day" - i(22), "hour" - i(8), "minute" - i(51), "station" - s("citgo"), "fill-ups" - i(10), "record history (days)" - i(30), "weekdays" - i(9), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(50), "standard deviation from mean" - i(144), "different locations" - i(1), "preferred station" - s("citgo"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("47FG"), "preferred pump %" - i(50)])).
car(947, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("BMR779"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(21), "minute" - i(41), "station" - s("citgo"), "fill-ups" - i(10), "record history (days)" - i(12), "weekdays" - i(5), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(225), "standard deviation from mean" - i(461), "different locations" - i(2), "preferred station" - s("citgo"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("76ER"), "preferred pump %" - i(40)])).
car(948, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("OIL13I"), "year" - i(2005), "month" - i(1), "day" - i(4), "hour" - i(21), "minute" - i(20), "station" - s("getty06"), "fill-ups" - i(4), "record history (days)" - i(133), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(75), "mean time of visit (minutes after midnight)" - i(367), "standard deviation from mean" - i(260), "different locations" - i(2), "preferred station" - s("getty07"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("76AH"), "preferred pump %" - i(25)])).
car(949, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("38OWB3"), "year" - i(2005), "month" - i(1), "day" - i(9), "hour" - i(11), "minute" - i(1), "station" - s("getty08"), "fill-ups" - i(2), "record history (days)" - i(6), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(437), "standard deviation from mean" - i(310), "different locations" - i(1), "preferred station" - s("getty08"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("37GH"), "preferred pump %" - i(100)])).
car(950, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("94RZP2"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(6), "minute" - i(26), "station" - s("getty01"), "fill-ups" - i(120), "record history (days)" - i(172), "weekdays" - i(87), "weekends" - i(33), "preferred day" - s("friday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(36), "different locations" - i(2), "preferred station" - s("getty01"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("17ZH"), "preferred pump %" - i(84)])).
car(951, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("QIV70X"), "year" - i(2004), "month" - i(11), "day" - i(2), "hour" - i(10), "minute" - i(10), "station" - s("getty07"), "fill-ups" - i(4), "record history (days)" - i(22), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(169), "standard deviation from mean" - i(196), "different locations" - i(2), "preferred station" - s("getty07"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("67AH"), "preferred pump %" - i(50)])).
car(952, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("QMA16A"), "year" - i(2004), "month" - i(10), "day" - i(18), "hour" - i(22), "minute" - i(47), "station" - s("texaco2"), "fill-ups" - i(16), "record history (days)" - i(26), "weekdays" - i(9), "weekends" - i(7), "preferred day" - s("saturday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(76), "standard deviation from mean" - i(264), "different locations" - i(1), "preferred station" - s("texaco2"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(21), "payment method" - s("credit"), "preferred pump" - s("07ER"), "preferred pump %" - i(81)])).
car(953, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("JMB62O"), "year" - i(2004), "month" - i(10), "day" - i(28), "hour" - i(10), "minute" - i(12), "station" - s("getty07"), "fill-ups" - i(3), "record history (days)" - i(40), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(394), "standard deviation from mean" - i(279), "different locations" - i(2), "preferred station" - s("getty07"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("56AH"), "preferred pump %" - i(33)])).
car(954, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("TOT96T"), "year" - i(2004), "month" - i(12), "day" - i(11), "hour" - i(18), "minute" - i(17), "station" - s("getty08"), "fill-ups" - i(5), "record history (days)" - i(41), "weekdays" - i(3), "weekends" - i(2), "preferred day" - s("monday"), "day preference %" - i(60), "mean time of visit (minutes after midnight)" - i(200), "standard deviation from mean" - i(359), "different locations" - i(1), "preferred station" - s("getty08"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("77GH"), "preferred pump %" - i(20)])).
car(955, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("17WOD4"), "year" - i(2005), "month" - i(2), "day" - i(24), "hour" - i(12), "minute" - i(33), "station" - s("6-Twelve"), "fill-ups" - i(28), "record history (days)" - i(159), "weekdays" - i(22), "weekends" - i(6), "preferred day" - s("monday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(48), "different locations" - i(2), "preferred station" - s("6-Twelve"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97QG"), "preferred pump %" - i(25)])).
car(956, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("70ZGU0"), "year" - i(2004), "month" - i(12), "day" - i(29), "hour" - i(17), "minute" - i(24), "station" - s("getty07"), "fill-ups" - i(2), "record history (days)" - i(19), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(1044), "standard deviation from mean" - i(0), "different locations" - i(1), "preferred station" - s("getty07"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("56AH"), "preferred pump %" - i(50)])).
car(957, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("F91EXL"), "year" - i(2004), "month" - i(11), "day" - i(27), "hour" - i(19), "minute" - i(10), "station" - s("getty17"), "fill-ups" - i(18), "record history (days)" - i(95), "weekdays" - i(10), "weekends" - i(8), "preferred day" - s("saturday"), "day preference %" - i(38), "mean time of visit (minutes after midnight)" - i(72), "standard deviation from mean" - i(289), "different locations" - i(1), "preferred station" - s("getty17"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07UH"), "preferred pump %" - i(50)])).
car(958, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("RKR38A"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(12), "minute" - i(35), "station" - s("getty01"), "fill-ups" - i(6), "record history (days)" - i(115), "weekdays" - i(4), "weekends" - i(2), "preferred day" - s("monday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(216), "standard deviation from mean" - i(442), "different locations" - i(1), "preferred station" - s("getty01"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17ZH"), "preferred pump %" - i(33)])).
car(959, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("61WOM9"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(12), "minute" - i(12), "station" - s("texaco0"), "fill-ups" - i(7), "record history (days)" - i(140), "weekdays" - i(1), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(42), "mean time of visit (minutes after midnight)" - i(114), "standard deviation from mean" - i(234), "different locations" - i(2), "preferred station" - s("texaco0"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17FJ"), "preferred pump %" - i(57)])).
car(960, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("58HGG7"), "year" - i(2004), "month" - i(12), "day" - i(19), "hour" - i(8), "minute" - i(42), "station" - s("getty06"), "fill-ups" - i(5), "record history (days)" - i(39), "weekdays" - i(5), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(470), "standard deviation from mean" - i(544), "different locations" - i(2), "preferred station" - s("getty06"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(66), "payment method" - s("credit"), "preferred pump" - s("37AH"), "preferred pump %" - i(60)])).
car(961, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("11ZGQ4"), "year" - i(2004), "month" - i(12), "day" - i(27), "hour" - i(21), "minute" - i(37), "station" - s("getty08"), "fill-ups" - i(24), "record history (days)" - i(126), "weekdays" - i(20), "weekends" - i(4), "preferred day" - s("wednesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(0), "different locations" - i(2), "preferred station" - s("getty17"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("07UH"), "preferred pump %" - i(45)])).
car(962, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("RJC80J"), "year" - i(2004), "month" - i(11), "day" - i(18), "hour" - i(22), "minute" - i(23), "station" - s("getty13"), "fill-ups" - i(11), "record history (days)" - i(86), "weekdays" - i(9), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(79), "standard deviation from mean" - i(240), "different locations" - i(1), "preferred station" - s("getty13"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("97IH"), "preferred pump %" - i(81)])).
car(963, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("BEC64J"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(0), "minute" - i(2), "station" - s("getty08"), "fill-ups" - i(5), "record history (days)" - i(43), "weekdays" - i(2), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(60), "mean time of visit (minutes after midnight)" - i(235), "standard deviation from mean" - i(422), "different locations" - i(1), "preferred station" - s("getty08"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("98GH"), "preferred pump %" - i(20)])).
car(964, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("EPD89K"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(16), "minute" - i(50), "station" - s("getty"), "fill-ups" - i(55), "record history (days)" - i(172), "weekdays" - i(39), "weekends" - i(16), "preferred day" - s("monday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(25), "standard deviation from mean" - i(189), "different locations" - i(3), "preferred station" - s("getty02"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17AJ"), "preferred pump %" - i(38)])).
car(965, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("NCH08L"), "year" - i(2004), "month" - i(12), "day" - i(24), "hour" - i(13), "minute" - i(32), "station" - s("6-Twelve"), "fill-ups" - i(25), "record history (days)" - i(100), "weekdays" - i(16), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(50), "standard deviation from mean" - i(244), "different locations" - i(3), "preferred station" - s("6-Twelve"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("97QG"), "preferred pump %" - i(28)])).
car(966, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("1779DC"), "year" - i(2005), "month" - i(2), "day" - i(19), "hour" - i(18), "minute" - i(34), "station" - s("getty06"), "fill-ups" - i(5), "record history (days)" - i(111), "weekdays" - i(3), "weekends" - i(2), "preferred day" - s("monday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(277), "standard deviation from mean" - i(496), "different locations" - i(3), "preferred station" - s("getty10"), "preferred station %" - i(40), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("97KH"), "preferred pump %" - i(40)])).
car(967, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("496766"), "year" - i(2004), "month" - i(12), "day" - i(3), "hour" - i(20), "minute" - i(24), "station" - s("getty10"), "fill-ups" - i(119), "record history (days)" - i(80), "weekdays" - i(83), "weekends" - i(36), "preferred day" - s("wednesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(121), "different locations" - i(16), "preferred station" - s("getty06"), "preferred station %" - i(37), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("76AH"), "preferred pump %" - i(17)])).
car(968, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("N41QUJ"), "year" - i(2004), "month" - i(11), "day" - i(30), "hour" - i(21), "minute" - i(34), "station" - s("getty06"), "fill-ups" - i(3), "record history (days)" - i(98), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(428), "standard deviation from mean" - i(495), "different locations" - i(1), "preferred station" - s("getty06"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("57AH"), "preferred pump %" - i(66)])).
car(969, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("BKZ40Q"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(15), "minute" - i(33), "station" - s("getty11"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(933), "standard deviation from mean" - i(0), "different locations" - i(1), "preferred station" - s("getty11"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("76DH"), "preferred pump %" - i(50)])).
car(970, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("XBV68U"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(8), "minute" - i(13), "station" - s("citgo"), "fill-ups" - i(2), "record history (days)" - i(25), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(561), "standard deviation from mean" - i(397), "different locations" - i(1), "preferred station" - s("citgo"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("37FG"), "preferred pump %" - i(50)])).
car(971, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("66VVH3"), "year" - i(2004), "month" - i(10), "day" - i(16), "hour" - i(10), "minute" - i(48), "station" - s("getty06"), "fill-ups" - i(3), "record history (days)" - i(14), "weekdays" - i(0), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(791), "standard deviation from mean" - i(0), "different locations" - i(1), "preferred station" - s("getty06"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("76AH"), "preferred pump %" - i(66)])).
car(972, class("additional purchases"), attributes(["state/province" - s("TX"), "tag" - s("RMV36A"), "year" - i(2004), "month" - i(11), "day" - i(21), "hour" - i(14), "minute" - i(42), "station" - s("getty16"), "fill-ups" - i(3), "record history (days)" - i(84), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(286), "standard deviation from mean" - i(331), "different locations" - i(1), "preferred station" - s("getty16"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("97SJ"), "preferred pump %" - i(66)])).
