%---------------------------------------------------------------------------%
% vim: ft=mercury ts=4 sw=4 et
%---------------------------------------------------------------------------%
% Check that negative fixed-sized integer values are not accidently promoted
% and sign-extended by the code generated by compiler/format_call.m.
%---------------------------------------------------------------------------%

:- module opt_format_sign_extend.
:- interface.

:- import_module io.

:- pred main(io::di, io::uo) is det.

%---------------------------------------------------------------------------%
%---------------------------------------------------------------------------%

:- implementation.

:- import_module int16.
:- import_module int32.
:- import_module int8.
:- import_module list.
:- import_module string.

main(!IO) :-
    io.format("%x\n", [i8(min_int8)], !IO),
    io.format("%x\n", [i16(min_int16)], !IO),
    io.format("%x\n", [i32(min_int32)], !IO),
    io.format("%x\n", [i8(-1_i8)], !IO),
    io.format("%x\n", [i16(-1_i16)], !IO),
    io.format("%x\n", [i32(-1_i32)], !IO),
    io.nl(!IO),
    io.format("%X\n", [i8(min_int8)], !IO),
    io.format("%X\n", [i16(min_int16)], !IO),
    io.format("%X\n", [i32(min_int32)], !IO),
    io.format("%X\n", [i8(-1_i8)], !IO),
    io.format("%X\n", [i16(-1_i16)], !IO),
    io.format("%X\n", [i32(-1_i32)], !IO),
    io.nl(!IO),
    io.format("%o\n", [i8(min_int8)], !IO),
    io.format("%o\n", [i16(min_int16)], !IO),
    io.format("%o\n", [i32(min_int32)], !IO),
    io.format("%o\n", [i8(-1_i8)], !IO),
    io.format("%o\n", [i16(-1_i16)], !IO),
    io.format("%o\n", [i32(-1_i32)], !IO),
    io.nl(!IO),
    io.format("%u\n", [i8(min_int8)], !IO),
    io.format("%u\n", [i16(min_int16)], !IO),
    io.format("%u\n", [i32(min_int32)], !IO),
    io.format("%u\n", [i8(-1_i8)], !IO),
    io.format("%u\n", [i16(-1_i16)], !IO),
    io.format("%u\n", [i32(-1_i32)], !IO).

%---------------------------------------------------------------------------%
:- end_module opt_format_sign_extend.
%---------------------------------------------------------------------------%
