// vim: ts=4 sw=4 expandtab ft=c

// Copyright (C) 2022, 2025 The Mercury team.
// This file is distributed under the terms specified in COPYING.LIB.

// Generated by generate_errno_name.

#include <errno.h>
#include <stdlib.h>

#include "mercury_errno_name.h"

const char *
MR_errno_name(int errnum)
{
    switch (errnum) {
#ifdef ENOSYS
    case ENOSYS: return "ENOSYS";
#endif
#ifdef EPERM
    case EPERM: return "EPERM";
#endif
#ifdef ENOENT
    case ENOENT: return "ENOENT";
#endif
#ifdef ESRCH
    case ESRCH: return "ESRCH";
#endif
#ifdef EINTR
    case EINTR: return "EINTR";
#endif
#ifdef EIO
    case EIO: return "EIO";
#endif
#ifdef ENXIO
    case ENXIO: return "ENXIO";
#endif
#ifdef E2BIG
    case E2BIG: return "E2BIG";
#endif
#ifdef ENOEXEC
    case ENOEXEC: return "ENOEXEC";
#endif
#ifdef EBADF
    case EBADF: return "EBADF";
#endif
#ifdef ECHILD
    case ECHILD: return "ECHILD";
#endif
#ifdef EAGAIN
    case EAGAIN: return "EAGAIN";
#endif
#ifdef ENOMEM
    case ENOMEM: return "ENOMEM";
#endif
#ifdef EACCES
    case EACCES: return "EACCES";
#endif
#ifdef EFAULT
    case EFAULT: return "EFAULT";
#endif
#ifdef ENOTBLK
    case ENOTBLK: return "ENOTBLK";
#endif
#ifdef EBUSY
    case EBUSY: return "EBUSY";
#endif
#ifdef EEXIST
    case EEXIST: return "EEXIST";
#endif
#ifdef EXDEV
    case EXDEV: return "EXDEV";
#endif
#ifdef ENODEV
    case ENODEV: return "ENODEV";
#endif
#ifdef ENOTDIR
    case ENOTDIR: return "ENOTDIR";
#endif
#ifdef EISDIR
    case EISDIR: return "EISDIR";
#endif
#ifdef EINVAL
    case EINVAL: return "EINVAL";
#endif
#ifdef ENFILE
    case ENFILE: return "ENFILE";
#endif
#ifdef EMFILE
    case EMFILE: return "EMFILE";
#endif
#ifdef ENOTTY
    case ENOTTY: return "ENOTTY";
#endif
#ifdef ETXTBSY
    case ETXTBSY: return "ETXTBSY";
#endif
#ifdef EFBIG
    case EFBIG: return "EFBIG";
#endif
#ifdef ENOSPC
    case ENOSPC: return "ENOSPC";
#endif
#ifdef EDQUOT
    case EDQUOT: return "EDQUOT";
#endif
#ifdef ESPIPE
    case ESPIPE: return "ESPIPE";
#endif
#ifdef EROFS
    case EROFS: return "EROFS";
#endif
#ifdef EMLINK
    case EMLINK: return "EMLINK";
#endif
#ifdef EPIPE
    case EPIPE: return "EPIPE";
#endif
#ifdef EDOM
    case EDOM: return "EDOM";
#endif
#ifdef ERANGE
    case ERANGE: return "ERANGE";
#endif
#ifdef EDEADLK
    case EDEADLK: return "EDEADLK";
#endif
#ifdef ENAMETOOLONG
    case ENAMETOOLONG: return "ENAMETOOLONG";
#endif
#ifdef ENOLCK
    case ENOLCK: return "ENOLCK";
#endif
#ifdef ELOOP
    case ELOOP: return "ELOOP";
#endif
#ifdef ENOMSG
    case ENOMSG: return "ENOMSG";
#endif
#ifdef EIDRM
    case EIDRM: return "EIDRM";
#endif
#ifdef ETIME
    case ETIME: return "ETIME";
#endif
#ifdef EPROTO
    case EPROTO: return "EPROTO";
#endif
#ifdef EOVERFLOW
    case EOVERFLOW: return "EOVERFLOW";
#endif
#ifdef EILSEQ
    case EILSEQ: return "EILSEQ";
#endif
#ifdef EUSERS
    case EUSERS: return "EUSERS";
#endif
#ifdef ENOTSOCK
    case ENOTSOCK: return "ENOTSOCK";
#endif
#ifdef EDESTADDRREQ
    case EDESTADDRREQ: return "EDESTADDRREQ";
#endif
#ifdef EMSGSIZE
    case EMSGSIZE: return "EMSGSIZE";
#endif
#ifdef EPROTOTYPE
    case EPROTOTYPE: return "EPROTOTYPE";
#endif
#ifdef ENOPROTOOPT
    case ENOPROTOOPT: return "ENOPROTOOPT";
#endif
#ifdef EPROTONOSUPPORT
    case EPROTONOSUPPORT: return "EPROTONOSUPPORT";
#endif
#ifdef ESOCKTNOSUPPORT
    case ESOCKTNOSUPPORT: return "ESOCKTNOSUPPORT";
#endif
#ifdef EOPNOTSUPP
    case EOPNOTSUPP: return "EOPNOTSUPP";
#endif
#ifdef EPFNOSUPPORT
    case EPFNOSUPPORT: return "EPFNOSUPPORT";
#endif
#ifdef EAFNOSUPPORT
    case EAFNOSUPPORT: return "EAFNOSUPPORT";
#endif
#ifdef EADDRINUSE
    case EADDRINUSE: return "EADDRINUSE";
#endif
#ifdef EADDRNOTAVAIL
    case EADDRNOTAVAIL: return "EADDRNOTAVAIL";
#endif
#ifdef ENETDOWN
    case ENETDOWN: return "ENETDOWN";
#endif
#ifdef ENETUNREACH
    case ENETUNREACH: return "ENETUNREACH";
#endif
#ifdef ENETRESET
    case ENETRESET: return "ENETRESET";
#endif
#ifdef ECONNABORTED
    case ECONNABORTED: return "ECONNABORTED";
#endif
#ifdef ECONNRESET
    case ECONNRESET: return "ECONNRESET";
#endif
#ifdef ENOBUFS
    case ENOBUFS: return "ENOBUFS";
#endif
#ifdef EISCONN
    case EISCONN: return "EISCONN";
#endif
#ifdef ENOTCONN
    case ENOTCONN: return "ENOTCONN";
#endif
#ifdef ESHUTDOWN
    case ESHUTDOWN: return "ESHUTDOWN";
#endif
#ifdef ETOOMANYREFS
    case ETOOMANYREFS: return "ETOOMANYREFS";
#endif
#ifdef ETIMEDOUT
    case ETIMEDOUT: return "ETIMEDOUT";
#endif
#ifdef ECONNREFUSED
    case ECONNREFUSED: return "ECONNREFUSED";
#endif
#ifdef EHOSTDOWN
    case EHOSTDOWN: return "EHOSTDOWN";
#endif
#ifdef EHOSTUNREACH
    case EHOSTUNREACH: return "EHOSTUNREACH";
#endif
#ifdef EALREADY
    case EALREADY: return "EALREADY";
#endif
#ifdef EINPROGRESS
    case EINPROGRESS: return "EINPROGRESS";
#endif
#ifdef ESTALE
    case ESTALE: return "ESTALE";
#endif
#ifdef EREMOTE
    case EREMOTE: return "EREMOTE";
#endif
#ifdef EBADRPC
    case EBADRPC: return "EBADRPC";
#endif
#ifdef ERPCMISMATCH
    case ERPCMISMATCH: return "ERPCMISMATCH";
#endif
#ifdef EPROGUNAVAIL
    case EPROGUNAVAIL: return "EPROGUNAVAIL";
#endif
#ifdef EPROGMISMATCH
    case EPROGMISMATCH: return "EPROGMISMATCH";
#endif
#ifdef EPROCUNAVAIL
    case EPROCUNAVAIL: return "EPROCUNAVAIL";
#endif
#ifdef EFTYPE
    case EFTYPE: return "EFTYPE";
#endif
#ifdef EAUTH
    case EAUTH: return "EAUTH";
#endif
#ifdef ENEEDAUTH
    case ENEEDAUTH: return "ENEEDAUTH";
#endif
#ifdef EPROCLIM
    case EPROCLIM: return "EPROCLIM";
#endif
#ifdef ENOATTR
    case ENOATTR: return "ENOATTR";
#endif
#ifdef EPWROFF
    case EPWROFF: return "EPWROFF";
#endif
#ifdef EDEVERR
    case EDEVERR: return "EDEVERR";
#endif
#ifdef EBADEXEC
    case EBADEXEC: return "EBADEXEC";
#endif
#ifdef EBADARCH
    case EBADARCH: return "EBADARCH";
#endif
#ifdef ESHLIBVERS
    case ESHLIBVERS: return "ESHLIBVERS";
#endif
#ifdef EBADMACHO
    case EBADMACHO: return "EBADMACHO";
#endif
#ifdef ENOPOLICY
    case ENOPOLICY: return "ENOPOLICY";
#endif
#ifdef EBADMSG
    case EBADMSG: return "EBADMSG";
#endif
#ifdef ECANCELED
    case ECANCELED: return "ECANCELED";
#endif
#ifdef EOWNERDEAD
    case EOWNERDEAD: return "EOWNERDEAD";
#endif
#ifdef ENOTRECOVERABLE
    case ENOTRECOVERABLE: return "ENOTRECOVERABLE";
#endif
#ifdef ENONET
    case ENONET: return "ENONET";
#endif
#ifdef ERESTART
    case ERESTART: return "ERESTART";
#endif
#ifdef ENODATA
    case ENODATA: return "ENODATA";
#endif
#ifdef ENOSR
    case ENOSR: return "ENOSR";
#endif
#ifdef ENOSTR
    case ENOSTR: return "ENOSTR";
#endif
#ifdef EMULTIHOP
    case EMULTIHOP: return "EMULTIHOP";
#endif
#ifdef ENOLINK
    case ENOLINK: return "ENOLINK";
#endif
#ifdef ENOMEDIUM
    case ENOMEDIUM: return "ENOMEDIUM";
#endif
#ifdef EMEDIUMTYPE
    case EMEDIUMTYPE: return "EMEDIUMTYPE";
#endif
#ifdef EBADFD
    case EBADFD: return "EBADFD";
#endif
#ifdef ECHRNG
    case ECHRNG: return "ECHRNG";
#endif
#ifdef EL2NSYNC
    case EL2NSYNC: return "EL2NSYNC";
#endif
#ifdef EL3HLT
    case EL3HLT: return "EL3HLT";
#endif
#ifdef EL3RST
    case EL3RST: return "EL3RST";
#endif
#ifdef ELNRNG
    case ELNRNG: return "ELNRNG";
#endif
#ifdef EUNATCH
    case EUNATCH: return "EUNATCH";
#endif
#ifdef ENOCSI
    case ENOCSI: return "ENOCSI";
#endif
#ifdef EL2HLT
    case EL2HLT: return "EL2HLT";
#endif
#ifdef EBADE
    case EBADE: return "EBADE";
#endif
#ifdef EBADR
    case EBADR: return "EBADR";
#endif
#ifdef EXFULL
    case EXFULL: return "EXFULL";
#endif
#ifdef ENOANO
    case ENOANO: return "ENOANO";
#endif
#ifdef EBADRQC
    case EBADRQC: return "EBADRQC";
#endif
#ifdef EBADSLT
    case EBADSLT: return "EBADSLT";
#endif
#ifdef ENOPKG
    case ENOPKG: return "ENOPKG";
#endif
#ifdef EADV
    case EADV: return "EADV";
#endif
#ifdef ESRMNT
    case ESRMNT: return "ESRMNT";
#endif
#ifdef ECOMM
    case ECOMM: return "ECOMM";
#endif
#ifdef EDOTDOT
    case EDOTDOT: return "EDOTDOT";
#endif
#ifdef ENOTUNIQ
    case ENOTUNIQ: return "ENOTUNIQ";
#endif
#ifdef EREMCHG
    case EREMCHG: return "EREMCHG";
#endif
#ifdef ELIBACC
    case ELIBACC: return "ELIBACC";
#endif
#ifdef ELIBBAD
    case ELIBBAD: return "ELIBBAD";
#endif
#ifdef ELIBSCN
    case ELIBSCN: return "ELIBSCN";
#endif
#ifdef ELIBMAX
    case ELIBMAX: return "ELIBMAX";
#endif
#ifdef ELIBEXEC
    case ELIBEXEC: return "ELIBEXEC";
#endif
#ifdef ESTRPIPE
    case ESTRPIPE: return "ESTRPIPE";
#endif
#ifdef EUCLEAN
    case EUCLEAN: return "EUCLEAN";
#endif
#ifdef ENOTNAM
    case ENOTNAM: return "ENOTNAM";
#endif
#ifdef ENAVAIL
    case ENAVAIL: return "ENAVAIL";
#endif
#ifdef EISNAM
    case EISNAM: return "EISNAM";
#endif
#ifdef EREMOTEIO
    case EREMOTEIO: return "EREMOTEIO";
#endif
#ifdef ENOKEY
    case ENOKEY: return "ENOKEY";
#endif
#ifdef EKEYEXPIRED
    case EKEYEXPIRED: return "EKEYEXPIRED";
#endif
#ifdef EKEYREVOKED
    case EKEYREVOKED: return "EKEYREVOKED";
#endif
#ifdef EKEYREJECTED
    case EKEYREJECTED: return "EKEYREJECTED";
#endif
#ifdef ERFKILL
    case ERFKILL: return "ERFKILL";
#endif
#ifdef EHWPOISON
    case EHWPOISON: return "EHWPOISON";
#endif
#ifdef EBFONT
    case EBFONT: return "EBFONT";
#endif
    default:
        switch (errnum) {
#ifdef EWOULDBLOCK
        case EWOULDBLOCK: return "EWOULDBLOCK";
#endif
#ifdef EDEADLOCK
        case EDEADLOCK: return "EDEADLOCK";
#endif
#ifdef ENOTSUP
        case ENOTSUP: return "ENOTSUP";
#endif
#ifdef ENOTEMPTY
        case ENOTEMPTY: return "ENOTEMPTY";
#endif
        }
    }
    return NULL;
}
