%---------------------------------------------------------------------------%
% vim: ts=4 sw=4 et ft=mercury
%---------------------------------------------------------------------------%

:- module constant_prop_int.
:- interface.

:- import_module io.

:- pred main(io::di, io::uo) is det.

:- implementation.

:- import_module int.

main(!IO) :-
    test_plus(!IO),
    test_minus(!IO),
    test_times(!IO),
    test_quotient(!IO),
    test_unchecked_quotient(!IO),
    test_mod(!IO),
    test_rem(!IO),
    test_unchecked_rem(!IO),
    test_left_shift(!IO),
    test_unchecked_left_shift(!IO),
    test_right_shift(!IO),
    test_unchecked_right_shift(!IO).

:- pred test_plus(io::di, io::uo) is det.

test_plus -->
    label("plus(1, 0) = "),
    result(1 + 0),
    label("plus(1, 1) = "),
    result(1 + 1),
    label("plus(1, -1) = "),
    result(1 + -1),
    label("plus(1, 31) = "),
    result(1 + 31),
    label("plus(1, -31) = "),
    result(1 + -31),
    label("plus(1, 2147483647) = "),
    result(1 + 2147483647),
    label("plus(1, -2147483648) = "),
    result(1 + -2147483648),
    label("plus(-1, 0) = "),
    result(-1 + 0),
    label("plus(-1, 1) = "),
    result(-1 + 1),
    label("plus(-1, -1) = "),
    result(-1 + -1),
    label("plus(-1, 31) = "),
    result(-1 + 31),
    label("plus(-1, -31) = "),
    result(-1 + -31),
    label("plus(-1, 2147483647) = "),
    result(-1 + 2147483647),
    label("plus(-1, -2147483648) = "),
    result(-1 + -2147483648),
    label("plus(31, 0) = "),
    result(31 + 0),
    label("plus(31, 1) = "),
    result(31 + 1),
    label("plus(31, -1) = "),
    result(31 + -1),
    label("plus(31, 31) = "),
    result(31 + 31),
    label("plus(31, -31) = "),
    result(31 + -31),
    label("plus(31, 2147483647) = "),
    result(31 + 2147483647),
    label("plus(31, -2147483648) = "),
    result(31 + -2147483648),
    label("plus(-31, 0) = "),
    result(-31 + 0),
    label("plus(-31, 1) = "),
    result(-31 + 1),
    label("plus(-31, -1) = "),
    result(-31 + -1),
    label("plus(-31, 31) = "),
    result(-31 + 31),
    label("plus(-31, -31) = "),
    result(-31 + -31),
    label("plus(-31, 2147483647) = "),
    result(-31 + 2147483647),
    label("plus(-31, -2147483648) = "),
    result(-31 + -2147483648),
    label("plus(2147483647, 0) = "),
    result(2147483647 + 0),
    label("plus(2147483647, 1) = "),
    result(2147483647 + 1),
    label("plus(2147483647, -1) = "),
    result(2147483647 + -1),
    label("plus(2147483647, 31) = "),
    result(2147483647 + 31),
    label("plus(2147483647, -31) = "),
    result(2147483647 + -31),
    label("plus(2147483647, 2147483647) = "),
    result(2147483647 + 2147483647),
    label("plus(2147483647, -2147483648) = "),
    result(2147483647 + -2147483648),
    label("plus(-2147483648, 0) = "),
    result(-2147483648 + 0),
    label("plus(-2147483648, 1) = "),
    result(-2147483648 + 1),
    label("plus(-2147483648, -1) = "),
    result(-2147483648 + -1),
    label("plus(-2147483648, 31) = "),
    result(-2147483648 + 31),
    label("plus(-2147483648, -31) = "),
    result(-2147483648 + -31),
    label("plus(-2147483648, 2147483647) = "),
    result(-2147483648 + 2147483647),
    label("plus(-2147483648, -2147483648) = "),
    result(-2147483648 + -2147483648),
    nl.

:- pred test_minus(io::di, io::uo) is det.

test_minus -->
    label("minus(1, 0) = "),
    result(1 - 0),
    label("minus(1, 1) = "),
    result(1 - 1),
    label("minus(1, -1) = "),
    result(1 - -1),
    label("minus(1, 31) = "),
    result(1 - 31),
    label("minus(1, -31) = "),
    result(1 - -31),
    label("minus(1, 2147483647) = "),
    result(1 - 2147483647),
    label("minus(1, -2147483648) = "),
    result(1 - -2147483648),
    label("minus(-1, 0) = "),
    result(-1 - 0),
    label("minus(-1, 1) = "),
    result(-1 - 1),
    label("minus(-1, -1) = "),
    result(-1 - -1),
    label("minus(-1, 31) = "),
    result(-1 - 31),
    label("minus(-1, -31) = "),
    result(-1 - -31),
    label("minus(-1, 2147483647) = "),
    result(-1 - 2147483647),
    label("minus(-1, -2147483648) = "),
    result(-1 - -2147483648),
    label("minus(31, 0) = "),
    result(31 - 0),
    label("minus(31, 1) = "),
    result(31 - 1),
    label("minus(31, -1) = "),
    result(31 - -1),
    label("minus(31, 31) = "),
    result(31 - 31),
    label("minus(31, -31) = "),
    result(31 - -31),
    label("minus(31, 2147483647) = "),
    result(31 - 2147483647),
    label("minus(31, -2147483648) = "),
    result(31 - -2147483648),
    label("minus(-31, 0) = "),
    result(-31 - 0),
    label("minus(-31, 1) = "),
    result(-31 - 1),
    label("minus(-31, -1) = "),
    result(-31 - -1),
    label("minus(-31, 31) = "),
    result(-31 - 31),
    label("minus(-31, -31) = "),
    result(-31 - -31),
    label("minus(-31, 2147483647) = "),
    result(-31 - 2147483647),
    label("minus(-31, -2147483648) = "),
    result(-31 - -2147483648),
    label("minus(2147483647, 0) = "),
    result(2147483647 - 0),
    label("minus(2147483647, 1) = "),
    result(2147483647 - 1),
    label("minus(2147483647, -1) = "),
    result(2147483647 - -1),
    label("minus(2147483647, 31) = "),
    result(2147483647 - 31),
    label("minus(2147483647, -31) = "),
    result(2147483647 - -31),
    label("minus(2147483647, 2147483647) = "),
    result(2147483647 - 2147483647),
    label("minus(2147483647, -2147483648) = "),
    result(2147483647 - -2147483648),
    label("minus(-2147483648, 0) = "),
    result(-2147483648 - 0),
    label("minus(-2147483648, 1) = "),
    result(-2147483648 - 1),
    label("minus(-2147483648, -1) = "),
    result(-2147483648 - -1),
    label("minus(-2147483648, 31) = "),
    result(-2147483648 - 31),
    label("minus(-2147483648, -31) = "),
    result(-2147483648 - -31),
    label("minus(-2147483648, 2147483647) = "),
    result(-2147483648 - 2147483647),
    label("minus(-2147483648, -2147483648) = "),
    result(-2147483648 - -2147483648),
    nl.

:- pred test_times(io::di, io::uo) is det.

test_times -->
    label("times(1, 0) = "),
    result(1 * 0),
    label("times(1, 1) = "),
    result(1 * 1),
    label("times(1, -1) = "),
    result(1 * -1),
    label("times(1, 31) = "),
    result(1 * 31),
    label("times(1, -31) = "),
    result(1 * -31),
    label("times(1, 2147483647) = "),
    result(1 * 2147483647),
    label("times(1, -2147483648) = "),
    result(1 * -2147483648),
    label("times(-1, 0) = "),
    result(-1 * 0),
    label("times(-1, 1) = "),
    result(-1 * 1),
    label("times(-1, -1) = "),
    result(-1 * -1),
    label("times(-1, 31) = "),
    result(-1 * 31),
    label("times(-1, -31) = "),
    result(-1 * -31),
    label("times(-1, 2147483647) = "),
    result(-1 * 2147483647),
    label("times(-1, -2147483648) = "),
    result(-1 * -2147483648),
    label("times(31, 0) = "),
    result(31 * 0),
    label("times(31, 1) = "),
    result(31 * 1),
    label("times(31, -1) = "),
    result(31 * -1),
    label("times(31, 31) = "),
    result(31 * 31),
    label("times(31, -31) = "),
    result(31 * -31),
    label("times(31, 2147483647) = "),
    result(31 * 2147483647),
    label("times(31, -2147483648) = "),
    result(31 * -2147483648),
    label("times(-31, 0) = "),
    result(-31 * 0),
    label("times(-31, 1) = "),
    result(-31 * 1),
    label("times(-31, -1) = "),
    result(-31 * -1),
    label("times(-31, 31) = "),
    result(-31 * 31),
    label("times(-31, -31) = "),
    result(-31 * -31),
    label("times(-31, 2147483647) = "),
    result(-31 * 2147483647),
    label("times(-31, -2147483648) = "),
    result(-31 * -2147483648),
    label("times(2147483647, 0) = "),
    result(2147483647 * 0),
    label("times(2147483647, 1) = "),
    result(2147483647 * 1),
    label("times(2147483647, -1) = "),
    result(2147483647 * -1),
    label("times(2147483647, 31) = "),
    result(2147483647 * 31),
    label("times(2147483647, -31) = "),
    result(2147483647 * -31),
    label("times(2147483647, 2147483647) = "),
    result(2147483647 * 2147483647),
    label("times(2147483647, -2147483648) = "),
    result(2147483647 * -2147483648),
    label("times(-2147483648, 0) = "),
    result(-2147483648 * 0),
    label("times(-2147483648, 1) = "),
    result(-2147483648 * 1),
    label("times(-2147483648, -1) = "),
    result(-2147483648 * -1),
    label("times(-2147483648, 31) = "),
    result(-2147483648 * 31),
    label("times(-2147483648, -31) = "),
    result(-2147483648 * -31),
    label("times(-2147483648, 2147483647) = "),
    result(-2147483648 * 2147483647),
    label("times(-2147483648, -2147483648) = "),
    result(-2147483648 * -2147483648),
    nl.

:- pred test_quotient(io::di, io::uo) is det.

test_quotient -->
    label("quotient(1, 1) = "),
    result(1 // 1),
    label("quotient(1, -1) = "),
    result(1 // -1),
    label("quotient(1, 31) = "),
    result(1 // 31),
    label("quotient(1, -31) = "),
    result(1 // -31),
    label("quotient(1, 2147483647) = "),
    result(1 // 2147483647),
    label("quotient(1, -2147483648) = "),
    result(1 // -2147483648),
    label("quotient(-1, 1) = "),
    result(-1 // 1),
    label("quotient(-1, -1) = "),
    result(-1 // -1),
    label("quotient(-1, 31) = "),
    result(-1 // 31),
    label("quotient(-1, -31) = "),
    result(-1 // -31),
    label("quotient(-1, 2147483647) = "),
    result(-1 // 2147483647),
    label("quotient(-1, -2147483648) = "),
    result(-1 // -2147483648),
    label("quotient(31, 1) = "),
    result(31 // 1),
    label("quotient(31, -1) = "),
    result(31 // -1),
    label("quotient(31, 31) = "),
    result(31 // 31),
    label("quotient(31, -31) = "),
    result(31 // -31),
    label("quotient(31, 2147483647) = "),
    result(31 // 2147483647),
    label("quotient(31, -2147483648) = "),
    result(31 // -2147483648),
    label("quotient(-31, 1) = "),
    result(-31 // 1),
    label("quotient(-31, -1) = "),
    result(-31 // -1),
    label("quotient(-31, 31) = "),
    result(-31 // 31),
    label("quotient(-31, -31) = "),
    result(-31 // -31),
    label("quotient(-31, 2147483647) = "),
    result(-31 // 2147483647),
    label("quotient(-31, -2147483648) = "),
    result(-31 // -2147483648),
    label("quotient(2147483647, 1) = "),
    result(2147483647 // 1),
    label("quotient(2147483647, -1) = "),
    result(2147483647 // -1),
    label("quotient(2147483647, 31) = "),
    result(2147483647 // 31),
    label("quotient(2147483647, -31) = "),
    result(2147483647 // -31),
    label("quotient(2147483647, 2147483647) = "),
    result(2147483647 // 2147483647),
    label("quotient(2147483647, -2147483648) = "),
    result(2147483647 // -2147483648),
    label("quotient(-2147483648, 1) = "),
    result(-2147483648 // 1),
    % label("quotient(-2147483648, -1) = "),
    % result(-2147483648 // -1),
    label("quotient(-2147483648, 31) = "),
    result(-2147483648 // 31),
    label("quotient(-2147483648, -31) = "),
    result(-2147483648 // -31),
    label("quotient(-2147483648, 2147483647) = "),
    result(-2147483648 // 2147483647),
    label("quotient(-2147483648, -2147483648) = "),
    result(-2147483648 // -2147483648),
    nl.

:- pred test_unchecked_quotient(io::di, io::uo) is det.

test_unchecked_quotient -->
    label("unchecked_quotient(1, 1) = "),
    result(unchecked_quotient(1, 1)),
    label("unchecked_quotient(1, -1) = "),
    result(unchecked_quotient(1, -1)),
    label("unchecked_quotient(1, 31) = "),
    result(unchecked_quotient(1, 31)),
    label("unchecked_quotient(1, -31) = "),
    result(unchecked_quotient(1, -31)),
    label("unchecked_quotient(1, 2147483647) = "),
    result(unchecked_quotient(1, 2147483647)),
    label("unchecked_quotient(1, -2147483648) = "),
    result(unchecked_quotient(1, -2147483648)),
    label("unchecked_quotient(-1, 1) = "),
    result(unchecked_quotient(-1, 1)),
    label("unchecked_quotient(-1, -1) = "),
    result(unchecked_quotient(-1, -1)),
    label("unchecked_quotient(-1, 31) = "),
    result(unchecked_quotient(-1, 31)),
    label("unchecked_quotient(-1, -31) = "),
    result(unchecked_quotient(-1, -31)),
    label("unchecked_quotient(-1, 2147483647) = "),
    result(unchecked_quotient(-1, 2147483647)),
    label("unchecked_quotient(-1, -2147483648) = "),
    result(unchecked_quotient(-1, -2147483648)),
    label("unchecked_quotient(31, 1) = "),
    result(unchecked_quotient(31, 1)),
    label("unchecked_quotient(31, -1) = "),
    result(unchecked_quotient(31, -1)),
    label("unchecked_quotient(31, 31) = "),
    result(unchecked_quotient(31, 31)),
    label("unchecked_quotient(31, -31) = "),
    result(unchecked_quotient(31, -31)),
    label("unchecked_quotient(31, 2147483647) = "),
    result(unchecked_quotient(31, 2147483647)),
    label("unchecked_quotient(31, -2147483648) = "),
    result(unchecked_quotient(31, -2147483648)),
    label("unchecked_quotient(-31, 1) = "),
    result(unchecked_quotient(-31, 1)),
    label("unchecked_quotient(-31, -1) = "),
    result(unchecked_quotient(-31, -1)),
    label("unchecked_quotient(-31, 31) = "),
    result(unchecked_quotient(-31, 31)),
    label("unchecked_quotient(-31, -31) = "),
    result(unchecked_quotient(-31, -31)),
    label("unchecked_quotient(-31, 2147483647) = "),
    result(unchecked_quotient(-31, 2147483647)),
    label("unchecked_quotient(-31, -2147483648) = "),
    result(unchecked_quotient(-31, -2147483648)),
    label("unchecked_quotient(2147483647, 1) = "),
    result(unchecked_quotient(2147483647, 1)),
    label("unchecked_quotient(2147483647, -1) = "),
    result(unchecked_quotient(2147483647, -1)),
    label("unchecked_quotient(2147483647, 31) = "),
    result(unchecked_quotient(2147483647, 31)),
    label("unchecked_quotient(2147483647, -31) = "),
    result(unchecked_quotient(2147483647, -31)),
    label("unchecked_quotient(2147483647, 2147483647) = "),
    result(unchecked_quotient(2147483647, 2147483647)),
    label("unchecked_quotient(2147483647, -2147483648) = "),
    result(unchecked_quotient(2147483647, -2147483648)),
    label("unchecked_quotient(-2147483648, 1) = "),
    result(unchecked_quotient(-2147483648, 1)),
    % label("unchecked_quotient(-2147483648, -1) = "),
    % result(unchecked_quotient(-2147483648, -1)),
    label("unchecked_quotient(-2147483648, 31) = "),
    result(unchecked_quotient(-2147483648, 31)),
    label("unchecked_quotient(-2147483648, -31) = "),
    result(unchecked_quotient(-2147483648, -31)),
    label("unchecked_quotient(-2147483648, 2147483647) = "),
    result(unchecked_quotient(-2147483648, 2147483647)),
    label("unchecked_quotient(-2147483648, -2147483648) = "),
    result(unchecked_quotient(-2147483648, -2147483648)),
    nl.

:- pred test_mod(io::di, io::uo) is det.

test_mod -->
    label("mod(1, 1) = "),
    result(mod(1, 1)),
    label("mod(1, -1) = "),
    result(mod(1, -1)),
    label("mod(1, 31) = "),
    result(mod(1, 31)),
    label("mod(1, -31) = "),
    result(mod(1, -31)),
    label("mod(1, 2147483647) = "),
    result(mod(1, 2147483647)),
    label("mod(1, -2147483648) = "),
    result(mod(1, -2147483648)),
    label("mod(-1, 1) = "),
    result(mod(-1, 1)),
    label("mod(-1, -1) = "),
    result(mod(-1, -1)),
    label("mod(-1, 31) = "),
    result(mod(-1, 31)),
    label("mod(-1, -31) = "),
    result(mod(-1, -31)),
    label("mod(-1, 2147483647) = "),
    result(mod(-1, 2147483647)),
    label("mod(-1, -2147483648) = "),
    result(mod(-1, -2147483648)),
    label("mod(31, 1) = "),
    result(mod(31, 1)),
    label("mod(31, -1) = "),
    result(mod(31, -1)),
    label("mod(31, 31) = "),
    result(mod(31, 31)),
    label("mod(31, -31) = "),
    result(mod(31, -31)),
    label("mod(31, 2147483647) = "),
    result(mod(31, 2147483647)),
    label("mod(31, -2147483648) = "),
    result(mod(31, -2147483648)),
    label("mod(-31, 1) = "),
    result(mod(-31, 1)),
    label("mod(-31, -1) = "),
    result(mod(-31, -1)),
    label("mod(-31, 31) = "),
    result(mod(-31, 31)),
    label("mod(-31, -31) = "),
    result(mod(-31, -31)),
    label("mod(-31, 2147483647) = "),
    result(mod(-31, 2147483647)),
    label("mod(-31, -2147483648) = "),
    result(mod(-31, -2147483648)),
    label("mod(2147483647, 1) = "),
    result(mod(2147483647, 1)),
    label("mod(2147483647, -1) = "),
    result(mod(2147483647, -1)),
    label("mod(2147483647, 31) = "),
    result(mod(2147483647, 31)),
    label("mod(2147483647, -31) = "),
    result(mod(2147483647, -31)),
    label("mod(2147483647, 2147483647) = "),
    result(mod(2147483647, 2147483647)),
    label("mod(2147483647, -2147483648) = "),
    result(mod(2147483647, -2147483648)),
    label("mod(-2147483648, 1) = "),
    result(mod(-2147483648, 1)),
    % label("mod(-2147483648, -1) = "),
    % result(mod(-2147483648, -1)),
    label("mod(-2147483648, 31) = "),
    result(mod(-2147483648, 31)),
    label("mod(-2147483648, -31) = "),
    result(mod(-2147483648, -31)),
    label("mod(-2147483648, 2147483647) = "),
    result(mod(-2147483648, 2147483647)),
    label("mod(-2147483648, -2147483648) = "),
    result(mod(-2147483648, -2147483648)),
    nl.

:- pred test_rem(io::di, io::uo) is det.

test_rem -->
    label("rem(1, 1) = "),
    result(rem(1, 1)),
    label("rem(1, -1) = "),
    result(rem(1, -1)),
    label("rem(1, 31) = "),
    result(rem(1, 31)),
    label("rem(1, -31) = "),
    result(rem(1, -31)),
    label("rem(1, 2147483647) = "),
    result(rem(1, 2147483647)),
    label("rem(1, -2147483648) = "),
    result(rem(1, -2147483648)),
    label("rem(-1, 1) = "),
    result(rem(-1, 1)),
    label("rem(-1, -1) = "),
    result(rem(-1, -1)),
    label("rem(-1, 31) = "),
    result(rem(-1, 31)),
    label("rem(-1, -31) = "),
    result(rem(-1, -31)),
    label("rem(-1, 2147483647) = "),
    result(rem(-1, 2147483647)),
    label("rem(-1, -2147483648) = "),
    result(rem(-1, -2147483648)),
    label("rem(31, 1) = "),
    result(rem(31, 1)),
    label("rem(31, -1) = "),
    result(rem(31, -1)),
    label("rem(31, 31) = "),
    result(rem(31, 31)),
    label("rem(31, -31) = "),
    result(rem(31, -31)),
    label("rem(31, 2147483647) = "),
    result(rem(31, 2147483647)),
    label("rem(31, -2147483648) = "),
    result(rem(31, -2147483648)),
    label("rem(-31, 1) = "),
    result(rem(-31, 1)),
    label("rem(-31, -1) = "),
    result(rem(-31, -1)),
    label("rem(-31, 31) = "),
    result(rem(-31, 31)),
    label("rem(-31, -31) = "),
    result(rem(-31, -31)),
    label("rem(-31, 2147483647) = "),
    result(rem(-31, 2147483647)),
    label("rem(-31, -2147483648) = "),
    result(rem(-31, -2147483648)),
    label("rem(2147483647, 1) = "),
    result(rem(2147483647, 1)),
    label("rem(2147483647, -1) = "),
    result(rem(2147483647, -1)),
    label("rem(2147483647, 31) = "),
    result(rem(2147483647, 31)),
    label("rem(2147483647, -31) = "),
    result(rem(2147483647, -31)),
    label("rem(2147483647, 2147483647) = "),
    result(rem(2147483647, 2147483647)),
    label("rem(2147483647, -2147483648) = "),
    result(rem(2147483647, -2147483648)),
    label("rem(-2147483648, 1) = "),
    result(rem(-2147483648, 1)),
    % label("rem(-2147483648, -1) = "),
    % result(rem(-2147483648, -1)),
    label("rem(-2147483648, 31) = "),
    result(rem(-2147483648, 31)),
    label("rem(-2147483648, -31) = "),
    result(rem(-2147483648, -31)),
    label("rem(-2147483648, 2147483647) = "),
    result(rem(-2147483648, 2147483647)),
    label("rem(-2147483648, -2147483648) = "),
    result(rem(-2147483648, -2147483648)),
    nl.

:- pred test_unchecked_rem(io::di, io::uo) is det.

test_unchecked_rem -->
    label("unchecked_rem(1, 1) = "),
    result(unchecked_rem(1, 1)),
    label("unchecked_rem(1, -1) = "),
    result(unchecked_rem(1, -1)),
    label("unchecked_rem(1, 31) = "),
    result(unchecked_rem(1, 31)),
    label("unchecked_rem(1, -31) = "),
    result(unchecked_rem(1, -31)),
    label("unchecked_rem(1, 2147483647) = "),
    result(unchecked_rem(1, 2147483647)),
    label("unchecked_rem(1, -2147483648) = "),
    result(unchecked_rem(1, -2147483648)),
    label("unchecked_rem(-1, 1) = "),
    result(unchecked_rem(-1, 1)),
    label("unchecked_rem(-1, -1) = "),
    result(unchecked_rem(-1, -1)),
    label("unchecked_rem(-1, 31) = "),
    result(unchecked_rem(-1, 31)),
    label("unchecked_rem(-1, -31) = "),
    result(unchecked_rem(-1, -31)),
    label("unchecked_rem(-1, 2147483647) = "),
    result(unchecked_rem(-1, 2147483647)),
    label("unchecked_rem(-1, -2147483648) = "),
    result(unchecked_rem(-1, -2147483648)),
    label("unchecked_rem(31, 1) = "),
    result(unchecked_rem(31, 1)),
    label("unchecked_rem(31, -1) = "),
    result(unchecked_rem(31, -1)),
    label("unchecked_rem(31, 31) = "),
    result(unchecked_rem(31, 31)),
    label("unchecked_rem(31, -31) = "),
    result(unchecked_rem(31, -31)),
    label("unchecked_rem(31, 2147483647) = "),
    result(unchecked_rem(31, 2147483647)),
    label("unchecked_rem(31, -2147483648) = "),
    result(unchecked_rem(31, -2147483648)),
    label("unchecked_rem(-31, 1) = "),
    result(unchecked_rem(-31, 1)),
    label("unchecked_rem(-31, -1) = "),
    result(unchecked_rem(-31, -1)),
    label("unchecked_rem(-31, 31) = "),
    result(unchecked_rem(-31, 31)),
    label("unchecked_rem(-31, -31) = "),
    result(unchecked_rem(-31, -31)),
    label("unchecked_rem(-31, 2147483647) = "),
    result(unchecked_rem(-31, 2147483647)),
    label("unchecked_rem(-31, -2147483648) = "),
    result(unchecked_rem(-31, -2147483648)),
    label("unchecked_rem(2147483647, 1) = "),
    result(unchecked_rem(2147483647, 1)),
    label("unchecked_rem(2147483647, -1) = "),
    result(unchecked_rem(2147483647, -1)),
    label("unchecked_rem(2147483647, 31) = "),
    result(unchecked_rem(2147483647, 31)),
    label("unchecked_rem(2147483647, -31) = "),
    result(unchecked_rem(2147483647, -31)),
    label("unchecked_rem(2147483647, 2147483647) = "),
    result(unchecked_rem(2147483647, 2147483647)),
    label("unchecked_rem(2147483647, -2147483648) = "),
    result(unchecked_rem(2147483647, -2147483648)),
    label("unchecked_rem(-2147483648, 1) = "),
    result(unchecked_rem(-2147483648, 1)),
    % label("unchecked_rem(-2147483648, -1) = "),
    % result(unchecked_rem(-2147483648, -1)),
    label("unchecked_rem(-2147483648, 31) = "),
    result(unchecked_rem(-2147483648, 31)),
    label("unchecked_rem(-2147483648, -31) = "),
    result(unchecked_rem(-2147483648, -31)),
    label("unchecked_rem(-2147483648, 2147483647) = "),
    result(unchecked_rem(-2147483648, 2147483647)),
    label("unchecked_rem(-2147483648, -2147483648) = "),
    result(unchecked_rem(-2147483648, -2147483648)),
    nl.

:- pred test_left_shift(io::di, io::uo) is det.

test_left_shift -->
    label("left_shift(1, 0) = "),
    result(1 << 0),
    label("left_shift(1, 1) = "),
    result(1 << 1),
    label("left_shift(1, 31) = "),
    result(1 << 31),
    label("left_shift(-1, 0) = "),
    result(-1 << 0),
    label("left_shift(-1, 1) = "),
    result(-1 << 1),
    label("left_shift(-1, 31) = "),
    result(-1 << 31),
    label("left_shift(31, 0) = "),
    result(31 << 0),
    label("left_shift(31, 1) = "),
    result(31 << 1),
    label("left_shift(31, 31) = "),
    result(31 << 31),
    label("left_shift(-31, 0) = "),
    result(-31 << 0),
    label("left_shift(-31, 1) = "),
    result(-31 << 1),
    label("left_shift(-31, 31) = "),
    result(-31 << 31),
    label("left_shift(2147483647, 0) = "),
    result(2147483647 << 0),
    label("left_shift(2147483647, 1) = "),
    result(2147483647 << 1),
    label("left_shift(2147483647, 31) = "),
    result(2147483647 << 31),
    label("left_shift(-2147483648, 0) = "),
    result(-2147483648 << 0),
    label("left_shift(-2147483648, 1) = "),
    result(-2147483648 << 1),
    label("left_shift(-2147483648, 31) = "),
    result(-2147483648 << 31),
    nl.

:- pred test_unchecked_left_shift(io::di, io::uo) is det.

test_unchecked_left_shift -->
    label("unchecked_left_shift(1, 0) = "),
    result(unchecked_left_shift(1, 0)),
    label("unchecked_left_shift(1, 1) = "),
    result(unchecked_left_shift(1, 1)),
    label("unchecked_left_shift(1, 31) = "),
    result(unchecked_left_shift(1, 31)),
    label("unchecked_left_shift(-1, 0) = "),
    result(unchecked_left_shift(-1, 0)),
    label("unchecked_left_shift(-1, 1) = "),
    result(unchecked_left_shift(-1, 1)),
    label("unchecked_left_shift(-1, 31) = "),
    result(unchecked_left_shift(-1, 31)),
    label("unchecked_left_shift(31, 0) = "),
    result(unchecked_left_shift(31, 0)),
    label("unchecked_left_shift(31, 1) = "),
    result(unchecked_left_shift(31, 1)),
    label("unchecked_left_shift(31, 31) = "),
    result(unchecked_left_shift(31, 31)),
    label("unchecked_left_shift(-31, 0) = "),
    result(unchecked_left_shift(-31, 0)),
    label("unchecked_left_shift(-31, 1) = "),
    result(unchecked_left_shift(-31, 1)),
    label("unchecked_left_shift(-31, 31) = "),
    result(unchecked_left_shift(-31, 31)),
    label("unchecked_left_shift(2147483647, 0) = "),
    result(unchecked_left_shift(2147483647, 0)),
    label("unchecked_left_shift(2147483647, 1) = "),
    result(unchecked_left_shift(2147483647, 1)),
    label("unchecked_left_shift(2147483647, 31) = "),
    result(unchecked_left_shift(2147483647, 31)),
    label("unchecked_left_shift(-2147483648, 0) = "),
    result(unchecked_left_shift(-2147483648, 0)),
    label("unchecked_left_shift(-2147483648, 1) = "),
    result(unchecked_left_shift(-2147483648, 1)),
    label("unchecked_left_shift(-2147483648, 31) = "),
    result(unchecked_left_shift(-2147483648, 31)),
    nl.

:- pred test_right_shift(io::di, io::uo) is det.

test_right_shift -->
    label("right_shift(1, 0) = "),
    result(1 >> 0),
    label("right_shift(1, 1) = "),
    result(1 >> 1),
    label("right_shift(1, 31) = "),
    result(1 >> 31),
    label("right_shift(-1, 0) = "),
    result(-1 >> 0),
    label("right_shift(-1, 1) = "),
    result(-1 >> 1),
    label("right_shift(-1, 31) = "),
    result(-1 >> 31),
    label("right_shift(31, 0) = "),
    result(31 >> 0),
    label("right_shift(31, 1) = "),
    result(31 >> 1),
    label("right_shift(31, 31) = "),
    result(31 >> 31),
    label("right_shift(-31, 0) = "),
    result(-31 >> 0),
    label("right_shift(-31, 1) = "),
    result(-31 >> 1),
    label("right_shift(-31, 31) = "),
    result(-31 >> 31),
    label("right_shift(2147483647, 0) = "),
    result(2147483647 >> 0),
    label("right_shift(2147483647, 1) = "),
    result(2147483647 >> 1),
    label("right_shift(2147483647, 31) = "),
    result(2147483647 >> 31),
    label("right_shift(-2147483648, 0) = "),
    result(-2147483648 >> 0),
    label("right_shift(-2147483648, 1) = "),
    result(-2147483648 >> 1),
    label("right_shift(-2147483648, 31) = "),
    result(-2147483648 >> 31),
    nl.

:- pred test_unchecked_right_shift(io::di, io::uo) is det.

test_unchecked_right_shift -->
    label("unchecked_right_shift(1, 0) = "),
    result(unchecked_right_shift(1, 0)),
    label("unchecked_right_shift(1, 1) = "),
    result(unchecked_right_shift(1, 1)),
    label("unchecked_right_shift(1, 31) = "),
    result(unchecked_right_shift(1, 31)),
    label("unchecked_right_shift(-1, 0) = "),
    result(unchecked_right_shift(-1, 0)),
    label("unchecked_right_shift(-1, 1) = "),
    result(unchecked_right_shift(-1, 1)),
    label("unchecked_right_shift(-1, 31) = "),
    result(unchecked_right_shift(-1, 31)),
    label("unchecked_right_shift(31, 0) = "),
    result(unchecked_right_shift(31, 0)),
    label("unchecked_right_shift(31, 1) = "),
    result(unchecked_right_shift(31, 1)),
    label("unchecked_right_shift(31, 31) = "),
    result(unchecked_right_shift(31, 31)),
    label("unchecked_right_shift(-31, 0) = "),
    result(unchecked_right_shift(-31, 0)),
    label("unchecked_right_shift(-31, 1) = "),
    result(unchecked_right_shift(-31, 1)),
    label("unchecked_right_shift(-31, 31) = "),
    result(unchecked_right_shift(-31, 31)),
    label("unchecked_right_shift(2147483647, 0) = "),
    result(unchecked_right_shift(2147483647, 0)),
    label("unchecked_right_shift(2147483647, 1) = "),
    result(unchecked_right_shift(2147483647, 1)),
    label("unchecked_right_shift(2147483647, 31) = "),
    result(unchecked_right_shift(2147483647, 31)),
    label("unchecked_right_shift(-2147483648, 0) = "),
    result(unchecked_right_shift(-2147483648, 0)),
    label("unchecked_right_shift(-2147483648, 1) = "),
    result(unchecked_right_shift(-2147483648, 1)),
    label("unchecked_right_shift(-2147483648, 31) = "),
    result(unchecked_right_shift(-2147483648, 31)),
    nl.

:- pred label(string::in, io::di, io::uo) is det.

label(X, !IO) :-
    io.write_string(X, !IO).

:- pred result(int::in, io::di, io::uo) is det.

result(X, !IO) :-
    io.write_int(X, !IO),
    io.nl(!IO).
